/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.query.reader.universal;

import java.io.IOException;
import org.apache.iotdb.tsfile.file.metadata.enums.TSDataType;
import org.apache.iotdb.tsfile.read.TimeValuePair;
import org.apache.iotdb.tsfile.read.reader.IPointReader;
import org.apache.iotdb.tsfile.utils.TsPrimitiveType;

public class FakedSeriesReader
implements IPointReader {
    private int index;
    private int size;
    private boolean initWithTimeList;
    private static final TSDataType DATA_TYPE = TSDataType.INT64;
    private long[] timestamps;
    private long value;
    private long startTime;
    private int interval;
    private int modValue;

    public FakedSeriesReader(long[] timestamps, long value) {
        this.initWithTimeList = true;
        this.index = 0;
        this.size = timestamps.length;
        this.timestamps = timestamps;
        this.value = value;
    }

    public FakedSeriesReader(long startTime, int size, int interval, int modValue) {
        this.initWithTimeList = false;
        this.index = 0;
        this.size = size;
        this.startTime = startTime;
        this.interval = interval;
        this.modValue = modValue;
    }

    public boolean hasNextTimeValuePair() {
        return this.index < this.size;
    }

    public TimeValuePair nextTimeValuePair() {
        if (this.initWithTimeList) {
            return new TimeValuePair(this.timestamps[this.index++], TsPrimitiveType.getByType((TSDataType)DATA_TYPE, (Object)this.value));
        }
        long time = this.startTime;
        this.startTime += (long)this.interval;
        ++this.index;
        return new TimeValuePair(time, TsPrimitiveType.getByType((TSDataType)TSDataType.INT64, (Object)(time % (long)this.modValue)));
    }

    public TimeValuePair currentTimeValuePair() throws IOException {
        throw new IOException("current() in FakedPrioritySeriesReader is an empty method.");
    }

    public void close() {
    }
}

