/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.query.reader.series;

import java.io.File;
import java.io.IOException;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import org.apache.iotdb.db.constant.TestConstant;
import org.apache.iotdb.db.engine.cache.ChunkCache;
import org.apache.iotdb.db.engine.cache.TimeSeriesMetadataCache;
import org.apache.iotdb.db.engine.merge.manage.MergeManager;
import org.apache.iotdb.db.engine.storagegroup.TsFileResource;
import org.apache.iotdb.db.exception.metadata.MetadataException;
import org.apache.iotdb.db.metadata.PartialPath;
import org.apache.iotdb.db.query.control.FileReaderManager;
import org.apache.iotdb.db.service.IoTDB;
import org.apache.iotdb.db.utils.EnvironmentUtils;
import org.apache.iotdb.tsfile.exception.write.WriteProcessException;
import org.apache.iotdb.tsfile.file.metadata.enums.CompressionType;
import org.apache.iotdb.tsfile.file.metadata.enums.TSDataType;
import org.apache.iotdb.tsfile.file.metadata.enums.TSEncoding;
import org.apache.iotdb.tsfile.write.TsFileWriter;
import org.apache.iotdb.tsfile.write.record.TSRecord;
import org.apache.iotdb.tsfile.write.record.datapoint.DataPoint;
import org.apache.iotdb.tsfile.write.schema.MeasurementSchema;

public class SeriesReaderTestUtil {
    private static int seqFileNum = 5;
    private static int unseqFileNum = 5;
    private static int measurementNum = 10;
    private static int deviceNum = 10;
    private static long ptNum = 100L;
    private static long flushInterval = 20L;
    private static TSEncoding encoding = TSEncoding.PLAIN;
    private static final String SERIES_READER_TEST_SG = "root.seriesReaderTest";

    public static void setUp(List<MeasurementSchema> measurementSchemas, List<String> deviceIds, List<TsFileResource> seqResources, List<TsFileResource> unseqResources) throws MetadataException, IOException, WriteProcessException {
        IoTDB.metaManager.init();
        SeriesReaderTestUtil.prepareSeries(measurementSchemas, deviceIds);
        SeriesReaderTestUtil.prepareFiles(seqResources, unseqResources, measurementSchemas, deviceIds);
    }

    public static void tearDown(List<TsFileResource> seqResources, List<TsFileResource> unseqResources) throws IOException {
        SeriesReaderTestUtil.removeFiles(seqResources, unseqResources);
        seqResources.clear();
        unseqResources.clear();
        ChunkCache.getInstance().clear();
        TimeSeriesMetadataCache.getInstance().clear();
        IoTDB.metaManager.clear();
        EnvironmentUtils.cleanAllDir();
        MergeManager.getINSTANCE().stop();
    }

    private static void prepareFiles(List<TsFileResource> seqResources, List<TsFileResource> unseqResources, List<MeasurementSchema> measurementSchemas, List<String> deviceIds) throws IOException, WriteProcessException {
        TsFileResource tsFileResource;
        File file;
        int i;
        for (i = 0; i < seqFileNum; ++i) {
            file = new File(TestConstant.BASE_OUTPUT_PATH.concat(i + "seq" + "-" + i + "-" + i + "-" + 0 + ".tsfile"));
            tsFileResource = new TsFileResource(file);
            tsFileResource.setClosed(true);
            tsFileResource.setMinPlanIndex((long)i);
            tsFileResource.setMaxPlanIndex((long)i);
            tsFileResource.setVersion((long)i);
            seqResources.add(tsFileResource);
            SeriesReaderTestUtil.prepareFile(tsFileResource, (long)i * ptNum, ptNum, 0L, measurementSchemas, deviceIds);
        }
        for (i = 0; i < unseqFileNum; ++i) {
            file = new File(TestConstant.BASE_OUTPUT_PATH.concat(i + "unseq" + "-" + i + "-" + i + "-" + 0 + ".tsfile"));
            tsFileResource = new TsFileResource(file);
            tsFileResource.setClosed(true);
            tsFileResource.setMinPlanIndex((long)(i + seqFileNum));
            tsFileResource.setMaxPlanIndex((long)(i + seqFileNum));
            tsFileResource.setVersion((long)(i + seqFileNum));
            unseqResources.add(tsFileResource);
            SeriesReaderTestUtil.prepareFile(tsFileResource, (long)i * ptNum, ptNum * (long)(i + 1) / (long)unseqFileNum, 10000L, measurementSchemas, deviceIds);
        }
        File file2 = new File(TestConstant.BASE_OUTPUT_PATH.concat(unseqFileNum + "unseq" + "-" + unseqFileNum + "-" + unseqFileNum + "-" + 0 + ".tsfile"));
        TsFileResource tsFileResource2 = new TsFileResource(file2);
        tsFileResource2.setClosed(true);
        tsFileResource2.setMinPlanIndex((long)(seqFileNum + unseqFileNum));
        tsFileResource2.setMaxPlanIndex((long)(seqFileNum + unseqFileNum));
        tsFileResource2.setVersion((long)(seqFileNum + unseqFileNum));
        unseqResources.add(tsFileResource2);
        SeriesReaderTestUtil.prepareFile(tsFileResource2, 0L, ptNum * 2L, 20000L, measurementSchemas, deviceIds);
    }

    private static void prepareFile(TsFileResource tsFileResource, long timeOffset, long ptNum, long valueOffset, List<MeasurementSchema> measurementSchemas, List<String> deviceIds) throws IOException, WriteProcessException {
        TsFileWriter fileWriter = new TsFileWriter(tsFileResource.getTsFile());
        HashMap<String, MeasurementSchema> template = new HashMap<String, MeasurementSchema>();
        for (MeasurementSchema measurementSchema : measurementSchemas) {
            template.put(measurementSchema.getMeasurementId(), measurementSchema);
        }
        fileWriter.registerDeviceTemplate("template0", template);
        for (String deviceId : deviceIds) {
            fileWriter.registerDevice(deviceId, "template0");
        }
        for (long i = timeOffset; i < timeOffset + ptNum; ++i) {
            for (String deviceId : deviceIds) {
                TSRecord record = new TSRecord(i, deviceId);
                for (MeasurementSchema measurementSchema : measurementSchemas) {
                    record.addTuple(DataPoint.getDataPoint((TSDataType)measurementSchema.getType(), (String)measurementSchema.getMeasurementId(), (String)String.valueOf(i + valueOffset)));
                }
                fileWriter.write(record);
                tsFileResource.updateStartTime(deviceId, i);
                tsFileResource.updateEndTime(deviceId, i);
            }
            if ((i + 1L) % flushInterval != 0L) continue;
            fileWriter.flushAllChunkGroups();
        }
        fileWriter.close();
    }

    private static void prepareSeries(List<MeasurementSchema> measurementSchemas, List<String> deviceIds) throws MetadataException {
        int i;
        for (i = 0; i < measurementNum; ++i) {
            measurementSchemas.add(new MeasurementSchema("sensor" + i, TSDataType.INT32, encoding, CompressionType.UNCOMPRESSED));
        }
        for (i = 0; i < deviceNum; ++i) {
            deviceIds.add("root.seriesReaderTest.device" + i);
        }
        IoTDB.metaManager.setStorageGroup(new PartialPath(SERIES_READER_TEST_SG));
        for (String device : deviceIds) {
            for (MeasurementSchema measurementSchema : measurementSchemas) {
                IoTDB.metaManager.createTimeseries(new PartialPath(device + '.' + measurementSchema.getMeasurementId()), measurementSchema.getType(), measurementSchema.getEncodingType(), measurementSchema.getCompressor(), Collections.emptyMap());
            }
        }
    }

    private static void removeFiles(List<TsFileResource> seqResources, List<TsFileResource> unseqResources) throws IOException {
        for (TsFileResource tsFileResource : seqResources) {
            tsFileResource.remove();
        }
        for (TsFileResource tsFileResource : unseqResources) {
            tsFileResource.remove();
        }
        FileReaderManager.getInstance().closeAndRemoveAllOpenedReaders();
        FileReaderManager.getInstance().stop();
    }
}

