/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.query.reader.series;

import java.io.IOException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import org.apache.iotdb.db.engine.querycontext.QueryDataSource;
import org.apache.iotdb.db.engine.storagegroup.TsFileResource;
import org.apache.iotdb.db.exception.metadata.IllegalPathException;
import org.apache.iotdb.db.exception.metadata.MetadataException;
import org.apache.iotdb.db.metadata.PartialPath;
import org.apache.iotdb.db.query.context.QueryContext;
import org.apache.iotdb.db.query.reader.series.SeriesReaderByTimestamp;
import org.apache.iotdb.db.query.reader.series.SeriesReaderTestUtil;
import org.apache.iotdb.tsfile.exception.write.WriteProcessException;
import org.apache.iotdb.tsfile.file.metadata.enums.TSDataType;
import org.apache.iotdb.tsfile.write.schema.MeasurementSchema;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class SeriesReaderByTimestampTest {
    private static final String SERIES_READER_TEST_SG = "root.seriesReaderTest";
    private List<String> deviceIds = new ArrayList<String>();
    private List<MeasurementSchema> measurementSchemas = new ArrayList<MeasurementSchema>();
    private List<TsFileResource> seqResources = new ArrayList<TsFileResource>();
    private List<TsFileResource> unseqResources = new ArrayList<TsFileResource>();

    @Before
    public void setUp() throws MetadataException, IOException, WriteProcessException {
        SeriesReaderTestUtil.setUp(this.measurementSchemas, this.deviceIds, this.seqResources, this.unseqResources);
    }

    @After
    public void tearDown() throws IOException {
        SeriesReaderTestUtil.tearDown(this.seqResources, this.unseqResources);
    }

    @Test
    public void test() throws IOException, IllegalPathException {
        QueryDataSource dataSource = new QueryDataSource(new PartialPath("root.seriesReaderTest.device0.sensor0"), this.seqResources, this.unseqResources);
        HashSet<String> allSensors = new HashSet<String>();
        allSensors.add("sensor0");
        SeriesReaderByTimestamp seriesReader = new SeriesReaderByTimestamp(new PartialPath("root.seriesReaderTest.device0.sensor0"), allSensors, TSDataType.INT32, new QueryContext(), dataSource, null, true);
        long[] timestamps = new long[500];
        for (int i = 0; i < 500; ++i) {
            timestamps[i] = i;
        }
        Object[] values = seriesReader.getValuesInTimestamps(timestamps, timestamps.length);
        for (int time = 0; time < 500; ++time) {
            if (time < 200) {
                Assert.assertEquals((Object)(time + 20000), (Object)values[time]);
                continue;
            }
            if (time < 260 || time >= 300 && time < 380 || time >= 400) {
                Assert.assertEquals((Object)(time + 10000), (Object)values[time]);
                continue;
            }
            Assert.assertEquals((Object)time, (Object)values[time]);
        }
    }
}

