/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.query.dataset;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.util.Collections;
import java.util.Map;
import org.apache.iotdb.db.query.dataset.ShowTimeSeriesResult;
import org.apache.iotdb.tsfile.file.metadata.enums.CompressionType;
import org.apache.iotdb.tsfile.file.metadata.enums.TSDataType;
import org.apache.iotdb.tsfile.file.metadata.enums.TSEncoding;
import org.junit.Assert;
import org.junit.Test;

public class ShowTimeSeriesResultTest {
    @Test
    public void serializeTest() throws IOException {
        Map<String, String> tag = Collections.singletonMap("tag1", "this is the first tag");
        Map<String, String> attribute = Collections.singletonMap("attribute1", "this is the first attribute");
        ShowTimeSeriesResult showTimeSeriesResult = new ShowTimeSeriesResult("root.sg1.d1.s1", "temperature", "root.sg1", TSDataType.DOUBLE, TSEncoding.GORILLA, CompressionType.SNAPPY, tag, attribute);
        ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
        showTimeSeriesResult.serialize((OutputStream)outputStream);
        ByteBuffer byteBuffer = ByteBuffer.wrap(outputStream.toByteArray());
        ShowTimeSeriesResult result = ShowTimeSeriesResult.deserialize((ByteBuffer)byteBuffer);
        Assert.assertEquals((Object)"root.sg1.d1.s1", (Object)result.getName());
        Assert.assertEquals((Object)"temperature", (Object)result.getAlias());
        Assert.assertEquals((Object)"root.sg1", (Object)result.getSgName());
        Assert.assertEquals((Object)TSDataType.DOUBLE, (Object)result.getDataType());
        Assert.assertEquals((Object)TSEncoding.GORILLA, (Object)result.getEncoding());
        Assert.assertEquals((Object)CompressionType.SNAPPY, (Object)result.getCompressor());
        Assert.assertEquals(tag, (Object)result.getTag());
        Assert.assertEquals(attribute, (Object)result.getAttribute());
    }
}

