/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.query.control;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Set;
import org.apache.commons.io.FileUtils;
import org.apache.iotdb.db.conf.IoTDBDescriptor;
import org.apache.iotdb.db.constant.TestConstant;
import org.apache.iotdb.db.engine.fileSystem.SystemFileFactory;
import org.apache.iotdb.db.engine.storagegroup.TsFileResource;
import org.apache.iotdb.db.query.control.TracingManager;
import org.apache.iotdb.db.utils.EnvironmentUtils;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class TracingManagerTest {
    private final String tracingDir = IoTDBDescriptor.getInstance().getConfig().getTracingDir();
    private TracingManager tracingManager;
    private final String sql = "select * from root.sg.device1 where time > 10";
    private final long queryId = 10L;
    private Set<TsFileResource> seqResources = new HashSet<TsFileResource>();

    @Before
    public void setUp() {
        this.tracingManager = TracingManager.getInstance();
        this.prepareTsFileResources();
    }

    @After
    public void tearDown() throws IOException {
        FileUtils.deleteDirectory((File)new File(this.tracingDir));
        EnvironmentUtils.cleanAllDir();
    }

    @Test
    public void tracingQueryTest() throws IOException {
        String str;
        if (!this.tracingManager.getWriterStatus()) {
            this.tracingManager.openTracingWriteStream();
        }
        String[] ans = new String[]{"Query Id: 10 - Query Statement: select * from root.sg.device1 where time > 10", "Query Id: 10 - Start time: 2020-12-", "Query Id: 10 - Number of series paths: 3", "Query Id: 10 - Query Statement: select * from root.sg.device1 where time > 10", "Query Id: 10 - Start time: 2020-12-", "Query Id: 10 - Number of series paths: 3", "Query Id: 10 - Number of sequence files: 1", "Query Id: 10 - SeqFile_1-1-0.tsfile root.sg.d1[1, 999], root.sg.d2[2, 998]", "Query Id: 10 - Number of unSequence files: 0", "Query Id: 10 - Number of chunks: 3", "Query Id: 10 - Average size of chunks: 1371", "Query Id: 10 - Total cost time: "};
        this.tracingManager.writeQueryInfo(10L, "select * from root.sg.device1 where time > 10", 1607529600000L);
        this.tracingManager.writePathsNum(10L, 3);
        this.tracingManager.writeQueryInfo(10L, "select * from root.sg.device1 where time > 10", 1607529600000L, 3);
        this.tracingManager.writeTsFileInfo(10L, this.seqResources, Collections.EMPTY_SET);
        this.tracingManager.writeChunksInfo(10L, 3L, 4113L);
        this.tracingManager.writeEndTime(10L);
        this.tracingManager.close();
        File tracingFile = SystemFileFactory.INSTANCE.getFile(this.tracingDir + File.separator + "tracing.txt");
        BufferedReader bufferedReader = new BufferedReader(new FileReader(tracingFile));
        int cnt = 0;
        while ((str = bufferedReader.readLine()) != null) {
            Assert.assertTrue((boolean)str.contains(ans[cnt++]));
        }
        bufferedReader.close();
    }

    void prepareTsFileResources() {
        HashMap<String, Integer> deviceToIndex = new HashMap<String, Integer>();
        deviceToIndex.put("root.sg.d1", 0);
        deviceToIndex.put("root.sg.d2", 1);
        long[] startTimes = new long[]{1L, 2L};
        long[] endTimes = new long[]{999L, 998L};
        File file1 = new File(TestConstant.OUTPUT_DATA_DIR.concat("1-1-0.tsfile"));
        TsFileResource tsFileResource1 = new TsFileResource(file1, deviceToIndex, startTimes, endTimes);
        tsFileResource1.setClosed(true);
        this.seqResources.add(tsFileResource1);
    }
}

