/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.qp.physical;

import java.io.ByteArrayOutputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.Arrays;
import java.util.List;
import org.apache.iotdb.db.exception.metadata.IllegalPathException;
import org.apache.iotdb.db.exception.metadata.MetadataException;
import org.apache.iotdb.db.exception.query.QueryProcessException;
import org.apache.iotdb.db.index.common.IndexType;
import org.apache.iotdb.db.metadata.MManager;
import org.apache.iotdb.db.metadata.PartialPath;
import org.apache.iotdb.db.qp.Planner;
import org.apache.iotdb.db.qp.logical.Operator;
import org.apache.iotdb.db.qp.physical.PhysicalPlan;
import org.apache.iotdb.db.qp.physical.crud.QueryIndexPlan;
import org.apache.iotdb.db.qp.physical.sys.CreateIndexPlan;
import org.apache.iotdb.db.qp.physical.sys.DropIndexPlan;
import org.apache.iotdb.db.utils.EnvironmentUtils;
import org.apache.iotdb.tsfile.file.metadata.enums.CompressionType;
import org.apache.iotdb.tsfile.file.metadata.enums.TSDataType;
import org.apache.iotdb.tsfile.file.metadata.enums.TSEncoding;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class IndexSubMatchingPhysicalPlanTest {
    private Planner processor = new Planner();

    @Before
    public void before() throws MetadataException {
        MManager.getInstance().init();
        MManager.getInstance().setStorageGroup(new PartialPath("root.Wind"));
        MManager.getInstance().createTimeseries(new PartialPath("root.Wind.AZQ02.Speed"), TSDataType.FLOAT, TSEncoding.PLAIN, CompressionType.UNCOMPRESSED, null);
    }

    @After
    public void clean() throws IOException {
        MManager.getInstance().clear();
        EnvironmentUtils.cleanAllDir();
    }

    @Test
    public void testCreateIndex() throws QueryProcessException {
        String sqlStr = "CREATE INDEX ON root.Wind.AZQ02.Speed WITH INDEX=ELB_INDEX, BLOCK_SIZE=5";
        Planner processor = new Planner();
        CreateIndexPlan plan = (CreateIndexPlan)processor.parseSQLToPhysicalPlan(sqlStr);
        System.out.println(plan);
        Assert.assertEquals((Object)"paths: [root.Wind.AZQ02.Speed], index type: ELB_INDEX, start time: 0, props: {BLOCK_SIZE=5}", (Object)plan.toString());
    }

    @Test
    public void testDropIndex() throws QueryProcessException {
        String sqlStr = "DROP INDEX ELB_INDEX ON root.Wind.AZQ02.Speed";
        Planner processor = new Planner();
        DropIndexPlan plan = (DropIndexPlan)processor.parseSQLToPhysicalPlan(sqlStr);
        Assert.assertEquals((Object)"paths: [root.Wind.AZQ02.Speed], index type: ELB_INDEX", (Object)plan.toString());
    }

    @Test
    public void testQueryIndex() throws QueryProcessException {
        String sqlStr = "SELECT Speed.* FROM root.Wind.AZQ02 WHERE Speed CONTAIN (15, 14, 12, 12, 12, 11) WITH TOLERANCE 1 CONCAT (10, 20, 25, 24, 14, 8) WITH TOLERANCE 2 CONCAT  (8, 9, 10, 14, 15, 15) WITH TOLERANCE 1";
        PhysicalPlan plan = this.processor.parseSQLToPhysicalPlan(sqlStr);
        Assert.assertEquals(QueryIndexPlan.class, plan.getClass());
        QueryIndexPlan queryIndexPlan = (QueryIndexPlan)plan;
        Assert.assertEquals((Object)Operator.OperatorType.QUERY_INDEX, (Object)queryIndexPlan.getOperatorType());
        Assert.assertEquals((Object)IndexType.ELB_INDEX, (Object)queryIndexPlan.getIndexType());
        Assert.assertEquals((long)1L, (long)queryIndexPlan.getPaths().size());
        Assert.assertEquals((Object)"root.Wind.AZQ02.Speed", (Object)((PartialPath)queryIndexPlan.getPaths().get(0)).getFullPath());
        Assert.assertEquals((long)2L, (long)queryIndexPlan.getProps().size());
        Assert.assertEquals((Object)"[1.0, 2.0, 1.0]", (Object)queryIndexPlan.getProps().get("THRESHOLD").toString());
        Assert.assertTrue((boolean)(queryIndexPlan.getProps().get("PATTERN") instanceof List));
        List pattern = (List)queryIndexPlan.getProps().get("PATTERN");
        Assert.assertEquals((Object)"[15.0, 14.0, 12.0, 12.0, 12.0, 11.0]", (Object)Arrays.toString((double[])pattern.get(0)));
        Assert.assertEquals((Object)"[10.0, 20.0, 25.0, 24.0, 14.0, 8.0]", (Object)Arrays.toString((double[])pattern.get(1)));
        Assert.assertEquals((Object)"[8.0, 9.0, 10.0, 14.0, 15.0, 15.0]", (Object)Arrays.toString((double[])pattern.get(2)));
    }

    @Test
    public void testCreateIndexSerialize() throws QueryProcessException, IOException, IllegalPathException {
        String sqlStr = "CREATE INDEX ON root.Wind.AZQ02.Speed WITH INDEX=ELB_INDEX, BLOCK_SIZE=5";
        PhysicalPlan plan = this.processor.parseSQLToPhysicalPlan(sqlStr);
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        try (DataOutputStream dataOutputStream = new DataOutputStream(byteArrayOutputStream);){
            plan.serialize(dataOutputStream);
            ByteBuffer buffer = ByteBuffer.wrap(byteArrayOutputStream.toByteArray());
            PhysicalPlan planB = PhysicalPlan.Factory.create((ByteBuffer)buffer);
            Assert.assertEquals((Object)plan, (Object)planB);
        }
        ByteBuffer buffer = ByteBuffer.allocate(4096);
        plan.serialize(buffer);
        buffer.flip();
        PhysicalPlan planB = PhysicalPlan.Factory.create((ByteBuffer)buffer);
        Assert.assertEquals((Object)plan, (Object)planB);
    }

    @Test
    public void testDropIndexSerialize() throws QueryProcessException, IOException, IllegalPathException {
        String sqlStr = "DROP INDEX ELB_INDEX ON root.Wind.AZQ02.Speed";
        PhysicalPlan plan = this.processor.parseSQLToPhysicalPlan(sqlStr);
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        try (DataOutputStream dataOutputStream = new DataOutputStream(byteArrayOutputStream);){
            plan.serialize(dataOutputStream);
            ByteBuffer buffer = ByteBuffer.wrap(byteArrayOutputStream.toByteArray());
            PhysicalPlan planB = PhysicalPlan.Factory.create((ByteBuffer)buffer);
            Assert.assertEquals((Object)plan, (Object)planB);
        }
        ByteBuffer buffer = ByteBuffer.allocate(4096);
        plan.serialize(buffer);
        buffer.flip();
        PhysicalPlan planB = PhysicalPlan.Factory.create((ByteBuffer)buffer);
        Assert.assertEquals((Object)plan, (Object)planB);
    }
}

