/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.qp.other;

import java.util.Arrays;
import java.util.Collection;
import org.apache.iotdb.db.exception.query.QueryProcessException;
import org.apache.iotdb.db.metadata.PartialPath;
import org.apache.iotdb.db.qp.Planner;
import org.apache.iotdb.db.qp.physical.sys.AuthorPlan;
import org.apache.iotdb.tsfile.read.common.Path;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

@RunWith(value=Parameterized.class)
public class TSPlanContextAuthorTest {
    private static Path[] emptyPaths = new Path[0];
    private static Path[] testPaths = new Path[]{new Path("root.node1.a", "b")};
    private String inputSQL;
    private Path[] paths;

    public TSPlanContextAuthorTest(String inputSQL, Path[] paths) {
        this.inputSQL = inputSQL;
        this.paths = paths;
    }

    @Parameterized.Parameters
    public static Collection<Object[]> data() {
        return Arrays.asList({"CREATE USER username1 'password1'", emptyPaths}, {"DROP USER username", emptyPaths}, {"CREATE ROLE rolename", emptyPaths}, {"DROP ROLE rolename", emptyPaths}, {"GRANT USER username PRIVILEGES 'SET_STORAGE_GROUP','INSERT_TIMESERIES' ON root.node1.a.b", testPaths}, {"REVOKE USER username PRIVILEGES 'SET_STORAGE_GROUP','INSERT_TIMESERIES' ON root.node1.a.b", testPaths}, {"GRANT ROLE rolename PRIVILEGES 'SET_STORAGE_GROUP','INSERT_TIMESERIES' ON root.node1.a.b", testPaths}, {"REVOKE ROLE rolename PRIVILEGES 'SET_STORAGE_GROUP','INSERT_TIMESERIES' ON root.node1.a.b", testPaths}, {"GRANT rolename TO username", emptyPaths}, {"REVOKE rolename FROM username", emptyPaths});
    }

    @Test
    public void testAnalyzeAuthor() throws QueryProcessException {
        Planner processor = new Planner();
        AuthorPlan author = (AuthorPlan)processor.parseSQLToPhysicalPlan(this.inputSQL);
        if (author == null) {
            Assert.fail();
        }
        Assert.assertArrayEquals((Object[])this.paths, (Object[])author.getPaths().stream().map(PartialPath::toTSFilePath).toArray());
    }
}

