/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.qp.logical;

import java.time.ZoneId;
import java.util.Arrays;
import java.util.List;
import org.apache.iotdb.db.index.common.IndexType;
import org.apache.iotdb.db.metadata.PartialPath;
import org.apache.iotdb.db.qp.logical.Operator;
import org.apache.iotdb.db.qp.logical.crud.QueryOperator;
import org.apache.iotdb.db.qp.logical.sys.CreateIndexOperator;
import org.apache.iotdb.db.qp.logical.sys.DropIndexOperator;
import org.apache.iotdb.db.qp.strategy.LogicalGenerator;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class IndexLogicalPlanTest {
    private LogicalGenerator generator;

    @Before
    public void before() {
        this.generator = new LogicalGenerator();
    }

    @Test
    public void testParseCreateIndexWholeMatching() {
        String sqlStr = "CREATE INDEX ON root.Ery.*.Glu WHERE time > 50 WITH INDEX=RTREE_PAA, PAA_dim=8";
        Operator op = this.generator.generate(sqlStr, ZoneId.systemDefault());
        Assert.assertEquals(CreateIndexOperator.class, op.getClass());
        CreateIndexOperator createOperator = (CreateIndexOperator)op;
        Assert.assertEquals((Object)Operator.OperatorType.CREATE_INDEX, (Object)createOperator.getType());
        Assert.assertNotNull((Object)createOperator.getSelectedPaths());
        Assert.assertEquals((Object)"root.Ery.*.Glu", (Object)((PartialPath)createOperator.getSelectedPaths().get(0)).toString());
        Assert.assertNull((Object)createOperator.getFromOperator());
        Assert.assertEquals((Object)IndexType.RTREE_PAA, (Object)createOperator.getIndexType());
        Assert.assertEquals((long)50L, (long)createOperator.getTime());
        Assert.assertEquals((long)1L, (long)createOperator.getProps().size());
        Assert.assertEquals((Object)"8", createOperator.getProps().get("PAA_DIM"));
    }

    @Test
    public void testParseCreateIndexSubMatching() {
        String sqlStr = "CREATE INDEX ON root.Wind.AZQ02.Speed WITH INDEX=ELB_INDEX, BLOCK_SIZE=5";
        Operator op = this.generator.generate(sqlStr, ZoneId.systemDefault());
        Assert.assertEquals(CreateIndexOperator.class, op.getClass());
        CreateIndexOperator createOperator = (CreateIndexOperator)op;
        Assert.assertEquals((Object)Operator.OperatorType.CREATE_INDEX, (Object)createOperator.getType());
        Assert.assertNotNull((Object)createOperator.getSelectedPaths());
        Assert.assertEquals((Object)"root.Wind.AZQ02.Speed", (Object)((PartialPath)createOperator.getSelectedPaths().get(0)).toString());
        Assert.assertNull((Object)createOperator.getFromOperator());
        Assert.assertEquals((Object)IndexType.ELB_INDEX, (Object)createOperator.getIndexType());
        Assert.assertEquals((long)1L, (long)createOperator.getProps().size());
        Assert.assertEquals((Object)"5", createOperator.getProps().get("BLOCK_SIZE"));
    }

    @Test
    public void testParseDropIndexWholeMatching() {
        String sqlStr = "DROP INDEX RTREE_PAA ON root.Ery.*.Glu";
        Operator op = this.generator.generate(sqlStr, ZoneId.systemDefault());
        Assert.assertEquals(DropIndexOperator.class, op.getClass());
        DropIndexOperator dropIndexOperator = (DropIndexOperator)op;
        Assert.assertEquals((Object)Operator.OperatorType.DROP_INDEX, (Object)dropIndexOperator.getType());
        Assert.assertNotNull((Object)dropIndexOperator.getSelectedPaths());
        Assert.assertEquals((Object)"root.Ery.*.Glu", (Object)((PartialPath)dropIndexOperator.getSelectedPaths().get(0)).toString());
        Assert.assertNull((Object)dropIndexOperator.getFromOperator());
        Assert.assertEquals((Object)IndexType.RTREE_PAA, (Object)dropIndexOperator.getIndexType());
    }

    @Test
    public void testParseDropIndexSubMatching() {
        String sqlStr = "DROP INDEX ELB_INDEX ON root.Wind.AZQ02.Speed";
        Operator op = this.generator.generate(sqlStr, ZoneId.systemDefault());
        Assert.assertEquals(DropIndexOperator.class, op.getClass());
        DropIndexOperator dropIndexOperator = (DropIndexOperator)op;
        Assert.assertEquals((Object)Operator.OperatorType.DROP_INDEX, (Object)dropIndexOperator.getType());
        Assert.assertNotNull((Object)dropIndexOperator.getSelectedPaths());
        Assert.assertEquals((Object)"root.Wind.AZQ02.Speed", (Object)((PartialPath)dropIndexOperator.getSelectedPaths().get(0)).toString());
        Assert.assertNull((Object)dropIndexOperator.getFromOperator());
        Assert.assertEquals((Object)IndexType.ELB_INDEX, (Object)dropIndexOperator.getIndexType());
    }

    @Test
    public void testParseQueryIndexWholeMatching() {
        String sqlStr = "SELECT TOP 2 Glu FROM root.Ery.* WHERE Glu LIKE (0, 120, 20, 80, 120, 100, 80, 0)";
        Operator op = this.generator.generate(sqlStr, ZoneId.systemDefault());
        Assert.assertEquals(QueryOperator.class, op.getClass());
        QueryOperator queryOperator = (QueryOperator)op;
        Assert.assertEquals((Object)Operator.OperatorType.QUERY, (Object)queryOperator.getType());
        Assert.assertEquals((Object)"Glu", (Object)((PartialPath)queryOperator.getSelectedPaths().get(0)).getFullPath());
        Assert.assertEquals((Object)"root.Ery.*", (Object)((PartialPath)queryOperator.getFromOperator().getPrefixPaths().get(0)).getFullPath());
        Assert.assertEquals((Object)IndexType.RTREE_PAA, (Object)queryOperator.getIndexType());
        Assert.assertEquals((long)2L, (long)queryOperator.getProps().size());
        Assert.assertEquals((long)2L, (long)((Integer)queryOperator.getProps().get("TOP_K")).intValue());
        Assert.assertEquals((Object)"[0.0, 120.0, 20.0, 80.0, 120.0, 100.0, 80.0, 0.0]", (Object)Arrays.toString((double[])queryOperator.getProps().get("PATTERN")));
    }

    @Test
    public void testParseQueryIndexSubMatching() {
        String sqlStr = "SELECT Speed.* FROM root.Wind.AZQ02 WHERE Speed CONTAIN (15, 14, 12, 12, 12, 11) WITH TOLERANCE 1 CONCAT (10, 20, 25, 24, 14, 8) WITH TOLERANCE 2 CONCAT  (8, 9, 10, 14, 15, 15) WITH TOLERANCE 1";
        Operator op = this.generator.generate(sqlStr, ZoneId.systemDefault());
        Assert.assertEquals(QueryOperator.class, op.getClass());
        QueryOperator queryOperator = (QueryOperator)op;
        Assert.assertEquals((Object)Operator.OperatorType.QUERY, (Object)queryOperator.getType());
        Assert.assertEquals((Object)"Speed", (Object)((PartialPath)queryOperator.getSelectedPaths().get(0)).getFullPath());
        Assert.assertEquals((Object)"root.Wind.AZQ02", (Object)((PartialPath)queryOperator.getFromOperator().getPrefixPaths().get(0)).getFullPath());
        Assert.assertEquals((Object)IndexType.ELB_INDEX, (Object)queryOperator.getIndexType());
        Assert.assertEquals((long)2L, (long)queryOperator.getProps().size());
        Assert.assertEquals((Object)"[1.0, 2.0, 1.0]", (Object)queryOperator.getProps().get("THRESHOLD").toString());
        Assert.assertTrue((boolean)(queryOperator.getProps().get("PATTERN") instanceof List));
        List pattern = (List)queryOperator.getProps().get("PATTERN");
        Assert.assertEquals((Object)"[15.0, 14.0, 12.0, 12.0, 12.0, 11.0]", (Object)Arrays.toString((double[])pattern.get(0)));
        Assert.assertEquals((Object)"[10.0, 20.0, 25.0, 24.0, 14.0, 8.0]", (Object)Arrays.toString((double[])pattern.get(1)));
        Assert.assertEquals((Object)"[8.0, 9.0, 10.0, 14.0, 15.0, 15.0]", (Object)Arrays.toString((double[])pattern.get(2)));
    }
}

