/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.qp;

import java.time.ZoneId;
import java.util.ArrayList;
import java.util.Collections;
import org.antlr.v4.runtime.misc.ParseCancellationException;
import org.apache.iotdb.db.exception.metadata.IllegalPathException;
import org.apache.iotdb.db.exception.query.QueryProcessException;
import org.apache.iotdb.db.exception.runtime.SQLParserException;
import org.apache.iotdb.db.metadata.MManager;
import org.apache.iotdb.db.metadata.PartialPath;
import org.apache.iotdb.db.qp.Planner;
import org.apache.iotdb.db.qp.logical.Operator;
import org.apache.iotdb.db.qp.physical.PhysicalPlan;
import org.apache.iotdb.db.qp.physical.crud.InsertRowPlan;
import org.apache.iotdb.db.service.IoTDB;
import org.apache.iotdb.db.utils.EnvironmentUtils;
import org.apache.iotdb.service.rpc.thrift.TSRawDataQueryReq;
import org.apache.iotdb.tsfile.common.conf.TSFileDescriptor;
import org.apache.iotdb.tsfile.file.metadata.enums.CompressionType;
import org.apache.iotdb.tsfile.file.metadata.enums.TSDataType;
import org.apache.iotdb.tsfile.file.metadata.enums.TSEncoding;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class PlannerTest {
    private CompressionType compressionType = TSFileDescriptor.getInstance().getConfig().getCompressor();
    private MManager mManager = IoTDB.metaManager;
    private Planner processor = new Planner();

    @Before
    public void setUp() throws Exception {
        EnvironmentUtils.envSetUp();
        this.mManager.setStorageGroup(new PartialPath("root.vehicle"));
        this.mManager.setStorageGroup(new PartialPath("root.vehicle1"));
        this.mManager.createTimeseries(new PartialPath("root.vehicle.device1.sensor1"), TSDataType.valueOf((String)"INT32"), TSEncoding.valueOf((String)"RLE"), this.compressionType, Collections.emptyMap());
        this.mManager.createTimeseries(new PartialPath("root.vehicle.device1.sensor2"), TSDataType.valueOf((String)"INT32"), TSEncoding.valueOf((String)"RLE"), this.compressionType, Collections.emptyMap());
        this.mManager.createTimeseries(new PartialPath("root.vehicle.device1.sensor3"), TSDataType.valueOf((String)"INT32"), TSEncoding.valueOf((String)"RLE"), this.compressionType, Collections.emptyMap());
        this.mManager.createTimeseries(new PartialPath("root.vehicle.device2.sensor1"), TSDataType.valueOf((String)"INT32"), TSEncoding.valueOf((String)"RLE"), this.compressionType, Collections.emptyMap());
        this.mManager.createTimeseries(new PartialPath("root.vehicle.device2.sensor2"), TSDataType.valueOf((String)"INT32"), TSEncoding.valueOf((String)"RLE"), this.compressionType, Collections.emptyMap());
        this.mManager.createTimeseries(new PartialPath("root.vehicle.device2.sensor3"), TSDataType.valueOf((String)"INT32"), TSEncoding.valueOf((String)"RLE"), this.compressionType, Collections.emptyMap());
        this.mManager.createTimeseries(new PartialPath("root.vehicle1.device1.sensor1"), TSDataType.valueOf((String)"INT32"), TSEncoding.valueOf((String)"RLE"), this.compressionType, Collections.emptyMap());
        this.mManager.createTimeseries(new PartialPath("root.vehicle1.device1.sensor2"), TSDataType.valueOf((String)"INT32"), TSEncoding.valueOf((String)"RLE"), this.compressionType, Collections.emptyMap());
        this.mManager.createTimeseries(new PartialPath("root.vehicle1.device1.sensor3"), TSDataType.valueOf((String)"INT32"), TSEncoding.valueOf((String)"RLE"), this.compressionType, Collections.emptyMap());
        this.mManager.createTimeseries(new PartialPath("root.vehicle1.device2.sensor1"), TSDataType.valueOf((String)"INT32"), TSEncoding.valueOf((String)"RLE"), this.compressionType, Collections.emptyMap());
        this.mManager.createTimeseries(new PartialPath("root.vehicle1.device2.sensor2"), TSDataType.valueOf((String)"INT32"), TSEncoding.valueOf((String)"RLE"), this.compressionType, Collections.emptyMap());
        this.mManager.createTimeseries(new PartialPath("root.vehicle1.device2.sensor3"), TSDataType.valueOf((String)"INT32"), TSEncoding.valueOf((String)"RLE"), this.compressionType, Collections.emptyMap());
    }

    @After
    public void tearDown() throws Exception {
        EnvironmentUtils.cleanEnv();
    }

    @Test
    public void parseSQLToPhysicalPlan() throws Exception {
        String createSGStatement = "set storage group to root.vehicle";
        PhysicalPlan plan1 = this.processor.parseSQLToPhysicalPlan(createSGStatement);
        Assert.assertEquals((Object)Operator.OperatorType.SET_STORAGE_GROUP, (Object)plan1.getOperatorType());
        String createTSStatement1 = "create timeseries root.vehicle.d1.s1 with datatype=INT32,encoding=RLE";
        PhysicalPlan plan2 = this.processor.parseSQLToPhysicalPlan(createTSStatement1);
        Assert.assertEquals((Object)Operator.OperatorType.CREATE_TIMESERIES, (Object)plan2.getOperatorType());
        String deleteTSStatement = "delete timeseries root.vehicle.d1.s1";
        PhysicalPlan plan3 = this.processor.parseSQLToPhysicalPlan(deleteTSStatement);
        Assert.assertEquals((Object)Operator.OperatorType.DELETE_TIMESERIES, (Object)plan3.getOperatorType());
        String insertStatement = "insert into root.vehicle.d0(timestamp,s0) values(10,100)";
        PhysicalPlan plan4 = this.processor.parseSQLToPhysicalPlan(insertStatement);
        Assert.assertEquals((Object)Operator.OperatorType.INSERT, (Object)plan4.getOperatorType());
        String deleteStatement = "DELETE FROM root.device0.sensor0,root.device0.sensor1 WHERE time <= 5000";
        PhysicalPlan plan6 = this.processor.parseSQLToPhysicalPlan(deleteStatement);
        Assert.assertEquals((Object)Operator.OperatorType.DELETE, (Object)plan6.getOperatorType());
        String queryStatement1 = "select * from root.vehicle where root.vehicle.device1.sensor1 > 50";
        PhysicalPlan plan7 = this.processor.parseSQLToPhysicalPlan(queryStatement1);
        Assert.assertEquals((Object)Operator.OperatorType.QUERY, (Object)plan7.getOperatorType());
        String aggregationStatement = "select sum(*) from root.vehicle where root.vehicle.device1.sensor1 > 50";
        PhysicalPlan plan8 = this.processor.parseSQLToPhysicalPlan(aggregationStatement);
        Assert.assertEquals((Object)Operator.OperatorType.AGGREGATION, (Object)plan8.getOperatorType());
        String groupbyStatement = "select sum(*) from root.vehicle where root.vehicle.device1.sensor1 > 50 group by ([100,1100), 20ms)";
        PhysicalPlan plan9 = this.processor.parseSQLToPhysicalPlan(groupbyStatement);
        Assert.assertEquals((Object)Operator.OperatorType.GROUPBYTIME, (Object)plan9.getOperatorType());
        String fillStatement = "select sensor1 from root.vehicle.device1 where time = 50 Fill(int32[linear, 5m, 5m], boolean[previous, 5m])";
        PhysicalPlan plan10 = this.processor.parseSQLToPhysicalPlan(fillStatement);
        Assert.assertEquals((Object)Operator.OperatorType.FILL, (Object)plan10.getOperatorType());
        String insertTimeStatement = "insert into root.vehicle.d0(time,s0) values(10,100)";
        PhysicalPlan plan11 = this.processor.parseSQLToPhysicalPlan(insertTimeStatement);
        Assert.assertEquals((Object)Operator.OperatorType.INSERT, (Object)plan11.getOperatorType());
        String createTSStatement2 = "create timeseries root.a.b.d_1.1s with datatype=FLOAT,encoding=RLE";
        PhysicalPlan plan12 = this.processor.parseSQLToPhysicalPlan(createTSStatement2);
        Assert.assertEquals((Object)Operator.OperatorType.CREATE_TIMESERIES, (Object)plan12.getOperatorType());
        String queryStatement2 = "select windDirection10min from root.national.4.5.585.9_6666.9_333.88_9";
        PhysicalPlan plan13 = this.processor.parseSQLToPhysicalPlan(queryStatement2);
        Assert.assertEquals((Object)Operator.OperatorType.QUERY, (Object)plan13.getOperatorType());
        String insertStatementException = "insert into root.vehicle.d0(timestamp,s0,s1) values(10,100)";
        try {
            this.processor.parseSQLToPhysicalPlan(insertStatementException);
        }
        catch (Exception e) {
            Assert.assertEquals((Object)new SQLParserException("the measurementList's size 2 is not consistent with the valueList's size 1").getMessage(), (Object)e.getMessage());
        }
    }

    @Test
    public void parseShowChildNodeToPhysicalPlan() throws Exception {
        String showChildNodesStatement = "show child nodes root.vehicle1.device1";
        PhysicalPlan plan14 = this.processor.parseSQLToPhysicalPlan(showChildNodesStatement);
        Assert.assertEquals((Object)Operator.OperatorType.SHOW, (Object)plan14.getOperatorType());
    }

    @Test(expected=ParseCancellationException.class)
    public void parseErrorSQLToPhysicalPlan() throws QueryProcessException {
        String createTSStatement = "create timeseriess root.vehicle.d1.s1 with datatype=INT32,encoding=RLE";
        this.processor.parseSQLToPhysicalPlan(createTSStatement);
    }

    @Test
    public void insertStatementWithNullValue() throws QueryProcessException {
        String createTSStatement = "insert into root.vehicle.d0(time,s0) values(10,NaN)";
        PhysicalPlan physicalPlan = this.processor.parseSQLToPhysicalPlan(createTSStatement);
        Assert.assertTrue((boolean)(physicalPlan instanceof InsertRowPlan));
        Assert.assertEquals((Object)"NaN", (Object)((InsertRowPlan)physicalPlan).getValues()[0]);
        Assert.assertEquals((double)Double.NaN, (double)Double.parseDouble("NaN"), (double)1.0E-15);
    }

    @Test
    public void rawDataQueryReqToPhysicalPlanTest() throws QueryProcessException, IllegalPathException {
        TSRawDataQueryReq tsRawDataQueryReq = new TSRawDataQueryReq();
        ArrayList<String> paths = new ArrayList<String>();
        paths.add("root.vehicle.device1.sensor1");
        paths.add("root.vehicle.device1.sensor2");
        tsRawDataQueryReq.setPaths(paths);
        tsRawDataQueryReq.setStartTime(0L);
        tsRawDataQueryReq.setEndTime(100L);
        tsRawDataQueryReq.setFetchSize(1000);
        PhysicalPlan physicalPlan = this.processor.rawDataQueryReqToPhysicalPlan(tsRawDataQueryReq, ZoneId.of("Asia/Shanghai"));
        Assert.assertEquals((Object)Operator.OperatorType.QUERY, (Object)physicalPlan.getOperatorType());
        Assert.assertEquals(paths.get(0), (Object)((PartialPath)physicalPlan.getPaths().get(0)).getFullPath());
        Assert.assertEquals(paths.get(1), (Object)((PartialPath)physicalPlan.getPaths().get(1)).getFullPath());
    }

    static {
        IoTDB.metaManager.init();
    }
}

