/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.mqtt;

import io.moquette.interception.messages.InterceptPublishMessage;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import io.netty.handler.codec.mqtt.MqttFixedHeader;
import io.netty.handler.codec.mqtt.MqttMessageType;
import io.netty.handler.codec.mqtt.MqttPublishMessage;
import io.netty.handler.codec.mqtt.MqttPublishVariableHeader;
import io.netty.handler.codec.mqtt.MqttQoS;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import org.apache.iotdb.db.mqtt.PayloadFormatManager;
import org.apache.iotdb.db.mqtt.PayloadFormatter;
import org.apache.iotdb.db.mqtt.PublishHandler;
import org.apache.iotdb.db.qp.executor.IPlanExecutor;
import org.apache.iotdb.db.qp.physical.PhysicalPlan;
import org.apache.iotdb.db.qp.physical.crud.InsertRowPlan;
import org.junit.Test;
import org.mockito.ArgumentMatchers;
import org.mockito.Mockito;

public class PublishHandlerTest {
    @Test
    public void onPublish() throws Exception {
        IPlanExecutor executor = (IPlanExecutor)Mockito.mock(IPlanExecutor.class);
        PayloadFormatter payloadFormat = PayloadFormatManager.getPayloadFormat((String)"json");
        PublishHandler handler = new PublishHandler(executor, payloadFormat);
        String payload = "{\n\"device\":\"root.sg.d1\",\n\"timestamp\":1586076045524,\n\"measurements\":[\"s1\"],\n\"values\":[0.530635]\n}";
        ByteBuf buf = Unpooled.copiedBuffer((CharSequence)payload, (Charset)StandardCharsets.UTF_8);
        MqttPublishVariableHeader variableHeader = new MqttPublishVariableHeader("root.sg.d1", 1);
        MqttFixedHeader fixedHeader = new MqttFixedHeader(MqttMessageType.PUBLISH, false, MqttQoS.AT_LEAST_ONCE, false, 1);
        MqttPublishMessage publishMessage = new MqttPublishMessage(fixedHeader, variableHeader, buf);
        InterceptPublishMessage message = new InterceptPublishMessage(publishMessage, null, null);
        handler.onPublish(message);
        ((IPlanExecutor)Mockito.verify((Object)executor)).processNonQuery((PhysicalPlan)ArgumentMatchers.any(InsertRowPlan.class));
    }
}

