/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.mqtt;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import org.apache.iotdb.db.mqtt.JSONPayloadFormatter;
import org.apache.iotdb.db.mqtt.Message;
import org.junit.Assert;
import org.junit.Test;

public class JSONPayloadFormatTest {
    @Test
    public void formatJson() {
        String payload = " {\n      \"device\":\"root.sg.d1\",\n      \"timestamp\":1586076045524,\n      \"measurements\":[\"s1\",\"s2\"],\n      \"values\":[0.530635,0.530635]\n }";
        ByteBuf buf = Unpooled.copiedBuffer((CharSequence)payload, (Charset)StandardCharsets.UTF_8);
        JSONPayloadFormatter formatter = new JSONPayloadFormatter();
        Message message = (Message)formatter.format(buf).get(0);
        Assert.assertEquals((Object)"root.sg.d1", (Object)message.getDevice());
        Assert.assertEquals((Object)1586076045524L, (Object)message.getTimestamp());
        Assert.assertEquals((Object)"s1", message.getMeasurements().get(0));
        Assert.assertEquals((double)0.530635, (double)Double.parseDouble((String)message.getValues().get(0)), (double)0.0);
    }

    @Test
    public void formatBatchJson() {
        String payload = " {\n      \"device\":\"root.sg.d1\",\n      \"timestamps\":[1586076045524,1586076065526],\n      \"measurements\":[\"s1\",\"s2\"],\n      \"values\":[[0.530635,0.530635], [0.530655,0.530695]]\n  }";
        ByteBuf buf = Unpooled.copiedBuffer((CharSequence)payload, (Charset)StandardCharsets.UTF_8);
        JSONPayloadFormatter formatter = new JSONPayloadFormatter();
        Message message = (Message)formatter.format(buf).get(1);
        Assert.assertEquals((Object)"root.sg.d1", (Object)message.getDevice());
        Assert.assertEquals((Object)1586076065526L, (Object)message.getTimestamp());
        Assert.assertEquals((Object)"s2", message.getMeasurements().get(1));
        Assert.assertEquals((double)0.530695, (double)Double.parseDouble((String)message.getValues().get(1)), (double)0.0);
    }
}

