/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.monitor;

import java.io.File;
import java.io.IOException;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.ResultSet;
import java.sql.Statement;
import org.apache.iotdb.db.conf.IoTDBConfig;
import org.apache.iotdb.db.conf.IoTDBDescriptor;
import org.apache.iotdb.db.engine.StorageEngine;
import org.apache.iotdb.db.exception.StorageEngineException;
import org.apache.iotdb.db.exception.metadata.MetadataException;
import org.apache.iotdb.db.monitor.StatMonitor;
import org.apache.iotdb.db.utils.EnvironmentUtils;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class IoTDBStatMonitorTest {
    private static final Logger logger = LoggerFactory.getLogger(IoTDBStatMonitorTest.class);
    private StatMonitor statMonitor;
    private final IoTDBConfig config = IoTDBDescriptor.getInstance().getConfig();
    private static final String STORAGE_GROUP_NAME = "root.sg";
    private static String[] dataset = new String[]{"SET STORAGE GROUP TO root.sg", "CREATE TIMESERIES root.sg.d1.s1 WITH DATATYPE=INT32, ENCODING=RLE", "insert into root.sg.d1(timestamp,s1) values(5,5)", "insert into root.sg.d1(timestamp,s1) values(12,12)", "insert into root.sg.d1(timestamp,s1) values(15,15)", "insert into root.sg.d1(timestamp,s1) values(25,25)", "insert into root.sg.d1(timestamp,s1) values(100,100)"};

    @Before
    public void setUp() throws Exception {
        this.config.setEnableStatMonitor(true);
        this.config.setEnableMonitorSeriesWrite(true);
        EnvironmentUtils.envSetUp();
        this.statMonitor = StatMonitor.getInstance();
        if (this.statMonitor.globalSeries.isEmpty()) {
            this.statMonitor.initMonitorSeriesInfo();
        }
        this.insertSomeData();
    }

    @After
    public void tearDown() throws IOException, StorageEngineException {
        this.config.setEnableStatMonitor(false);
        this.config.setEnableMonitorSeriesWrite(false);
        this.statMonitor.close();
        EnvironmentUtils.cleanEnv();
    }

    @Test
    public void completeTest() throws Exception {
        this.getValueInMemoryTest();
        this.statMonitor.saveStatValue(STORAGE_GROUP_NAME);
        this.saveStatValueTest();
        EnvironmentUtils.restartDaemon();
        long time = 0L;
        while (!StorageEngine.getInstance().isAllSgReady()) {
            Thread.sleep(500L);
            if ((time += 500L) > 10000L) {
                logger.warn("wait for sg ready for : " + time / 1000L + " s");
            }
            if (time <= 30000L) continue;
            throw new IllegalStateException("wait too long in IoTDBStatMonitorTest");
        }
        this.recoveryTest();
    }

    private void getValueInMemoryTest() {
        Assert.assertEquals((Object)true, (Object)this.statMonitor.getEnableStatMonitor());
        Assert.assertEquals((long)5L, (long)this.statMonitor.getGlobalTotalPointsNum());
        Assert.assertEquals((long)0L, (long)this.statMonitor.getGlobalReqFailNum());
        Assert.assertEquals((long)5L, (long)this.statMonitor.getGlobalReqSuccessNum());
        Assert.assertEquals((long)5L, (long)this.statMonitor.getStorageGroupTotalPointsNum(STORAGE_GROUP_NAME));
        Assert.assertEquals((long)0L, (long)this.statMonitor.getDataSizeInByte());
        Assert.assertEquals((Object)new File(this.config.getSystemDir()).getAbsolutePath(), (Object)this.statMonitor.getSystemDirectory());
        Assert.assertEquals((Object)this.config.isEnableWal(), (Object)this.statMonitor.getWriteAheadLogStatus());
    }

    private void saveStatValueTest() throws MetadataException, StorageEngineException {
        try (Connection connection = DriverManager.getConnection("jdbc:iotdb://127.0.0.1:6667/", "root", "root");
             Statement statement = connection.createStatement();){
            long ans;
            boolean hasResult = statement.execute("select TOTAL_POINTS from root.stats.\"root.sg\"");
            Assert.assertTrue((boolean)hasResult);
            int cnt = 0;
            try (ResultSet resultSet = statement.getResultSet();){
                while (resultSet.next()) {
                    ans = resultSet.getLong("root.stats.\"root.sg\".TOTAL_POINTS");
                    Assert.assertEquals((long)5L, (long)ans);
                    ++cnt;
                }
                Assert.assertEquals((long)1L, (long)cnt);
            }
            hasResult = statement.execute("select TOTAL_POINTS from root.stats.\"global\"");
            Assert.assertTrue((boolean)hasResult);
            cnt = 0;
            resultSet = statement.getResultSet();
            try {
                while (resultSet.next()) {
                    ans = resultSet.getLong("root.stats.\"global\".TOTAL_POINTS");
                    Assert.assertEquals((long)6L, (long)ans);
                    ++cnt;
                }
                Assert.assertEquals((long)1L, (long)cnt);
            }
            finally {
                if (resultSet != null) {
                    resultSet.close();
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void recoveryTest() {
        this.statMonitor.recovery();
        Assert.assertEquals((long)5L, (long)this.statMonitor.getStorageGroupTotalPointsNum(STORAGE_GROUP_NAME));
        Assert.assertEquals((long)6L, (long)this.statMonitor.getGlobalTotalPointsNum());
        Assert.assertEquals((long)7L, (long)this.statMonitor.getGlobalReqSuccessNum());
        Assert.assertEquals((long)0L, (long)this.statMonitor.getGlobalReqFailNum());
    }

    private void insertSomeData() throws ClassNotFoundException {
        Class.forName("org.apache.iotdb.jdbc.IoTDBDriver");
        try (Connection connection = DriverManager.getConnection("jdbc:iotdb://127.0.0.1:6667/", "root", "root");
             Statement statement = connection.createStatement();){
            for (String sql : dataset) {
                statement.execute(sql);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

