/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.metadata.mnode;

import com.google.common.util.concurrent.ThreadFactoryBuilder;
import java.util.List;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import org.apache.iotdb.db.metadata.MetaUtils;
import org.apache.iotdb.db.metadata.mnode.MNode;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class MNodeTest {
    private static ExecutorService service;

    @Before
    public void setUp() throws Exception {
        service = Executors.newFixedThreadPool(Runtime.getRuntime().availableProcessors(), new ThreadFactoryBuilder().setDaemon(false).setNameFormat("replaceChild-%d").build());
    }

    @Test
    public void testReplaceChild() throws InterruptedException {
        MNode rootNode = new MNode(null, "root");
        MNode aNode = new MNode(rootNode, "a");
        rootNode.addChild(aNode.getName(), aNode);
        MNode bNode = new MNode(aNode, "b");
        aNode.addChild(bNode.getName(), bNode);
        aNode.addAlias("aliasOfb", bNode);
        for (int i = 0; i < 500; ++i) {
            service.submit(new Thread(() -> rootNode.replaceChild(aNode.getName(), new MNode(null, "c"))));
        }
        if (!service.isShutdown()) {
            service.shutdown();
            service.awaitTermination(30L, TimeUnit.SECONDS);
        }
        List multiFullPaths = MetaUtils.getMultiFullPaths((MNode)rootNode);
        Assert.assertEquals((Object)"root.c.b", multiFullPaths.get(0));
        Assert.assertEquals((Object)"root.c.b", (Object)rootNode.getChild("c").getChild("aliasOfb").getFullPath());
    }

    @Test
    public void testAddChild() {
        MNode rootNode = new MNode(null, "root");
        MNode speedNode = rootNode.addChild(new MNode(null, "sg1")).addChild(new MNode(null, "a")).addChild(new MNode(null, "b")).addChild(new MNode(null, "c")).addChild(new MNode(null, "d")).addChild(new MNode(null, "device")).addChild(new MNode(null, "speed"));
        Assert.assertEquals((Object)"root.sg1.a.b.c.d.device.speed", (Object)speedNode.getFullPath());
        MNode temperatureNode = rootNode.getChild("sg1").addChild(new MNode(null, "aa")).addChild(new MNode(null, "bb")).addChild(new MNode(null, "cc")).addChild(new MNode(null, "dd")).addChild(new MNode(null, "device11")).addChild(new MNode(null, "temperature"));
        Assert.assertEquals((Object)"root.sg1.aa.bb.cc.dd.device11.temperature", (Object)temperatureNode.getFullPath());
    }
}

