/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.metadata;

import java.util.Arrays;
import java.util.List;
import org.apache.iotdb.db.exception.metadata.IllegalPathException;
import org.apache.iotdb.db.metadata.MetaUtils;
import org.apache.iotdb.db.metadata.mnode.MNode;
import org.junit.Assert;
import org.junit.Test;

public class MetaUtilsTest {
    @Test
    public void testSplitPathToNodes() throws IllegalPathException {
        Assert.assertArrayEquals((Object[])Arrays.asList("root", "sg", "d1", "s1").toArray(), (Object[])MetaUtils.splitPathToDetachedPath((String)"root.sg.d1.s1"));
        Assert.assertArrayEquals((Object[])Arrays.asList("root", "sg", "d1", "\"s.1\"").toArray(), (Object[])MetaUtils.splitPathToDetachedPath((String)"root.sg.d1.\"s.1\""));
        Assert.assertArrayEquals((Object[])Arrays.asList("root", "sg", "d1", "\"s\\\".1\"").toArray(), (Object[])MetaUtils.splitPathToDetachedPath((String)"root.sg.d1.\"s\\\".1\""));
        Assert.assertArrayEquals((Object[])Arrays.asList("root", "\"s g\"", "d1", "\"s.1\"").toArray(), (Object[])MetaUtils.splitPathToDetachedPath((String)"root.\"s g\".d1.\"s.1\""));
        Assert.assertArrayEquals((Object[])Arrays.asList("root", "\"s g\"", "\"d_.1\"", "\"s.1.1\"").toArray(), (Object[])MetaUtils.splitPathToDetachedPath((String)"root.\"s g\".\"d_.1\".\"s.1.1\""));
        Assert.assertArrayEquals((Object[])Arrays.asList("root", "1").toArray(), (Object[])MetaUtils.splitPathToDetachedPath((String)"root.1"));
        Assert.assertArrayEquals((Object[])Arrays.asList("root", "sg", "d1", "s", "1").toArray(), (Object[])MetaUtils.splitPathToDetachedPath((String)"root.sg.d1.s.1"));
        try {
            MetaUtils.splitPathToDetachedPath((String)"root.sg.\"d.1\"\"s.1\"");
        }
        catch (IllegalPathException e) {
            Assert.assertEquals((Object)"root.sg.\"d.1\"\"s.1\" is not a legal path", (Object)e.getMessage());
        }
        try {
            MetaUtils.splitPathToDetachedPath((String)"root..a");
        }
        catch (IllegalPathException e) {
            Assert.assertEquals((Object)"root..a is not a legal path", (Object)e.getMessage());
        }
        try {
            MetaUtils.splitPathToDetachedPath((String)"root.sg.d1.'s1'");
        }
        catch (IllegalPathException e) {
            Assert.assertEquals((Object)"root.sg.d1.'s1' is not a legal path", (Object)e.getMessage());
        }
    }

    @Test
    public void testGetMultiFullPaths() {
        MNode rootNode = new MNode(null, "root");
        MNode aNode = new MNode(rootNode, "a");
        rootNode.addChild(aNode.getName(), aNode);
        MNode aaNode = new MNode(rootNode, "aa");
        rootNode.addChild(aaNode.getName(), aaNode);
        MNode bNode = new MNode(aNode, "b");
        aNode.addChild(bNode.getName(), bNode);
        MNode bbNode = new MNode(aaNode, "bb");
        aaNode.addChild(bbNode.getName(), bbNode);
        MNode ccNode = new MNode(bbNode, "cc");
        bbNode.addChild(ccNode.getName(), ccNode);
        List multiFullPaths = MetaUtils.getMultiFullPaths((MNode)rootNode);
        Assert.assertSame((Object)2, (Object)multiFullPaths.size());
        multiFullPaths.forEach(fullPath -> {
            if (fullPath.contains("aa")) {
                Assert.assertEquals((Object)"root.aa.bb.cc", (Object)fullPath);
            } else {
                Assert.assertEquals((Object)"root.a.b", (Object)fullPath);
            }
        });
    }
}

