/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.metadata;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.apache.iotdb.db.exception.metadata.AliasAlreadyExistException;
import org.apache.iotdb.db.exception.metadata.IllegalPathException;
import org.apache.iotdb.db.exception.metadata.MetadataException;
import org.apache.iotdb.db.metadata.MTree;
import org.apache.iotdb.db.metadata.PartialPath;
import org.apache.iotdb.db.metadata.mnode.MNode;
import org.apache.iotdb.db.metadata.mnode.MeasurementMNode;
import org.apache.iotdb.db.utils.EnvironmentUtils;
import org.apache.iotdb.tsfile.common.conf.TSFileDescriptor;
import org.apache.iotdb.tsfile.file.metadata.enums.CompressionType;
import org.apache.iotdb.tsfile.file.metadata.enums.TSDataType;
import org.apache.iotdb.tsfile.file.metadata.enums.TSEncoding;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class MTreeTest {
    @Before
    public void setUp() {
        EnvironmentUtils.envSetUp();
    }

    @After
    public void tearDown() throws Exception {
        EnvironmentUtils.cleanEnv();
    }

    @Test
    public void testSetStorageGroupExceptionMessage() throws IllegalPathException {
        MTree root = new MTree();
        try {
            root.setStorageGroup(new PartialPath("root.edge1.access"));
            root.setStorageGroup(new PartialPath("root.edge1"));
            Assert.fail((String)"Expected exception");
        }
        catch (MetadataException e) {
            Assert.assertEquals((Object)"some children of root.edge1 have already been set to storage group", (Object)e.getMessage());
        }
        try {
            root.setStorageGroup(new PartialPath("root.edge2"));
            root.setStorageGroup(new PartialPath("root.edge2.access"));
            Assert.fail((String)"Expected exception");
        }
        catch (MetadataException e) {
            Assert.assertEquals((Object)"root.edge2 has already been set to storage group", (Object)e.getMessage());
        }
        try {
            root.setStorageGroup(new PartialPath("root.edge1.access"));
            Assert.fail((String)"Expected exception");
        }
        catch (MetadataException e) {
            Assert.assertEquals((Object)"root.edge1.access has already been set to storage group", (Object)e.getMessage());
        }
    }

    @Test
    public void testAddLeftNodePathWithAlias() throws MetadataException {
        MTree root = new MTree();
        root.setStorageGroup(new PartialPath("root.laptop"));
        try {
            root.createTimeseries(new PartialPath("root.laptop.d1.s1"), TSDataType.INT32, TSEncoding.RLE, TSFileDescriptor.getInstance().getConfig().getCompressor(), Collections.emptyMap(), "status");
        }
        catch (MetadataException e) {
            e.printStackTrace();
            Assert.fail((String)e.getMessage());
        }
        try {
            root.createTimeseries(new PartialPath("root.laptop.d1.s2"), TSDataType.INT32, TSEncoding.RLE, TSFileDescriptor.getInstance().getConfig().getCompressor(), Collections.emptyMap(), "status");
        }
        catch (MetadataException e) {
            Assert.assertTrue((boolean)(e instanceof AliasAlreadyExistException));
        }
    }

    @Test
    public void testAddAndPathExist() throws MetadataException {
        MTree root = new MTree();
        String path1 = "root";
        root.setStorageGroup(new PartialPath("root.laptop"));
        Assert.assertTrue((boolean)root.isPathExist(new PartialPath(path1)));
        Assert.assertFalse((boolean)root.isPathExist(new PartialPath("root.laptop.d1")));
        try {
            root.createTimeseries(new PartialPath("root.laptop.d1.s1"), TSDataType.INT32, TSEncoding.RLE, TSFileDescriptor.getInstance().getConfig().getCompressor(), Collections.emptyMap(), null);
        }
        catch (MetadataException e1) {
            Assert.fail((String)e1.getMessage());
        }
        Assert.assertTrue((boolean)root.isPathExist(new PartialPath("root.laptop.d1")));
        Assert.assertTrue((boolean)root.isPathExist(new PartialPath("root.laptop")));
        Assert.assertFalse((boolean)root.isPathExist(new PartialPath("root.laptop.d1.s2")));
        try {
            root.createTimeseries(new PartialPath("aa.bb.cc"), TSDataType.INT32, TSEncoding.RLE, TSFileDescriptor.getInstance().getConfig().getCompressor(), Collections.emptyMap(), null);
        }
        catch (MetadataException e) {
            Assert.assertEquals((Object)String.format("%s is not a legal path", "aa.bb.cc"), (Object)e.getMessage());
        }
    }

    @Test
    public void testAddAndQueryPath() {
        MTree root = new MTree();
        try {
            Assert.assertFalse((boolean)root.isPathExist(new PartialPath("root.a.d0")));
            Assert.assertFalse((boolean)root.checkStorageGroupByPath(new PartialPath("root.a.d0")));
            root.setStorageGroup(new PartialPath("root.a.d0"));
            root.createTimeseries(new PartialPath("root.a.d0.s0"), TSDataType.INT32, TSEncoding.RLE, TSFileDescriptor.getInstance().getConfig().getCompressor(), Collections.emptyMap(), null);
            root.createTimeseries(new PartialPath("root.a.d0.s1"), TSDataType.INT32, TSEncoding.RLE, TSFileDescriptor.getInstance().getConfig().getCompressor(), Collections.emptyMap(), null);
            Assert.assertFalse((boolean)root.isPathExist(new PartialPath("root.a.d1")));
            Assert.assertFalse((boolean)root.checkStorageGroupByPath(new PartialPath("root.a.d1")));
            root.setStorageGroup(new PartialPath("root.a.d1"));
            root.createTimeseries(new PartialPath("root.a.d1.s0"), TSDataType.INT32, TSEncoding.RLE, TSFileDescriptor.getInstance().getConfig().getCompressor(), Collections.emptyMap(), null);
            root.createTimeseries(new PartialPath("root.a.d1.s1"), TSDataType.INT32, TSEncoding.RLE, TSFileDescriptor.getInstance().getConfig().getCompressor(), Collections.emptyMap(), null);
            root.setStorageGroup(new PartialPath("root.a.b.d0"));
            root.createTimeseries(new PartialPath("root.a.b.d0.s0"), TSDataType.INT32, TSEncoding.RLE, TSFileDescriptor.getInstance().getConfig().getCompressor(), Collections.emptyMap(), null);
        }
        catch (MetadataException e1) {
            e1.printStackTrace();
        }
        try {
            List result = root.getAllTimeseriesPath(new PartialPath("root.a.*.s0"));
            Assert.assertEquals((long)2L, (long)result.size());
            Assert.assertEquals((Object)"root.a.d0.s0", (Object)((PartialPath)result.get(0)).getFullPath());
            Assert.assertEquals((Object)"root.a.d1.s0", (Object)((PartialPath)result.get(1)).getFullPath());
            result = root.getAllTimeseriesPath(new PartialPath("root.a.*.*.s0"));
            Assert.assertEquals((Object)"root.a.b.d0.s0", (Object)((PartialPath)result.get(0)).getFullPath());
        }
        catch (MetadataException e) {
            e.printStackTrace();
            Assert.fail((String)e.getMessage());
        }
    }

    @Test
    public void testAddAndQueryPathWithAlias() {
        MTree root = new MTree();
        try {
            Assert.assertFalse((boolean)root.isPathExist(new PartialPath("root.a.d0")));
            Assert.assertFalse((boolean)root.checkStorageGroupByPath(new PartialPath("root.a.d0")));
            root.setStorageGroup(new PartialPath("root.a.d0"));
            root.createTimeseries(new PartialPath("root.a.d0.s0"), TSDataType.INT32, TSEncoding.RLE, TSFileDescriptor.getInstance().getConfig().getCompressor(), Collections.emptyMap(), "temperature");
            root.createTimeseries(new PartialPath("root.a.d0.s1"), TSDataType.INT32, TSEncoding.RLE, TSFileDescriptor.getInstance().getConfig().getCompressor(), Collections.emptyMap(), "status");
            Assert.assertFalse((boolean)root.isPathExist(new PartialPath("root.a.d1")));
            Assert.assertFalse((boolean)root.checkStorageGroupByPath(new PartialPath("root.a.d1")));
            root.setStorageGroup(new PartialPath("root.a.d1"));
            root.createTimeseries(new PartialPath("root.a.d1.s0"), TSDataType.INT32, TSEncoding.RLE, TSFileDescriptor.getInstance().getConfig().getCompressor(), Collections.emptyMap(), "temperature");
            root.createTimeseries(new PartialPath("root.a.d1.s1"), TSDataType.INT32, TSEncoding.RLE, TSFileDescriptor.getInstance().getConfig().getCompressor(), Collections.emptyMap(), null);
            root.setStorageGroup(new PartialPath("root.a.b.d0"));
            root.createTimeseries(new PartialPath("root.a.b.d0.s0"), TSDataType.INT32, TSEncoding.RLE, TSFileDescriptor.getInstance().getConfig().getCompressor(), Collections.emptyMap(), null);
        }
        catch (MetadataException e1) {
            e1.printStackTrace();
        }
        try {
            List result = root.getAllTimeseriesPath(new PartialPath("root.a.*.s0"));
            Assert.assertEquals((long)2L, (long)result.size());
            Assert.assertEquals((Object)"root.a.d0.s0", (Object)((PartialPath)result.get(0)).getFullPath());
            Assert.assertEquals((Object)"root.a.d1.s0", (Object)((PartialPath)result.get(1)).getFullPath());
            result = root.getAllTimeseriesPath(new PartialPath("root.a.*.temperature"));
            Assert.assertEquals((long)2L, (long)result.size());
            Assert.assertEquals((Object)"root.a.d0.s0", (Object)((PartialPath)result.get(0)).getFullPath());
            Assert.assertEquals((Object)"root.a.d1.s0", (Object)((PartialPath)result.get(1)).getFullPath());
            List result2 = (List)root.getAllTimeseriesPathWithAlias((PartialPath)new PartialPath((String)"root.a.*.s0"), (int)0, (int)0).left;
            Assert.assertEquals((long)2L, (long)result2.size());
            Assert.assertEquals((Object)"root.a.d0.s0", (Object)((PartialPath)result2.get(0)).getFullPath());
            Assert.assertFalse((boolean)((PartialPath)result2.get(0)).isMeasurementAliasExists());
            Assert.assertEquals((Object)"root.a.d1.s0", (Object)((PartialPath)result2.get(1)).getFullPath());
            Assert.assertFalse((boolean)((PartialPath)result2.get(1)).isMeasurementAliasExists());
            result2 = (List)root.getAllTimeseriesPathWithAlias((PartialPath)new PartialPath((String)"root.a.*.temperature"), (int)0, (int)0).left;
            Assert.assertEquals((long)2L, (long)result2.size());
            Assert.assertEquals((Object)"root.a.d0.temperature", (Object)((PartialPath)result2.get(0)).getFullPathWithAlias());
            Assert.assertEquals((Object)"root.a.d1.temperature", (Object)((PartialPath)result2.get(1)).getFullPathWithAlias());
        }
        catch (MetadataException e) {
            e.printStackTrace();
            Assert.fail((String)e.getMessage());
        }
    }

    @Test
    public void testCombineMetadataInStrings() {
        MTree root = new MTree();
        MTree root1 = new MTree();
        MTree root2 = new MTree();
        MTree root3 = new MTree();
        try {
            CompressionType compressionType = TSFileDescriptor.getInstance().getConfig().getCompressor();
            root.setStorageGroup(new PartialPath("root.a.d0"));
            root.createTimeseries(new PartialPath("root.a.d0.s0"), TSDataType.valueOf((String)"INT32"), TSEncoding.valueOf((String)"RLE"), compressionType, Collections.emptyMap(), null);
            root.createTimeseries(new PartialPath("root.a.d0.s1"), TSDataType.valueOf((String)"INT32"), TSEncoding.valueOf((String)"RLE"), compressionType, Collections.emptyMap(), null);
            root.setStorageGroup(new PartialPath("root.a.d1"));
            root.createTimeseries(new PartialPath("root.a.d1.s0"), TSDataType.valueOf((String)"INT32"), TSEncoding.valueOf((String)"RLE"), compressionType, Collections.emptyMap(), null);
            root.createTimeseries(new PartialPath("root.a.d1.s1"), TSDataType.valueOf((String)"INT32"), TSEncoding.valueOf((String)"RLE"), compressionType, Collections.emptyMap(), null);
            root.setStorageGroup(new PartialPath("root.a.b.d0"));
            root.createTimeseries(new PartialPath("root.a.b.d0.s0"), TSDataType.valueOf((String)"INT32"), TSEncoding.valueOf((String)"RLE"), compressionType, Collections.emptyMap(), null);
            root1.setStorageGroup(new PartialPath("root.a.d0"));
            root1.createTimeseries(new PartialPath("root.a.d0.s0"), TSDataType.valueOf((String)"INT32"), TSEncoding.valueOf((String)"RLE"), compressionType, Collections.emptyMap(), null);
            root1.createTimeseries(new PartialPath("root.a.d0.s1"), TSDataType.valueOf((String)"INT32"), TSEncoding.valueOf((String)"RLE"), compressionType, Collections.emptyMap(), null);
            root2.setStorageGroup(new PartialPath("root.a.d1"));
            root2.createTimeseries(new PartialPath("root.a.d1.s0"), TSDataType.valueOf((String)"INT32"), TSEncoding.valueOf((String)"RLE"), compressionType, Collections.emptyMap(), null);
            root2.createTimeseries(new PartialPath("root.a.d1.s1"), TSDataType.valueOf((String)"INT32"), TSEncoding.valueOf((String)"RLE"), compressionType, Collections.emptyMap(), null);
            root3.setStorageGroup(new PartialPath("root.a.b.d0"));
            root3.createTimeseries(new PartialPath("root.a.b.d0.s0"), TSDataType.valueOf((String)"INT32"), TSEncoding.valueOf((String)"RLE"), compressionType, Collections.emptyMap(), null);
            String[] metadatas = new String[]{root1.toString(), root2.toString(), root3.toString()};
            Assert.assertEquals((Object)MTree.combineMetadataInStrings((String[])metadatas), (Object)MTree.combineMetadataInStrings((String[])new String[]{root.toString()}));
        }
        catch (MetadataException e) {
            e.printStackTrace();
            Assert.fail((String)e.getMessage());
        }
    }

    @Test
    public void testGetAllChildNodeNamesByPath() {
        MTree root = new MTree();
        try {
            root.setStorageGroup(new PartialPath("root.a.d0"));
            root.createTimeseries(new PartialPath("root.a.d0.s0"), TSDataType.INT32, TSEncoding.RLE, TSFileDescriptor.getInstance().getConfig().getCompressor(), Collections.emptyMap(), null);
            root.createTimeseries(new PartialPath("root.a.d0.s1"), TSDataType.INT32, TSEncoding.RLE, TSFileDescriptor.getInstance().getConfig().getCompressor(), Collections.emptyMap(), null);
            root.createTimeseries(new PartialPath("root.a.d5"), TSDataType.INT32, TSEncoding.RLE, TSFileDescriptor.getInstance().getConfig().getCompressor(), Collections.emptyMap(), null);
            Set result1 = root.getChildNodeInNextLevel(new PartialPath("root.a.d0"));
            Set result2 = root.getChildNodeInNextLevel(new PartialPath("root.a"));
            Set result3 = root.getChildNodeInNextLevel(new PartialPath("root"));
            Assert.assertEquals((Object)result1, new HashSet<String>(Arrays.asList("s0", "s1")));
            Assert.assertEquals((Object)result2, new HashSet<String>(Arrays.asList("d0", "d5")));
            Assert.assertEquals((Object)result3, new HashSet<String>(Arrays.asList("a")));
            Set result5 = root.getChildNodeInNextLevel(new PartialPath("root.a.d5"));
            Assert.assertEquals((Object)result5, new HashSet<Object>(Arrays.asList(new Object[0])));
        }
        catch (MetadataException e1) {
            e1.printStackTrace();
        }
    }

    @Test
    public void testSetStorageGroup() throws IllegalPathException {
        MTree root = new MTree();
        try {
            root.setStorageGroup(new PartialPath("root.laptop.d1"));
            Assert.assertTrue((boolean)root.isPathExist(new PartialPath("root.laptop.d1")));
            Assert.assertTrue((boolean)root.checkStorageGroupByPath(new PartialPath("root.laptop.d1")));
            Assert.assertEquals((Object)"root.laptop.d1", (Object)root.getStorageGroupPath(new PartialPath("root.laptop.d1")).getFullPath());
            Assert.assertFalse((boolean)root.isPathExist(new PartialPath("root.laptop.d1.s1")));
            Assert.assertTrue((boolean)root.checkStorageGroupByPath(new PartialPath("root.laptop.d1.s1")));
            Assert.assertEquals((Object)"root.laptop.d1", (Object)root.getStorageGroupPath(new PartialPath("root.laptop.d1.s1")).getFullPath());
        }
        catch (MetadataException e) {
            e.printStackTrace();
            Assert.fail((String)e.getMessage());
        }
        try {
            root.setStorageGroup(new PartialPath("root.laptop.d2"));
        }
        catch (MetadataException e) {
            Assert.fail((String)e.getMessage());
        }
        try {
            root.setStorageGroup(new PartialPath("root.laptop"));
        }
        catch (MetadataException e) {
            Assert.assertEquals((Object)"some children of root.laptop have already been set to storage group", (Object)e.getMessage());
        }
        Assert.assertFalse((boolean)root.isPathExist(new PartialPath("root.laptop.d1.s0")));
        Assert.assertFalse((boolean)root.isPathExist(new PartialPath("root.laptop.d1.s1")));
        Assert.assertFalse((boolean)root.isPathExist(new PartialPath("root.laptop.d2.s0")));
        Assert.assertFalse((boolean)root.isPathExist(new PartialPath("root.laptop.d2.s1")));
        try {
            Assert.assertEquals((Object)"root.laptop.d1", (Object)root.getStorageGroupPath(new PartialPath("root.laptop.d1.s0")).getFullPath());
            root.createTimeseries(new PartialPath("root.laptop.d1.s0"), TSDataType.INT32, TSEncoding.RLE, TSFileDescriptor.getInstance().getConfig().getCompressor(), Collections.emptyMap(), null);
            Assert.assertEquals((Object)"root.laptop.d1", (Object)root.getStorageGroupPath(new PartialPath("root.laptop.d1.s1")).getFullPath());
            root.createTimeseries(new PartialPath("root.laptop.d1.s1"), TSDataType.INT32, TSEncoding.RLE, TSFileDescriptor.getInstance().getConfig().getCompressor(), Collections.emptyMap(), null);
            Assert.assertEquals((Object)"root.laptop.d2", (Object)root.getStorageGroupPath(new PartialPath("root.laptop.d2.s0")).getFullPath());
            root.createTimeseries(new PartialPath("root.laptop.d2.s0"), TSDataType.INT32, TSEncoding.RLE, TSFileDescriptor.getInstance().getConfig().getCompressor(), Collections.emptyMap(), null);
            Assert.assertEquals((Object)"root.laptop.d2", (Object)root.getStorageGroupPath(new PartialPath("root.laptop.d2.s1")).getFullPath());
            root.createTimeseries(new PartialPath("root.laptop.d2.s1"), TSDataType.INT32, TSEncoding.RLE, TSFileDescriptor.getInstance().getConfig().getCompressor(), Collections.emptyMap(), null);
        }
        catch (MetadataException e) {
            e.printStackTrace();
            Assert.fail((String)e.getMessage());
        }
        try {
            root.deleteTimeseriesAndReturnEmptyStorageGroup(new PartialPath("root.laptop.d1.s0"));
        }
        catch (MetadataException e) {
            e.printStackTrace();
            Assert.fail((String)e.getMessage());
        }
        Assert.assertFalse((boolean)root.isPathExist(new PartialPath("root.laptop.d1.s0")));
        try {
            root.deleteStorageGroup(new PartialPath("root.laptop.d1"));
        }
        catch (MetadataException e) {
            e.printStackTrace();
            Assert.fail((String)e.getMessage());
        }
        Assert.assertFalse((boolean)root.isPathExist(new PartialPath("root.laptop.d1.s1")));
        Assert.assertFalse((boolean)root.isPathExist(new PartialPath("root.laptop.d1")));
        Assert.assertTrue((boolean)root.isPathExist(new PartialPath("root.laptop")));
        Assert.assertTrue((boolean)root.isPathExist(new PartialPath("root.laptop.d2")));
        Assert.assertTrue((boolean)root.isPathExist(new PartialPath("root.laptop.d2.s0")));
    }

    @Test
    public void testCheckStorageGroup() {
        MTree root = new MTree();
        try {
            Assert.assertFalse((boolean)root.isStorageGroup(new PartialPath("root")));
            Assert.assertFalse((boolean)root.isStorageGroup(new PartialPath("root1.laptop.d2")));
            root.setStorageGroup(new PartialPath("root.laptop.d1"));
            Assert.assertTrue((boolean)root.isStorageGroup(new PartialPath("root.laptop.d1")));
            Assert.assertFalse((boolean)root.isStorageGroup(new PartialPath("root.laptop.d2")));
            Assert.assertFalse((boolean)root.isStorageGroup(new PartialPath("root.laptop")));
            Assert.assertFalse((boolean)root.isStorageGroup(new PartialPath("root.laptop.d1.s1")));
            root.setStorageGroup(new PartialPath("root.laptop.d2"));
            Assert.assertTrue((boolean)root.isStorageGroup(new PartialPath("root.laptop.d1")));
            Assert.assertTrue((boolean)root.isStorageGroup(new PartialPath("root.laptop.d2")));
            Assert.assertFalse((boolean)root.isStorageGroup(new PartialPath("root.laptop.d3")));
            root.setStorageGroup(new PartialPath("root.1"));
            Assert.assertTrue((boolean)root.isStorageGroup(new PartialPath("root.1")));
        }
        catch (MetadataException e) {
            e.printStackTrace();
            Assert.fail((String)e.getMessage());
        }
    }

    @Test
    public void testGetAllFileNamesByPath() {
        MTree root = new MTree();
        try {
            root.setStorageGroup(new PartialPath("root.laptop.d1"));
            root.setStorageGroup(new PartialPath("root.laptop.d2"));
            root.createTimeseries(new PartialPath("root.laptop.d1.s1"), TSDataType.INT32, TSEncoding.PLAIN, CompressionType.GZIP, null, null);
            root.createTimeseries(new PartialPath("root.laptop.d1.s2"), TSDataType.INT32, TSEncoding.PLAIN, CompressionType.GZIP, null, null);
            ArrayList<String> list = new ArrayList<String>();
            list.add("root.laptop.d1");
            Assert.assertEquals(list, (Object)root.getStorageGroupByPath(new PartialPath("root.laptop.d1.s1")));
            Assert.assertEquals(list, (Object)root.getStorageGroupByPath(new PartialPath("root.laptop.d1")));
            list.add("root.laptop.d2");
            Assert.assertEquals(list, (Object)root.getStorageGroupByPath(new PartialPath("root.laptop")));
            Assert.assertEquals(list, (Object)root.getStorageGroupByPath(new PartialPath("root")));
        }
        catch (MetadataException e) {
            e.printStackTrace();
            Assert.fail((String)e.getMessage());
        }
    }

    @Test
    public void testCheckStorageExistOfPath() {
        MTree root = new MTree();
        try {
            Assert.assertTrue((boolean)root.getStorageGroupByPath(new PartialPath("root")).isEmpty());
            Assert.assertTrue((boolean)root.getStorageGroupByPath(new PartialPath("root.vehicle")).isEmpty());
            Assert.assertTrue((boolean)root.getStorageGroupByPath(new PartialPath("root.vehicle.device")).isEmpty());
            Assert.assertTrue((boolean)root.getStorageGroupByPath(new PartialPath("root.vehicle.device.sensor")).isEmpty());
            root.setStorageGroup(new PartialPath("root.vehicle"));
            Assert.assertFalse((boolean)root.getStorageGroupByPath(new PartialPath("root.vehicle")).isEmpty());
            Assert.assertFalse((boolean)root.getStorageGroupByPath(new PartialPath("root.vehicle.device")).isEmpty());
            Assert.assertFalse((boolean)root.getStorageGroupByPath(new PartialPath("root.vehicle.device.sensor")).isEmpty());
            Assert.assertTrue((boolean)root.getStorageGroupByPath(new PartialPath("root.vehicle1")).isEmpty());
            Assert.assertTrue((boolean)root.getStorageGroupByPath(new PartialPath("root.vehicle1.device")).isEmpty());
            root.setStorageGroup(new PartialPath("root.vehicle1.device"));
            Assert.assertTrue((boolean)root.getStorageGroupByPath(new PartialPath("root.vehicle1.device1")).isEmpty());
            Assert.assertTrue((boolean)root.getStorageGroupByPath(new PartialPath("root.vehicle1.device2")).isEmpty());
            Assert.assertTrue((boolean)root.getStorageGroupByPath(new PartialPath("root.vehicle1.device3")).isEmpty());
            Assert.assertFalse((boolean)root.getStorageGroupByPath(new PartialPath("root.vehicle1.device")).isEmpty());
        }
        catch (MetadataException e) {
            e.printStackTrace();
            Assert.fail((String)e.getMessage());
        }
    }

    @Test
    public void testGetAllTimeseriesCount() {
        MTree root = new MTree();
        try {
            root.setStorageGroup(new PartialPath("root.laptop"));
            root.createTimeseries(new PartialPath("root.laptop.d1.s1"), TSDataType.INT32, TSEncoding.PLAIN, CompressionType.GZIP, null, null);
            root.createTimeseries(new PartialPath("root.laptop.d1.s2"), TSDataType.INT32, TSEncoding.PLAIN, CompressionType.GZIP, null, null);
            root.createTimeseries(new PartialPath("root.laptop.d2.s1"), TSDataType.INT32, TSEncoding.PLAIN, CompressionType.GZIP, null, null);
            root.createTimeseries(new PartialPath("root.laptop.d2.s2"), TSDataType.INT32, TSEncoding.PLAIN, CompressionType.GZIP, null, null);
            Assert.assertEquals((long)4L, (long)root.getAllTimeseriesCount(new PartialPath("root.laptop")));
            Assert.assertEquals((long)2L, (long)root.getAllTimeseriesCount(new PartialPath("root.laptop.*.s1")));
            PartialPath partialPath = new PartialPath("root.laptop.d1.s3");
            try {
                root.getAllTimeseriesCount(partialPath);
                Assert.fail((String)"Expected exception");
            }
            catch (MetadataException e) {
                Assert.assertEquals((Object)"Path [root.laptop.d1.s3] does not exist", (Object)e.getMessage());
            }
            Assert.assertEquals((long)2L, (long)root.getNodesCountInGivenLevel(new PartialPath("root.laptop"), 2));
            Assert.assertEquals((long)4L, (long)root.getNodesCountInGivenLevel(new PartialPath("root.laptop"), 3));
            Assert.assertEquals((long)2L, (long)root.getNodesCountInGivenLevel(new PartialPath("root.laptop.*"), 2));
            Assert.assertEquals((long)4L, (long)root.getNodesCountInGivenLevel(new PartialPath("root.laptop.*"), 3));
            Assert.assertEquals((long)2L, (long)root.getNodesCountInGivenLevel(new PartialPath("root.laptop.d1"), 3));
            Assert.assertEquals((long)0L, (long)root.getNodesCountInGivenLevel(new PartialPath("root.laptop.d1"), 4));
        }
        catch (MetadataException e) {
            e.printStackTrace();
            Assert.fail((String)e.getMessage());
        }
    }

    @Test
    public void testAddSubDevice() throws MetadataException {
        MTree root = new MTree();
        root.setStorageGroup(new PartialPath("root.laptop"));
        root.createTimeseries(new PartialPath("root.laptop.d1.s1"), TSDataType.INT32, TSEncoding.RLE, TSFileDescriptor.getInstance().getConfig().getCompressor(), Collections.emptyMap(), null);
        root.createTimeseries(new PartialPath("root.laptop.d1.s1.b"), TSDataType.INT32, TSEncoding.RLE, TSFileDescriptor.getInstance().getConfig().getCompressor(), Collections.emptyMap(), null);
        Assert.assertEquals((long)2L, (long)root.getDevices(new PartialPath("root")).size());
        Assert.assertEquals((long)2L, (long)root.getAllTimeseriesCount(new PartialPath("root")));
        Assert.assertEquals((long)2L, (long)root.getAllTimeseriesPath(new PartialPath("root")).size());
        Assert.assertEquals((long)2L, (long)((List)root.getAllTimeseriesPathWithAlias((PartialPath)new PartialPath((String)"root"), (int)0, (int)0).left).size());
    }

    @Test
    public void testIllegalStorageGroup() {
        MTree root = new MTree();
        try {
            root.setStorageGroup(new PartialPath("root.\"sg.ln\""));
        }
        catch (MetadataException e) {
            Assert.assertEquals((Object)"The storage group name can only be characters, numbers and underscores. root.\"sg.ln\" is not a legal path", (Object)e.getMessage());
        }
    }

    @Test
    public void testSearchStorageGroup() throws MetadataException {
        MTree root = new MTree();
        String path1 = "root";
        String sgPath1 = "root.vehicle";
        root.setStorageGroup(new PartialPath(sgPath1));
        Assert.assertTrue((boolean)root.isPathExist(new PartialPath(path1)));
        try {
            root.createTimeseries(new PartialPath("root.vehicle.d1.s1"), TSDataType.INT32, TSEncoding.RLE, TSFileDescriptor.getInstance().getConfig().getCompressor(), Collections.emptyMap(), null);
            root.createTimeseries(new PartialPath("root.vehicle.d1.s2"), TSDataType.INT32, TSEncoding.RLE, TSFileDescriptor.getInstance().getConfig().getCompressor(), Collections.emptyMap(), null);
        }
        catch (MetadataException e1) {
            Assert.fail((String)e1.getMessage());
        }
        Assert.assertEquals((Object)root.searchAllRelatedStorageGroups(new PartialPath("root.vehicle.d1.s1")), Collections.singletonList(new PartialPath(sgPath1)));
    }

    @Test
    public void testDeleteChildOfMeasurementMNode() throws MetadataException {
        MTree root = new MTree();
        String sgPath = "root.sg1";
        root.setStorageGroup(new PartialPath(sgPath));
        try {
            root.createTimeseries(new PartialPath("root.sg1.a.b"), TSDataType.INT32, TSEncoding.RLE, TSFileDescriptor.getInstance().getConfig().getCompressor(), Collections.emptyMap(), null);
            root.createTimeseries(new PartialPath("root.sg1.a.b.c"), TSDataType.INT32, TSEncoding.RLE, TSFileDescriptor.getInstance().getConfig().getCompressor(), Collections.emptyMap(), null);
            Assert.assertTrue((boolean)root.isPathExist(new PartialPath("root.sg1.a.b")));
            Assert.assertTrue((boolean)root.isPathExist(new PartialPath("root.sg1.a.b.c")));
            root.deleteTimeseriesAndReturnEmptyStorageGroup(new PartialPath("root.sg1.a.b.c"));
            Assert.assertFalse((boolean)root.isPathExist(new PartialPath("root.sg1.a.b.c")));
            Assert.assertTrue((boolean)root.isPathExist(new PartialPath("root.sg1.a.b")));
        }
        catch (MetadataException e1) {
            Assert.fail((String)e1.getMessage());
        }
    }

    @Test
    public void testGetMeasurementMNodeCount() throws MetadataException {
        MTree root = new MTree();
        PartialPath sgPath = new PartialPath("root.sg1");
        root.setStorageGroup(sgPath);
        try {
            root.createTimeseries(new PartialPath("root.sg1.a.b"), TSDataType.INT32, TSEncoding.RLE, TSFileDescriptor.getInstance().getConfig().getCompressor(), Collections.emptyMap(), null);
            MNode sgNode = root.getNodeByPath(sgPath);
            Assert.assertEquals((long)1L, (long)sgNode.getMeasurementMNodeCount());
            root.createTimeseries(new PartialPath("root.sg1.a.b.c"), TSDataType.INT32, TSEncoding.RLE, TSFileDescriptor.getInstance().getConfig().getCompressor(), Collections.emptyMap(), null);
            Assert.assertEquals((long)2L, (long)sgNode.getMeasurementMNodeCount());
            MNode cNode = sgNode.getChild("a").getChild("b").getChild("c");
            Assert.assertEquals((long)1L, (long)cNode.getMeasurementMNodeCount());
            root.createTimeseries(new PartialPath("root.sg1.a.b.c.d"), TSDataType.INT32, TSEncoding.RLE, TSFileDescriptor.getInstance().getConfig().getCompressor(), Collections.emptyMap(), null);
            Assert.assertEquals((long)3L, (long)sgNode.getMeasurementMNodeCount());
            Assert.assertEquals((long)2L, (long)cNode.getMeasurementMNodeCount());
            MNode dNode = cNode.getChild("d");
            Assert.assertEquals((long)1L, (long)dNode.getMeasurementMNodeCount());
        }
        catch (MetadataException e1) {
            Assert.fail((String)e1.getMessage());
        }
    }

    @Test
    public void testCreateTimeseries() throws MetadataException {
        MTree root = new MTree();
        String sgPath = "root.sg1";
        root.setStorageGroup(new PartialPath(sgPath));
        root.createTimeseries(new PartialPath("root.sg1.a.b.c"), TSDataType.INT32, TSEncoding.RLE, TSFileDescriptor.getInstance().getConfig().getCompressor(), Collections.emptyMap(), null);
        root.createTimeseries(new PartialPath("root.sg1.a.b"), TSDataType.INT32, TSEncoding.RLE, TSFileDescriptor.getInstance().getConfig().getCompressor(), Collections.emptyMap(), null);
        MNode node = root.getNodeByPath(new PartialPath("root.sg1.a.b"));
        Assert.assertTrue((boolean)(node instanceof MeasurementMNode));
    }
}

