/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.metadata;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.apache.iotdb.db.exception.metadata.IllegalPathException;
import org.apache.iotdb.db.exception.metadata.MetadataException;
import org.apache.iotdb.db.metadata.MManager;
import org.apache.iotdb.db.metadata.PartialPath;
import org.apache.iotdb.db.metadata.mnode.MNode;
import org.apache.iotdb.db.metadata.mnode.MeasurementMNode;
import org.apache.iotdb.db.service.IoTDB;
import org.apache.iotdb.db.utils.EnvironmentUtils;
import org.apache.iotdb.tsfile.common.conf.TSFileDescriptor;
import org.apache.iotdb.tsfile.file.metadata.enums.TSDataType;
import org.apache.iotdb.tsfile.file.metadata.enums.TSEncoding;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MManagerImproveTest {
    private static Logger logger = LoggerFactory.getLogger(MManagerImproveTest.class);
    private static final int TIMESERIES_NUM = 1000;
    private static final int DEVICE_NUM = 10;
    private static MManager mManager = null;

    @Before
    public void setUp() throws Exception {
        EnvironmentUtils.envSetUp();
        mManager = IoTDB.metaManager;
        mManager.setStorageGroup(new PartialPath("root.t1.v2"));
        for (int j = 0; j < 10; ++j) {
            for (int i = 0; i < 1000; ++i) {
                String p = "root.t1.v2.d" + j + ".s" + i;
                mManager.createTimeseries(new PartialPath(p), TSDataType.TEXT, TSEncoding.PLAIN, TSFileDescriptor.getInstance().getConfig().getCompressor(), Collections.emptyMap());
            }
        }
    }

    @Test
    public void checkSetUp() throws IllegalPathException {
        mManager = IoTDB.metaManager;
        Assert.assertTrue((boolean)mManager.isPathExist(new PartialPath("root.t1.v2.d3.s5")));
        Assert.assertFalse((boolean)mManager.isPathExist(new PartialPath("root.t1.v2.d9.s1000")));
        Assert.assertFalse((boolean)mManager.isPathExist(new PartialPath("root.t10")));
    }

    @Test
    public void analyseTimeCost() throws MetadataException {
        mManager = IoTDB.metaManager;
        long get_seriestype = 0L;
        long check_filelevel = 0L;
        long list_init = 0L;
        long path_exist = 0L;
        long string_combine = 0L;
        String deviceId = "root.t1.v2.d3";
        String measurement = "s5";
        String path = deviceId + "." + measurement;
        long startTime = System.currentTimeMillis();
        for (int i = 0; i < 100000; ++i) {
            Assert.assertTrue((boolean)mManager.isPathExist(new PartialPath(path)));
        }
        long endTime = System.currentTimeMillis();
        path_exist += endTime - startTime;
        startTime = System.currentTimeMillis();
        endTime = System.currentTimeMillis();
        list_init += endTime - startTime;
        startTime = System.currentTimeMillis();
        for (int i = 0; i < 100000; ++i) {
            TSDataType dataType = mManager.getSeriesType(new PartialPath(path));
            Assert.assertEquals((Object)TSDataType.TEXT, (Object)dataType);
        }
        endTime = System.currentTimeMillis();
        logger.debug("string combine:\t" + string_combine);
        logger.debug("seriesPath exist:\t" + path_exist);
        logger.debug("list init:\t" + list_init);
        logger.debug("check file level:\t" + check_filelevel);
        logger.debug("get series type:\t" + (get_seriestype += endTime - startTime));
    }

    private void doOriginTest(String deviceId, List<String> measurementList) throws MetadataException {
        for (String measurement : measurementList) {
            String path = deviceId + "." + measurement;
            Assert.assertTrue((boolean)mManager.isPathExist(new PartialPath(path)));
            TSDataType dataType = mManager.getSeriesType(new PartialPath(path));
            Assert.assertEquals((Object)TSDataType.TEXT, (Object)dataType);
        }
    }

    private void doPathLoopOnceTest(String deviceId, List<String> measurementList) throws MetadataException {
        for (String measurement : measurementList) {
            String path = deviceId + "." + measurement;
            TSDataType dataType = mManager.getSeriesType(new PartialPath(path));
            Assert.assertEquals((Object)TSDataType.TEXT, (Object)dataType);
        }
    }

    private void doCacheTest(String deviceId, List<String> measurementList) throws MetadataException {
        MNode node = mManager.getDeviceNodeWithAutoCreate(new PartialPath(deviceId));
        for (String s : measurementList) {
            Assert.assertTrue((boolean)node.hasChild(s));
            MeasurementMNode measurementNode = (MeasurementMNode)node.getChild(s);
            TSDataType dataType = measurementNode.getSchema().getType();
            Assert.assertEquals((Object)TSDataType.TEXT, (Object)dataType);
        }
    }

    @Test
    public void improveTest() throws MetadataException {
        mManager = IoTDB.metaManager;
        String[] deviceIdList = new String[10];
        for (int i = 0; i < 10; ++i) {
            deviceIdList[i] = "root.t1.v2.d" + i;
        }
        ArrayList<String> measurementList = new ArrayList<String>();
        for (int i = 0; i < 1000; ++i) {
            measurementList.add("s" + i);
        }
        long startTime = System.currentTimeMillis();
        for (String deviceId : deviceIdList) {
            this.doOriginTest(deviceId, measurementList);
        }
        long endTime = System.currentTimeMillis();
        logger.debug("origin:\t" + (endTime - startTime));
        startTime = System.currentTimeMillis();
        for (String deviceId : deviceIdList) {
            this.doPathLoopOnceTest(deviceId, measurementList);
        }
        endTime = System.currentTimeMillis();
        logger.debug("seriesPath loop once:\t" + (endTime - startTime));
        startTime = System.currentTimeMillis();
        for (String deviceId : deviceIdList) {
            this.doCacheTest(deviceId, measurementList);
        }
        endTime = System.currentTimeMillis();
        logger.debug("add cache:\t" + (endTime - startTime));
    }

    @After
    public void tearDown() throws Exception {
        EnvironmentUtils.cleanEnv();
    }
}

