/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.metadata;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import java.util.TreeSet;
import java.util.stream.Collectors;
import org.apache.iotdb.db.conf.IoTDBDescriptor;
import org.apache.iotdb.db.exception.metadata.IllegalPathException;
import org.apache.iotdb.db.exception.metadata.MetadataException;
import org.apache.iotdb.db.exception.metadata.StorageGroupNotSetException;
import org.apache.iotdb.db.metadata.MManager;
import org.apache.iotdb.db.metadata.MetaUtils;
import org.apache.iotdb.db.metadata.PartialPath;
import org.apache.iotdb.db.service.IoTDB;
import org.apache.iotdb.db.utils.EnvironmentUtils;
import org.apache.iotdb.tsfile.common.conf.TSFileDescriptor;
import org.apache.iotdb.tsfile.file.metadata.enums.CompressionType;
import org.apache.iotdb.tsfile.file.metadata.enums.TSDataType;
import org.apache.iotdb.tsfile.file.metadata.enums.TSEncoding;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class MManagerBasicTest {
    private CompressionType compressionType;

    @Before
    public void setUp() {
        this.compressionType = TSFileDescriptor.getInstance().getConfig().getCompressor();
        EnvironmentUtils.envSetUp();
    }

    @After
    public void tearDown() throws Exception {
        EnvironmentUtils.cleanEnv();
    }

    @Test
    public void testAddPathAndExist() throws IllegalPathException {
        MManager manager = IoTDB.metaManager;
        Assert.assertTrue((boolean)manager.isPathExist(new PartialPath("root")));
        Assert.assertFalse((boolean)manager.isPathExist(new PartialPath("root.laptop")));
        try {
            manager.setStorageGroup(new PartialPath("root.laptop.d1"));
            manager.setStorageGroup(new PartialPath("root.1"));
        }
        catch (MetadataException e) {
            e.printStackTrace();
            Assert.fail((String)e.getMessage());
        }
        Assert.assertTrue((boolean)manager.isPathExist(new PartialPath("root.1")));
        try {
            manager.setStorageGroup(new PartialPath("root.laptop"));
        }
        catch (MetadataException e) {
            Assert.assertEquals((Object)"some children of root.laptop have already been set to storage group", (Object)e.getMessage());
        }
        try {
            manager.createTimeseries(new PartialPath("root.laptop.d1.s0"), TSDataType.valueOf((String)"INT32"), TSEncoding.valueOf((String)"RLE"), this.compressionType, Collections.emptyMap());
        }
        catch (MetadataException e) {
            e.printStackTrace();
            Assert.fail((String)e.getMessage());
        }
        Assert.assertTrue((boolean)manager.isPathExist(new PartialPath("root.laptop")));
        Assert.assertTrue((boolean)manager.isPathExist(new PartialPath("root.laptop.d1")));
        Assert.assertTrue((boolean)manager.isPathExist(new PartialPath("root.laptop.d1.s0")));
        Assert.assertFalse((boolean)manager.isPathExist(new PartialPath("root.laptop.d1.s1")));
        try {
            manager.createTimeseries(new PartialPath("root.laptop.d1.s1"), TSDataType.valueOf((String)"INT32"), TSEncoding.valueOf((String)"RLE"), this.compressionType, Collections.emptyMap());
            manager.createTimeseries(new PartialPath("root.laptop.d1.1_2"), TSDataType.INT32, TSEncoding.RLE, TSFileDescriptor.getInstance().getConfig().getCompressor(), Collections.EMPTY_MAP);
            manager.createTimeseries(new PartialPath("root.laptop.d1.\"1.2.3\""), TSDataType.INT32, TSEncoding.RLE, TSFileDescriptor.getInstance().getConfig().getCompressor(), Collections.EMPTY_MAP);
            manager.createTimeseries(new PartialPath("root.1.2.3"), TSDataType.INT32, TSEncoding.RLE, TSFileDescriptor.getInstance().getConfig().getCompressor(), Collections.EMPTY_MAP);
            Assert.assertTrue((boolean)manager.isPathExist(new PartialPath("root.laptop.d1.s1")));
            Assert.assertTrue((boolean)manager.isPathExist(new PartialPath("root.laptop.d1.1_2")));
            Assert.assertTrue((boolean)manager.isPathExist(new PartialPath("root.laptop.d1.\"1.2.3\"")));
            Assert.assertTrue((boolean)manager.isPathExist(new PartialPath("root.1.2")));
            Assert.assertTrue((boolean)manager.isPathExist(new PartialPath("root.1.2.3")));
        }
        catch (MetadataException e1) {
            e1.printStackTrace();
            Assert.fail((String)e1.getMessage());
        }
        try {
            manager.deleteTimeseries(new PartialPath("root.laptop.d1.s1"));
        }
        catch (MetadataException e) {
            e.printStackTrace();
            Assert.fail((String)e.getMessage());
        }
        Assert.assertFalse((boolean)manager.isPathExist(new PartialPath("root.laptop.d1.s1")));
        try {
            manager.deleteTimeseries(new PartialPath("root.laptop.d1.s0"));
        }
        catch (MetadataException e) {
            e.printStackTrace();
            Assert.fail((String)e.getMessage());
        }
        Assert.assertFalse((boolean)manager.isPathExist(new PartialPath("root.laptop.d1.s0")));
        Assert.assertTrue((boolean)manager.isPathExist(new PartialPath("root.laptop.d1")));
        Assert.assertTrue((boolean)manager.isPathExist(new PartialPath("root.laptop")));
        Assert.assertTrue((boolean)manager.isPathExist(new PartialPath("root")));
        try {
            manager.createTimeseries(new PartialPath("root.laptop.d1.s1"), TSDataType.valueOf((String)"INT32"), TSEncoding.valueOf((String)"RLE"), this.compressionType, Collections.emptyMap());
        }
        catch (MetadataException e1) {
            e1.printStackTrace();
            Assert.fail((String)e1.getMessage());
        }
        try {
            manager.createTimeseries(new PartialPath("root.laptop.d1.s0"), TSDataType.valueOf((String)"INT32"), TSEncoding.valueOf((String)"RLE"), this.compressionType, Collections.emptyMap());
        }
        catch (MetadataException e1) {
            e1.printStackTrace();
            Assert.fail((String)e1.getMessage());
        }
        Assert.assertFalse((boolean)manager.isPathExist(new PartialPath("root.laptop.d2")));
        Assert.assertFalse((boolean)manager.checkStorageGroupByPath(new PartialPath("root.laptop.d2")));
        try {
            manager.deleteTimeseries(new PartialPath("root.laptop.d1.s0"));
        }
        catch (MetadataException e) {
            e.printStackTrace();
            Assert.fail((String)e.getMessage());
        }
        try {
            manager.deleteTimeseries(new PartialPath("root.laptop.d1.s1"));
        }
        catch (MetadataException e) {
            e.printStackTrace();
            Assert.fail((String)e.getMessage());
        }
        try {
            manager.setStorageGroup(new PartialPath("root.laptop1"));
        }
        catch (MetadataException e) {
            Assert.assertEquals((Object)String.format("The seriesPath of %s already exist, it can't be set to the storage group", "root.laptop1"), (Object)e.getMessage());
        }
        try {
            manager.deleteTimeseries(new PartialPath("root.laptop.d1.1_2"));
            manager.deleteTimeseries(new PartialPath("root.laptop.d1.\"1.2.3\""));
            manager.deleteTimeseries(new PartialPath("root.1.2.3"));
        }
        catch (MetadataException e) {
            e.printStackTrace();
            Assert.fail((String)e.getMessage());
        }
        Assert.assertFalse((boolean)manager.isPathExist(new PartialPath("root.laptop.d1.1_2")));
        Assert.assertFalse((boolean)manager.isPathExist(new PartialPath("root.laptop.d1.\"1.2.3\"")));
        Assert.assertFalse((boolean)manager.isPathExist(new PartialPath("root.1.2.3")));
        Assert.assertFalse((boolean)manager.isPathExist(new PartialPath("root.1.2")));
        Assert.assertTrue((boolean)manager.isPathExist(new PartialPath("root.1")));
        try {
            manager.deleteStorageGroups(Collections.singletonList(new PartialPath("root.1")));
        }
        catch (MetadataException e) {
            e.printStackTrace();
            Assert.fail((String)e.getMessage());
        }
        Assert.assertFalse((boolean)manager.isPathExist(new PartialPath("root.1")));
    }

    @Test
    public void testGetAllTimeseriesCount() {
        MManager manager = IoTDB.metaManager;
        try {
            manager.setStorageGroup(new PartialPath("root.laptop"));
            manager.createTimeseries(new PartialPath("root.laptop.d1"), TSDataType.INT32, TSEncoding.PLAIN, CompressionType.GZIP, null);
            manager.createTimeseries(new PartialPath("root.laptop.d1.s1"), TSDataType.INT32, TSEncoding.PLAIN, CompressionType.GZIP, null);
            manager.createTimeseries(new PartialPath("root.laptop.d1.s1.t1"), TSDataType.INT32, TSEncoding.PLAIN, CompressionType.GZIP, null);
            manager.createTimeseries(new PartialPath("root.laptop.d1.s2"), TSDataType.INT32, TSEncoding.PLAIN, CompressionType.GZIP, null);
            manager.createTimeseries(new PartialPath("root.laptop.d2.s1"), TSDataType.INT32, TSEncoding.PLAIN, CompressionType.GZIP, null);
            manager.createTimeseries(new PartialPath("root.laptop.d2.s2"), TSDataType.INT32, TSEncoding.PLAIN, CompressionType.GZIP, null);
            Assert.assertEquals((long)manager.getAllTimeseriesCount(new PartialPath("root")), (long)6L);
            Assert.assertEquals((long)manager.getAllTimeseriesCount(new PartialPath("root.laptop")), (long)6L);
            Assert.assertEquals((long)manager.getAllTimeseriesCount(new PartialPath("root.laptop.*")), (long)6L);
            Assert.assertEquals((long)manager.getAllTimeseriesCount(new PartialPath("root.laptop.*.*")), (long)5L);
            Assert.assertEquals((long)manager.getAllTimeseriesCount(new PartialPath("root.laptop.*.*.t1")), (long)1L);
            Assert.assertEquals((long)manager.getAllTimeseriesCount(new PartialPath("root.laptop.*.s1")), (long)3L);
            Assert.assertEquals((long)manager.getAllTimeseriesCount(new PartialPath("root.laptop.d1")), (long)4L);
            Assert.assertEquals((long)manager.getAllTimeseriesCount(new PartialPath("root.laptop.d1.*")), (long)3L);
            Assert.assertEquals((long)manager.getAllTimeseriesCount(new PartialPath("root.laptop.d2.s1")), (long)1L);
            Assert.assertEquals((long)manager.getAllTimeseriesCount(new PartialPath("root.laptop.d2")), (long)2L);
            try {
                manager.getAllTimeseriesCount(new PartialPath("root.laptop.d3.s1"));
                Assert.fail((String)"Expected exception");
            }
            catch (MetadataException e) {
                Assert.assertEquals((Object)"Path [root.laptop.d3.s1] does not exist", (Object)e.getMessage());
            }
        }
        catch (MetadataException e) {
            e.printStackTrace();
            Assert.fail((String)e.getMessage());
        }
    }

    @Test
    public void testSetStorageGroupAndExist() {
        MManager manager = IoTDB.metaManager;
        try {
            Assert.assertFalse((boolean)manager.isStorageGroup(new PartialPath("root")));
            Assert.assertFalse((boolean)manager.isStorageGroup(new PartialPath("root1.laptop.d2")));
            manager.setStorageGroup(new PartialPath("root.laptop.d1"));
            Assert.assertTrue((boolean)manager.isStorageGroup(new PartialPath("root.laptop.d1")));
            Assert.assertFalse((boolean)manager.isStorageGroup(new PartialPath("root.laptop.d2")));
            Assert.assertFalse((boolean)manager.isStorageGroup(new PartialPath("root.laptop")));
            Assert.assertFalse((boolean)manager.isStorageGroup(new PartialPath("root.laptop.d1.s1")));
            manager.setStorageGroup(new PartialPath("root.laptop.d2"));
            Assert.assertTrue((boolean)manager.isStorageGroup(new PartialPath("root.laptop.d1")));
            Assert.assertTrue((boolean)manager.isStorageGroup(new PartialPath("root.laptop.d2")));
            Assert.assertFalse((boolean)manager.isStorageGroup(new PartialPath("root.laptop.d3")));
            Assert.assertFalse((boolean)manager.isStorageGroup(new PartialPath("root.laptop")));
        }
        catch (MetadataException e) {
            e.printStackTrace();
            Assert.fail((String)e.getMessage());
        }
    }

    @Test
    public void testRecover() {
        MManager manager = IoTDB.metaManager;
        try {
            manager.setStorageGroup(new PartialPath("root.laptop.d1"));
            manager.setStorageGroup(new PartialPath("root.laptop.d2"));
            manager.createTimeseries(new PartialPath("root.laptop.d1.s1"), TSDataType.INT32, TSEncoding.PLAIN, CompressionType.GZIP, null);
            manager.createTimeseries(new PartialPath("root.laptop.d2.s1"), TSDataType.INT32, TSEncoding.PLAIN, CompressionType.GZIP, null);
            Assert.assertTrue((boolean)manager.isStorageGroup(new PartialPath("root.laptop.d1")));
            Assert.assertTrue((boolean)manager.isStorageGroup(new PartialPath("root.laptop.d2")));
            Assert.assertFalse((boolean)manager.isStorageGroup(new PartialPath("root.laptop.d3")));
            Assert.assertFalse((boolean)manager.isStorageGroup(new PartialPath("root.laptop")));
            TreeSet<String> devices = new TreeSet<String>(){
                {
                    this.add("root.laptop.d1");
                    this.add("root.laptop.d2");
                }
            };
            Assert.assertEquals((Object)devices, manager.getDevices(new PartialPath("root.*")).stream().map(PartialPath::getFullPath).collect(Collectors.toSet()));
            manager.deleteStorageGroups(Collections.singletonList(new PartialPath("root.laptop.d2")));
            Assert.assertTrue((boolean)manager.isStorageGroup(new PartialPath("root.laptop.d1")));
            Assert.assertFalse((boolean)manager.isStorageGroup(new PartialPath("root.laptop.d2")));
            Assert.assertFalse((boolean)manager.isStorageGroup(new PartialPath("root.laptop.d3")));
            Assert.assertFalse((boolean)manager.isStorageGroup(new PartialPath("root.laptop")));
            devices.remove("root.laptop.d2");
            Assert.assertEquals((Object)devices, manager.getDevices(new PartialPath("root.*")).stream().map(PartialPath::getFullPath).collect(Collectors.toSet()));
            MManager recoverManager = new MManager();
            recoverManager.init();
            Assert.assertTrue((boolean)recoverManager.isStorageGroup(new PartialPath("root.laptop.d1")));
            Assert.assertFalse((boolean)recoverManager.isStorageGroup(new PartialPath("root.laptop.d2")));
            Assert.assertFalse((boolean)recoverManager.isStorageGroup(new PartialPath("root.laptop.d3")));
            Assert.assertFalse((boolean)recoverManager.isStorageGroup(new PartialPath("root.laptop")));
            Assert.assertEquals((Object)devices, recoverManager.getDevices(new PartialPath("root.*")).stream().map(PartialPath::getFullPath).collect(Collectors.toSet()));
            recoverManager.clear();
        }
        catch (MetadataException e) {
            e.printStackTrace();
            Assert.fail((String)e.getMessage());
        }
    }

    @Test
    public void testGetAllFileNamesByPath() {
        MManager manager = IoTDB.metaManager;
        try {
            manager.setStorageGroup(new PartialPath("root.laptop.d1"));
            manager.setStorageGroup(new PartialPath("root.laptop.d2"));
            manager.createTimeseries(new PartialPath("root.laptop.d1.s1"), TSDataType.INT32, TSEncoding.PLAIN, CompressionType.GZIP, null);
            manager.createTimeseries(new PartialPath("root.laptop.d2.s1"), TSDataType.INT32, TSEncoding.PLAIN, CompressionType.GZIP, null);
            ArrayList<String> list = new ArrayList<String>();
            list.add("root.laptop.d1");
            Assert.assertEquals(list, (Object)manager.getStorageGroupByPath(new PartialPath("root.laptop.d1.s1")));
            Assert.assertEquals(list, (Object)manager.getStorageGroupByPath(new PartialPath("root.laptop.d1")));
            list.add("root.laptop.d2");
            Assert.assertEquals(list, (Object)manager.getStorageGroupByPath(new PartialPath("root.laptop")));
            Assert.assertEquals(list, (Object)manager.getStorageGroupByPath(new PartialPath("root")));
        }
        catch (MetadataException e) {
            e.printStackTrace();
            Assert.fail((String)e.getMessage());
        }
    }

    @Test
    public void testCheckStorageExistOfPath() {
        MManager manager = IoTDB.metaManager;
        try {
            Assert.assertTrue((boolean)manager.getAllTimeseriesPath(new PartialPath("root")).isEmpty());
            Assert.assertTrue((boolean)manager.getStorageGroupByPath(new PartialPath("root.vehicle")).isEmpty());
            Assert.assertTrue((boolean)manager.getStorageGroupByPath(new PartialPath("root.vehicle.device")).isEmpty());
            Assert.assertTrue((boolean)manager.getStorageGroupByPath(new PartialPath("root.vehicle.device.sensor")).isEmpty());
            manager.setStorageGroup(new PartialPath("root.vehicle"));
            Assert.assertFalse((boolean)manager.getStorageGroupByPath(new PartialPath("root.vehicle")).isEmpty());
            Assert.assertFalse((boolean)manager.getStorageGroupByPath(new PartialPath("root.vehicle.device")).isEmpty());
            Assert.assertFalse((boolean)manager.getStorageGroupByPath(new PartialPath("root.vehicle.device.sensor")).isEmpty());
            Assert.assertTrue((boolean)manager.getStorageGroupByPath(new PartialPath("root.vehicle1")).isEmpty());
            Assert.assertTrue((boolean)manager.getStorageGroupByPath(new PartialPath("root.vehicle1.device")).isEmpty());
            manager.setStorageGroup(new PartialPath("root.vehicle1.device"));
            Assert.assertTrue((boolean)manager.getStorageGroupByPath(new PartialPath("root.vehicle1.device1")).isEmpty());
            Assert.assertTrue((boolean)manager.getStorageGroupByPath(new PartialPath("root.vehicle1.device2")).isEmpty());
            Assert.assertTrue((boolean)manager.getStorageGroupByPath(new PartialPath("root.vehicle1.device3")).isEmpty());
            Assert.assertFalse((boolean)manager.getStorageGroupByPath(new PartialPath("root.vehicle1.device")).isEmpty());
        }
        catch (MetadataException e) {
            e.printStackTrace();
            Assert.fail((String)e.getMessage());
        }
    }

    @Test
    public void testShowChildNodesWithGivenPrefix() {
        MManager manager = IoTDB.metaManager;
        try {
            manager.setStorageGroup(new PartialPath("root.laptop"));
            manager.createTimeseries(new PartialPath("root.laptop.d1.s1"), TSDataType.INT32, TSEncoding.PLAIN, CompressionType.GZIP, null);
            manager.createTimeseries(new PartialPath("root.laptop.d2.s1"), TSDataType.INT32, TSEncoding.PLAIN, CompressionType.GZIP, null);
            manager.createTimeseries(new PartialPath("root.laptop.d1.s2"), TSDataType.INT32, TSEncoding.PLAIN, CompressionType.GZIP, null);
            HashSet<String> nodes = new HashSet<String>(Arrays.asList("s1", "s2"));
            HashSet<String> nodes2 = new HashSet<String>(Arrays.asList("laptop"));
            HashSet<String> nodes3 = new HashSet<String>(Arrays.asList("d1", "d2"));
            Set nexLevelNodes1 = manager.getChildNodeInNextLevel(new PartialPath("root.laptop.d1"));
            Set nexLevelNodes2 = manager.getChildNodeInNextLevel(new PartialPath("root"));
            Set nexLevelNodes3 = manager.getChildNodeInNextLevel(new PartialPath("root.laptop"));
            Assert.assertEquals(nodes, (Object)nexLevelNodes1);
            Assert.assertEquals(nodes2, (Object)nexLevelNodes2);
            Assert.assertEquals(nodes3, (Object)nexLevelNodes3);
        }
        catch (MetadataException e) {
            e.printStackTrace();
            Assert.fail((String)e.getMessage());
        }
    }

    @Test
    public void testGetStorageGroupNameByAutoLevel() {
        int level = IoTDBDescriptor.getInstance().getConfig().getDefaultStorageGroupLevel();
        try {
            Assert.assertEquals((Object)"root.laptop", (Object)MetaUtils.getStorageGroupPathByLevel((PartialPath)new PartialPath("root.laptop.d1.s1"), (int)level).getFullPath());
        }
        catch (MetadataException e) {
            e.printStackTrace();
            Assert.fail((String)e.getMessage());
        }
        boolean caughtException = false;
        try {
            MetaUtils.getStorageGroupPathByLevel((PartialPath)new PartialPath("root1.laptop.d1.s1"), (int)level);
        }
        catch (MetadataException e) {
            caughtException = true;
            Assert.assertEquals((Object)"root1.laptop.d1.s1 is not a legal path", (Object)e.getMessage());
        }
        Assert.assertTrue((boolean)caughtException);
        caughtException = false;
        try {
            MetaUtils.getStorageGroupPathByLevel((PartialPath)new PartialPath("root"), (int)level);
        }
        catch (MetadataException e) {
            caughtException = true;
            Assert.assertEquals((Object)"root is not a legal path", (Object)e.getMessage());
        }
        Assert.assertTrue((boolean)caughtException);
    }

    @Test
    public void testSetStorageGroupWithIllegalName() {
        MManager manager = IoTDB.metaManager;
        try {
            PartialPath path1 = new PartialPath("root.laptop\n");
            try {
                manager.setStorageGroup(path1);
                Assert.fail();
            }
            catch (MetadataException metadataException) {}
        }
        catch (IllegalPathException e1) {
            Assert.fail();
        }
        try {
            PartialPath path2 = new PartialPath("root.laptop\t");
            try {
                manager.setStorageGroup(path2);
                Assert.fail();
            }
            catch (MetadataException metadataException) {}
        }
        catch (IllegalPathException e1) {
            Assert.fail();
        }
    }

    @Test
    public void testCreateTimeseriesWithIllegalName() {
        MManager manager = IoTDB.metaManager;
        try {
            PartialPath path1 = new PartialPath("root.laptop.d1\n.s1");
            try {
                manager.createTimeseries(path1, TSDataType.INT32, TSEncoding.PLAIN, CompressionType.SNAPPY, null);
                Assert.fail();
            }
            catch (MetadataException metadataException) {}
        }
        catch (IllegalPathException e1) {
            Assert.fail();
        }
        try {
            PartialPath path2 = new PartialPath("root.laptop.d1\t.s1");
            try {
                manager.createTimeseries(path2, TSDataType.INT32, TSEncoding.PLAIN, CompressionType.SNAPPY, null);
                Assert.fail();
            }
            catch (MetadataException metadataException) {}
        }
        catch (IllegalPathException e1) {
            Assert.fail();
        }
    }

    @Test
    public void testGetDevicesWithGivenPrefix() {
        MManager manager = IoTDB.metaManager;
        try {
            manager.setStorageGroup(new PartialPath("root.laptop"));
            manager.createTimeseries(new PartialPath("root.laptop.d1.s1"), TSDataType.INT32, TSEncoding.PLAIN, CompressionType.GZIP, null);
            manager.createTimeseries(new PartialPath("root.laptop.d2.s1"), TSDataType.INT32, TSEncoding.PLAIN, CompressionType.GZIP, null);
            TreeSet<String> devices = new TreeSet<String>();
            devices.add("root.laptop.d1");
            devices.add("root.laptop.d2");
            Assert.assertEquals(devices, manager.getDevices(new PartialPath("root.laptop")).stream().map(PartialPath::getFullPath).collect(Collectors.toSet()));
            manager.setStorageGroup(new PartialPath("root.vehicle"));
            manager.createTimeseries(new PartialPath("root.vehicle.d1.s1"), TSDataType.INT32, TSEncoding.PLAIN, CompressionType.GZIP, null);
            devices.add("root.vehicle.d1");
            Assert.assertEquals(devices, manager.getDevices(new PartialPath("root.*")).stream().map(PartialPath::getFullPath).collect(Collectors.toSet()));
        }
        catch (MetadataException e) {
            e.printStackTrace();
            Assert.fail((String)e.getMessage());
        }
    }

    @Test
    public void testGetChildNodePathInNextLevel() {
        MManager manager = IoTDB.metaManager;
        String[] res = new String[]{"[root.laptop, root.vehicle]", "[root.laptop.b1, root.laptop.b2]", "[root.laptop.b1.d1, root.laptop.b1.d2]", "[root.laptop.b1, root.laptop.b2, root.vehicle.b1, root.vehicle.b2]", "[root.laptop.b1.d1, root.laptop.b1.d2, root.vehicle.b1.d0, root.vehicle.b1.d2, root.vehicle.b1.d3]", "[root.laptop.b1.d1, root.laptop.b1.d2]", "[root.vehicle.b1.d0, root.vehicle.b1.d2, root.vehicle.b1.d3, root.vehicle.b2.d0]", "[root.laptop.b1.d1.s0, root.laptop.b1.d1.s1, root.laptop.b1.d2.s0, root.laptop.b2.d1.s1, root.laptop.b2.d1.s3, root.laptop.b2.d2.s2]", "[]"};
        try {
            manager.setStorageGroup(new PartialPath("root.laptop"));
            manager.setStorageGroup(new PartialPath("root.vehicle"));
            manager.createTimeseries(new PartialPath("root.laptop.b1.d1.s0"), TSDataType.INT32, TSEncoding.PLAIN, CompressionType.GZIP, null);
            manager.createTimeseries(new PartialPath("root.laptop.b1.d1.s1"), TSDataType.INT32, TSEncoding.PLAIN, CompressionType.GZIP, null);
            manager.createTimeseries(new PartialPath("root.laptop.b1.d2.s0"), TSDataType.INT32, TSEncoding.PLAIN, CompressionType.GZIP, null);
            manager.createTimeseries(new PartialPath("root.laptop.b2.d1.s1"), TSDataType.INT32, TSEncoding.PLAIN, CompressionType.GZIP, null);
            manager.createTimeseries(new PartialPath("root.laptop.b2.d1.s3"), TSDataType.INT32, TSEncoding.PLAIN, CompressionType.GZIP, null);
            manager.createTimeseries(new PartialPath("root.laptop.b2.d2.s2"), TSDataType.INT32, TSEncoding.PLAIN, CompressionType.GZIP, null);
            manager.createTimeseries(new PartialPath("root.vehicle.b1.d0.s0"), TSDataType.INT32, TSEncoding.PLAIN, CompressionType.GZIP, null);
            manager.createTimeseries(new PartialPath("root.vehicle.b1.d2.s2"), TSDataType.INT32, TSEncoding.PLAIN, CompressionType.GZIP, null);
            manager.createTimeseries(new PartialPath("root.vehicle.b1.d3.s3"), TSDataType.INT32, TSEncoding.PLAIN, CompressionType.GZIP, null);
            manager.createTimeseries(new PartialPath("root.vehicle.b2.d0.s1"), TSDataType.INT32, TSEncoding.PLAIN, CompressionType.GZIP, null);
            Assert.assertEquals((Object)res[0], (Object)manager.getChildNodePathInNextLevel(new PartialPath("root")).toString());
            Assert.assertEquals((Object)res[1], (Object)manager.getChildNodePathInNextLevel(new PartialPath("root.laptop")).toString());
            Assert.assertEquals((Object)res[2], (Object)manager.getChildNodePathInNextLevel(new PartialPath("root.laptop.b1")).toString());
            Assert.assertEquals((Object)res[3], (Object)manager.getChildNodePathInNextLevel(new PartialPath("root.*")).toString());
            Assert.assertEquals((Object)res[4], (Object)manager.getChildNodePathInNextLevel(new PartialPath("root.*.b1")).toString());
            Assert.assertEquals((Object)res[5], (Object)manager.getChildNodePathInNextLevel(new PartialPath("root.l*.b1")).toString());
            Assert.assertEquals((Object)res[6], (Object)manager.getChildNodePathInNextLevel(new PartialPath("root.v*.*")).toString());
            Assert.assertEquals((Object)res[7], (Object)manager.getChildNodePathInNextLevel(new PartialPath("root.l*.b*.*")).toString());
            Assert.assertEquals((Object)res[8], (Object)manager.getChildNodePathInNextLevel(new PartialPath("root.laptopp")).toString());
        }
        catch (MetadataException e) {
            e.printStackTrace();
            Assert.fail((String)e.getMessage());
        }
    }

    @Test
    public void testTotalSeriesNumber() throws Exception {
        MManager manager = IoTDB.metaManager;
        try {
            manager.setStorageGroup(new PartialPath("root.laptop"));
            manager.createTimeseries(new PartialPath("root.laptop.d1"), TSDataType.INT32, TSEncoding.PLAIN, CompressionType.GZIP, null);
            manager.createTimeseries(new PartialPath("root.laptop.d1.s1"), TSDataType.INT32, TSEncoding.PLAIN, CompressionType.GZIP, null);
            manager.createTimeseries(new PartialPath("root.laptop.d1.s1.t1"), TSDataType.INT32, TSEncoding.PLAIN, CompressionType.GZIP, null);
            manager.createTimeseries(new PartialPath("root.laptop.d1.s2"), TSDataType.INT32, TSEncoding.PLAIN, CompressionType.GZIP, null);
            manager.createTimeseries(new PartialPath("root.laptop.d2.s1"), TSDataType.INT32, TSEncoding.PLAIN, CompressionType.GZIP, null);
            manager.createTimeseries(new PartialPath("root.laptop.d2.s2"), TSDataType.INT32, TSEncoding.PLAIN, CompressionType.GZIP, null);
            Assert.assertEquals((long)6L, (long)manager.getTotalSeriesNumber());
            EnvironmentUtils.restartDaemon();
            Assert.assertEquals((long)6L, (long)manager.getTotalSeriesNumber());
            manager.deleteTimeseries(new PartialPath("root.laptop.d2.s1"));
            Assert.assertEquals((long)5L, (long)manager.getTotalSeriesNumber());
            manager.deleteStorageGroups(Collections.singletonList(new PartialPath("root.laptop")));
            Assert.assertEquals((long)0L, (long)manager.getTotalSeriesNumber());
        }
        catch (MetadataException e) {
            e.printStackTrace();
            Assert.fail((String)e.getMessage());
        }
    }

    @Test
    public void testStorageGroupNameWithHyphen() throws IllegalPathException {
        MManager manager = IoTDB.metaManager;
        Assert.assertTrue((boolean)manager.isPathExist(new PartialPath("root")));
        Assert.assertFalse((boolean)manager.isPathExist(new PartialPath("root.group-with-hyphen")));
        try {
            manager.setStorageGroup(new PartialPath("root.group-with-hyphen"));
        }
        catch (MetadataException e) {
            e.printStackTrace();
            Assert.fail((String)e.getMessage());
        }
        Assert.assertTrue((boolean)manager.isPathExist(new PartialPath("root.group-with-hyphen")));
    }

    @Test
    public void testGetStorageGroupNodeByPath() {
        MManager manager = IoTDB.metaManager;
        PartialPath partialPath = null;
        try {
            partialPath = new PartialPath("root.ln.sg1");
        }
        catch (IllegalPathException e) {
            Assert.fail((String)e.getMessage());
        }
        try {
            manager.setStorageGroup(partialPath);
        }
        catch (MetadataException e) {
            Assert.fail((String)e.getMessage());
        }
        try {
            partialPath = new PartialPath("root.ln.sg2.device1.sensor1");
        }
        catch (IllegalPathException e) {
            Assert.fail((String)e.getMessage());
        }
        try {
            manager.getStorageGroupNodeByPath(partialPath);
        }
        catch (StorageGroupNotSetException e) {
            Assert.assertEquals((Object)"Storage group is not set for current seriesPath: [root.ln.sg2.device1.sensor1]", (Object)e.getMessage());
        }
        catch (MetadataException e) {
            Assert.fail((String)e.getMessage());
        }
    }
}

