/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.integration.auth;

import java.sql.BatchUpdateException;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Collections;
import org.apache.iotdb.db.utils.EnvironmentUtils;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Ignore;
import org.junit.Test;

public class IoTDBAuthorizationIT {
    @Before
    public void setUp() {
        EnvironmentUtils.closeStatMonitor();
        EnvironmentUtils.envSetUp();
    }

    @After
    public void tearDown() throws Exception {
        EnvironmentUtils.cleanEnv();
    }

    @Test
    public void allPrivilegesTest() throws ClassNotFoundException, SQLException {
        Class.forName("org.apache.iotdb.jdbc.IoTDBDriver");
        try (Connection adminCon = DriverManager.getConnection("jdbc:iotdb://127.0.0.1:6667/", "root", "root");
             Statement adminStmt = adminCon.createStatement();){
            adminStmt.execute("CREATE USER tempuser 'temppw'");
            boolean caught = false;
            try (Connection userCon = DriverManager.getConnection("jdbc:iotdb://127.0.0.1:6667/", "tempuser", "temppw");
                 Statement userStmt = userCon.createStatement();){
                try {
                    userStmt.execute("SET STORAGE GROUP TO root.a");
                }
                catch (SQLException e) {
                    caught = true;
                }
                Assert.assertTrue((boolean)caught);
                caught = false;
                try {
                    userStmt.execute("CREATE TIMESERIES root.a.b WITH DATATYPE=INT32,ENCODING=PLAIN");
                }
                catch (SQLException e) {
                    caught = true;
                }
                Assert.assertTrue((boolean)caught);
                caught = false;
                try {
                    userStmt.execute("INSERT INTO root.a(timestamp, b) VALUES (100, 100)");
                }
                catch (SQLException e) {
                    caught = true;
                }
                Assert.assertTrue((boolean)caught);
                caught = false;
                try {
                    userStmt.execute("SELECT * from root.a");
                }
                catch (SQLException e) {
                    caught = true;
                }
                Assert.assertTrue((boolean)caught);
                caught = false;
                try {
                    userStmt.execute("GRANT USER tempuser PRIVILEGES 'CREATE_TIMESERIES' ON root.a");
                }
                catch (SQLException e) {
                    caught = true;
                }
                Assert.assertTrue((boolean)caught);
                adminStmt.execute("GRANT USER tempuser PRIVILEGES 'ALL' ON root");
                userStmt.execute("SET STORAGE GROUP TO root.a");
                userStmt.execute("CREATE TIMESERIES root.a.b WITH DATATYPE=INT32,ENCODING=PLAIN");
                userStmt.execute("INSERT INTO root.a(timestamp, b) VALUES (100, 100)");
                userStmt.execute("SELECT * from root.a");
                userStmt.execute("GRANT USER tempuser PRIVILEGES 'SET_STORAGE_GROUP' ON root.a");
                userStmt.execute("GRANT USER tempuser PRIVILEGES 'CREATE_TIMESERIES' ON root.b.b");
                adminStmt.execute("REVOKE USER tempuser PRIVILEGES 'ALL' ON root");
                adminStmt.execute("REVOKE USER tempuser PRIVILEGES 'CREATE_TIMESERIES' ON root.b.b");
                caught = false;
                try {
                    userStmt.execute("SET STORAGE GROUP TO root.b");
                }
                catch (SQLException e) {
                    caught = true;
                }
                Assert.assertTrue((boolean)caught);
                caught = false;
                try {
                    userStmt.execute("CREATE TIMESERIES root.b.b WITH DATATYPE=INT32,ENCODING=PLAIN");
                }
                catch (SQLException e) {
                    caught = true;
                }
                Assert.assertTrue((boolean)caught);
                caught = false;
                try {
                    userStmt.execute("INSERT INTO root.b(timestamp, b) VALUES (100, 100)");
                }
                catch (SQLException e) {
                    caught = true;
                }
                Assert.assertTrue((boolean)caught);
                caught = false;
                try {
                    userStmt.execute("SELECT * from root.b");
                }
                catch (SQLException e) {
                    caught = true;
                }
                Assert.assertTrue((boolean)caught);
                caught = false;
                try {
                    userStmt.execute("GRANT USER tempuser PRIVILEGES \"CREATE_TIMESERIES\" ON root.a");
                }
                catch (SQLException e) {
                    caught = true;
                }
                Assert.assertTrue((boolean)caught);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void updatePasswordTest() throws ClassNotFoundException, SQLException {
        Class.forName("org.apache.iotdb.jdbc.IoTDBDriver");
        try (Connection adminCon = DriverManager.getConnection("jdbc:iotdb://127.0.0.1:6667/", "root", "root");
             Statement adminStmt = adminCon.createStatement();){
            adminStmt.execute("CREATE USER tempuser 'temppw'");
            Connection userCon = DriverManager.getConnection("jdbc:iotdb://127.0.0.1:6667/", "tempuser", "temppw");
            userCon.close();
            adminStmt.execute("ALTER USER tempuser SET PASSWORD 'newpw'");
            boolean caught = false;
            try {
                userCon = DriverManager.getConnection("jdbc:iotdb://127.0.0.1:6667/", "tempuser", "temppw");
            }
            catch (SQLException e) {
                caught = true;
            }
            finally {
                userCon.close();
            }
            Assert.assertTrue((boolean)caught);
            userCon = DriverManager.getConnection("jdbc:iotdb://127.0.0.1:6667/", "tempuser", "newpw");
            userCon.close();
        }
    }

    @Test
    public void illegalGrantRevokeUserTest() throws ClassNotFoundException, SQLException {
        Class.forName("org.apache.iotdb.jdbc.IoTDBDriver");
        try (Connection adminCon = DriverManager.getConnection("jdbc:iotdb://127.0.0.1:6667/", "root", "root");
             Statement adminStmt = adminCon.createStatement();){
            adminStmt.execute("CREATE USER tempuser 'temppw'");
            try (Connection userCon = DriverManager.getConnection("jdbc:iotdb://127.0.0.1:6667/", "tempuser", "temppw");
                 Statement userStmt = userCon.createStatement();){
                boolean caught = false;
                try {
                    adminStmt.execute("GRANT USER nulluser PRIVILEGES 'SET_STORAGE_GROUP' on root.a");
                }
                catch (SQLException e) {
                    caught = true;
                }
                Assert.assertTrue((boolean)caught);
                caught = false;
                try {
                    adminStmt.execute("GRANT USER tempuser PRIVILEGES 'NOT_A_PRIVILEGE' on root.a");
                }
                catch (SQLException e) {
                    caught = true;
                }
                Assert.assertTrue((boolean)caught);
                adminStmt.execute("GRANT USER tempuser PRIVILEGES 'CREATE_USER' on root.a");
                caught = false;
                try {
                    adminStmt.execute("GRANT USER tempuser PRIVILEGES 'CREATE_USER' on root.a");
                }
                catch (SQLException e) {
                    caught = true;
                }
                Assert.assertTrue((boolean)caught);
                caught = false;
                try {
                    adminStmt.execute("GRANT USER tempuser PRIVILEGES 'DELETE_TIMESERIES' on a.b");
                }
                catch (SQLException e) {
                    caught = true;
                }
                Assert.assertTrue((boolean)caught);
                caught = false;
                try {
                    adminStmt.execute("GRANT USER root PRIVILEGES 'DELETE_TIMESERIES' on root.a.b");
                }
                catch (SQLException e) {
                    caught = true;
                }
                Assert.assertTrue((boolean)caught);
                caught = false;
                try {
                    userStmt.execute("GRANT USER tempuser PRIVILEGES 'DELETE_TIMESERIES' on root.a.b");
                }
                catch (SQLException e) {
                    caught = true;
                }
                Assert.assertTrue((boolean)caught);
                adminStmt.execute("REVOKE USER tempuser PRIVILEGES 'CREATE_USER' on root.a");
                caught = false;
                try {
                    adminStmt.execute("REVOKE USER tempuser PRIVILEGES 'CREATE_USER' on root.a");
                }
                catch (SQLException e) {
                    caught = true;
                }
                Assert.assertTrue((boolean)caught);
                caught = false;
                try {
                    adminStmt.execute("REVOKE USER tempuser1 PRIVILEGES 'CREATE_USER' on root.a");
                }
                catch (SQLException e) {
                    caught = true;
                }
                Assert.assertTrue((boolean)caught);
                caught = false;
                try {
                    adminStmt.execute("REVOKE USER tempuser PRIVILEGES 'DELETE_TIMESERIES' on a.b");
                }
                catch (SQLException e) {
                    caught = true;
                }
                Assert.assertTrue((boolean)caught);
                caught = false;
                try {
                    adminStmt.execute("REVOKE USER root PRIVILEGES 'DELETE_TIMESERIES' on root.a.b");
                }
                catch (SQLException e) {
                    caught = true;
                }
                Assert.assertTrue((boolean)caught);
                caught = false;
                try {
                    userStmt.execute("REVOKE USER tempuser PRIVILEGES 'DELETE_TIMESERIES' on root.a.b");
                }
                catch (SQLException e) {
                    caught = true;
                }
                Assert.assertTrue((boolean)caught);
                caught = false;
                try {
                    userStmt.execute("GRANT USER tempuser PRIVILEGES 'DELETE_TIMESERIES' on root.a.b");
                }
                catch (SQLException e) {
                    caught = true;
                }
                Assert.assertTrue((boolean)caught);
                adminStmt.execute("GRANT USER tempuser PRIVILEGES 'GRANT_USER_PRIVILEGE' on root");
                userStmt.execute("GRANT USER tempuser PRIVILEGES 'DELETE_TIMESERIES' on root");
                caught = false;
                try {
                    userStmt.execute("REVOKE USER tempuser PRIVILEGES 'DELETE_TIMESERIES' on root");
                }
                catch (SQLException e) {
                    caught = true;
                }
                Assert.assertTrue((boolean)caught);
                adminStmt.execute("GRANT USER tempuser PRIVILEGES 'REVOKE_USER_PRIVILEGE' on root");
                userStmt.execute("REVOKE USER tempuser PRIVILEGES 'DELETE_TIMESERIES' on root");
            }
        }
    }

    @Test
    public void createDeleteTimeSeriesTest() throws SQLException, ClassNotFoundException {
        Class.forName("org.apache.iotdb.jdbc.IoTDBDriver");
        try (Connection adminCon = DriverManager.getConnection("jdbc:iotdb://127.0.0.1:6667/", "root", "root");
             Statement adminStmt = adminCon.createStatement();){
            adminStmt.execute("CREATE USER tempuser 'temppw'");
            try (Connection userCon = DriverManager.getConnection("jdbc:iotdb://127.0.0.1:6667/", "tempuser", "temppw");
                 Statement userStmt = userCon.createStatement();){
                boolean caught = false;
                try {
                    userStmt.execute("SET STORAGE GROUP TO root.a");
                }
                catch (SQLException e) {
                    caught = true;
                }
                Assert.assertTrue((boolean)caught);
                adminStmt.execute("GRANT USER tempuser PRIVILEGES 'SET_STORAGE_GROUP' ON root.a");
                userStmt.execute("SET STORAGE GROUP TO root.a");
                adminStmt.execute("GRANT USER tempuser PRIVILEGES 'CREATE_TIMESERIES' ON root.a.b");
                userStmt.execute("CREATE TIMESERIES root.a.b WITH DATATYPE=INT32,ENCODING=PLAIN");
                caught = false;
                try {
                    userStmt.execute("SET STORAGE GROUP TO root.b");
                }
                catch (SQLException e) {
                    caught = true;
                }
                Assert.assertTrue((boolean)caught);
                caught = false;
                try {
                    adminStmt.execute("GRANT USER tempuser PRIVILEGES 'SET_STORAGE_GROUP' ON root.a");
                }
                catch (SQLException e) {
                    caught = true;
                }
                Assert.assertTrue((boolean)caught);
                adminStmt.execute("REVOKE USER tempuser PRIVILEGES 'SET_STORAGE_GROUP' ON root.a");
                caught = false;
                try {
                    userStmt.execute("SET STORAGE GROUP TO root.a");
                }
                catch (SQLException e) {
                    caught = true;
                }
                Assert.assertTrue((boolean)caught);
                caught = false;
                try {
                    userStmt.execute("CREATE TIMESERIES root.b.a WITH DATATYPE=INT32,ENCODING=PLAIN");
                }
                catch (SQLException e) {
                    caught = true;
                }
                Assert.assertTrue((boolean)caught);
                caught = false;
                try {
                    adminStmt.execute("GRANT USER tempuser PRIVILEGES 'CREATE_TIMESERIES' ON root.a.b");
                }
                catch (SQLException e) {
                    caught = true;
                }
                Assert.assertTrue((boolean)caught);
                adminStmt.execute("REVOKE USER tempuser PRIVILEGES 'CREATE_TIMESERIES' ON root.a.b");
                caught = false;
                try {
                    userStmt.execute("CREATE TIMESERIES root.a.b WITH DATATYPE=INT32,ENCODING=PLAIN");
                }
                catch (SQLException e) {
                    caught = true;
                }
                Assert.assertTrue((boolean)caught);
                caught = false;
                try {
                    userStmt.execute("DELETE TIMESERIES root.a.b");
                }
                catch (SQLException e) {
                    caught = true;
                }
                Assert.assertTrue((boolean)caught);
                adminStmt.execute("GRANT USER tempuser PRIVILEGES 'DELETE_TIMESERIES' on root.a");
                adminStmt.execute("GRANT USER tempuser PRIVILEGES 'DELETE_TIMESERIES' on root.b");
                userStmt.execute("DELETE TIMESERIES root.a.b");
                adminStmt.execute("CREATE TIMESERIES root.a.b WITH DATATYPE=INT32,ENCODING=PLAIN");
                adminStmt.execute("SET STORAGE GROUP TO root.b");
                adminStmt.execute("CREATE TIMESERIES root.b.a WITH DATATYPE=INT32,ENCODING=PLAIN");
                adminStmt.execute("REVOKE USER tempuser PRIVILEGES 'DELETE_TIMESERIES' on root.a");
                userStmt.execute("DELETE TIMESERIES root.b.a");
                caught = false;
                try {
                    userStmt.execute("DELETE TIMESERIES root.a.b");
                }
                catch (SQLException e) {
                    caught = true;
                }
                Assert.assertTrue((boolean)caught);
            }
        }
    }

    @Test
    public void insertQueryTest() throws ClassNotFoundException, SQLException {
        Class.forName("org.apache.iotdb.jdbc.IoTDBDriver");
        try (Connection adminCon = DriverManager.getConnection("jdbc:iotdb://127.0.0.1:6667/", "root", "root");
             Statement adminStmt = adminCon.createStatement();){
            adminStmt.execute("CREATE USER tempuser 'temppw'");
            try (Connection userCon = DriverManager.getConnection("jdbc:iotdb://127.0.0.1:6667/", "tempuser", "temppw");
                 Statement userStmt = userCon.createStatement();){
                adminStmt.execute("GRANT USER tempuser PRIVILEGES 'SET_STORAGE_GROUP' ON root.a");
                userStmt.execute("SET STORAGE GROUP TO root.a");
                adminStmt.execute("GRANT USER tempuser PRIVILEGES 'CREATE_TIMESERIES' ON root.a.b");
                userStmt.execute("CREATE TIMESERIES root.a.b WITH DATATYPE=INT32,ENCODING=PLAIN");
                boolean caught = false;
                try {
                    userStmt.execute("INSERT INTO root.a(timestamp, b) VALUES (1,100)");
                }
                catch (SQLException e) {
                    caught = true;
                }
                Assert.assertTrue((boolean)caught);
                adminStmt.execute("GRANT USER tempuser PRIVILEGES 'INSERT_TIMESERIES' on root.a");
                userStmt.execute("INSERT INTO root.a(timestamp, b) VALUES (1,100)");
                adminStmt.execute("REVOKE USER tempuser PRIVILEGES 'INSERT_TIMESERIES' on root.a");
                caught = false;
                try {
                    userStmt.execute("INSERT INTO root.a(timestamp, b) VALUES (1,100)");
                }
                catch (SQLException e) {
                    caught = true;
                }
                Assert.assertTrue((boolean)caught);
                caught = false;
                try {
                    userStmt.execute("SELECT * from root.a");
                }
                catch (SQLException e) {
                    caught = true;
                }
                Assert.assertTrue((boolean)caught);
                adminStmt.execute("GRANT USER tempuser PRIVILEGES 'READ_TIMESERIES' on root.a");
                userStmt.execute("SELECT * from root.a");
                userStmt.getResultSet().close();
                userStmt.execute("SELECT LAST b from root.a");
                userStmt.getResultSet().close();
                adminStmt.execute("REVOKE USER tempuser PRIVILEGES 'READ_TIMESERIES' on root.a");
                caught = false;
                try {
                    userStmt.execute("SELECT * from root.a");
                }
                catch (SQLException e) {
                    caught = true;
                }
                Assert.assertTrue((boolean)caught);
            }
        }
    }

    @Test
    public void rolePrivilegeTest() throws SQLException, ClassNotFoundException {
        Class.forName("org.apache.iotdb.jdbc.IoTDBDriver");
        try (Connection adminCon = DriverManager.getConnection("jdbc:iotdb://127.0.0.1:6667/", "root", "root");
             Statement adminStmt = adminCon.createStatement();){
            adminStmt.execute("CREATE USER tempuser 'temppw'");
            try (Connection userCon = DriverManager.getConnection("jdbc:iotdb://127.0.0.1:6667/", "tempuser", "temppw");
                 Statement userStmt = userCon.createStatement();){
                boolean caught = false;
                try {
                    userStmt.execute("CREATE ROLE admin");
                }
                catch (SQLException e) {
                    caught = true;
                }
                Assert.assertTrue((boolean)caught);
                adminStmt.execute("CREATE ROLE admin");
                adminStmt.execute("GRANT ROLE admin PRIVILEGES 'SET_STORAGE_GROUP','CREATE_TIMESERIES','DELETE_TIMESERIES','READ_TIMESERIES','INSERT_TIMESERIES' on root");
                adminStmt.execute("GRANT admin TO tempuser");
                userStmt.execute("SET STORAGE GROUP TO root.a");
                userStmt.execute("CREATE TIMESERIES root.a.b WITH DATATYPE=INT32,ENCODING=PLAIN");
                userStmt.execute("CREATE TIMESERIES root.a.c WITH DATATYPE=INT32,ENCODING=PLAIN");
                userStmt.execute("INSERT INTO root.a(timestamp,b,c) VALUES (1,100,1000)");
                userStmt.execute("SELECT * FROM root");
                userStmt.getResultSet().close();
                adminStmt.execute("REVOKE ROLE admin PRIVILEGES 'DELETE_TIMESERIES' on root");
                caught = false;
                try {
                    userStmt.execute("DELETE FROM root.* WHERE TIME <= 1000000000");
                }
                catch (SQLException e) {
                    caught = true;
                }
                Assert.assertTrue((boolean)caught);
                adminStmt.execute("GRANT USER tempuser PRIVILEGES 'READ_TIMESERIES' on root");
                adminStmt.execute("REVOKE admin FROM tempuser");
                userStmt.execute("SELECT * FROM root");
                userStmt.getResultSet().close();
                caught = false;
                try {
                    userStmt.execute("CREATE TIMESERIES root.a.b WITH DATATYPE=INT32,ENCODING=PLAIN");
                }
                catch (SQLException e) {
                    caught = true;
                }
                Assert.assertTrue((boolean)caught);
            }
        }
    }

    @Test
    @Ignore
    public void authPerformanceTest() throws ClassNotFoundException, SQLException {
        Class.forName("org.apache.iotdb.jdbc.IoTDBDriver");
        try (Connection adminCon = DriverManager.getConnection("jdbc:iotdb://127.0.0.1:6667/", "root", "root");
             Statement adminStmt = adminCon.createStatement();){
            adminStmt.execute("CREATE USER tempuser 'temppw'");
            adminStmt.execute("SET STORAGE GROUP TO root.a");
            int privilegeCnt = 500;
            for (int i = 0; i < privilegeCnt; ++i) {
                adminStmt.execute("CREATE TIMESERIES root.a.b" + i + " WITH DATATYPE=INT32,ENCODING=PLAIN");
                adminStmt.execute("GRANT USER tempuser PRIVILEGES 'INSERT_TIMESERIES' ON root.a.b" + i);
            }
            try (Connection userCon = DriverManager.getConnection("jdbc:iotdb://127.0.0.1:6667/", "tempuser", "temppw");
                 Statement userStmt = userCon.createStatement();){
                int j;
                int insertCnt = 20000;
                int batchSize = 500;
                long time = System.currentTimeMillis();
                int i = 0;
                while (i < insertCnt) {
                    for (j = 0; j < batchSize; ++j) {
                        userStmt.addBatch("INSERT INTO root.a(timestamp, b" + (privilegeCnt - 1) + ") VALUES (" + (i++ + 1) + ", 100)");
                    }
                    userStmt.executeBatch();
                    userStmt.clearBatch();
                }
                time = System.currentTimeMillis();
                i = 0;
                while (i < insertCnt) {
                    for (j = 0; j < batchSize; ++j) {
                        adminStmt.addBatch("INSERT INTO root.a(timestamp, b0) VALUES (" + (i++ + 1 + insertCnt) + ", 100)");
                    }
                    adminStmt.executeBatch();
                    adminStmt.clearBatch();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testListUser() throws ClassNotFoundException, SQLException {
        Class.forName("org.apache.iotdb.jdbc.IoTDBDriver");
        Connection adminCon = DriverManager.getConnection("jdbc:iotdb://127.0.0.1:6667/", "root", "root");
        Statement adminStmt = adminCon.createStatement();
        try {
            String ans = String.format("root,\n", new Object[0]);
            try (ResultSet resultSet = adminStmt.executeQuery("LIST USER");){
                int i;
                this.validateResultSet(resultSet, ans);
                for (i = 0; i < 10; ++i) {
                    adminStmt.execute("CREATE USER user" + i + " 'password " + i + "'");
                }
                resultSet = adminStmt.executeQuery("LIST USER");
                ans = "root,\nuser0,\nuser1,\nuser2,\nuser3,\nuser4,\nuser5,\nuser6,\nuser7,\nuser8,\nuser9,\n";
                this.validateResultSet(resultSet, ans);
                for (i = 0; i < 10; ++i) {
                    if (i % 2 != 0) continue;
                    adminStmt.execute("DROP USER user" + i);
                }
                resultSet = adminStmt.executeQuery("LIST USER");
                ans = "root,\nuser1,\nuser3,\nuser5,\nuser7,\nuser9,\n";
                this.validateResultSet(resultSet, ans);
            }
        }
        finally {
            adminCon.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testListRole() throws ClassNotFoundException, SQLException {
        Class.forName("org.apache.iotdb.jdbc.IoTDBDriver");
        Connection adminCon = DriverManager.getConnection("jdbc:iotdb://127.0.0.1:6667/", "root", "root");
        Statement adminStmt = adminCon.createStatement();
        try {
            String ans = "";
            try (ResultSet resultSet = adminStmt.executeQuery("LIST ROLE");){
                int i;
                this.validateResultSet(resultSet, ans);
                for (i = 0; i < 10; ++i) {
                    adminStmt.execute("CREATE ROLE role" + i);
                }
                resultSet = adminStmt.executeQuery("LIST ROLE");
                ans = "role0,\nrole1,\nrole2,\nrole3,\nrole4,\nrole5,\nrole6,\nrole7,\nrole8,\nrole9,\n";
                this.validateResultSet(resultSet, ans);
                for (i = 0; i < 10; ++i) {
                    if (i % 2 != 0) continue;
                    adminStmt.execute("DROP ROLE role" + i);
                }
                resultSet = adminStmt.executeQuery("LIST ROLE");
                ans = "role1,\nrole3,\nrole5,\nrole7,\nrole9,\n";
                this.validateResultSet(resultSet, ans);
            }
        }
        finally {
            adminStmt.close();
            adminCon.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testListUserPrivileges() throws SQLException, ClassNotFoundException {
        Class.forName("org.apache.iotdb.jdbc.IoTDBDriver");
        Connection adminCon = DriverManager.getConnection("jdbc:iotdb://127.0.0.1:6667/", "root", "root");
        Statement adminStmt = adminCon.createStatement();
        try {
            adminStmt.execute("CREATE USER user1 'password1'");
            adminStmt.execute("GRANT USER user1 PRIVILEGES 'READ_TIMESERIES' ON root.a.b");
            adminStmt.execute("CREATE ROLE role1");
            adminStmt.execute("GRANT ROLE role1 PRIVILEGES 'READ_TIMESERIES','INSERT_TIMESERIES','DELETE_TIMESERIES' ON root.a.b.c");
            adminStmt.execute("GRANT ROLE role1 PRIVILEGES 'READ_TIMESERIES','INSERT_TIMESERIES','DELETE_TIMESERIES' ON root.d.b.c");
            adminStmt.execute("GRANT role1 TO user1");
            String ans = ",root.a.b : READ_TIMESERIES,\nrole1,root.a.b.c : INSERT_TIMESERIES READ_TIMESERIES DELETE_TIMESERIES,\nrole1,root.d.b.c : INSERT_TIMESERIES READ_TIMESERIES DELETE_TIMESERIES,\n";
            try (ResultSet resultSet = adminStmt.executeQuery("LIST USER PRIVILEGES  user1");){
                this.validateResultSet(resultSet, ans);
                resultSet = adminStmt.executeQuery("LIST PRIVILEGES USER user1 ON root.a.b.c");
                ans = ",root.a.b : READ_TIMESERIES,\nrole1,root.a.b.c : INSERT_TIMESERIES READ_TIMESERIES DELETE_TIMESERIES,\n";
                this.validateResultSet(resultSet, ans);
                adminStmt.execute("REVOKE role1 from user1");
                resultSet = adminStmt.executeQuery("LIST USER PRIVILEGES  user1");
                ans = ",root.a.b : READ_TIMESERIES,\n";
                this.validateResultSet(resultSet, ans);
                resultSet = adminStmt.executeQuery("LIST PRIVILEGES USER user1 ON root.a.b.c");
                ans = ",root.a.b : READ_TIMESERIES,\n";
                this.validateResultSet(resultSet, ans);
            }
        }
        finally {
            adminStmt.close();
            adminCon.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testListRolePrivileges() throws ClassNotFoundException, SQLException {
        Class.forName("org.apache.iotdb.jdbc.IoTDBDriver");
        Connection adminCon = DriverManager.getConnection("jdbc:iotdb://127.0.0.1:6667/", "root", "root");
        Statement adminStmt = adminCon.createStatement();
        try {
            adminStmt.execute("CREATE ROLE role1");
            String ans = "";
            try (ResultSet resultSet = adminStmt.executeQuery("LIST ROLE PRIVILEGES role1");){
                this.validateResultSet(resultSet, ans);
                adminStmt.execute("GRANT ROLE role1 PRIVILEGES 'READ_TIMESERIES','INSERT_TIMESERIES','DELETE_TIMESERIES' ON root.a.b.c");
                adminStmt.execute("GRANT ROLE role1 PRIVILEGES 'READ_TIMESERIES','INSERT_TIMESERIES','DELETE_TIMESERIES' ON root.d.b.c");
                resultSet = adminStmt.executeQuery("LIST ROLE PRIVILEGES role1");
                ans = "root.a.b.c : INSERT_TIMESERIES READ_TIMESERIES DELETE_TIMESERIES,\nroot.d.b.c : INSERT_TIMESERIES READ_TIMESERIES DELETE_TIMESERIES,\n";
                this.validateResultSet(resultSet, ans);
                resultSet = adminStmt.executeQuery("LIST PRIVILEGES ROLE role1 ON root.a.b.c");
                ans = "root.a.b.c : INSERT_TIMESERIES READ_TIMESERIES DELETE_TIMESERIES,\n";
                this.validateResultSet(resultSet, ans);
                adminStmt.execute("REVOKE ROLE role1 PRIVILEGES 'INSERT_TIMESERIES','DELETE_TIMESERIES' ON root.a.b.c");
                resultSet = adminStmt.executeQuery("LIST ROLE PRIVILEGES role1");
                ans = "root.a.b.c : READ_TIMESERIES,\nroot.d.b.c : INSERT_TIMESERIES READ_TIMESERIES DELETE_TIMESERIES,\n";
                this.validateResultSet(resultSet, ans);
                resultSet = adminStmt.executeQuery("LIST PRIVILEGES ROLE role1 ON root.a.b.c");
                ans = "root.a.b.c : READ_TIMESERIES,\n";
                this.validateResultSet(resultSet, ans);
            }
        }
        finally {
            adminStmt.close();
            adminCon.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testListUserRoles() throws SQLException, ClassNotFoundException {
        Class.forName("org.apache.iotdb.jdbc.IoTDBDriver");
        Connection adminCon = DriverManager.getConnection("jdbc:iotdb://127.0.0.1:6667/", "root", "root");
        Statement adminStmt = adminCon.createStatement();
        try {
            adminStmt.execute("CREATE USER chenduxiu 'orange'");
            adminStmt.execute("CREATE ROLE xijing");
            adminStmt.execute("CREATE ROLE dalao");
            adminStmt.execute("CREATE ROLE shenshi");
            adminStmt.execute("CREATE ROLE zhazha");
            adminStmt.execute("CREATE ROLE hakase");
            adminStmt.execute("GRANT xijing TO chenduxiu");
            adminStmt.execute("GRANT dalao TO chenduxiu");
            adminStmt.execute("GRANT shenshi TO chenduxiu");
            adminStmt.execute("GRANT zhazha TO chenduxiu");
            adminStmt.execute("GRANT hakase TO chenduxiu");
            String ans = "xijing,\ndalao,\nshenshi,\nzhazha,\nhakase,\n";
            try (ResultSet resultSet = adminStmt.executeQuery("LIST ALL ROLE OF USER chenduxiu");){
                this.validateResultSet(resultSet, ans);
                adminStmt.execute("REVOKE dalao FROM chenduxiu");
                adminStmt.execute("REVOKE hakase FROM chenduxiu");
                resultSet = adminStmt.executeQuery("LIST ALL ROLE OF USER chenduxiu");
                ans = "xijing,\nshenshi,\nzhazha,\n";
                this.validateResultSet(resultSet, ans);
            }
        }
        finally {
            adminStmt.close();
            adminCon.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testListRoleUsers() throws SQLException, ClassNotFoundException {
        Class.forName("org.apache.iotdb.jdbc.IoTDBDriver");
        Connection adminCon = DriverManager.getConnection("jdbc:iotdb://127.0.0.1:6667/", "root", "root");
        Statement adminStmt = adminCon.createStatement();
        try {
            adminStmt.execute("CREATE ROLE dalao");
            adminStmt.execute("CREATE ROLE zhazha");
            String[] members = new String[]{"HighFly", "SunComparison", "Persistence", "GoodWoods", "HealthHonor", "GoldLuck", "DoubleLight", "Eastwards", "ScentEffusion", "Smart", "East", "DailySecurity", "Moon", "RayBud", "RiverSky"};
            for (int i = 0; i < members.length - 1; ++i) {
                adminStmt.execute("CREATE USER " + members[i] + " '666666'");
                adminStmt.execute("GRANT dalao TO  " + members[i]);
            }
            adminStmt.execute("CREATE USER RiverSky '2333333'");
            adminStmt.execute("GRANT zhazha TO RiverSky");
            String ans = "DailySecurity,\nDoubleLight,\nEast,\nEastwards,\nGoldLuck,\nGoodWoods,\nHealthHonor,\nHighFly,\nMoon,\nPersistence,\nRayBud,\nScentEffusion,\nSmart,\nSunComparison,\n";
            try (ResultSet resultSet = adminStmt.executeQuery("LIST ALL USER OF ROLE dalao");){
                this.validateResultSet(resultSet, ans);
                resultSet = adminStmt.executeQuery("LIST ALL USER OF ROLE zhazha");
                ans = "RiverSky,\n";
                this.validateResultSet(resultSet, ans);
                adminStmt.execute("REVOKE zhazha from RiverSky");
                resultSet = adminStmt.executeQuery("LIST ALL USER OF ROLE zhazha");
                ans = "";
                this.validateResultSet(resultSet, ans);
            }
        }
        finally {
            adminStmt.close();
            adminCon.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void validateResultSet(ResultSet set, String ans) throws SQLException {
        try {
            StringBuilder builder = new StringBuilder();
            ResultSetMetaData metaData = set.getMetaData();
            int colNum = metaData.getColumnCount();
            while (set.next()) {
                for (int i = 1; i <= colNum; ++i) {
                    builder.append(set.getString(i)).append(",");
                }
                builder.append("\n");
            }
            Assert.assertEquals((Object)ans, (Object)builder.toString());
        }
        finally {
            set.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testListUserPrivilege() throws ClassNotFoundException, SQLException {
        Class.forName("org.apache.iotdb.jdbc.IoTDBDriver");
        Connection adminCon = DriverManager.getConnection("jdbc:iotdb://127.0.0.1:6667/", "root", "root");
        Statement adminStmt = adminCon.createStatement();
        for (int i = 0; i < 10; ++i) {
            adminStmt.execute("CREATE USER user" + i + " 'password " + i + "'");
        }
        adminStmt.execute("CREATE USER tempuser 'temppw'");
        try (Connection userCon = DriverManager.getConnection("jdbc:iotdb://127.0.0.1:6667/", "tempuser", "temppw");
             Statement userStmt = userCon.createStatement();){
            try {
                ResultSet resultSet = userStmt.executeQuery("LIST USER");
                String ans = "";
                this.validateResultSet(resultSet, ans);
                adminStmt.execute("GRANT USER tempuser PRIVILEGES 'LIST_USER' ON root");
                resultSet = userStmt.executeQuery("LIST USER");
                ans = "root,\ntempuser,\nuser0,\nuser1,\nuser2,\nuser3,\nuser4,\nuser5,\nuser6,\nuser7,\nuser8,\nuser9,\n";
                this.validateResultSet(resultSet, ans);
            }
            finally {
                userStmt.close();
            }
        }
        finally {
            adminCon.close();
        }
    }

    @Test
    public void testExecuteBatchWithPrivilege() throws ClassNotFoundException, SQLException {
        Class.forName("org.apache.iotdb.jdbc.IoTDBDriver");
        try (Connection adminCon = DriverManager.getConnection("jdbc:iotdb://127.0.0.1:6667/", "root", "root");
             Statement adminStmt = adminCon.createStatement();){
            adminStmt.execute("CREATE USER tempuser 'temppw'");
            try (Connection userCon = DriverManager.getConnection("jdbc:iotdb://127.0.0.1:6667/", "tempuser", "temppw");
                 Statement userStatement = userCon.createStatement();){
                userStatement.addBatch("CREATE TIMESERIES root.sg1.d1.s1 WITH DATATYPE=INT64");
                userStatement.addBatch("CREATE TIMESERIES root.sg2.d1.s1 WITH DATATYPE=INT64");
                try {
                    userStatement.executeBatch();
                }
                catch (BatchUpdateException e) {
                    Assert.assertEquals((Object)"\nNo permissions for this operation CREATE_TIMESERIES for SQL: \"CREATE TIMESERIES root.sg1.d1.s1 WITH DATATYPE=INT64\"\nNo permissions for this operation CREATE_TIMESERIES for SQL: \"CREATE TIMESERIES root.sg2.d1.s1 WITH DATATYPE=INT64\"\n", (Object)e.getMessage());
                }
            }
        }
    }

    @Test
    public void testExecuteBatchWithPrivilege1() throws ClassNotFoundException, SQLException {
        Class.forName("org.apache.iotdb.jdbc.IoTDBDriver");
        try (Connection adminCon = DriverManager.getConnection("jdbc:iotdb://127.0.0.1:6667/", "root", "root");
             Statement adminStmt = adminCon.createStatement();){
            adminStmt.execute("CREATE USER tempuser 'temppw'");
            adminStmt.execute("GRANT USER tempuser PRIVILEGES 'INSERT_TIMESERIES' on root.sg1");
            try (Connection userCon = DriverManager.getConnection("jdbc:iotdb://127.0.0.1:6667/", "tempuser", "temppw");
                 Statement userStatement = userCon.createStatement();){
                userStatement.addBatch("insert into root.sg1.d1(timestamp,s1) values (1,1)");
                userStatement.addBatch("insert into root.sg2.d1(timestamp,s1) values (2,1)");
                userStatement.addBatch("insert into root.sg1.d1(timestamp,s2) values (3,1)");
                userStatement.addBatch("insert into root.sg2.d1(timestamp,s1) values (4,1)");
                try {
                    userStatement.executeBatch();
                }
                catch (BatchUpdateException e) {
                    System.out.println(e.getMessage());
                    Assert.assertEquals((Object)"\nNo permissions for this operation INSERT for SQL: \"insert into root.sg2.d1(timestamp,s1) values (2,1)\"\nNo permissions for this operation INSERT for SQL: \"insert into root.sg2.d1(timestamp,s1) values (4,1)\"\n", (Object)e.getMessage());
                }
            }
            ResultSet resultSet = adminStmt.executeQuery("select * from root");
            String[] expected = new String[]{"1, 1.0", "1, null", "3, null", "3, 1.0"};
            ArrayList expectedList = new ArrayList();
            Collections.addAll(expectedList, expected);
            ArrayList<String> result = new ArrayList<String>();
            while (resultSet.next()) {
                result.add(resultSet.getString("Time") + ", " + resultSet.getString("root.sg1.d1.s1"));
                result.add(resultSet.getString("Time") + ", " + resultSet.getString("root.sg1.d1.s2"));
            }
            Assert.assertEquals((long)expected.length, (long)result.size());
            Assert.assertTrue((boolean)expectedList.containsAll(result));
        }
    }
}

