/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.integration.aggregation;

import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.ResultSet;
import java.sql.Statement;
import org.apache.iotdb.db.conf.IoTDBDescriptor;
import org.apache.iotdb.db.constant.TestConstant;
import org.apache.iotdb.db.engine.compaction.CompactionStrategy;
import org.apache.iotdb.db.utils.EnvironmentUtils;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class IoTDBAggregationLargeDataIT {
    private static final String TIMESTAMP_STR = "Time";
    private final String d0s0 = "root.vehicle.d0.s0";
    private final String d0s1 = "root.vehicle.d0.s1";
    private final String d0s2 = "root.vehicle.d0.s2";
    private final String d0s3 = "root.vehicle.d0.s3";
    private final String d0s4 = "root.vehicle.d0.s4";
    private static String[] createSql = new String[]{"SET STORAGE GROUP TO root.vehicle", "CREATE TIMESERIES root.vehicle.d1.s0 WITH DATATYPE=INT32, ENCODING=RLE", "CREATE TIMESERIES root.vehicle.d0.s2 WITH DATATYPE=FLOAT, ENCODING=RLE", "CREATE TIMESERIES root.vehicle.d0.s3 WITH DATATYPE=TEXT, ENCODING=PLAIN", "CREATE TIMESERIES root.vehicle.d0.s0 WITH DATATYPE=INT32, ENCODING=RLE", "CREATE TIMESERIES root.vehicle.d0.s1 WITH DATATYPE=INT64, ENCODING=RLE", "CREATE TIMESERIES root.vehicle.d0.s4 WITH DATATYPE=BOOLEAN, ENCODING=PLAIN"};
    private static String[] insertSql = new String[]{"insert into root.vehicle.d0(timestamp,s0) values(1,101)", "insert into root.vehicle.d0(timestamp,s0) values(2,198)", "insert into root.vehicle.d0(timestamp,s0) values(100,99)", "insert into root.vehicle.d0(timestamp,s0) values(101,99)", "insert into root.vehicle.d0(timestamp,s0) values(102,80)", "insert into root.vehicle.d0(timestamp,s0) values(103,99)", "insert into root.vehicle.d0(timestamp,s0) values(104,90)", "insert into root.vehicle.d0(timestamp,s0) values(105,99)", "insert into root.vehicle.d0(timestamp,s0) values(106,99)", "insert into root.vehicle.d0(timestamp,s0) values(2,10000)", "insert into root.vehicle.d0(timestamp,s0) values(50,10000)", "insert into root.vehicle.d0(timestamp,s0) values(1000,22222)", "insert into root.vehicle.d0(timestamp,s0) values(106,199)", "DELETE FROM root.vehicle.d0.s0 WHERE time < 104", "insert into root.vehicle.d0(timestamp,s1) values(1,1101)", "insert into root.vehicle.d0(timestamp,s1) values(2,198)", "insert into root.vehicle.d0(timestamp,s1) values(100,199)", "insert into root.vehicle.d0(timestamp,s1) values(101,199)", "insert into root.vehicle.d0(timestamp,s1) values(102,180)", "insert into root.vehicle.d0(timestamp,s1) values(103,199)", "insert into root.vehicle.d0(timestamp,s1) values(104,190)", "insert into root.vehicle.d0(timestamp,s1) values(105,199)", "insert into root.vehicle.d0(timestamp,s1) values(2,40000)", "insert into root.vehicle.d0(timestamp,s1) values(50,50000)", "insert into root.vehicle.d0(timestamp,s1) values(1000,55555)", "insert into root.vehicle.d0(timestamp,s2) values(1000,55555)", "insert into root.vehicle.d0(timestamp,s2) values(2,2.22)", "insert into root.vehicle.d0(timestamp,s2) values(3,3.33)", "insert into root.vehicle.d0(timestamp,s2) values(4,4.44)", "insert into root.vehicle.d0(timestamp,s2) values(102,10.00)", "insert into root.vehicle.d0(timestamp,s2) values(105,11.11)", "insert into root.vehicle.d0(timestamp,s2) values(1000,1000.11)", "insert into root.vehicle.d0(timestamp,s3) values(60,'aaaaa')", "insert into root.vehicle.d0(timestamp,s3) values(70,'bbbbb')", "insert into root.vehicle.d0(timestamp,s3) values(80,'ccccc')", "insert into root.vehicle.d0(timestamp,s3) values(101,'ddddd')", "insert into root.vehicle.d0(timestamp,s3) values(102,'fffff')", "insert into root.vehicle.d1(timestamp,s0) values(1,999)", "insert into root.vehicle.d1(timestamp,s0) values(1000,888)", "insert into root.vehicle.d0(timestamp,s4) values(100, false)", "insert into root.vehicle.d0(timestamp,s4) values(100, true)"};
    private long prevPartitionInterval;
    private static String[] stringValue = new String[]{"A", "B", "C", "D", "E"};

    @Before
    public void setUp() {
        EnvironmentUtils.closeStatMonitor();
        this.prevPartitionInterval = IoTDBDescriptor.getInstance().getConfig().getPartitionInterval();
        IoTDBDescriptor.getInstance().getConfig().setCompactionStrategy(CompactionStrategy.NO_COMPACTION);
        EnvironmentUtils.envSetUp();
    }

    @After
    public void tearDown() throws Exception {
        EnvironmentUtils.cleanEnv();
        IoTDBDescriptor.getInstance().getConfig().setPartitionInterval(this.prevPartitionInterval);
        IoTDBDescriptor.getInstance().getConfig().setCompactionStrategy(CompactionStrategy.LEVEL_COMPACTION);
    }

    @Test
    public void test() throws ClassNotFoundException {
        IoTDBAggregationLargeDataIT.insertSQL();
        this.lastValueAggreWithSingleFilterTest();
        this.avgAggreWithSingleFilterTest();
        this.sumAggreWithSingleFilterTest();
        this.firstAggreWithSingleFilterTest();
        this.countAggreWithSingleFilterTest();
        this.minTimeAggreWithSingleFilterTest();
        this.minValueAggreWithSingleFilterTest();
        this.maxValueAggreWithSingleFilterTest();
        this.countAggreWithMultiFilterTest();
        this.maxTimeAggreWithMultiFilterTest();
        this.avgAggreWithMultiFilterTest();
        this.sumAggreWithMultiFilterTest();
        this.firstAggreWithMultiFilterTest();
    }

    private void lastValueAggreWithSingleFilterTest() {
        String[] retArray = new String[]{"0,9,39,63.0,E,true"};
        try (Connection connection = DriverManager.getConnection("jdbc:iotdb://127.0.0.1:6667/", "root", "root");
             Statement statement = connection.createStatement();){
            String ans;
            int cnt;
            boolean hasResultSet = statement.execute("select last_value(s0),last_value(s1),last_value(s2),last_value(s3),last_value(s4) from root.vehicle.d0 where s1 >= 0");
            Assert.assertTrue((boolean)hasResultSet);
            try (ResultSet resultSet = statement.getResultSet();){
                cnt = 0;
                while (resultSet.next()) {
                    ans = resultSet.getString(TIMESTAMP_STR) + "," + resultSet.getString(TestConstant.last_value("root.vehicle.d0.s0")) + "," + resultSet.getString(TestConstant.last_value("root.vehicle.d0.s1")) + "," + resultSet.getString(TestConstant.last_value("root.vehicle.d0.s2")) + "," + resultSet.getString(TestConstant.last_value("root.vehicle.d0.s3")) + "," + resultSet.getString(TestConstant.last_value("root.vehicle.d0.s4"));
                    Assert.assertEquals((Object)retArray[cnt], (Object)ans);
                    ++cnt;
                }
                Assert.assertEquals((long)1L, (long)cnt);
            }
            hasResultSet = statement.execute("select last_value(s0),last_value(s1),last_value(s2),last_value(s3),last_value(s4) from root.vehicle.d0 where s1 >= 0 order by time desc");
            Assert.assertTrue((boolean)hasResultSet);
            resultSet = statement.getResultSet();
            try {
                cnt = 0;
                while (resultSet.next()) {
                    ans = resultSet.getString(TIMESTAMP_STR) + "," + resultSet.getString(TestConstant.last_value("root.vehicle.d0.s0")) + "," + resultSet.getString(TestConstant.last_value("root.vehicle.d0.s1")) + "," + resultSet.getString(TestConstant.last_value("root.vehicle.d0.s2")) + "," + resultSet.getString(TestConstant.last_value("root.vehicle.d0.s3")) + "," + resultSet.getString(TestConstant.last_value("root.vehicle.d0.s4"));
                    Assert.assertEquals((Object)retArray[cnt], (Object)ans);
                    ++cnt;
                }
                Assert.assertEquals((long)1L, (long)cnt);
            }
            finally {
                if (resultSet != null) {
                    resultSet.close();
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            Assert.fail((String)e.getMessage());
        }
    }

    private void sumAggreWithSingleFilterTest() {
        String[] retArray = new String[]{"0,55061.0,156752.0,20254"};
        try (Connection connection = DriverManager.getConnection("jdbc:iotdb://127.0.0.1:6667/", "root", "root");
             Statement statement = connection.createStatement();){
            String ans;
            int cnt;
            boolean hasResultSet = statement.execute("select sum(s0),sum(s1),sum(s2) from root.vehicle.d0 where s1 >= 0");
            Assert.assertTrue((boolean)hasResultSet);
            try (ResultSet resultSet = statement.getResultSet();){
                cnt = 0;
                while (resultSet.next()) {
                    ans = resultSet.getString(TIMESTAMP_STR) + "," + resultSet.getString(TestConstant.sum("root.vehicle.d0.s0")) + "," + resultSet.getString(TestConstant.sum("root.vehicle.d0.s1")) + "," + Math.round(resultSet.getDouble(TestConstant.sum("root.vehicle.d0.s2")));
                    Assert.assertEquals((Object)ans, (Object)retArray[cnt]);
                    ++cnt;
                }
                Assert.assertEquals((long)1L, (long)cnt);
            }
            hasResultSet = statement.execute("select sum(s0),sum(s1),sum(s2) from root.vehicle.d0 where s1 >= 0 order by time desc");
            Assert.assertTrue((boolean)hasResultSet);
            resultSet = statement.getResultSet();
            try {
                cnt = 0;
                while (resultSet.next()) {
                    ans = resultSet.getString(TIMESTAMP_STR) + "," + resultSet.getString(TestConstant.sum("root.vehicle.d0.s0")) + "," + resultSet.getString(TestConstant.sum("root.vehicle.d0.s1")) + "," + Math.round(resultSet.getDouble(TestConstant.sum("root.vehicle.d0.s2")));
                    Assert.assertEquals((Object)ans, (Object)retArray[retArray.length - cnt - 1]);
                    ++cnt;
                }
                Assert.assertEquals((long)1L, (long)cnt);
            }
            finally {
                if (resultSet != null) {
                    resultSet.close();
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            Assert.fail((String)e.getMessage());
        }
    }

    private void firstAggreWithSingleFilterTest() {
        String[] retArray = new String[]{"0,90,1101,2.22,ddddd,true"};
        try (Connection connection = DriverManager.getConnection("jdbc:iotdb://127.0.0.1:6667/", "root", "root");
             Statement statement = connection.createStatement();){
            String ans;
            int cnt;
            boolean hasResultSet = statement.execute("select first_value(s0),first_value(s1),first_value(s2),first_value(s3),first_value(s4) from root.vehicle.d0 where s1 >= 0");
            Assert.assertTrue((boolean)hasResultSet);
            try (ResultSet resultSet = statement.getResultSet();){
                cnt = 0;
                while (resultSet.next()) {
                    ans = resultSet.getString(TIMESTAMP_STR) + "," + resultSet.getString(TestConstant.first_value("root.vehicle.d0.s0")) + "," + resultSet.getString(TestConstant.first_value("root.vehicle.d0.s1")) + "," + resultSet.getString(TestConstant.first_value("root.vehicle.d0.s2")) + "," + resultSet.getString(TestConstant.first_value("root.vehicle.d0.s3")) + "," + resultSet.getString(TestConstant.first_value("root.vehicle.d0.s4"));
                    Assert.assertEquals((Object)ans, (Object)retArray[cnt]);
                    ++cnt;
                }
                Assert.assertEquals((long)1L, (long)cnt);
            }
            hasResultSet = statement.execute("select first_value(s0),first_value(s1),first_value(s2),first_value(s3),first_value(s4) from root.vehicle.d0 where s1 >= 0 order by time desc");
            Assert.assertTrue((boolean)hasResultSet);
            resultSet = statement.getResultSet();
            try {
                cnt = 0;
                while (resultSet.next()) {
                    ans = resultSet.getString(TIMESTAMP_STR) + "," + resultSet.getString(TestConstant.first_value("root.vehicle.d0.s0")) + "," + resultSet.getString(TestConstant.first_value("root.vehicle.d0.s1")) + "," + resultSet.getString(TestConstant.first_value("root.vehicle.d0.s2")) + "," + resultSet.getString(TestConstant.first_value("root.vehicle.d0.s3")) + "," + resultSet.getString(TestConstant.first_value("root.vehicle.d0.s4"));
                    Assert.assertEquals((Object)ans, (Object)retArray[cnt]);
                    ++cnt;
                }
                Assert.assertEquals((long)1L, (long)cnt);
            }
            finally {
                if (resultSet != null) {
                    resultSet.close();
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            Assert.fail((String)e.getMessage());
        }
    }

    private void avgAggreWithSingleFilterTest() {
        String[] retArray = new String[]{"0,75,212,28"};
        try (Connection connection = DriverManager.getConnection("jdbc:iotdb://127.0.0.1:6667/", "root", "root");
             Statement statement = connection.createStatement();){
            String ans;
            int cnt;
            boolean hasResultSet = statement.execute("select avg(s0),avg(s1),avg(s2) from root.vehicle.d0 where s1 >= 0");
            Assert.assertTrue((boolean)hasResultSet);
            try (ResultSet resultSet = statement.getResultSet();){
                cnt = 0;
                while (resultSet.next()) {
                    ans = resultSet.getString(TIMESTAMP_STR) + "," + Math.round(resultSet.getDouble(TestConstant.avg("root.vehicle.d0.s0"))) + "," + Math.round(resultSet.getDouble(TestConstant.avg("root.vehicle.d0.s1"))) + "," + Math.round(resultSet.getDouble(TestConstant.avg("root.vehicle.d0.s2")));
                    Assert.assertEquals((Object)retArray[cnt], (Object)ans);
                    ++cnt;
                }
                Assert.assertEquals((long)1L, (long)cnt);
            }
            hasResultSet = statement.execute("select avg(s0),avg(s1),avg(s2) from root.vehicle.d0 where s1 >= 0 order by time desc");
            Assert.assertTrue((boolean)hasResultSet);
            resultSet = statement.getResultSet();
            try {
                cnt = 0;
                while (resultSet.next()) {
                    ans = resultSet.getString(TIMESTAMP_STR) + "," + Math.round(resultSet.getDouble(TestConstant.avg("root.vehicle.d0.s0"))) + "," + Math.round(resultSet.getDouble(TestConstant.avg("root.vehicle.d0.s1"))) + "," + Math.round(resultSet.getDouble(TestConstant.avg("root.vehicle.d0.s2")));
                    Assert.assertEquals((Object)retArray[cnt], (Object)ans);
                    ++cnt;
                }
                Assert.assertEquals((long)1L, (long)cnt);
            }
            finally {
                if (resultSet != null) {
                    resultSet.close();
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            Assert.fail((String)e.getMessage());
        }
    }

    private void countAggreWithSingleFilterTest() {
        String[] retArray = new String[]{"0,733,740,734"};
        try (Connection connection = DriverManager.getConnection("jdbc:iotdb://127.0.0.1:6667/", "root", "root");
             Statement statement = connection.createStatement();){
            String ans;
            int cnt;
            boolean hasResultSet = statement.execute("select count(s0),count(s1),count(s2) from root.vehicle.d0 where s1 >= 0");
            Assert.assertTrue((boolean)hasResultSet);
            try (ResultSet resultSet = statement.getResultSet();){
                cnt = 0;
                while (resultSet.next()) {
                    ans = resultSet.getString(TIMESTAMP_STR) + "," + resultSet.getString(TestConstant.count("root.vehicle.d0.s0")) + "," + resultSet.getString(TestConstant.count("root.vehicle.d0.s1")) + "," + resultSet.getString(TestConstant.count("root.vehicle.d0.s2"));
                    Assert.assertEquals((Object)retArray[cnt], (Object)ans);
                    ++cnt;
                }
                Assert.assertEquals((long)1L, (long)cnt);
            }
            hasResultSet = statement.execute("select count(s0),count(s1),count(s2) from root.vehicle.d0 where s1 >= 0 order by time desc");
            Assert.assertTrue((boolean)hasResultSet);
            resultSet = statement.getResultSet();
            try {
                cnt = 0;
                while (resultSet.next()) {
                    ans = resultSet.getString(TIMESTAMP_STR) + "," + resultSet.getString(TestConstant.count("root.vehicle.d0.s0")) + "," + resultSet.getString(TestConstant.count("root.vehicle.d0.s1")) + "," + resultSet.getString(TestConstant.count("root.vehicle.d0.s2"));
                    Assert.assertEquals((Object)retArray[cnt], (Object)ans);
                    ++cnt;
                }
                Assert.assertEquals((long)1L, (long)cnt);
            }
            finally {
                if (resultSet != null) {
                    resultSet.close();
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            Assert.fail((String)e.getMessage());
        }
    }

    private void minTimeAggreWithSingleFilterTest() {
        String[] retArray = new String[]{"0,104,1,2,101,100"};
        try (Connection connection = DriverManager.getConnection("jdbc:iotdb://127.0.0.1:6667/", "root", "root");
             Statement statement = connection.createStatement();){
            String ans;
            boolean hasResultSet = statement.execute("select min_time(s0),min_time(s1),min_time(s2),min_time(s3),min_time(s4) from root.vehicle.d0 where s1 >= 0");
            Assert.assertTrue((boolean)hasResultSet);
            int cnt = 0;
            try (ResultSet resultSet = statement.getResultSet();){
                while (resultSet.next()) {
                    ans = resultSet.getString(TIMESTAMP_STR) + "," + resultSet.getString(TestConstant.min_time("root.vehicle.d0.s0")) + "," + resultSet.getString(TestConstant.min_time("root.vehicle.d0.s1")) + "," + resultSet.getString(TestConstant.min_time("root.vehicle.d0.s2")) + "," + resultSet.getString(TestConstant.min_time("root.vehicle.d0.s3")) + "," + resultSet.getString(TestConstant.min_time("root.vehicle.d0.s4"));
                    Assert.assertEquals((Object)ans, (Object)retArray[cnt]);
                    ++cnt;
                }
                Assert.assertEquals((long)1L, (long)cnt);
            }
            hasResultSet = statement.execute("select min_time(s0),min_time(s1),min_time(s2),min_time(s3),min_time(s4) from root.vehicle.d0 where s1 >= 0 order by time desc");
            Assert.assertTrue((boolean)hasResultSet);
            cnt = 0;
            resultSet = statement.getResultSet();
            try {
                while (resultSet.next()) {
                    ans = resultSet.getString(TIMESTAMP_STR) + "," + resultSet.getString(TestConstant.min_time("root.vehicle.d0.s0")) + "," + resultSet.getString(TestConstant.min_time("root.vehicle.d0.s1")) + "," + resultSet.getString(TestConstant.min_time("root.vehicle.d0.s2")) + "," + resultSet.getString(TestConstant.min_time("root.vehicle.d0.s3")) + "," + resultSet.getString(TestConstant.min_time("root.vehicle.d0.s4"));
                    Assert.assertEquals((Object)ans, (Object)retArray[cnt]);
                    ++cnt;
                }
                Assert.assertEquals((long)1L, (long)cnt);
            }
            finally {
                if (resultSet != null) {
                    resultSet.close();
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            Assert.fail((String)e.getMessage());
        }
    }

    private void minValueAggreWithSingleFilterTest() {
        block30: {
            String[] retArray = new String[]{"0,0,0,0.0,B,true"};
            try (Connection connection = DriverManager.getConnection("jdbc:iotdb://127.0.0.1:6667/", "root", "root");
                 Statement statement = connection.createStatement();){
                String ans;
                ResultSet resultSet;
                int cnt;
                boolean hasResultSet = statement.execute("select min_value(s0),min_value(s1),min_value(s2),min_value(s3),min_value(s4) from root.vehicle.d0 where s1 < 50000 and s1 != 100");
                if (hasResultSet) {
                    cnt = 0;
                    resultSet = statement.getResultSet();
                    try {
                        while (resultSet.next()) {
                            ans = resultSet.getString(TIMESTAMP_STR) + "," + resultSet.getString(TestConstant.min_value("root.vehicle.d0.s0")) + "," + resultSet.getString(TestConstant.min_value("root.vehicle.d0.s1")) + "," + resultSet.getString(TestConstant.min_value("root.vehicle.d0.s2")) + "," + resultSet.getString(TestConstant.min_value("root.vehicle.d0.s3")) + "," + resultSet.getString(TestConstant.min_value("root.vehicle.d0.s4"));
                            Assert.assertEquals((Object)ans, (Object)retArray[cnt]);
                            ++cnt;
                        }
                        Assert.assertEquals((long)1L, (long)cnt);
                    }
                    finally {
                        if (resultSet != null) {
                            resultSet.close();
                        }
                    }
                }
                if (!(hasResultSet = statement.execute("select min_value(s0),min_value(s1),min_value(s2),min_value(s3),min_value(s4) from root.vehicle.d0 where s1 < 50000 and s1 != 100 order by time desc"))) break block30;
                cnt = 0;
                resultSet = statement.getResultSet();
                try {
                    while (resultSet.next()) {
                        ans = resultSet.getString(TIMESTAMP_STR) + "," + resultSet.getString(TestConstant.min_value("root.vehicle.d0.s0")) + "," + resultSet.getString(TestConstant.min_value("root.vehicle.d0.s1")) + "," + resultSet.getString(TestConstant.min_value("root.vehicle.d0.s2")) + "," + resultSet.getString(TestConstant.min_value("root.vehicle.d0.s3")) + "," + resultSet.getString(TestConstant.min_value("root.vehicle.d0.s4"));
                        Assert.assertEquals((Object)ans, (Object)retArray[cnt]);
                        ++cnt;
                    }
                    Assert.assertEquals((long)1L, (long)cnt);
                }
                finally {
                    if (resultSet != null) {
                        resultSet.close();
                    }
                }
            }
            catch (Exception e) {
                e.printStackTrace();
                Assert.fail((String)e.getMessage());
            }
        }
    }

    private void maxValueAggreWithSingleFilterTest() {
        block30: {
            String[] retArray = new String[]{"0,99,40000,122.0,fffff,true"};
            try (Connection connection = DriverManager.getConnection("jdbc:iotdb://127.0.0.1:6667/", "root", "root");
                 Statement statement = connection.createStatement();){
                String ans;
                ResultSet resultSet;
                int cnt;
                boolean hasResultSet = statement.execute("select max_value(s0),max_value(s1),max_value(s2),max_value(s3),max_value(s4) from root.vehicle.d0 where s1 < 50000 and s1 != 100");
                if (hasResultSet) {
                    cnt = 0;
                    resultSet = statement.getResultSet();
                    try {
                        while (resultSet.next()) {
                            ans = resultSet.getString(TIMESTAMP_STR) + "," + resultSet.getString(TestConstant.max_value("root.vehicle.d0.s0")) + "," + resultSet.getString(TestConstant.max_value("root.vehicle.d0.s1")) + "," + resultSet.getString(TestConstant.max_value("root.vehicle.d0.s2")) + "," + resultSet.getString(TestConstant.max_value("root.vehicle.d0.s3")) + "," + resultSet.getString(TestConstant.max_value("root.vehicle.d0.s4"));
                            Assert.assertEquals((Object)ans, (Object)retArray[cnt]);
                            ++cnt;
                        }
                        Assert.assertEquals((long)1L, (long)cnt);
                    }
                    finally {
                        if (resultSet != null) {
                            resultSet.close();
                        }
                    }
                }
                if (!(hasResultSet = statement.execute("select max_value(s0),max_value(s1),max_value(s2),max_value(s3),max_value(s4) from root.vehicle.d0 where s1 < 50000 and s1 != 100 order by time desc"))) break block30;
                cnt = 0;
                resultSet = statement.getResultSet();
                try {
                    while (resultSet.next()) {
                        ans = resultSet.getString(TIMESTAMP_STR) + "," + resultSet.getString(TestConstant.max_value("root.vehicle.d0.s0")) + "," + resultSet.getString(TestConstant.max_value("root.vehicle.d0.s1")) + "," + resultSet.getString(TestConstant.max_value("root.vehicle.d0.s2")) + "," + resultSet.getString(TestConstant.max_value("root.vehicle.d0.s3")) + "," + resultSet.getString(TestConstant.max_value("root.vehicle.d0.s4"));
                        Assert.assertEquals((Object)ans, (Object)retArray[cnt]);
                        ++cnt;
                    }
                    Assert.assertEquals((long)1L, (long)cnt);
                }
                finally {
                    if (resultSet != null) {
                        resultSet.close();
                    }
                }
            }
            catch (Exception e) {
                e.printStackTrace();
                Assert.fail((String)e.getMessage());
            }
        }
    }

    private void avgAggreWithMultiFilterTest() {
        String[] retArray = new String[]{"0,55061.0,733,75,212,28"};
        try (Connection connection = DriverManager.getConnection("jdbc:iotdb://127.0.0.1:6667/", "root", "root");
             Statement statement = connection.createStatement();){
            boolean hasResultSet = statement.execute("select sum(s0),count(s0),avg(s0),avg(s1),avg(s2) from root.vehicle.d0 where s1 >= 0 or s2 < 10");
            Assert.assertTrue((boolean)hasResultSet);
            int cnt = 0;
            try (ResultSet resultSet = statement.getResultSet();){
                while (resultSet.next()) {
                    String ans = resultSet.getString(TIMESTAMP_STR) + "," + resultSet.getString(TestConstant.sum("root.vehicle.d0.s0")) + "," + resultSet.getString(TestConstant.count("root.vehicle.d0.s0")) + "," + Math.round(resultSet.getDouble(TestConstant.avg("root.vehicle.d0.s0"))) + "," + Math.round(resultSet.getDouble(TestConstant.avg("root.vehicle.d0.s1"))) + "," + Math.round(resultSet.getDouble(TestConstant.avg("root.vehicle.d0.s2")));
                    Assert.assertEquals((Object)retArray[cnt], (Object)ans);
                    ++cnt;
                }
                Assert.assertEquals((long)1L, (long)cnt);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            Assert.fail((String)e.getMessage());
        }
    }

    private void sumAggreWithMultiFilterTest() {
        String[] retArray = new String[]{"0,55061.0,156752.0,20262"};
        try (Connection connection = DriverManager.getConnection("jdbc:iotdb://127.0.0.1:6667/", "root", "root");
             Statement statement = connection.createStatement();){
            String ans;
            boolean hasResultSet = statement.execute("select sum(s0),sum(s1),sum(s2) from root.vehicle.d0 where s1 >= 0 or s2 < 10");
            Assert.assertTrue((boolean)hasResultSet);
            int cnt = 0;
            try (ResultSet resultSet = statement.getResultSet();){
                while (resultSet.next()) {
                    ans = resultSet.getString(TIMESTAMP_STR) + "," + resultSet.getString(TestConstant.sum("root.vehicle.d0.s0")) + "," + resultSet.getString(TestConstant.sum("root.vehicle.d0.s1")) + "," + Math.round(resultSet.getDouble(TestConstant.sum("root.vehicle.d0.s2")));
                    Assert.assertEquals((Object)retArray[cnt], (Object)ans);
                    ++cnt;
                }
                Assert.assertEquals((long)1L, (long)cnt);
            }
            hasResultSet = statement.execute("select sum(s0),sum(s1),sum(s2) from root.vehicle.d0 where s1 >= 0 or s2 < 10 order by time desc ");
            Assert.assertTrue((boolean)hasResultSet);
            cnt = 0;
            resultSet = statement.getResultSet();
            try {
                while (resultSet.next()) {
                    ans = resultSet.getString(TIMESTAMP_STR) + "," + resultSet.getString(TestConstant.sum("root.vehicle.d0.s0")) + "," + resultSet.getString(TestConstant.sum("root.vehicle.d0.s1")) + "," + Math.round(resultSet.getDouble(TestConstant.sum("root.vehicle.d0.s2")));
                    Assert.assertEquals((Object)retArray[cnt], (Object)ans);
                    ++cnt;
                }
                Assert.assertEquals((long)1L, (long)cnt);
            }
            finally {
                if (resultSet != null) {
                    resultSet.close();
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            Assert.fail((String)e.getMessage());
        }
    }

    private void firstAggreWithMultiFilterTest() {
        String[] retArray = new String[]{"0,90,1101,2.22,ddddd,true"};
        try (Connection connection = DriverManager.getConnection("jdbc:iotdb://127.0.0.1:6667/", "root", "root");
             Statement statement = connection.createStatement();){
            String ans;
            boolean hasResultSet = statement.execute("select first_value(s0),first_value(s1),first_value(s2),first_value(s3),first_value(s4) from root.vehicle.d0 where s1 >= 0 or s2 < 10");
            Assert.assertTrue((boolean)hasResultSet);
            int cnt = 0;
            try (ResultSet resultSet = statement.getResultSet();){
                while (resultSet.next()) {
                    ans = resultSet.getString(TIMESTAMP_STR) + "," + resultSet.getString(TestConstant.first_value("root.vehicle.d0.s0")) + "," + resultSet.getString(TestConstant.first_value("root.vehicle.d0.s1")) + "," + resultSet.getString(TestConstant.first_value("root.vehicle.d0.s2")) + "," + resultSet.getString(TestConstant.first_value("root.vehicle.d0.s3")) + "," + resultSet.getString(TestConstant.first_value("root.vehicle.d0.s4"));
                    Assert.assertEquals((Object)retArray[cnt], (Object)ans);
                    ++cnt;
                }
                Assert.assertEquals((long)1L, (long)cnt);
            }
            hasResultSet = statement.execute("select first_value(s0),first_value(s1),first_value(s2),first_value(s3),first_value(s4) from root.vehicle.d0 where s1 >= 0 or s2 < 10 order by time desc");
            Assert.assertTrue((boolean)hasResultSet);
            cnt = 0;
            resultSet = statement.getResultSet();
            try {
                while (resultSet.next()) {
                    ans = resultSet.getString(TIMESTAMP_STR) + "," + resultSet.getString(TestConstant.first_value("root.vehicle.d0.s0")) + "," + resultSet.getString(TestConstant.first_value("root.vehicle.d0.s1")) + "," + resultSet.getString(TestConstant.first_value("root.vehicle.d0.s2")) + "," + resultSet.getString(TestConstant.first_value("root.vehicle.d0.s3")) + "," + resultSet.getString(TestConstant.first_value("root.vehicle.d0.s4"));
                    Assert.assertEquals((Object)retArray[cnt], (Object)ans);
                    ++cnt;
                }
                Assert.assertEquals((long)1L, (long)cnt);
            }
            finally {
                if (resultSet != null) {
                    resultSet.close();
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            Assert.fail((String)e.getMessage());
        }
    }

    private void countAggreWithMultiFilterTest() {
        String[] retArray = new String[]{"0,733,740,736,482,1"};
        try (Connection connection = DriverManager.getConnection("jdbc:iotdb://127.0.0.1:6667/", "root", "root");
             Statement statement = connection.createStatement();){
            boolean hasResultSet = statement.execute("select count(s0),count(s1),count(s2),count(s3),count(s4) from root.vehicle.d0 where s1 >= 0 or s2 < 10");
            Assert.assertTrue((boolean)hasResultSet);
            int cnt = 0;
            try (ResultSet resultSet = statement.getResultSet();){
                while (resultSet.next()) {
                    String ans = resultSet.getString(TIMESTAMP_STR) + "," + resultSet.getString(TestConstant.count("root.vehicle.d0.s0")) + "," + resultSet.getString(TestConstant.count("root.vehicle.d0.s1")) + "," + resultSet.getString(TestConstant.count("root.vehicle.d0.s2")) + "," + resultSet.getString(TestConstant.count("root.vehicle.d0.s3")) + "," + resultSet.getString(TestConstant.count("root.vehicle.d0.s4"));
                    Assert.assertEquals((Object)retArray[cnt], (Object)ans);
                    ++cnt;
                }
                Assert.assertEquals((long)1L, (long)cnt);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            Assert.fail((String)e.getMessage());
        }
    }

    private void maxTimeAggreWithMultiFilterTest() throws ClassNotFoundException {
        String[] retArray = new String[]{"0,3999,3999,3999,3599,100"};
        Class.forName("org.apache.iotdb.jdbc.IoTDBDriver");
        try (Connection connection = DriverManager.getConnection("jdbc:iotdb://127.0.0.1:6667/", "root", "root");
             Statement statement = connection.createStatement();){
            String ans;
            boolean hasResultSet = statement.execute("select max_time(s0),max_time(s1),max_time(s2),max_time(s3),max_time(s4) from root.vehicle.d0 where s1 < 50000 and s1 != 100");
            Assert.assertTrue((boolean)hasResultSet);
            int cnt = 0;
            try (ResultSet resultSet = statement.getResultSet();){
                while (resultSet.next()) {
                    ans = resultSet.getString(TIMESTAMP_STR) + "," + resultSet.getString(TestConstant.max_time("root.vehicle.d0.s0")) + "," + resultSet.getString(TestConstant.max_time("root.vehicle.d0.s1")) + "," + resultSet.getString(TestConstant.max_time("root.vehicle.d0.s2")) + "," + resultSet.getString(TestConstant.max_time("root.vehicle.d0.s3")) + "," + resultSet.getString(TestConstant.max_time("root.vehicle.d0.s4"));
                    Assert.assertEquals((Object)ans, (Object)retArray[cnt]);
                    ++cnt;
                }
                Assert.assertEquals((long)1L, (long)cnt);
            }
            hasResultSet = statement.execute("select max_time(s0),max_time(s1),max_time(s2),max_time(s3),max_time(s4) from root.vehicle.d0 where s1 < 50000 and s1 != 100 order by time desc");
            Assert.assertTrue((boolean)hasResultSet);
            cnt = 0;
            resultSet = statement.getResultSet();
            try {
                while (resultSet.next()) {
                    ans = resultSet.getString(TIMESTAMP_STR) + "," + resultSet.getString(TestConstant.max_time("root.vehicle.d0.s0")) + "," + resultSet.getString(TestConstant.max_time("root.vehicle.d0.s1")) + "," + resultSet.getString(TestConstant.max_time("root.vehicle.d0.s2")) + "," + resultSet.getString(TestConstant.max_time("root.vehicle.d0.s3")) + "," + resultSet.getString(TestConstant.max_time("root.vehicle.d0.s4"));
                    Assert.assertEquals((Object)ans, (Object)retArray[cnt]);
                    ++cnt;
                }
                Assert.assertEquals((long)1L, (long)cnt);
            }
            finally {
                if (resultSet != null) {
                    resultSet.close();
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            Assert.fail((String)e.getMessage());
        }
    }

    public static void insertSQL() throws ClassNotFoundException {
        Class.forName("org.apache.iotdb.jdbc.IoTDBDriver");
        double d0s0sum = 0.0;
        double d0s1sum = 0.0;
        double d0s2sum = 0.0;
        int cnt = 0;
        try (Connection connection = DriverManager.getConnection("jdbc:iotdb://127.0.0.1:6667/", "root", "root");
             Statement statement = connection.createStatement();){
            int time;
            for (String sql : createSql) {
                statement.execute(sql);
            }
            for (time = 3000; time < 3600; ++time) {
                if (time % 5 == 0) continue;
                String sql = String.format("insert into root.vehicle.d0(timestamp,s0) values(%s,%s)", time, time % 100);
                statement.execute(sql);
                sql = String.format("insert into root.vehicle.d0(timestamp,s1) values(%s,%s)", time, time % 17);
                statement.execute(sql);
                sql = String.format("insert into root.vehicle.d0(timestamp,s2) values(%s,%s)", time, time % 22);
                statement.execute(sql);
                sql = String.format("insert into root.vehicle.d0(timestamp,s3) values(%s,'%s')", time, stringValue[time % 5]);
                statement.execute(sql);
                ++cnt;
                d0s0sum += (double)(time % 100);
                d0s1sum += (double)(time % 17);
                d0s2sum += (double)(time % 22);
            }
            statement.execute("flush");
            for (time = 3700; time < 4000; ++time) {
                if (time % 6 == 0) continue;
                String sql = String.format("insert into root.vehicle.d0(timestamp,s0) values(%s,%s)", time, time % 70);
                statement.execute(sql);
                sql = String.format("insert into root.vehicle.d0(timestamp,s1) values(%s,%s)", time, time % 40);
                statement.execute(sql);
                sql = String.format("insert into root.vehicle.d0(timestamp,s2) values(%s,%s)", time, time % 123);
                statement.execute(sql);
                ++cnt;
                d0s0sum += (double)(time % 70);
                d0s1sum += (double)(time % 40);
                d0s2sum += (double)(time % 123);
            }
            statement.execute("merge");
            for (String sql : insertSql) {
                statement.execute(sql);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            Assert.fail((String)e.getMessage());
        }
    }
}

