/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.integration.aggregation;

import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Locale;
import org.apache.iotdb.db.conf.IoTDBDescriptor;
import org.apache.iotdb.db.constant.TestConstant;
import org.apache.iotdb.db.engine.compaction.CompactionStrategy;
import org.apache.iotdb.db.utils.EnvironmentUtils;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class IoTDBAggregationIT {
    private static final double DETLA = 1.0E-6;
    private static final String TIMESTAMP_STR = "Time";
    private static final String TEMPERATURE_STR = "root.ln.wf01.wt01.temperature";
    private static String[] creationSqls = new String[]{"SET STORAGE GROUP TO root.vehicle.d0", "SET STORAGE GROUP TO root.vehicle.d1", "CREATE TIMESERIES root.vehicle.d0.s0 WITH DATATYPE=INT32, ENCODING=RLE", "CREATE TIMESERIES root.vehicle.d0.s1 WITH DATATYPE=INT64, ENCODING=RLE", "CREATE TIMESERIES root.vehicle.d0.s2 WITH DATATYPE=FLOAT, ENCODING=RLE", "CREATE TIMESERIES root.vehicle.d0.s3 WITH DATATYPE=TEXT, ENCODING=PLAIN", "CREATE TIMESERIES root.vehicle.d0.s4 WITH DATATYPE=BOOLEAN, ENCODING=PLAIN"};
    private static String[] dataSet2 = new String[]{"SET STORAGE GROUP TO root.ln.wf01.wt01", "CREATE TIMESERIES root.ln.wf01.wt01.status WITH DATATYPE=BOOLEAN, ENCODING=PLAIN", "CREATE TIMESERIES root.ln.wf01.wt01.temperature WITH DATATYPE=FLOAT, ENCODING=PLAIN", "CREATE TIMESERIES root.ln.wf01.wt01.hardware WITH DATATYPE=INT32, ENCODING=PLAIN", "INSERT INTO root.ln.wf01.wt01(timestamp,temperature,status, hardware) values(1, 1.1, false, 11)", "INSERT INTO root.ln.wf01.wt01(timestamp,temperature,status, hardware) values(2, 2.2, true, 22)", "INSERT INTO root.ln.wf01.wt01(timestamp,temperature,status, hardware) values(3, 3.3, false, 33 )", "INSERT INTO root.ln.wf01.wt01(timestamp,temperature,status, hardware) values(4, 4.4, false, 44)", "INSERT INTO root.ln.wf01.wt01(timestamp,temperature,status, hardware) values(5, 5.5, false, 55)"};
    private static String[] dataSet3 = new String[]{"SET STORAGE GROUP TO root.sg", "CREATE TIMESERIES root.sg.d1.s1 WITH DATATYPE=INT32, ENCODING=RLE", "insert into root.sg.d1(timestamp,s1) values(5,5)", "insert into root.sg.d1(timestamp,s1) values(12,12)", "flush", "insert into root.sg.d1(timestamp,s1) values(15,15)", "insert into root.sg.d1(timestamp,s1) values(25,25)", "flush", "insert into root.sg.d1(timestamp,s1) values(1,111)", "insert into root.sg.d1(timestamp,s1) values(20,200)", "flush"};
    private final String d0s0 = "root.vehicle.d0.s0";
    private final String d0s1 = "root.vehicle.d0.s1";
    private final String d0s2 = "root.vehicle.d0.s2";
    private final String d0s3 = "root.vehicle.d0.s3";
    private String insertTemplate = "INSERT INTO root.vehicle.d0(timestamp,s0,s1,s2,s3,s4) VALUES(%d,%d,%d,%f,%s,%s)";
    private long prevPartitionInterval;

    @Before
    public void setUp() throws Exception {
        EnvironmentUtils.closeStatMonitor();
        this.prevPartitionInterval = IoTDBDescriptor.getInstance().getConfig().getPartitionInterval();
        IoTDBDescriptor.getInstance().getConfig().setPartitionInterval(1000L);
        IoTDBDescriptor.getInstance().getConfig().setCompactionStrategy(CompactionStrategy.NO_COMPACTION);
        EnvironmentUtils.envSetUp();
        Class.forName("org.apache.iotdb.jdbc.IoTDBDriver");
        this.prepareData();
    }

    @After
    public void tearDown() throws Exception {
        EnvironmentUtils.cleanEnv();
        IoTDBDescriptor.getInstance().getConfig().setPartitionInterval(this.prevPartitionInterval);
        IoTDBDescriptor.getInstance().getConfig().setCompactionStrategy(CompactionStrategy.LEVEL_COMPACTION);
    }

    @Test
    public void test() {
        String[] retArray = new String[]{"0,2", "0,4", "0,3"};
        try (Connection connection = DriverManager.getConnection("jdbc:iotdb://127.0.0.1:6667/", "root", "root");
             Statement statement = connection.createStatement();){
            String ans;
            int cnt;
            boolean hasResultSet = statement.execute("SELECT count(temperature) FROM root.ln.wf01.wt01 WHERE time > 3");
            Assert.assertTrue((boolean)hasResultSet);
            try (ResultSet resultSet = statement.getResultSet();){
                cnt = 0;
                while (resultSet.next()) {
                    ans = resultSet.getString(TIMESTAMP_STR) + "," + resultSet.getString(TestConstant.count(TEMPERATURE_STR));
                    Assert.assertEquals((Object)retArray[cnt], (Object)ans);
                    ++cnt;
                }
                Assert.assertEquals((long)1L, (long)cnt);
            }
            hasResultSet = statement.execute("SELECT count(temperature) FROM root.ln.wf01.wt01 WHERE time > 3 order by time desc");
            Assert.assertTrue((boolean)hasResultSet);
            resultSet = statement.getResultSet();
            try {
                cnt = 0;
                while (resultSet.next()) {
                    ans = resultSet.getString(TIMESTAMP_STR) + "," + resultSet.getString(TestConstant.count(TEMPERATURE_STR));
                    Assert.assertEquals((Object)retArray[cnt], (Object)ans);
                    ++cnt;
                }
                Assert.assertEquals((long)1L, (long)cnt);
            }
            finally {
                if (resultSet != null) {
                    resultSet.close();
                }
            }
            hasResultSet = statement.execute("SELECT min_time(temperature) FROM root.ln.wf01.wt01 WHERE time > 3");
            Assert.assertTrue((boolean)hasResultSet);
            resultSet = statement.getResultSet();
            try {
                while (resultSet.next()) {
                    ans = resultSet.getString(TIMESTAMP_STR) + "," + resultSet.getString(TestConstant.min_time(TEMPERATURE_STR));
                    Assert.assertEquals((Object)retArray[cnt], (Object)ans);
                    ++cnt;
                }
                Assert.assertEquals((long)2L, (long)cnt);
            }
            finally {
                if (resultSet != null) {
                    resultSet.close();
                }
            }
            hasResultSet = statement.execute("SELECT min_time(temperature) FROM root.ln.wf01.wt01 WHERE temperature > 3");
            Assert.assertTrue((boolean)hasResultSet);
            resultSet = statement.getResultSet();
            try {
                while (resultSet.next()) {
                    ans = resultSet.getString(TIMESTAMP_STR) + "," + resultSet.getString(TestConstant.min_time(TEMPERATURE_STR));
                    Assert.assertEquals((Object)retArray[cnt], (Object)ans);
                    ++cnt;
                }
                Assert.assertEquals((long)3L, (long)cnt);
            }
            finally {
                if (resultSet != null) {
                    resultSet.close();
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            Assert.fail((String)e.getMessage());
        }
    }

    @Test
    public void countTest() {
        String[] retArray = new String[]{"0,2001,2001,2001,2001", "0,7500,7500,7500,7500"};
        try (Connection connection = DriverManager.getConnection("jdbc:iotdb://127.0.0.1:6667/", "root", "root");
             Statement statement = connection.createStatement();){
            String ans;
            int cnt;
            boolean hasResultSet = statement.execute("SELECT count(s0),count(s1),count(s2),count(s3) FROM root.vehicle.d0 WHERE time >= 6000 AND time <= 9000");
            Assert.assertTrue((boolean)hasResultSet);
            try (ResultSet resultSet = statement.getResultSet();){
                cnt = 0;
                while (resultSet.next()) {
                    ans = resultSet.getString(TIMESTAMP_STR) + "," + resultSet.getString(TestConstant.count("root.vehicle.d0.s0")) + "," + resultSet.getString(TestConstant.count("root.vehicle.d0.s1")) + "," + resultSet.getString(TestConstant.count("root.vehicle.d0.s2")) + "," + resultSet.getString(TestConstant.count("root.vehicle.d0.s3"));
                    Assert.assertEquals((Object)retArray[cnt], (Object)ans);
                    ++cnt;
                }
                Assert.assertEquals((long)1L, (long)cnt);
            }
            hasResultSet = statement.execute("SELECT count(s0),count(s1),count(s2),count(s3) FROM root.vehicle.d0");
            Assert.assertTrue((boolean)hasResultSet);
            resultSet = statement.getResultSet();
            try {
                while (resultSet.next()) {
                    ans = resultSet.getString(TIMESTAMP_STR) + "," + resultSet.getString(TestConstant.count("root.vehicle.d0.s0")) + "," + resultSet.getString(TestConstant.count("root.vehicle.d0.s1")) + "," + resultSet.getString(TestConstant.count("root.vehicle.d0.s2")) + "," + resultSet.getString(TestConstant.count("root.vehicle.d0.s3"));
                    Assert.assertEquals((Object)retArray[cnt], (Object)ans);
                    ++cnt;
                }
                Assert.assertEquals((long)2L, (long)cnt);
            }
            finally {
                if (resultSet != null) {
                    resultSet.close();
                }
            }
            hasResultSet = statement.execute("SELECT count(s0),count(s1),count(s2),count(s3) FROM root.vehicle.d0 WHERE time >= 6000 AND time <= 9000 order by time desc");
            Assert.assertTrue((boolean)hasResultSet);
            resultSet = statement.getResultSet();
            try {
                cnt = 0;
                while (resultSet.next()) {
                    ans = resultSet.getString(TIMESTAMP_STR) + "," + resultSet.getString(TestConstant.count("root.vehicle.d0.s0")) + "," + resultSet.getString(TestConstant.count("root.vehicle.d0.s1")) + "," + resultSet.getString(TestConstant.count("root.vehicle.d0.s2")) + "," + resultSet.getString(TestConstant.count("root.vehicle.d0.s3"));
                    Assert.assertEquals((Object)retArray[cnt], (Object)ans);
                    ++cnt;
                }
                Assert.assertEquals((long)1L, (long)cnt);
            }
            finally {
                if (resultSet != null) {
                    resultSet.close();
                }
            }
            hasResultSet = statement.execute("SELECT count(s0),count(s1),count(s2),count(s3) FROM root.vehicle.d0 order by time desc");
            Assert.assertTrue((boolean)hasResultSet);
            resultSet = statement.getResultSet();
            try {
                while (resultSet.next()) {
                    ans = resultSet.getString(TIMESTAMP_STR) + "," + resultSet.getString(TestConstant.count("root.vehicle.d0.s0")) + "," + resultSet.getString(TestConstant.count("root.vehicle.d0.s1")) + "," + resultSet.getString(TestConstant.count("root.vehicle.d0.s2")) + "," + resultSet.getString(TestConstant.count("root.vehicle.d0.s3"));
                    Assert.assertEquals((Object)retArray[cnt], (Object)ans);
                    ++cnt;
                }
                Assert.assertEquals((long)2L, (long)cnt);
            }
            finally {
                if (resultSet != null) {
                    resultSet.close();
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            Assert.fail((String)e.getMessage());
        }
    }

    @Test
    public void firstTest() {
        String[] retArray = new String[]{"0,2000,2000,2000.0,2000", "0,500,500,500.0,500"};
        try (Connection connection = DriverManager.getConnection("jdbc:iotdb://127.0.0.1:6667/", "root", "root");
             Statement statement = connection.createStatement();){
            String ans;
            int cnt;
            boolean hasResultSet = statement.execute("SELECT first_value(s0),first_value(s1),first_value(s2),first_value(s3) FROM root.vehicle.d0 WHERE time >= 1500 AND time <= 9000");
            Assert.assertTrue((boolean)hasResultSet);
            try (ResultSet resultSet = statement.getResultSet();){
                cnt = 0;
                while (resultSet.next()) {
                    ans = resultSet.getString(TIMESTAMP_STR) + "," + resultSet.getString(TestConstant.first_value("root.vehicle.d0.s0")) + "," + resultSet.getString(TestConstant.first_value("root.vehicle.d0.s1")) + "," + resultSet.getString(TestConstant.first_value("root.vehicle.d0.s2")) + "," + resultSet.getString(TestConstant.first_value("root.vehicle.d0.s3"));
                    Assert.assertEquals((Object)retArray[cnt], (Object)ans);
                    ++cnt;
                }
                Assert.assertEquals((long)1L, (long)cnt);
            }
            hasResultSet = statement.execute("SELECT first_value(s0),first_value(s1),first_value(s2),first_value(s3) FROM root.vehicle.d0");
            Assert.assertTrue((boolean)hasResultSet);
            resultSet = statement.getResultSet();
            try {
                while (resultSet.next()) {
                    ans = resultSet.getString(TIMESTAMP_STR) + "," + resultSet.getString(TestConstant.first_value("root.vehicle.d0.s0")) + "," + resultSet.getString(TestConstant.first_value("root.vehicle.d0.s1")) + "," + resultSet.getString(TestConstant.first_value("root.vehicle.d0.s2")) + "," + resultSet.getString(TestConstant.first_value("root.vehicle.d0.s3"));
                    Assert.assertEquals((Object)retArray[cnt], (Object)ans);
                    ++cnt;
                }
                Assert.assertEquals((long)2L, (long)cnt);
            }
            finally {
                if (resultSet != null) {
                    resultSet.close();
                }
            }
            hasResultSet = statement.execute("SELECT first_value(s0),first_value(s1),first_value(s2),first_value(s3) FROM root.vehicle.d0 WHERE time >= 1500 AND time <= 9000 order by time desc");
            Assert.assertTrue((boolean)hasResultSet);
            resultSet = statement.getResultSet();
            try {
                cnt = 0;
                while (resultSet.next()) {
                    ans = resultSet.getString(TIMESTAMP_STR) + "," + resultSet.getString(TestConstant.first_value("root.vehicle.d0.s0")) + "," + resultSet.getString(TestConstant.first_value("root.vehicle.d0.s1")) + "," + resultSet.getString(TestConstant.first_value("root.vehicle.d0.s2")) + "," + resultSet.getString(TestConstant.first_value("root.vehicle.d0.s3"));
                    Assert.assertEquals((Object)retArray[cnt], (Object)ans);
                    ++cnt;
                }
                Assert.assertEquals((long)1L, (long)cnt);
            }
            finally {
                if (resultSet != null) {
                    resultSet.close();
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            Assert.fail((String)e.getMessage());
        }
    }

    @Test
    public void lastTest() {
        String[] retArray = new String[]{"0,8499,8499.0", "0,1499,1499.0", "0,2200,2200.0"};
        try (Connection connection = DriverManager.getConnection("jdbc:iotdb://127.0.0.1:6667/", "root", "root");
             Statement statement = connection.createStatement();){
            String ans;
            int cnt;
            boolean hasResultSet = statement.execute("SELECT last_value(s0),last_value(s2) FROM root.vehicle.d0 WHERE time >= 1500 AND time < 9000");
            Assert.assertTrue((boolean)hasResultSet);
            try (ResultSet resultSet = statement.getResultSet();){
                cnt = 0;
                while (resultSet.next()) {
                    ans = resultSet.getString(TIMESTAMP_STR) + "," + resultSet.getString(TestConstant.last_value("root.vehicle.d0.s0")) + "," + resultSet.getString(TestConstant.last_value("root.vehicle.d0.s2"));
                    Assert.assertEquals((Object)retArray[cnt], (Object)ans);
                    ++cnt;
                }
                Assert.assertEquals((long)1L, (long)cnt);
            }
            hasResultSet = statement.execute("SELECT last_value(s0),last_value(s2) FROM root.vehicle.d0 WHERE time <= 1600");
            Assert.assertTrue((boolean)hasResultSet);
            resultSet = statement.getResultSet();
            try {
                while (resultSet.next()) {
                    ans = resultSet.getString(TIMESTAMP_STR) + "," + resultSet.getString(TestConstant.last_value("root.vehicle.d0.s0")) + "," + resultSet.getString(TestConstant.last_value("root.vehicle.d0.s2"));
                    Assert.assertEquals((Object)retArray[cnt], (Object)ans);
                    ++cnt;
                }
                Assert.assertEquals((long)2L, (long)cnt);
            }
            finally {
                if (resultSet != null) {
                    resultSet.close();
                }
            }
            hasResultSet = statement.execute("SELECT last_value(s0),last_value(s2) FROM root.vehicle.d0 WHERE time <= 2200");
            Assert.assertTrue((boolean)hasResultSet);
            resultSet = statement.getResultSet();
            try {
                while (resultSet.next()) {
                    ans = resultSet.getString(TIMESTAMP_STR) + "," + resultSet.getString(TestConstant.last_value("root.vehicle.d0.s0")) + "," + resultSet.getString(TestConstant.last_value("root.vehicle.d0.s2"));
                    Assert.assertEquals((Object)retArray[cnt], (Object)ans);
                    ++cnt;
                }
                Assert.assertEquals((long)3L, (long)cnt);
            }
            finally {
                if (resultSet != null) {
                    resultSet.close();
                }
            }
            hasResultSet = statement.execute("SELECT last_value(s0),last_value(s2) FROM root.vehicle.d0 WHERE time <= 2200 order by time desc");
            Assert.assertTrue((boolean)hasResultSet);
            resultSet = statement.getResultSet();
            try {
                cnt = 0;
                while (resultSet.next()) {
                    ans = resultSet.getString(TIMESTAMP_STR) + "," + resultSet.getString(TestConstant.last_value("root.vehicle.d0.s0")) + "," + resultSet.getString(TestConstant.last_value("root.vehicle.d0.s2"));
                    Assert.assertEquals((Object)retArray[retArray.length - cnt - 1], (Object)ans);
                    ++cnt;
                }
                Assert.assertEquals((long)1L, (long)cnt);
            }
            finally {
                if (resultSet != null) {
                    resultSet.close();
                }
            }
            hasResultSet = statement.execute("SELECT last_value(s0),last_value(s2) FROM root.vehicle.d0 WHERE time >= 1500 AND time < 9000 order by time desc");
            Assert.assertTrue((boolean)hasResultSet);
            resultSet = statement.getResultSet();
            try {
                cnt = 0;
                while (resultSet.next()) {
                    ans = resultSet.getString(TIMESTAMP_STR) + "," + resultSet.getString(TestConstant.last_value("root.vehicle.d0.s0")) + "," + resultSet.getString(TestConstant.last_value("root.vehicle.d0.s2"));
                    Assert.assertEquals((Object)retArray[cnt], (Object)ans);
                    ++cnt;
                }
                Assert.assertEquals((long)1L, (long)cnt);
            }
            finally {
                if (resultSet != null) {
                    resultSet.close();
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            Assert.fail((String)e.getMessage());
        }
    }

    @Test
    public void maxminTimeTest() {
        String[] retArray = new String[]{"0,8499,500", "0,2499,2000"};
        try (Connection connection = DriverManager.getConnection("jdbc:iotdb://127.0.0.1:6667/", "root", "root");
             Statement statement = connection.createStatement();){
            String ans;
            int cnt;
            boolean hasResultSet = statement.execute("SELECT max_time(s0),min_time(s2) FROM root.vehicle.d0 WHERE time >= 100 AND time < 9000");
            Assert.assertTrue((boolean)hasResultSet);
            try (ResultSet resultSet = statement.getResultSet();){
                cnt = 0;
                while (resultSet.next()) {
                    ans = resultSet.getString(TIMESTAMP_STR) + "," + resultSet.getString(TestConstant.max_time("root.vehicle.d0.s0")) + "," + resultSet.getString(TestConstant.min_time("root.vehicle.d0.s2"));
                    Assert.assertEquals((Object)retArray[cnt], (Object)ans);
                    ++cnt;
                }
                Assert.assertEquals((long)1L, (long)cnt);
            }
            hasResultSet = statement.execute("SELECT max_time(s0),min_time(s2) FROM root.vehicle.d0 WHERE time <= 2500 AND time > 1800");
            Assert.assertTrue((boolean)hasResultSet);
            resultSet = statement.getResultSet();
            try {
                while (resultSet.next()) {
                    ans = resultSet.getString(TIMESTAMP_STR) + "," + resultSet.getString(TestConstant.max_time("root.vehicle.d0.s0")) + "," + resultSet.getString(TestConstant.min_time("root.vehicle.d0.s2"));
                    Assert.assertEquals((Object)retArray[cnt], (Object)ans);
                    ++cnt;
                }
                Assert.assertEquals((long)2L, (long)cnt);
            }
            finally {
                if (resultSet != null) {
                    resultSet.close();
                }
            }
            hasResultSet = statement.execute("SELECT max_time(s0),min_time(s2) FROM root.vehicle.d0 WHERE time >= 100 AND time < 9000 order by time desc");
            Assert.assertTrue((boolean)hasResultSet);
            resultSet = statement.getResultSet();
            try {
                cnt = 0;
                while (resultSet.next()) {
                    ans = resultSet.getString(TIMESTAMP_STR) + "," + resultSet.getString(TestConstant.max_time("root.vehicle.d0.s0")) + "," + resultSet.getString(TestConstant.min_time("root.vehicle.d0.s2"));
                    Assert.assertEquals((Object)retArray[cnt], (Object)ans);
                    ++cnt;
                }
                Assert.assertEquals((long)1L, (long)cnt);
            }
            finally {
                if (resultSet != null) {
                    resultSet.close();
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            Assert.fail((String)e.getMessage());
        }
    }

    @Test
    public void firstLastValueTest() throws SQLException {
        String[] retArray = new String[]{"0,2.2,4.4"};
        try (Connection connection = DriverManager.getConnection("jdbc:iotdb://127.0.0.1:6667/", "root", "root");
             Statement statement = connection.createStatement();){
            boolean hasResultSet = statement.execute("SELECT first_value(temperature),last_value(temperature) FROM root.ln.wf01.wt01 WHERE time > 1 AND time < 5");
            Assert.assertTrue((boolean)hasResultSet);
            try (ResultSet resultSet = statement.getResultSet();){
                int cnt = 0;
                while (resultSet.next()) {
                    String ans = resultSet.getString(TIMESTAMP_STR) + "," + resultSet.getString(1) + "," + resultSet.getString(2);
                    Assert.assertEquals((Object)retArray[cnt], (Object)ans);
                    ++cnt;
                }
                Assert.assertEquals((long)1L, (long)cnt);
            }
        }
    }

    @Test
    public void maxminValueTest() {
        String[] retArray = new String[]{"0,8499,500.0", "0,2499,500.0"};
        try (Connection connection = DriverManager.getConnection("jdbc:iotdb://127.0.0.1:6667/", "root", "root");
             Statement statement = connection.createStatement();){
            String ans;
            int cnt;
            boolean hasResultSet = statement.execute("SELECT max_value(s0),min_value(s2) FROM root.vehicle.d0 WHERE time >= 100 AND time < 9000");
            Assert.assertTrue((boolean)hasResultSet);
            try (ResultSet resultSet = statement.getResultSet();){
                cnt = 0;
                while (resultSet.next()) {
                    ans = resultSet.getString(TIMESTAMP_STR) + "," + resultSet.getString(TestConstant.max_value("root.vehicle.d0.s0")) + "," + resultSet.getString(TestConstant.min_value("root.vehicle.d0.s2"));
                    Assert.assertEquals((Object)retArray[cnt], (Object)ans);
                    ++cnt;
                }
                Assert.assertEquals((long)1L, (long)cnt);
            }
            hasResultSet = statement.execute("SELECT max_value(s0),min_value(s2) FROM root.vehicle.d0 WHERE time < 2500");
            Assert.assertTrue((boolean)hasResultSet);
            resultSet = statement.getResultSet();
            try {
                while (resultSet.next()) {
                    ans = resultSet.getString(TIMESTAMP_STR) + "," + resultSet.getString(TestConstant.max_value("root.vehicle.d0.s0")) + "," + resultSet.getString(TestConstant.min_value("root.vehicle.d0.s2"));
                    Assert.assertEquals((Object)retArray[cnt], (Object)ans);
                    ++cnt;
                }
                Assert.assertEquals((long)2L, (long)cnt);
            }
            finally {
                if (resultSet != null) {
                    resultSet.close();
                }
            }
            hasResultSet = statement.execute("SELECT max_value(s0),min_value(s2) FROM root.vehicle.d0 WHERE time >= 100 AND time < 9000 order by time desc");
            Assert.assertTrue((boolean)hasResultSet);
            cnt = 0;
            resultSet = statement.getResultSet();
            try {
                while (resultSet.next()) {
                    ans = resultSet.getString(TIMESTAMP_STR) + "," + resultSet.getString(TestConstant.max_value("root.vehicle.d0.s0")) + "," + resultSet.getString(TestConstant.min_value("root.vehicle.d0.s2"));
                    Assert.assertEquals((Object)retArray[cnt], (Object)ans);
                    ++cnt;
                }
                Assert.assertEquals((long)1L, (long)cnt);
            }
            finally {
                if (resultSet != null) {
                    resultSet.close();
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            Assert.fail((String)e.getMessage());
        }
    }

    @Test
    public void avgSumTest() {
        double[][] retArray = new double[][]{{0.0, 1.4508E7, 7250.374812593702}, {0.0, 626750.0, 1250.9980039920158}};
        try (Connection connection = DriverManager.getConnection("jdbc:iotdb://127.0.0.1:6667/", "root", "root");
             Statement statement = connection.createStatement();){
            double[] ans;
            boolean hasResultSet = statement.execute("SELECT sum(s0),avg(s2)FROM root.vehicle.d0 WHERE time >= 6000 AND time <= 9000");
            Assert.assertTrue((boolean)hasResultSet);
            int cnt = 0;
            try (ResultSet resultSet = statement.getResultSet();){
                while (resultSet.next()) {
                    ans = new double[]{Double.valueOf(resultSet.getString(TIMESTAMP_STR)), Double.valueOf(resultSet.getString(TestConstant.sum("root.vehicle.d0.s0"))), Double.valueOf(resultSet.getString(TestConstant.avg("root.vehicle.d0.s2")))};
                    Assert.assertArrayEquals((double[])retArray[cnt], (double[])ans, (double)1.0E-6);
                    ++cnt;
                }
                Assert.assertEquals((long)1L, (long)cnt);
            }
            hasResultSet = statement.execute("SELECT sum(s0),avg(s2)FROM root.vehicle.d0 WHERE time >= 1000 AND time <= 2000");
            Assert.assertTrue((boolean)hasResultSet);
            resultSet = statement.getResultSet();
            try {
                while (resultSet.next()) {
                    ans = new double[]{Double.valueOf(resultSet.getString(TIMESTAMP_STR)), Double.valueOf(resultSet.getString(TestConstant.sum("root.vehicle.d0.s0"))), Double.valueOf(resultSet.getString(TestConstant.avg("root.vehicle.d0.s2")))};
                    Assert.assertArrayEquals((double[])retArray[cnt], (double[])ans, (double)1.0E-6);
                    ++cnt;
                }
                Assert.assertEquals((long)2L, (long)cnt);
            }
            finally {
                if (resultSet != null) {
                    resultSet.close();
                }
            }
            hasResultSet = statement.execute("SELECT sum(s0),avg(s2)FROM root.vehicle.d0 WHERE time >= 6000 AND time <= 9000 order by time desc");
            Assert.assertTrue((boolean)hasResultSet);
            cnt = 0;
            resultSet = statement.getResultSet();
            try {
                while (resultSet.next()) {
                    ans = new double[]{Double.valueOf(resultSet.getString(TIMESTAMP_STR)), Double.valueOf(resultSet.getString(TestConstant.sum("root.vehicle.d0.s0"))), Double.valueOf(resultSet.getString(TestConstant.avg("root.vehicle.d0.s2")))};
                    Assert.assertArrayEquals((double[])retArray[cnt], (double[])ans, (double)1.0E-6);
                    ++cnt;
                }
                Assert.assertEquals((long)1L, (long)cnt);
            }
            finally {
                if (resultSet != null) {
                    resultSet.close();
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            Assert.fail((String)e.getMessage());
        }
    }

    @Test
    public void avgSumErrorTest() {
        try (Connection connection = DriverManager.getConnection("jdbc:iotdb://127.0.0.1:6667/", "root", "root");
             Statement statement = connection.createStatement();){
            ResultSet resultSet;
            try {
                statement.execute("SELECT avg(s3)FROM root.vehicle.d0 WHERE time >= 6000 AND time <= 9000");
                resultSet = statement.getResultSet();
                try {
                    resultSet.next();
                    Assert.fail();
                }
                finally {
                    if (resultSet != null) {
                        resultSet.close();
                    }
                }
            }
            catch (Exception e) {
                Assert.assertTrue((boolean)e.getMessage().contains("Unsupported data type in aggregation AVG : TEXT"));
            }
            try {
                statement.execute("SELECT sum(s3)FROM root.vehicle.d0 WHERE time >= 6000 AND time <= 9000");
                resultSet = statement.getResultSet();
                try {
                    resultSet.next();
                    Assert.fail();
                }
                finally {
                    if (resultSet != null) {
                        resultSet.close();
                    }
                }
            }
            catch (Exception e) {
                Assert.assertTrue((boolean)e.getMessage().contains("Unsupported data type in aggregation SUM : TEXT"));
            }
            try {
                statement.execute("SELECT avg(s4)FROM root.vehicle.d0 WHERE time >= 6000 AND time <= 9000");
                resultSet = statement.getResultSet();
                try {
                    resultSet.next();
                    Assert.fail();
                }
                finally {
                    if (resultSet != null) {
                        resultSet.close();
                    }
                }
            }
            catch (Exception e) {
                Assert.assertTrue((boolean)e.getMessage().contains("Unsupported data type in aggregation AVG : BOOLEAN"));
            }
            try {
                statement.execute("SELECT sum(s4)FROM root.vehicle.d0 WHERE time >= 6000 AND time <= 9000");
                resultSet = statement.getResultSet();
                try {
                    resultSet.next();
                    Assert.fail();
                }
                finally {
                    if (resultSet != null) {
                        resultSet.close();
                    }
                }
            }
            catch (Exception e) {
                Assert.assertTrue((boolean)e.getMessage().contains("Unsupported data type in aggregation SUM : BOOLEAN"));
            }
            try {
                statement.execute("SELECT avg(status) FROM root.ln.wf01.wt01");
                resultSet = statement.getResultSet();
                try {
                    resultSet.next();
                    Assert.fail();
                }
                finally {
                    if (resultSet != null) {
                        resultSet.close();
                    }
                }
            }
            catch (Exception e) {
                Assert.assertTrue((boolean)e.getMessage().contains("Boolean statistics does not support: avg"));
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            Assert.fail((String)e.getMessage());
        }
    }

    @Test
    public void mergeAggrOnOneSeriesTest() {
        double[][] retArray = new double[][]{{0.0, 1.4508E7, 7250.374812593702, 7250.374812593702, 1.4508E7}, {0.0, 626750.0, 1250.9980039920158, 1250.9980039920158, 626750.0}, {0.0, 1.4508E7, 2001.0, 7250.374812593702, 7250.374812593702}, {0.0, 1.4508E7, 2001.0, 7250.374812593702, 7250.374812593702, 2001.0, 1.4508E7}};
        try (Connection connection = DriverManager.getConnection("jdbc:iotdb://127.0.0.1:6667/", "root", "root");
             Statement statement = connection.createStatement();){
            double[] ans;
            boolean hasResultSet = statement.execute("SELECT sum(s0), avg(s2), avg(s0), sum(s2)FROM root.vehicle.d0 WHERE time >= 6000 AND time <= 9000");
            Assert.assertTrue((boolean)hasResultSet);
            int cnt = 0;
            try (ResultSet resultSet = statement.getResultSet();){
                while (resultSet.next()) {
                    ans = new double[]{Double.valueOf(resultSet.getString(TIMESTAMP_STR)), Double.valueOf(resultSet.getString(TestConstant.sum("root.vehicle.d0.s0"))), Double.valueOf(resultSet.getString(TestConstant.avg("root.vehicle.d0.s2"))), Double.valueOf(resultSet.getString(TestConstant.avg("root.vehicle.d0.s0"))), Double.valueOf(resultSet.getString(TestConstant.sum("root.vehicle.d0.s2")))};
                    Assert.assertArrayEquals((double[])retArray[cnt], (double[])ans, (double)1.0E-6);
                    ++cnt;
                }
                Assert.assertEquals((long)1L, (long)cnt);
            }
            hasResultSet = statement.execute("SELECT sum(s0), avg(s2), avg(s0), sum(s2)FROM root.vehicle.d0 WHERE time >= 1000 AND time <= 2000");
            Assert.assertTrue((boolean)hasResultSet);
            resultSet = statement.getResultSet();
            try {
                while (resultSet.next()) {
                    ans = new double[]{Double.valueOf(resultSet.getString(TIMESTAMP_STR)), Double.valueOf(resultSet.getString(TestConstant.sum("root.vehicle.d0.s0"))), Double.valueOf(resultSet.getString(TestConstant.avg("root.vehicle.d0.s2"))), Double.valueOf(resultSet.getString(TestConstant.avg("root.vehicle.d0.s0"))), Double.valueOf(resultSet.getString(TestConstant.sum("root.vehicle.d0.s2")))};
                    Assert.assertArrayEquals((double[])retArray[cnt], (double[])ans, (double)1.0E-6);
                    ++cnt;
                }
                Assert.assertEquals((long)2L, (long)cnt);
            }
            finally {
                if (resultSet != null) {
                    resultSet.close();
                }
            }
            hasResultSet = statement.execute("SELECT sum(s0), count(s0), avg(s2), avg(s0)FROM root.vehicle.d0 WHERE time >= 6000 AND time <= 9000");
            Assert.assertTrue((boolean)hasResultSet);
            resultSet = statement.getResultSet();
            try {
                while (resultSet.next()) {
                    ans = new double[]{Double.valueOf(resultSet.getString(TIMESTAMP_STR)), Double.valueOf(resultSet.getString(TestConstant.sum("root.vehicle.d0.s0"))), Double.valueOf(resultSet.getString(TestConstant.count("root.vehicle.d0.s0"))), Double.valueOf(resultSet.getString(TestConstant.avg("root.vehicle.d0.s2"))), Double.valueOf(resultSet.getString(TestConstant.avg("root.vehicle.d0.s0")))};
                    Assert.assertArrayEquals((double[])retArray[cnt], (double[])ans, (double)1.0E-6);
                    ++cnt;
                }
                Assert.assertEquals((long)3L, (long)cnt);
            }
            finally {
                if (resultSet != null) {
                    resultSet.close();
                }
            }
            hasResultSet = statement.execute("SELECT sum(s2), count(s0), avg(s2), avg(s1), count(s2),sum(s0)FROM root.vehicle.d0 WHERE time >= 6000 AND time <= 9000");
            Assert.assertTrue((boolean)hasResultSet);
            resultSet = statement.getResultSet();
            try {
                while (resultSet.next()) {
                    ans = new double[]{Double.valueOf(resultSet.getString(TIMESTAMP_STR)), Double.valueOf(resultSet.getString(TestConstant.sum("root.vehicle.d0.s2"))), Double.valueOf(resultSet.getString(TestConstant.count("root.vehicle.d0.s0"))), Double.valueOf(resultSet.getString(TestConstant.avg("root.vehicle.d0.s2"))), Double.valueOf(resultSet.getString(TestConstant.avg("root.vehicle.d0.s1"))), Double.valueOf(resultSet.getString(TestConstant.count("root.vehicle.d0.s2"))), Double.valueOf(resultSet.getString(TestConstant.sum("root.vehicle.d0.s0")))};
                    Assert.assertArrayEquals((double[])retArray[cnt], (double[])ans, (double)1.0E-6);
                    ++cnt;
                }
                Assert.assertEquals((long)4L, (long)cnt);
            }
            finally {
                if (resultSet != null) {
                    resultSet.close();
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            Assert.fail((String)e.getMessage());
        }
    }

    @Test
    public void descAggregationWithUnseqData() {
        String[] retArray = new String[]{"0,12"};
        try (Connection connection = DriverManager.getConnection("jdbc:iotdb://127.0.0.1:6667/", "root", "root");
             Statement statement = connection.createStatement();){
            boolean hasResultSet = statement.execute("SELECT max_time(s1) FROM root.sg.d1 where time < 15");
            Assert.assertTrue((boolean)hasResultSet);
            int cnt = 0;
            try (ResultSet resultSet = statement.getResultSet();){
                while (resultSet.next()) {
                    String ans = resultSet.getString(TIMESTAMP_STR) + "," + resultSet.getString(TestConstant.max_time("root.sg.d1.s1"));
                    Assert.assertEquals((Object)retArray[cnt], (Object)ans);
                    ++cnt;
                }
                Assert.assertEquals((long)1L, (long)cnt);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            Assert.fail((String)e.getMessage());
        }
    }

    private void prepareData() {
        try (Connection connection = DriverManager.getConnection("jdbc:iotdb://127.0.0.1:6667/", "root", "root");
             Statement statement = connection.createStatement();){
            int i;
            for (String sql : creationSqls) {
                statement.execute(sql);
            }
            for (i = 5000; i < 7000; ++i) {
                statement.execute(String.format(Locale.ENGLISH, this.insertTemplate, i, i, i, (double)i, "'" + i + "'", "true"));
            }
            statement.execute("FLUSH");
            for (i = 7500; i < 8500; ++i) {
                statement.execute(String.format(Locale.ENGLISH, this.insertTemplate, i, i, i, (double)i, "'" + i + "'", "false"));
            }
            statement.execute("FLUSH");
            for (i = 500; i < 1500; ++i) {
                statement.execute(String.format(Locale.ENGLISH, this.insertTemplate, i, i, i, (double)i, "'" + i + "'", "true"));
            }
            statement.execute("FLUSH");
            for (i = 3000; i < 6500; ++i) {
                statement.execute(String.format(Locale.ENGLISH, this.insertTemplate, i, i, i, (double)i, "'" + i + "'", "false"));
            }
            statement.execute("merge");
            for (i = 9000; i < 10000; ++i) {
                statement.execute(String.format(Locale.ENGLISH, this.insertTemplate, i, i, i, (double)i, "'" + i + "'", "true"));
            }
            for (i = 2000; i < 2500; ++i) {
                statement.execute(String.format(Locale.ENGLISH, this.insertTemplate, i, i, i, (double)i, "'" + i + "'", "false"));
            }
            for (String sql : dataSet3) {
                statement.execute(sql);
            }
            for (String sql : dataSet2) {
                statement.execute(sql);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

