/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.integration.aggregation;

import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import org.apache.iotdb.db.conf.IoTDBDescriptor;
import org.apache.iotdb.db.constant.TestConstant;
import org.apache.iotdb.db.utils.EnvironmentUtils;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class IoTDBAggregationDeleteIT {
    private static String[] dataSet = new String[]{"INSERT INTO root.turbine.d1(timestamp,s1) values(1,1)", "INSERT INTO root.turbine.d1(timestamp,s1) values(2,2)", "INSERT INTO root.turbine.d1(timestamp,s1) values(3,3)", "INSERT INTO root.turbine.d1(timestamp,s1) values(4,4)", "INSERT INTO root.turbine.d1(timestamp,s1) values(5,5)", "flush", "delete from root.turbine.d1.s1 where time < 3"};
    private long prevPartitionInterval;

    @Before
    public void setUp() throws Exception {
        EnvironmentUtils.closeStatMonitor();
        this.prevPartitionInterval = IoTDBDescriptor.getInstance().getConfig().getPartitionInterval();
        IoTDBDescriptor.getInstance().getConfig().setPartitionInterval(1000L);
        EnvironmentUtils.envSetUp();
        Class.forName("org.apache.iotdb.jdbc.IoTDBDriver");
        this.prepareData();
    }

    @After
    public void tearDown() throws Exception {
        EnvironmentUtils.cleanEnv();
        IoTDBDescriptor.getInstance().getConfig().setPartitionInterval(this.prevPartitionInterval);
    }

    @Test
    public void countAfterDeleteTest() throws SQLException {
        try (Connection connection = DriverManager.getConnection("jdbc:iotdb://127.0.0.1:6667/", "root", "root");
             Statement statement = connection.createStatement();){
            boolean hasResultSet = statement.execute("select count(*) from root");
            Assert.assertTrue((boolean)hasResultSet);
            try (ResultSet resultSet = statement.getResultSet();){
                while (resultSet.next()) {
                    Assert.assertEquals((Object)"3", (Object)resultSet.getString(TestConstant.count("root.turbine.d1.s1")));
                }
            }
        }
    }

    private void prepareData() throws SQLException {
        try (Connection connection = DriverManager.getConnection("jdbc:iotdb://127.0.0.1:6667/", "root", "root");
             Statement statement = connection.createStatement();){
            for (String sql : dataSet) {
                statement.execute(sql);
            }
        }
    }
}

