/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.integration.aggregation;

import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.ResultSet;
import java.sql.Statement;
import org.apache.iotdb.db.constant.TestConstant;
import org.apache.iotdb.db.qp.Planner;
import org.apache.iotdb.db.utils.EnvironmentUtils;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class IoTDBAggregationByLevelIT {
    private Planner planner = new Planner();
    private static final String[] dataSet = new String[]{"SET STORAGE GROUP TO root.sg1", "SET STORAGE GROUP TO root.sg2", "CREATE TIMESERIES root.sg1.d1.status WITH DATATYPE=BOOLEAN, ENCODING=PLAIN", "CREATE TIMESERIES root.sg1.d1.temperature WITH DATATYPE=DOUBLE, ENCODING=PLAIN", "CREATE TIMESERIES root.sg1.d2.status WITH DATATYPE=BOOLEAN, ENCODING=PLAIN", "CREATE TIMESERIES root.sg1.d2.temperature WITH DATATYPE=DOUBLE, ENCODING=PLAIN", "CREATE TIMESERIES root.sg2.d1.status WITH DATATYPE=INT32, ENCODING=PLAIN", "CREATE TIMESERIES root.sg2.d1.temperature WITH DATATYPE=DOUBLE, ENCODING=PLAIN", "CREATE TIMESERIES root.sg2.d2.temperature WITH DATATYPE=DOUBLE, ENCODING=PLAIN", "INSERT INTO root.sg1.d1(timestamp,status) values(150,true)", "INSERT INTO root.sg1.d1(timestamp,status,temperature) values(200,false,20.71)", "INSERT INTO root.sg1.d1(timestamp,status,temperature) values(600,false,71.12)", "INSERT INTO root.sg1.d2(timestamp,status,temperature) values(200,false,42.66)", "INSERT INTO root.sg1.d2(timestamp,status,temperature) values(300,false,46.77)", "INSERT INTO root.sg1.d2(timestamp,status,temperature) values(700,true,62.15)", "INSERT INTO root.sg2.d1(timestamp,status,temperature) values(100,3,88.24)", "INSERT INTO root.sg2.d1(timestamp,status,temperature) values(500,5,125.5)", "INSERT INTO root.sg2.d2(timestamp,temperature) values(200,105.5)", "INSERT INTO root.sg2.d2(timestamp,temperature) values(800,61.22)"};
    private static final double DOUBLE_PRECISION = 0.001;

    @Before
    public void setUp() throws Exception {
        EnvironmentUtils.closeStatMonitor();
        EnvironmentUtils.envSetUp();
        Class.forName("org.apache.iotdb.jdbc.IoTDBDriver");
        this.prepareData();
    }

    @After
    public void tearDown() throws Exception {
        EnvironmentUtils.cleanEnv();
    }

    @Test
    public void sumFuncGroupByLevelTest() throws Exception {
        double[] retArray = new double[]{243.41, 380.46, 623.87};
        try (Connection connection = DriverManager.getConnection("jdbc:iotdb://127.0.0.1:6667/", "root", "root");
             Statement statement = connection.createStatement();){
            String ans;
            statement.execute("select sum(temperature) from root.sg1.* GROUP BY level=1");
            int cnt = 0;
            try (ResultSet resultSet = statement.getResultSet();){
                while (resultSet.next()) {
                    ans = resultSet.getString(TestConstant.sum("root.sg1.*.temperature"));
                    Assert.assertEquals((double)retArray[cnt], (double)Double.parseDouble(ans), (double)0.001);
                    ++cnt;
                }
            }
            statement.execute("select sum(temperature) from root.sg2.* GROUP BY level=1");
            resultSet = statement.getResultSet();
            try {
                while (resultSet.next()) {
                    ans = resultSet.getString(TestConstant.sum("root.sg2.*.temperature"));
                    Assert.assertEquals((double)retArray[cnt], (double)Double.parseDouble(ans), (double)0.001);
                    ++cnt;
                }
            }
            finally {
                if (resultSet != null) {
                    resultSet.close();
                }
            }
            statement.execute("select sum(temperature) from root.*.* GROUP BY level=0");
            resultSet = statement.getResultSet();
            try {
                while (resultSet.next()) {
                    ans = resultSet.getString(TestConstant.sum("root.*.*.temperature"));
                    Assert.assertEquals((double)retArray[cnt], (double)Double.parseDouble(ans), (double)0.001);
                    ++cnt;
                }
            }
            finally {
                if (resultSet != null) {
                    resultSet.close();
                }
            }
            Assert.assertEquals((long)retArray.length, (long)cnt);
        }
    }

    @Test
    public void avgFuncGroupByLevelTest() throws Exception {
        double[] retArray = new double[]{48.682, 95.115, 69.319};
        try (Connection connection = DriverManager.getConnection("jdbc:iotdb://127.0.0.1:6667/", "root", "root");
             Statement statement = connection.createStatement();){
            String ans;
            statement.execute("select avg(temperature) from root.sg1.* GROUP BY level=1");
            int cnt = 0;
            try (ResultSet resultSet = statement.getResultSet();){
                while (resultSet.next()) {
                    ans = resultSet.getString(TestConstant.avg("root.sg1.*.temperature"));
                    Assert.assertEquals((double)retArray[cnt], (double)Double.parseDouble(ans), (double)0.001);
                    ++cnt;
                }
            }
            statement.execute("select avg(temperature) from root.sg2.* GROUP BY level=1");
            resultSet = statement.getResultSet();
            try {
                while (resultSet.next()) {
                    ans = resultSet.getString(TestConstant.avg("root.sg2.*.temperature"));
                    Assert.assertEquals((double)retArray[cnt], (double)Double.parseDouble(ans), (double)0.001);
                    ++cnt;
                }
            }
            finally {
                if (resultSet != null) {
                    resultSet.close();
                }
            }
            statement.execute("select avg(temperature) from root.*.* GROUP BY level=0");
            resultSet = statement.getResultSet();
            try {
                while (resultSet.next()) {
                    ans = resultSet.getString(TestConstant.avg("root.*.*.temperature"));
                    Assert.assertEquals((double)retArray[cnt], (double)Double.parseDouble(ans), (double)0.001);
                    ++cnt;
                }
            }
            finally {
                if (resultSet != null) {
                    resultSet.close();
                }
            }
            Assert.assertEquals((long)retArray.length, (long)cnt);
        }
    }

    @Test
    public void timeFuncGroupByLevelTest() throws Exception {
        String[] retArray = new String[]{"8,100", "600,700,2,3"};
        try (Connection connection = DriverManager.getConnection("jdbc:iotdb://127.0.0.1:6667/", "root", "root");
             Statement statement = connection.createStatement();){
            String ans;
            statement.execute("select count(status), min_time(temperature) from root.*.* GROUP BY level=0");
            int cnt = 0;
            try (ResultSet resultSet = statement.getResultSet();){
                while (resultSet.next()) {
                    ans = resultSet.getString(TestConstant.count("root.*.*.status")) + "," + resultSet.getString(TestConstant.min_time("root.*.*.temperature"));
                    Assert.assertEquals((Object)retArray[cnt], (Object)ans);
                    ++cnt;
                }
            }
            statement.execute("select max_time(status), count(temperature) from root.sg1.* GROUP BY level=2");
            resultSet = statement.getResultSet();
            try {
                while (resultSet.next()) {
                    ans = resultSet.getString(TestConstant.max_time("root.sg1.d1.status")) + "," + resultSet.getString(TestConstant.max_time("root.sg1.d2.status")) + "," + resultSet.getString(TestConstant.count("root.sg1.d1.temperature")) + "," + resultSet.getString(TestConstant.count("root.sg1.d2.temperature"));
                    Assert.assertEquals((Object)retArray[cnt], (Object)ans);
                    ++cnt;
                }
            }
            finally {
                if (resultSet != null) {
                    resultSet.close();
                }
            }
            Assert.assertEquals((long)retArray.length, (long)cnt);
        }
    }

    @Test
    public void valueFuncGroupByLevelTest() throws Exception {
        String[] retArray = new String[]{"61.22,125.5", "71.12,62.15,71.12,62.15"};
        try (Connection connection = DriverManager.getConnection("jdbc:iotdb://127.0.0.1:6667/", "root", "root");
             Statement statement = connection.createStatement();){
            String ans;
            statement.execute("select last_value(temperature), max_value(temperature) from root.*.* GROUP BY level=0");
            int cnt = 0;
            try (ResultSet resultSet = statement.getResultSet();){
                while (resultSet.next()) {
                    ans = resultSet.getString(TestConstant.last_value("root.*.*.temperature")) + "," + resultSet.getString(TestConstant.max_value("root.*.*.temperature"));
                    Assert.assertEquals((Object)retArray[cnt], (Object)ans);
                    ++cnt;
                }
            }
            statement.execute("select last_value(temperature), max_value(temperature) from root.sg1.* GROUP BY level=2");
            resultSet = statement.getResultSet();
            try {
                while (resultSet.next()) {
                    ans = resultSet.getString(TestConstant.last_value("root.sg1.d1.temperature")) + "," + resultSet.getString(TestConstant.last_value("root.sg1.d2.temperature")) + "," + resultSet.getString(TestConstant.max_value("root.sg1.d1.temperature")) + "," + resultSet.getString(TestConstant.max_value("root.sg1.d2.temperature"));
                    Assert.assertEquals((Object)retArray[cnt], (Object)ans);
                    ++cnt;
                }
            }
            finally {
                if (resultSet != null) {
                    resultSet.close();
                }
            }
            Assert.assertEquals((long)retArray.length, (long)cnt);
        }
    }

    @Test
    public void groupByLevelWithTimeIntervalTest() throws Exception {
        String[] retArray1 = new String[]{"0.0", "88.24", "105.5", "0.0", "0.0", "125.5"};
        String[] retArray2 = new String[]{"null,null,null,null", "null,100,null,88.24", "200,200,31.685,105.5", "300,null,46.77,null", "null,null,null,null", "null,500,null,125.5"};
        try (Connection connection = DriverManager.getConnection("jdbc:iotdb://127.0.0.1:6667/", "root", "root");
             Statement statement = connection.createStatement();){
            String ans;
            statement.execute("select sum(temperature) from root.sg2.* GROUP BY ([0, 600), 100ms), level=1");
            int cnt = 0;
            try (ResultSet resultSet = statement.getResultSet();){
                while (resultSet.next()) {
                    ans = resultSet.getString(TestConstant.sum("root.sg2.*.temperature"));
                    Assert.assertEquals((Object)retArray1[cnt], (Object)ans);
                    ++cnt;
                }
            }
            cnt = 0;
            statement.execute("select max_time(temperature), avg(temperature) from root.*.* GROUP BY ([0, 600), 100ms), level=1");
            resultSet = statement.getResultSet();
            try {
                while (resultSet.next()) {
                    ans = resultSet.getString(TestConstant.max_time("root.sg1.*.temperature")) + "," + resultSet.getString(TestConstant.max_time("root.sg2.*.temperature")) + "," + resultSet.getString(TestConstant.avg("root.sg1.*.temperature")) + "," + resultSet.getString(TestConstant.avg("root.sg2.*.temperature"));
                    Assert.assertEquals((Object)retArray2[cnt], (Object)ans);
                    ++cnt;
                }
            }
            finally {
                if (resultSet != null) {
                    resultSet.close();
                }
            }
        }
    }

    @Test
    public void mismatchedFuncGroupByLevelTest() throws Exception {
        String[] retArray = new String[]{"true", "3"};
        try (Connection connection = DriverManager.getConnection("jdbc:iotdb://127.0.0.1:6667/", "root", "root");
             Statement statement = connection.createStatement();){
            statement.execute("select last_value(status) from root.*.* GROUP BY level=0");
            int cnt = 0;
            try (ResultSet resultSet = statement.getResultSet();){
                while (resultSet.next()) {
                    String ans = resultSet.getString(1);
                    Assert.assertEquals((Object)retArray[cnt], (Object)ans);
                    ++cnt;
                }
            }
            try {
                this.planner.parseSQLToPhysicalPlan("select avg(status) from root.sg2.* GROUP BY level=1");
            }
            catch (Exception e) {
                Assert.assertEquals((Object)"Aggregate among unmatched data types", (Object)e.getMessage());
            }
        }
    }

    @Test
    public void TestGroupByLevelWithoutAggregationFunc() {
        try (Connection connection = DriverManager.getConnection("jdbc:iotdb://127.0.0.1:6667/", "root", "root");
             Statement statement = connection.createStatement();){
            statement.execute("select temperature from root.sg1.* group by level = 2");
            Assert.fail((String)"No expected exception thrown");
        }
        catch (Exception e) {
            Assert.assertTrue((boolean)e.getMessage().contains("There is no aggregation function with group by query"));
        }
    }

    private void prepareData() {
        try (Connection connection = DriverManager.getConnection("jdbc:iotdb://127.0.0.1:6667/", "root", "root");
             Statement statement = connection.createStatement();){
            for (String sql : dataSet) {
                statement.execute(sql);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

