/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.integration;

import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.ResultSet;
import java.sql.Statement;
import org.apache.iotdb.db.conf.IoTDBDescriptor;
import org.apache.iotdb.db.utils.EnvironmentUtils;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Test;

public class IoTDBWithoutAnyNullIT {
    private static final String[] dataSet = new String[]{"SET STORAGE GROUP TO root.testWithoutAnyNull", "CREATE TIMESERIES root.testWithoutAnyNull.d1.s1 WITH DATATYPE=INT32, ENCODING=PLAIN", "CREATE TIMESERIES root.testWithoutAnyNull.d1.s2 WITH DATATYPE=BOOLEAN, ENCODING=PLAIN", "CREATE TIMESERIES root.testWithoutAnyNull.d1.s3 WITH DATATYPE=DOUBLE, ENCODING=PLAIN", "INSERT INTO root.testWithoutAnyNull.d1(timestamp,s1,s2,s3) values(1, 21, false, 11.1)", "INSERT INTO root.testWithoutAnyNull.d1(timestamp,s1,s2) values(2, 22, true)", "INSERT INTO root.testWithoutAnyNull.d1(timestamp,s1,s2,s3) values(3, 23, false, 33.3)", "INSERT INTO root.testWithoutAnyNull.d1(timestamp,s1,s3) values(4, 24, 44.4)", "INSERT INTO root.testWithoutAnyNull.d1(timestamp,s2,s3) values(5, true, 55.5)", "INSERT INTO root.testWithoutAnyNull.d1(timestamp,s1) values(6, 26)", "INSERT INTO root.testWithoutAnyNull.d1(timestamp,s2) values(7, false)", "INSERT INTO root.testWithoutAnyNull.d1(timestamp,s3) values(8, 88.8)", "INSERT INTO root.testWithoutAnyNull.d1(timestamp,s1,s2,s3) values(9, 29, true, 99.9)", "flush", "INSERT INTO root.testWithoutAnyNull.d1(timestamp,s1,s2,s3) values(10, 20, true, 10.0)", "INSERT INTO root.testWithoutAnyNull.d1(timestamp,s1,s2,s3) values(11, 21, false, 11.1)", "INSERT INTO root.testWithoutAnyNull.d1(timestamp,s1,s2) values(12, 22, true)", "INSERT INTO root.testWithoutAnyNull.d1(timestamp,s1,s2,s3) values(13, 23, false, 33.3)", "INSERT INTO root.testWithoutAnyNull.d1(timestamp,s1,s3) values(14, 24, 44.4)", "INSERT INTO root.testWithoutAnyNull.d1(timestamp,s2,s3) values(15, true, 55.5)", "INSERT INTO root.testWithoutAnyNull.d1(timestamp,s1) values(16, 26)", "INSERT INTO root.testWithoutAnyNull.d1(timestamp,s2) values(17, false)", "INSERT INTO root.testWithoutAnyNull.d1(timestamp,s3) values(18, 88.8)", "INSERT INTO root.testWithoutAnyNull.d1(timestamp,s1,s2,s3) values(19, 29, true, 99.9)"};

    @BeforeClass
    public static void setUp() throws Exception {
        EnvironmentUtils.closeStatMonitor();
        EnvironmentUtils.envSetUp();
        IoTDBDescriptor.getInstance().getConfig().setPartitionInterval(1000L);
        Class.forName("org.apache.iotdb.jdbc.IoTDBDriver");
        IoTDBWithoutAnyNullIT.prepareData();
    }

    @AfterClass
    public static void tearDown() throws Exception {
        IoTDBDescriptor.getInstance().getConfig().setPartitionInterval(86400L);
        EnvironmentUtils.cleanEnv();
    }

    @Test
    public void withoutAnyNullTest1() {
        String[] retArray1 = new String[]{"1,21,false,11.1", "3,23,false,33.3", "9,29,true,99.9", "10,20,true,10.0", "11,21,false,11.1", "13,23,false,33.3", "19,29,true,99.9"};
        try (Connection connection = DriverManager.getConnection("jdbc:iotdb://127.0.0.1:6667/", "root", "root");
             Statement statement = connection.createStatement();){
            boolean hasResultSet = statement.execute("select * from root.testWithoutAnyNull.d1 WITHOUT NULL ANY");
            Assert.assertTrue((boolean)hasResultSet);
            try (ResultSet resultSet = statement.getResultSet();){
                int cnt = 0;
                while (resultSet.next()) {
                    String ans = resultSet.getString("Time") + "," + resultSet.getString("root.testWithoutAnyNull.d1.s1") + "," + resultSet.getString("root.testWithoutAnyNull.d1.s2") + "," + resultSet.getString("root.testWithoutAnyNull.d1.s3");
                    Assert.assertEquals((Object)retArray1[cnt], (Object)ans);
                    ++cnt;
                }
                Assert.assertEquals((long)retArray1.length, (long)cnt);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            Assert.fail((String)e.getMessage());
        }
    }

    @Test
    public void withoutAnyNullTest2() {
        String[] retArray = new String[]{"10,20,true,10.0", "11,21,false,11.1", "13,23,false,33.3", "19,29,true,99.9"};
        try (Connection connection = DriverManager.getConnection("jdbc:iotdb://127.0.0.1:6667/", "root", "root");
             Statement statement = connection.createStatement();){
            boolean hasResultSet = statement.execute("select * from root.testWithoutAnyNull.d1 WHERE time >= 10 WITHOUT NULL ANY");
            Assert.assertTrue((boolean)hasResultSet);
            try (ResultSet resultSet = statement.getResultSet();){
                int cnt = 0;
                while (resultSet.next()) {
                    String ans = resultSet.getString("Time") + "," + resultSet.getString("root.testWithoutAnyNull.d1.s1") + "," + resultSet.getString("root.testWithoutAnyNull.d1.s2") + "," + resultSet.getString("root.testWithoutAnyNull.d1.s3");
                    Assert.assertEquals((Object)retArray[cnt], (Object)ans);
                    ++cnt;
                }
                Assert.assertEquals((long)retArray.length, (long)cnt);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            Assert.fail((String)e.getMessage());
        }
    }

    @Test
    public void withoutAnyNullTest3() {
        String[] retArray1 = new String[]{"3,23,false,33.3", "9,29,true,99.9", "10,20,true,10.0", "11,21,false,11.1", "13,23,false,33.3"};
        try (Connection connection = DriverManager.getConnection("jdbc:iotdb://127.0.0.1:6667/", "root", "root");
             Statement statement = connection.createStatement();){
            boolean hasResultSet = statement.execute("select * from root.testWithoutAnyNull.d1 WITHOUT NULL ANY limit 5 offset 1");
            Assert.assertTrue((boolean)hasResultSet);
            try (ResultSet resultSet = statement.getResultSet();){
                int cnt = 0;
                while (resultSet.next()) {
                    String ans = resultSet.getString("Time") + "," + resultSet.getString("root.testWithoutAnyNull.d1.s1") + "," + resultSet.getString("root.testWithoutAnyNull.d1.s2") + "," + resultSet.getString("root.testWithoutAnyNull.d1.s3");
                    Assert.assertEquals((Object)retArray1[cnt], (Object)ans);
                    ++cnt;
                }
                Assert.assertEquals((long)retArray1.length, (long)cnt);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            Assert.fail((String)e.getMessage());
        }
    }

    private static void prepareData() {
        try (Connection connection = DriverManager.getConnection("jdbc:iotdb://127.0.0.1:6667/", "root", "root");
             Statement statement = connection.createStatement();){
            for (String sql : dataSet) {
                statement.execute(sql);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

