/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.integration;

import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.SQLException;
import java.sql.Statement;
import org.apache.iotdb.db.engine.version.SimpleFileVersionController;
import org.apache.iotdb.db.utils.EnvironmentUtils;
import org.junit.After;
import org.junit.Before;
import org.junit.Test;

public class IoTDBVersionIT {
    @Before
    public void setUp() {
        EnvironmentUtils.envSetUp();
    }

    @After
    public void tearDown() throws Exception {
        EnvironmentUtils.cleanEnv();
    }

    @Test
    public void testVersionPersist() throws SQLException, ClassNotFoundException {
        Class.forName("org.apache.iotdb.jdbc.IoTDBDriver");
        try (Connection connection = DriverManager.getConnection("jdbc:iotdb://127.0.0.1:6667/", "root", "root");
             Statement statement = connection.createStatement();){
            statement.execute("SET STORAGE GROUP TO root.versionTest1");
            statement.execute("SET STORAGE GROUP TO root.versionTest2");
            statement.execute("CREATE TIMESERIES root.versionTest1.s0 WITH DATATYPE=INT32,ENCODING=PLAIN");
            statement.execute("CREATE TIMESERIES root.versionTest2.s0 WITH DATATYPE=INT32,ENCODING=PLAIN");
            int i = 0;
            while ((long)i < SimpleFileVersionController.getSaveInterval() + 1L) {
                statement.execute(String.format("INSERT INTO root.versionTest1(timestamp, s0) VALUES (%d, %d)", i * 100, i));
                statement.execute("FLUSH");
                statement.execute("MERGE");
                ++i;
            }
        }
    }
}

