/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.integration;

import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Arrays;
import java.util.HashSet;
import org.apache.iotdb.db.conf.IoTDBDescriptor;
import org.apache.iotdb.db.exception.metadata.MetadataException;
import org.apache.iotdb.db.metadata.PartialPath;
import org.apache.iotdb.db.service.IoTDB;
import org.apache.iotdb.db.utils.EnvironmentUtils;
import org.apache.iotdb.tsfile.file.metadata.enums.CompressionType;
import org.apache.iotdb.tsfile.file.metadata.enums.TSDataType;
import org.apache.iotdb.tsfile.file.metadata.enums.TSEncoding;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Test;

public class IoTDBUDTFNonAlignQueryIT {
    protected static final int ITERATION_TIMES = 5000;
    protected static final int ADDEND = 500000000;
    protected static final int LIMIT = 500;
    protected static final int OFFSET = 500;
    protected static final int SLIMIT = 5;
    protected static final int SOFFSET = 2;

    @BeforeClass
    public static void setUp() throws Exception {
        IoTDBDescriptor.getInstance().getConfig().setUdfCollectorMemoryBudgetInMB(1.0f);
        IoTDBDescriptor.getInstance().getConfig().setUdfTransformerMemoryBudgetInMB(1.0f);
        IoTDBDescriptor.getInstance().getConfig().setUdfReaderMemoryBudgetInMB(1.0f);
        EnvironmentUtils.envSetUp();
        Class.forName("org.apache.iotdb.jdbc.IoTDBDriver");
        IoTDBUDTFNonAlignQueryIT.createTimeSeries();
        IoTDBUDTFNonAlignQueryIT.generateData();
        IoTDBUDTFNonAlignQueryIT.registerUDF();
    }

    private static void createTimeSeries() throws MetadataException {
        IoTDB.metaManager.setStorageGroup(new PartialPath("root.vehicle"));
        IoTDB.metaManager.createTimeseries(new PartialPath("root.vehicle.d1.s1"), TSDataType.INT32, TSEncoding.PLAIN, CompressionType.UNCOMPRESSED, null);
        IoTDB.metaManager.createTimeseries(new PartialPath("root.vehicle.d1.s2"), TSDataType.INT64, TSEncoding.PLAIN, CompressionType.UNCOMPRESSED, null);
        IoTDB.metaManager.createTimeseries(new PartialPath("root.vehicle.d2.s1"), TSDataType.FLOAT, TSEncoding.PLAIN, CompressionType.UNCOMPRESSED, null);
        IoTDB.metaManager.createTimeseries(new PartialPath("root.vehicle.d2.s2"), TSDataType.DOUBLE, TSEncoding.PLAIN, CompressionType.UNCOMPRESSED, null);
    }

    private static void generateData() {
        try (Connection connection = DriverManager.getConnection("jdbc:iotdb://127.0.0.1:6667/", "root", "root");
             Statement statement = connection.createStatement();){
            int i;
            for (i = 0; i < 5000; ++i) {
                statement.execute(String.format("insert into root.vehicle.d1(timestamp,s1,s2) values(%d,%d,%d)", i, i, i));
            }
            for (i = 0; i < 2500; ++i) {
                statement.execute(String.format("insert into root.vehicle.d2(timestamp,s1,s2) values(%d,%d,%d)", i, i, i));
            }
        }
        catch (SQLException throwable) {
            Assert.fail((String)throwable.getMessage());
        }
    }

    private static void registerUDF() {
        try (Connection connection = DriverManager.getConnection("jdbc:iotdb://127.0.0.1:6667/", "root", "root");
             Statement statement = connection.createStatement();){
            statement.execute("create function udf as \"org.apache.iotdb.db.query.udf.example.Adder\"");
        }
        catch (SQLException throwable) {
            Assert.fail((String)throwable.getMessage());
        }
    }

    @AfterClass
    public static void tearDown() throws Exception {
        EnvironmentUtils.cleanEnv();
        IoTDBDescriptor.getInstance().getConfig().setUdfCollectorMemoryBudgetInMB(100.0f);
        IoTDBDescriptor.getInstance().getConfig().setUdfTransformerMemoryBudgetInMB(100.0f);
        IoTDBDescriptor.getInstance().getConfig().setUdfReaderMemoryBudgetInMB(100.0f);
    }

    @Test
    public void queryWithoutValueFilter1() {
        String sqlStr = "select udf(*, *, \"addend\"=\"500000000\"), *, udf(*, *) from root.vehicle.d1 disable align";
        HashSet<Integer> s1AndS2WithAddend = new HashSet<Integer>(Arrays.asList(0, 1, 2, 3));
        HashSet<Integer> s1AndS2 = new HashSet<Integer>(Arrays.asList(6, 7, 8, 9));
        HashSet<Integer> s1OrS2 = new HashSet<Integer>(Arrays.asList(4, 5));
        try (Statement statement = DriverManager.getConnection("jdbc:iotdb://127.0.0.1:6667/", "root", "root").createStatement();){
            ResultSet resultSet = statement.executeQuery(sqlStr);
            int count = 0;
            int columnCount = resultSet.getMetaData().getColumnCount();
            Assert.assertEquals((long)20L, (long)columnCount);
            while (resultSet.next()) {
                for (int i = 1; i <= columnCount; ++i) {
                    String actualString = resultSet.getString(i);
                    int originalIndex = (i - 1) / 2;
                    if (i % 2 == 1) {
                        Assert.assertEquals((long)count, (long)((int)Double.parseDouble(actualString)));
                        continue;
                    }
                    if (s1AndS2WithAddend.contains(originalIndex)) {
                        Assert.assertEquals((long)(count * 2 + 500000000), (long)((int)Double.parseDouble(actualString)));
                        continue;
                    }
                    if (s1AndS2.contains(originalIndex)) {
                        Assert.assertEquals((long)(count * 2), (long)((int)Double.parseDouble(actualString)));
                        continue;
                    }
                    if (!s1OrS2.contains(originalIndex)) continue;
                    Assert.assertEquals((long)count, (long)((int)Double.parseDouble(actualString)));
                }
                ++count;
            }
            Assert.assertEquals((long)5000L, (long)count);
        }
        catch (SQLException throwable) {
            Assert.fail((String)throwable.getMessage());
        }
    }

    @Test
    public void queryWithoutValueFilter2() {
        String sqlStr = "select udf(d1.s1, d1.s2), udf(d2.s1, d2.s2) from root.vehicle disable align";
        try (Statement statement = DriverManager.getConnection("jdbc:iotdb://127.0.0.1:6667/", "root", "root").createStatement();){
            ResultSet resultSet = statement.executeQuery(sqlStr);
            int count = 0;
            int columnCount = resultSet.getMetaData().getColumnCount();
            Assert.assertEquals((long)4L, (long)columnCount);
            while (resultSet.next()) {
                for (int i = 1; i <= columnCount; ++i) {
                    String actualString = resultSet.getString(i);
                    int originalIndex = (i - 1) / 2;
                    if (i % 2 == 1) {
                        if (count < 2500 || originalIndex == 0) {
                            Assert.assertEquals((long)count, (long)((int)Double.parseDouble(actualString)));
                            continue;
                        }
                        Assert.assertNull((Object)actualString);
                        continue;
                    }
                    if (count < 2500 || originalIndex == 0) {
                        Assert.assertEquals((long)(2 * count), (long)((int)Double.parseDouble(actualString)));
                        continue;
                    }
                    Assert.assertNull((Object)actualString);
                }
                ++count;
            }
            Assert.assertEquals((long)5000L, (long)count);
        }
        catch (SQLException throwable) {
            Assert.fail((String)throwable.getMessage());
        }
    }

    @Test
    public void queryWithValueFilter1() {
        String sqlStr = "select udf(d2.s2, d2.s1), udf(d2.s1, d2.s2), d2.s1, d2.s2, udf(d2.s1, d2.s2), udf(d2.s2, d2.s1), d2.s1, d2.s2 from root.vehicle" + String.format(" where d2.s1 >= %d and d2.s2 < %d disable align", 1250, 3750);
        HashSet<Integer> s1s2 = new HashSet<Integer>(Arrays.asList(0, 1, 4, 5));
        HashSet<Integer> s1 = new HashSet<Integer>(Arrays.asList(2, 6));
        HashSet<Integer> s2 = new HashSet<Integer>(Arrays.asList(3, 7));
        try (Statement statement = DriverManager.getConnection("jdbc:iotdb://127.0.0.1:6667/", "root", "root").createStatement();){
            ResultSet resultSet = statement.executeQuery(sqlStr);
            int index = 1250;
            int columnCount = resultSet.getMetaData().getColumnCount();
            Assert.assertEquals((long)16L, (long)columnCount);
            while (resultSet.next()) {
                for (int i = 1; i <= columnCount; ++i) {
                    String actualString = resultSet.getString(i);
                    int originalIndex = (i - 1) / 2;
                    if (i % 2 == 1) {
                        Assert.assertEquals((long)index, (long)((int)Double.parseDouble(actualString)));
                        continue;
                    }
                    if (s1s2.contains(originalIndex)) {
                        Assert.assertEquals((long)(index * 2), (long)((int)Double.parseDouble(actualString)));
                        continue;
                    }
                    if (s1.contains(originalIndex)) {
                        Assert.assertEquals((long)index, (long)((int)Double.parseDouble(actualString)));
                        continue;
                    }
                    if (!s2.contains(originalIndex)) continue;
                    Assert.assertEquals((long)index, (long)((int)Double.parseDouble(actualString)));
                }
                ++index;
            }
            Assert.assertEquals((long)1250L, (long)(index - 1250));
        }
        catch (SQLException throwable) {
            Assert.fail((String)throwable.getMessage());
        }
    }

    @Test
    public void queryWithValueFilter2() {
        String sqlStr = "select udf(*, *) from root.vehicle.d1, root.vehicle.d1" + String.format(" where root.vehicle.d1.s1 >= %d and root.vehicle.d1.s2 < %d disable align", 1500, 3500);
        try (Statement statement = DriverManager.getConnection("jdbc:iotdb://127.0.0.1:6667/", "root", "root").createStatement();){
            ResultSet resultSet = statement.executeQuery(sqlStr);
            int index = 1500;
            int columnCount = resultSet.getMetaData().getColumnCount();
            Assert.assertEquals((long)32L, (long)columnCount);
            while (resultSet.next()) {
                for (int i = 1; i <= columnCount; ++i) {
                    String actualString = resultSet.getString(i);
                    if (i % 2 == 1) {
                        Assert.assertEquals((long)index, (long)((int)Double.parseDouble(actualString)));
                        continue;
                    }
                    Assert.assertEquals((double)(2 * index), (double)Double.parseDouble(actualString), (double)0.0);
                }
                ++index;
            }
            Assert.assertEquals((long)2000L, (long)(index - 1500));
        }
        catch (SQLException throwable) {
            Assert.fail((String)throwable.getMessage());
        }
    }

    @Test
    public void queryWithValueFilter3() {
        String sqlStr = "select udf(d2.s2, d2.s1), udf(d2.s1, d2.s2), d2.s1, d2.s2, udf(d2.s1, d2.s2), udf(d2.s2, d2.s1), d2.s1, d2.s2 from root.vehicle" + String.format(" where d2.s1 >= %d and d2.s2 < %d slimit %d soffset %d disable align", 1250, 3750, 5, 2);
        HashSet<Integer> s1s2 = new HashSet<Integer>(Arrays.asList(0, 1, 4, 5));
        HashSet<Integer> s1 = new HashSet<Integer>(Arrays.asList(2, 6));
        HashSet<Integer> s2 = new HashSet<Integer>(Arrays.asList(3, 7));
        try (Statement statement = DriverManager.getConnection("jdbc:iotdb://127.0.0.1:6667/", "root", "root").createStatement();){
            ResultSet resultSet = statement.executeQuery(sqlStr);
            int index = 1250;
            int columnCount = resultSet.getMetaData().getColumnCount();
            Assert.assertEquals((long)10L, (long)columnCount);
            while (resultSet.next()) {
                for (int i = 1; i <= columnCount; ++i) {
                    String actualString = resultSet.getString(i);
                    int originalIndex = (i - 1) / 2 + 2;
                    if (i % 2 == 1) {
                        Assert.assertEquals((long)index, (long)((int)Double.parseDouble(actualString)));
                        continue;
                    }
                    if (s1s2.contains(originalIndex)) {
                        Assert.assertEquals((long)(index * 2), (long)((int)Double.parseDouble(actualString)));
                        continue;
                    }
                    if (s1.contains(originalIndex)) {
                        Assert.assertEquals((long)index, (long)((int)Double.parseDouble(actualString)));
                        continue;
                    }
                    if (!s2.contains(originalIndex)) continue;
                    Assert.assertEquals((long)index, (long)((int)Double.parseDouble(actualString)));
                }
                ++index;
            }
            Assert.assertEquals((long)1250L, (long)(index - 1250));
        }
        catch (SQLException throwable) {
            Assert.fail((String)throwable.getMessage());
        }
    }

    @Test
    public void queryWithValueFilter4() {
        String sqlStr = "select udf(*, *) from root.vehicle.d1, root.vehicle.d1" + String.format(" where root.vehicle.d1.s1 >= %d and root.vehicle.d1.s2 < %d limit %d offset %d disable align", 1500, 3500, 500, 500);
        try (Statement statement = DriverManager.getConnection("jdbc:iotdb://127.0.0.1:6667/", "root", "root").createStatement();){
            ResultSet resultSet = statement.executeQuery(sqlStr);
            int index = 2000;
            int columnCount = resultSet.getMetaData().getColumnCount();
            Assert.assertEquals((long)32L, (long)columnCount);
            while (resultSet.next()) {
                for (int i = 1; i <= columnCount; ++i) {
                    String actualString = resultSet.getString(i);
                    if (i % 2 == 1) {
                        Assert.assertEquals((long)index, (long)((int)Double.parseDouble(actualString)));
                        continue;
                    }
                    Assert.assertEquals((double)(2 * index), (double)Double.parseDouble(actualString), (double)0.0);
                }
                ++index;
            }
            Assert.assertEquals((long)500L, (long)(index - 2000));
        }
        catch (SQLException throwable) {
            Assert.fail((String)throwable.getMessage());
        }
    }
}

