/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.integration;

import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import org.apache.iotdb.db.exception.metadata.MetadataException;
import org.apache.iotdb.db.metadata.PartialPath;
import org.apache.iotdb.db.service.IoTDB;
import org.apache.iotdb.db.utils.EnvironmentUtils;
import org.apache.iotdb.tsfile.file.metadata.enums.CompressionType;
import org.apache.iotdb.tsfile.file.metadata.enums.TSDataType;
import org.apache.iotdb.tsfile.file.metadata.enums.TSEncoding;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Test;

public class IoTDBUDTFBuiltinFunctionIT {
    private static final double E = 1.0E-4;
    private static final String[] INSERTION_SQLS = new String[]{"insert into root.sg.d1(time, s1, s2, s3, s4, s5, s6) values (0, 0, 0, 0, 0, true, '0')", "insert into root.sg.d1(time, s1, s2, s3, s4, s5, s6) values (2, 1, 1, 1, 1, false, '1')", "insert into root.sg.d1(time, s1, s2, s3, s4, s5, s6) values (4, 2, 2, 2, 2, false, '2')", "insert into root.sg.d1(time, s1, s2, s3, s4, s5, s6) values (6, 3, 3, 3, 3, true, '3')", "insert into root.sg.d1(time, s1, s2, s3, s4, s5, s6) values (8, 4, 4, 4, 4, true, '4')"};

    @BeforeClass
    public static void setUp() throws Exception {
        EnvironmentUtils.envSetUp();
        Class.forName("org.apache.iotdb.jdbc.IoTDBDriver");
        IoTDBUDTFBuiltinFunctionIT.createTimeSeries();
        IoTDBUDTFBuiltinFunctionIT.generateData();
    }

    private static void createTimeSeries() throws MetadataException {
        IoTDB.metaManager.setStorageGroup(new PartialPath("root.sg"));
        IoTDB.metaManager.createTimeseries(new PartialPath("root.sg.d1.s1"), TSDataType.INT32, TSEncoding.PLAIN, CompressionType.UNCOMPRESSED, null);
        IoTDB.metaManager.createTimeseries(new PartialPath("root.sg.d1.s2"), TSDataType.INT64, TSEncoding.PLAIN, CompressionType.UNCOMPRESSED, null);
        IoTDB.metaManager.createTimeseries(new PartialPath("root.sg.d1.s3"), TSDataType.FLOAT, TSEncoding.PLAIN, CompressionType.UNCOMPRESSED, null);
        IoTDB.metaManager.createTimeseries(new PartialPath("root.sg.d1.s4"), TSDataType.DOUBLE, TSEncoding.PLAIN, CompressionType.UNCOMPRESSED, null);
        IoTDB.metaManager.createTimeseries(new PartialPath("root.sg.d1.s5"), TSDataType.BOOLEAN, TSEncoding.PLAIN, CompressionType.UNCOMPRESSED, null);
        IoTDB.metaManager.createTimeseries(new PartialPath("root.sg.d1.s6"), TSDataType.TEXT, TSEncoding.PLAIN, CompressionType.UNCOMPRESSED, null);
    }

    private static void generateData() {
        try (Connection connection = DriverManager.getConnection("jdbc:iotdb://127.0.0.1:6667/", "root", "root");
             Statement statement = connection.createStatement();){
            for (String dataGenerationSql : INSERTION_SQLS) {
                statement.execute(dataGenerationSql);
            }
        }
        catch (SQLException throwable) {
            Assert.fail((String)throwable.getMessage());
        }
    }

    @AfterClass
    public static void tearDown() throws Exception {
        EnvironmentUtils.cleanEnv();
    }

    @Test
    public void testMathFunctions() {
        this.testMathFunction("sin", Math::sin);
        this.testMathFunction("cos", Math::cos);
        this.testMathFunction("tan", Math::tan);
        this.testMathFunction("asin", Math::asin);
        this.testMathFunction("acos", Math::acos);
        this.testMathFunction("atan", Math::atan);
        this.testMathFunction("degrees", Math::toDegrees);
        this.testMathFunction("radians", Math::toRadians);
        this.testMathFunction("abs", Math::abs);
        this.testMathFunction("sign", Math::signum);
        this.testMathFunction("ceil", Math::ceil);
        this.testMathFunction("floor", Math::floor);
        this.testMathFunction("round", Math::rint);
        this.testMathFunction("exp", Math::exp);
        this.testMathFunction("ln", Math::log);
        this.testMathFunction("log10", Math::log10);
        this.testMathFunction("sqrt", Math::sqrt);
    }

    private void testMathFunction(String functionName, MathFunctionProxy functionProxy) {
        try (Statement statement = DriverManager.getConnection("jdbc:iotdb://127.0.0.1:6667/", "root", "root").createStatement();){
            ResultSet resultSet = statement.executeQuery(String.format("select %s(s1), %s(s2), %s(s3), %s(s4) from root.sg.d1", functionName, functionName, functionName, functionName));
            int columnCount = resultSet.getMetaData().getColumnCount();
            Assert.assertEquals((long)5L, (long)columnCount);
            for (int i = 0; i < INSERTION_SQLS.length; ++i) {
                resultSet.next();
                for (int j = 0; j < 4; ++j) {
                    double expected = functionProxy.invoke(i);
                    double actual = Double.parseDouble(resultSet.getString(2 + j));
                    Assert.assertEquals((double)expected, (double)actual, (double)1.0E-4);
                }
            }
        }
        catch (SQLException throwable) {
            Assert.fail((String)throwable.getMessage());
        }
    }

    @Test
    public void testSelectorFunctions() {
        int j;
        int i;
        int columnCount;
        ResultSet resultSet;
        Statement statement;
        String TOP_K = "TOP_K";
        String BOTTOM_K = "BOTTOM_K";
        String K = "'k'='2'";
        try {
            statement = DriverManager.getConnection("jdbc:iotdb://127.0.0.1:6667/", "root", "root").createStatement();
            try {
                resultSet = statement.executeQuery(String.format("select %s(s1, %s), %s(s2, %s), %s(s3, %s), %s(s4, %s), %s(s6, %s) from root.sg.d1", "TOP_K", "'k'='2'", "TOP_K", "'k'='2'", "TOP_K", "'k'='2'", "TOP_K", "'k'='2'", "TOP_K", "'k'='2'"));
                columnCount = resultSet.getMetaData().getColumnCount();
                Assert.assertEquals((long)6L, (long)columnCount);
                for (i = INSERTION_SQLS.length - 2; i < INSERTION_SQLS.length; ++i) {
                    resultSet.next();
                    for (j = 0; j < 5; ++j) {
                        Assert.assertEquals((double)i, (double)Double.parseDouble(resultSet.getString(2 + j)), (double)1.0E-4);
                    }
                }
            }
            finally {
                if (statement != null) {
                    statement.close();
                }
            }
        }
        catch (SQLException throwable) {
            Assert.fail((String)throwable.getMessage());
        }
        try {
            statement = DriverManager.getConnection("jdbc:iotdb://127.0.0.1:6667/", "root", "root").createStatement();
            try {
                resultSet = statement.executeQuery(String.format("select %s(s1, %s), %s(s2, %s), %s(s3, %s), %s(s4, %s), %s(s6, %s) from root.sg.d1", "BOTTOM_K", "'k'='2'", "BOTTOM_K", "'k'='2'", "BOTTOM_K", "'k'='2'", "BOTTOM_K", "'k'='2'", "BOTTOM_K", "'k'='2'"));
                columnCount = resultSet.getMetaData().getColumnCount();
                Assert.assertEquals((long)6L, (long)columnCount);
                for (i = 0; i < 2; ++i) {
                    resultSet.next();
                    for (j = 0; j < 5; ++j) {
                        Assert.assertEquals((double)i, (double)Double.parseDouble(resultSet.getString(2 + j)), (double)1.0E-4);
                    }
                }
            }
            finally {
                if (statement != null) {
                    statement.close();
                }
            }
        }
        catch (SQLException throwable) {
            Assert.fail((String)throwable.getMessage());
        }
    }

    @Test
    public void testStringProcessingFunctions() {
        try (Statement statement = DriverManager.getConnection("jdbc:iotdb://127.0.0.1:6667/", "root", "root").createStatement();){
            ResultSet resultSet = statement.executeQuery("select STRING_CONTAINS(s6, 's'='0'), STRING_MATCHES(s6, 'regex'='\\d') from root.sg.d1");
            int columnCount = resultSet.getMetaData().getColumnCount();
            Assert.assertEquals((long)3L, (long)columnCount);
            for (int i = 0; i < INSERTION_SQLS.length; ++i) {
                resultSet.next();
                if (i == 0) {
                    Assert.assertTrue((boolean)Boolean.parseBoolean(resultSet.getString(2)));
                } else {
                    Assert.assertFalse((boolean)Boolean.parseBoolean(resultSet.getString(2)));
                }
                Assert.assertTrue((boolean)Boolean.parseBoolean(resultSet.getString(3)));
            }
        }
        catch (SQLException throwable) {
            Assert.fail((String)throwable.getMessage());
        }
    }

    @Test
    public void testVariationTrendCalculationFunctions() {
        this.testVariationTrendCalculationFunction("TIME_DIFFERENCE", 2.0);
        this.testVariationTrendCalculationFunction("DIFFERENCE", 1.0);
        this.testVariationTrendCalculationFunction("NON_NEGATIVE_DIFFERENCE", 1.0);
        this.testVariationTrendCalculationFunction("DERIVATIVE", 0.5);
        this.testVariationTrendCalculationFunction("NON_NEGATIVE_DERIVATIVE", 0.5);
    }

    public void testVariationTrendCalculationFunction(String functionName, double expected) {
        try (Statement statement = DriverManager.getConnection("jdbc:iotdb://127.0.0.1:6667/", "root", "root").createStatement();){
            ResultSet resultSet = statement.executeQuery(String.format("select %s(s1), %s(s2), %s(s3), %s(s4) from root.sg.d1", functionName, functionName, functionName, functionName));
            int columnCount = resultSet.getMetaData().getColumnCount();
            Assert.assertEquals((long)5L, (long)columnCount);
            for (int i = 0; i < INSERTION_SQLS.length - 1; ++i) {
                resultSet.next();
                for (int j = 0; j < 4; ++j) {
                    Assert.assertEquals((double)expected, (double)Double.parseDouble(resultSet.getString(2 + j)), (double)1.0E-4);
                }
            }
        }
        catch (SQLException throwable) {
            Assert.fail((String)throwable.getMessage());
        }
    }

    private static interface MathFunctionProxy {
        public double invoke(double var1);
    }
}

