/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.integration;

import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Arrays;
import java.util.HashSet;
import org.apache.iotdb.db.conf.IoTDBDescriptor;
import org.apache.iotdb.db.exception.metadata.MetadataException;
import org.apache.iotdb.db.metadata.PartialPath;
import org.apache.iotdb.db.service.IoTDB;
import org.apache.iotdb.db.utils.EnvironmentUtils;
import org.apache.iotdb.tsfile.file.metadata.enums.CompressionType;
import org.apache.iotdb.tsfile.file.metadata.enums.TSDataType;
import org.apache.iotdb.tsfile.file.metadata.enums.TSEncoding;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Test;

public class IoTDBUDTFAlignByTimeQueryIT {
    protected static final int ITERATION_TIMES = 10000;
    protected static final int ADDEND = 500000000;
    protected static final int LIMIT = 1000;
    protected static final int OFFSET = 1000;
    protected static final int SLIMIT = 10;
    protected static final int SOFFSET = 2;

    @BeforeClass
    public static void setUp() throws Exception {
        IoTDBDescriptor.getInstance().getConfig().setUdfCollectorMemoryBudgetInMB(1.0f);
        IoTDBDescriptor.getInstance().getConfig().setUdfTransformerMemoryBudgetInMB(1.0f);
        IoTDBDescriptor.getInstance().getConfig().setUdfReaderMemoryBudgetInMB(1.0f);
        EnvironmentUtils.envSetUp();
        Class.forName("org.apache.iotdb.jdbc.IoTDBDriver");
        IoTDBUDTFAlignByTimeQueryIT.createTimeSeries();
        IoTDBUDTFAlignByTimeQueryIT.generateData();
        IoTDBUDTFAlignByTimeQueryIT.registerUDF();
    }

    private static void createTimeSeries() throws MetadataException {
        IoTDB.metaManager.setStorageGroup(new PartialPath("root.vehicle"));
        IoTDB.metaManager.createTimeseries(new PartialPath("root.vehicle.d1.s1"), TSDataType.INT32, TSEncoding.PLAIN, CompressionType.UNCOMPRESSED, null);
        IoTDB.metaManager.createTimeseries(new PartialPath("root.vehicle.d1.s2"), TSDataType.INT64, TSEncoding.PLAIN, CompressionType.UNCOMPRESSED, null);
        IoTDB.metaManager.createTimeseries(new PartialPath("root.vehicle.d2.s1"), TSDataType.FLOAT, TSEncoding.PLAIN, CompressionType.UNCOMPRESSED, null);
        IoTDB.metaManager.createTimeseries(new PartialPath("root.vehicle.d2.s2"), TSDataType.DOUBLE, TSEncoding.PLAIN, CompressionType.UNCOMPRESSED, null);
        IoTDB.metaManager.createTimeseries(new PartialPath("root.vehicle.d3.s1"), TSDataType.FLOAT, TSEncoding.PLAIN, CompressionType.UNCOMPRESSED, null);
        IoTDB.metaManager.createTimeseries(new PartialPath("root.vehicle.d3.s2"), TSDataType.DOUBLE, TSEncoding.PLAIN, CompressionType.UNCOMPRESSED, null);
        IoTDB.metaManager.createTimeseries(new PartialPath("root.vehicle.d4.s1"), TSDataType.INT32, TSEncoding.PLAIN, CompressionType.UNCOMPRESSED, null);
        IoTDB.metaManager.createTimeseries(new PartialPath("root.vehicle.d4.s2"), TSDataType.INT32, TSEncoding.PLAIN, CompressionType.UNCOMPRESSED, null);
    }

    private static void generateData() {
        try (Connection connection = DriverManager.getConnection("jdbc:iotdb://127.0.0.1:6667/", "root", "root");
             Statement statement = connection.createStatement();){
            for (int i = 0; i < 10000; ++i) {
                statement.execute(i % 3 != 0 ? String.format("insert into root.vehicle.d1(timestamp,s1,s2) values(%d,%d,%d)", i, i, i) : (i % 2 == 0 ? String.format("insert into root.vehicle.d1(timestamp,s1) values(%d,%d)", i, i) : String.format("insert into root.vehicle.d1(timestamp,s2) values(%d,%d)", i, i)));
                statement.execute(String.format("insert into root.vehicle.d2(timestamp,s1,s2) values(%d,%d,%d)", i, i, i));
                statement.execute(String.format("insert into root.vehicle.d3(timestamp,s1,s2) values(%d,%d,%d)", i, i, i));
                statement.execute(String.format("insert into root.vehicle.d4(timestamp,s1) values(%d,%d)", 2 * i, 3 * i));
            }
        }
        catch (SQLException throwable) {
            Assert.fail((String)throwable.getMessage());
        }
    }

    private static void registerUDF() {
        try (Connection connection = DriverManager.getConnection("jdbc:iotdb://127.0.0.1:6667/", "root", "root");
             Statement statement = connection.createStatement();){
            statement.execute("create function udf as \"org.apache.iotdb.db.query.udf.example.Adder\"");
            statement.execute("create function multiplier as \"org.apache.iotdb.db.query.udf.example.Multiplier\"");
            statement.execute("create function max as \"org.apache.iotdb.db.query.udf.example.Max\"");
            statement.execute("create function terminate as \"org.apache.iotdb.db.query.udf.example.TerminateTester\"");
            statement.execute("create function validate as \"org.apache.iotdb.db.query.udf.example.ValidateTester\"");
        }
        catch (SQLException throwable) {
            Assert.fail((String)throwable.getMessage());
        }
    }

    @AfterClass
    public static void tearDown() throws Exception {
        EnvironmentUtils.cleanEnv();
        IoTDBDescriptor.getInstance().getConfig().setUdfCollectorMemoryBudgetInMB(100.0f);
        IoTDBDescriptor.getInstance().getConfig().setUdfTransformerMemoryBudgetInMB(100.0f);
        IoTDBDescriptor.getInstance().getConfig().setUdfReaderMemoryBudgetInMB(100.0f);
    }

    @Test
    public void queryWithoutValueFilter1() {
        String sqlStr = "select udf(d1.s2, d1.s1), udf(d1.s1, d1.s2), d1.s1, d1.s2, udf(d1.s1, d1.s2), udf(d1.s2, d1.s1), d1.s1, d1.s2 from root.vehicle";
        HashSet<Integer> s1s2 = new HashSet<Integer>(Arrays.asList(0, 1, 4, 5));
        HashSet<Integer> s1 = new HashSet<Integer>(Arrays.asList(2, 6));
        HashSet<Integer> s2 = new HashSet<Integer>(Arrays.asList(3, 7));
        try (Statement statement = DriverManager.getConnection("jdbc:iotdb://127.0.0.1:6667/", "root", "root").createStatement();){
            ResultSet resultSet = statement.executeQuery(sqlStr);
            int count = 0;
            int columnCount = resultSet.getMetaData().getColumnCount();
            Assert.assertEquals((long)9L, (long)columnCount);
            while (resultSet.next()) {
                StringBuilder expected = new StringBuilder();
                StringBuilder actual = new StringBuilder();
                for (int i = 2; i <= columnCount; ++i) {
                    String actualString = resultSet.getString(i);
                    actual.append(actualString == null ? "null" : Double.valueOf(Double.parseDouble(actualString))).append(", ");
                    if (s1s2.contains(i - 2)) {
                        expected.append(count % 3 != 0 ? Float.valueOf(count * 2) : "null").append(", ");
                        continue;
                    }
                    if (s1.contains(i - 2)) {
                        expected.append(count % 3 != 0 || count % 2 == 0 ? Float.valueOf(count) : "null").append(", ");
                        continue;
                    }
                    if (!s2.contains(i - 2)) continue;
                    expected.append(count % 3 != 0 || count % 2 != 0 ? Float.valueOf(count) : "null").append(", ");
                }
                Assert.assertEquals((Object)expected.toString(), (Object)actual.toString());
                ++count;
            }
            Assert.assertEquals((long)10000L, (long)count);
        }
        catch (SQLException throwable) {
            Assert.fail((String)throwable.getMessage());
        }
    }

    @Test
    public void queryWithoutValueFilter2() {
        String sqlStr = "select udf(*, *) from root.vehicle.d1";
        try (Statement statement = DriverManager.getConnection("jdbc:iotdb://127.0.0.1:6667/", "root", "root").createStatement();){
            ResultSet resultSet = statement.executeQuery(sqlStr);
            int count = 0;
            int columnCount = resultSet.getMetaData().getColumnCount();
            Assert.assertEquals((long)5L, (long)columnCount);
            while (resultSet.next()) {
                for (int i = 2; i <= columnCount; ++i) {
                    String actualString = resultSet.getString(i);
                    Assert.assertTrue((actualString == null || (int)Double.parseDouble(actualString) == count * 2 ? 1 : 0) != 0);
                }
                ++count;
            }
            Assert.assertEquals((long)10000L, (long)count);
        }
        catch (SQLException throwable) {
            Assert.fail((String)throwable.getMessage());
        }
    }

    @Test
    public void queryWithoutValueFilter3() {
        String sqlStr = "select *, udf(*, *), *, udf(*, *), * from root.vehicle.d1";
        HashSet<Integer> s1AndS2 = new HashSet<Integer>(Arrays.asList(2, 3, 4, 5, 8, 9, 10, 11));
        HashSet<Integer> s1OrS2 = new HashSet<Integer>(Arrays.asList(0, 1, 6, 7, 12, 13));
        try (Statement statement = DriverManager.getConnection("jdbc:iotdb://127.0.0.1:6667/", "root", "root").createStatement();){
            ResultSet resultSet = statement.executeQuery(sqlStr);
            int count = 0;
            int columnCount = resultSet.getMetaData().getColumnCount();
            Assert.assertEquals((long)15L, (long)columnCount);
            while (resultSet.next()) {
                for (int i = 2; i <= columnCount; ++i) {
                    String actualString = resultSet.getString(i);
                    if (s1AndS2.contains(i - 2)) {
                        Assert.assertTrue((actualString == null || (int)Double.parseDouble(actualString) == count * 2 ? 1 : 0) != 0);
                        continue;
                    }
                    if (!s1OrS2.contains(i - 2)) continue;
                    Assert.assertTrue((actualString == null || (int)Double.parseDouble(actualString) == count ? 1 : 0) != 0);
                }
                ++count;
            }
            Assert.assertEquals((long)10000L, (long)count);
        }
        catch (SQLException throwable) {
            Assert.fail((String)throwable.getMessage());
        }
    }

    @Test
    public void queryWithoutValueFilter4() {
        String sqlStr = "select udf(*, *, \"addend\"=\"500000000\"), *, udf(*, *) from root.vehicle.d1";
        HashSet<Integer> s1AndS2WithAddend = new HashSet<Integer>(Arrays.asList(0, 1, 2, 3));
        HashSet<Integer> s1AndS2 = new HashSet<Integer>(Arrays.asList(6, 7, 8, 9));
        HashSet<Integer> s1OrS2 = new HashSet<Integer>(Arrays.asList(4, 5));
        try (Statement statement = DriverManager.getConnection("jdbc:iotdb://127.0.0.1:6667/", "root", "root").createStatement();){
            ResultSet resultSet = statement.executeQuery(sqlStr);
            int count = 0;
            int columnCount = resultSet.getMetaData().getColumnCount();
            Assert.assertEquals((long)11L, (long)columnCount);
            while (resultSet.next()) {
                for (int i = 2; i <= columnCount; ++i) {
                    String actualString = resultSet.getString(i);
                    if (s1AndS2WithAddend.contains(i - 2)) {
                        Assert.assertTrue((actualString == null || (int)Double.parseDouble(actualString) == count * 2 + 500000000 ? 1 : 0) != 0);
                        continue;
                    }
                    if (s1AndS2.contains(i - 2)) {
                        Assert.assertTrue((actualString == null || (int)Double.parseDouble(actualString) == count * 2 ? 1 : 0) != 0);
                        continue;
                    }
                    if (!s1OrS2.contains(i - 2)) continue;
                    Assert.assertTrue((actualString == null || (int)Double.parseDouble(actualString) == count ? 1 : 0) != 0);
                }
                ++count;
            }
            Assert.assertEquals((long)10000L, (long)count);
        }
        catch (SQLException throwable) {
            Assert.fail((String)throwable.getMessage());
        }
    }

    @Test
    public void queryWithoutValueFilter5() {
        String sqlStr = "select multiplier(s2, \"a\"=\"2\", \"b\"=\"5\") from root.vehicle.d1";
        try (Statement statement = DriverManager.getConnection("jdbc:iotdb://127.0.0.1:6667/", "root", "root").createStatement();){
            ResultSet resultSet = statement.executeQuery(sqlStr);
            Assert.assertEquals((long)2L, (long)resultSet.getMetaData().getColumnCount());
            Assert.assertEquals((Object)"Time", (Object)resultSet.getMetaData().getColumnName(1));
            Assert.assertEquals((Object)"multiplier(root.vehicle.d1.s2, \"a\"=\"2\", \"b\"=\"5\")", (Object)resultSet.getMetaData().getColumnName(2));
            for (int i = 0; i < 10000; ++i) {
                if (i % 3 == 0 && i % 2 == 0) continue;
                Assert.assertTrue((boolean)resultSet.next());
                Assert.assertEquals((long)(i * 2 * 5), (long)Integer.parseInt(resultSet.getString(2)));
            }
        }
        catch (SQLException throwable) {
            Assert.fail((String)throwable.getMessage());
        }
    }

    @Test
    public void queryWithoutValueFilter6() {
        String sqlStr = "select max(s1), max(s2) from root.vehicle.d4";
        try (Statement statement = DriverManager.getConnection("jdbc:iotdb://127.0.0.1:6667/", "root", "root").createStatement();){
            ResultSet resultSet = statement.executeQuery(sqlStr);
            Assert.assertEquals((long)3L, (long)resultSet.getMetaData().getColumnCount());
            Assert.assertEquals((Object)"Time", (Object)resultSet.getMetaData().getColumnName(1));
            String columnS1 = "max(root.vehicle.d4.s1)";
            String columnS2 = "max(root.vehicle.d4.s2)";
            Assert.assertTrue((columnS1.equals(resultSet.getMetaData().getColumnName(2)) || columnS2.equals(resultSet.getMetaData().getColumnName(2)) ? 1 : 0) != 0);
            Assert.assertTrue((columnS1.equals(resultSet.getMetaData().getColumnName(3)) || columnS2.equals(resultSet.getMetaData().getColumnName(3)) ? 1 : 0) != 0);
            Assert.assertTrue((boolean)resultSet.next());
            Assert.assertEquals((long)29997L, (long)Integer.parseInt(resultSet.getString(columnS1)));
            Assert.assertNull((Object)resultSet.getString(columnS2));
            Assert.assertFalse((boolean)resultSet.next());
        }
        catch (SQLException throwable) {
            Assert.fail((String)throwable.getMessage());
        }
    }

    @Test
    public void queryWithoutValueFilter7() {
        String sqlStr = "select terminate(s1), terminate(s2) from root.vehicle.d4";
        try (Statement statement = DriverManager.getConnection("jdbc:iotdb://127.0.0.1:6667/", "root", "root").createStatement();){
            ResultSet resultSet = statement.executeQuery(sqlStr);
            Assert.assertEquals((long)3L, (long)resultSet.getMetaData().getColumnCount());
            Assert.assertEquals((Object)"Time", (Object)resultSet.getMetaData().getColumnName(1));
            String columnS1 = "terminate(root.vehicle.d4.s1)";
            String columnS2 = "terminate(root.vehicle.d4.s2)";
            Assert.assertTrue((columnS1.equals(resultSet.getMetaData().getColumnName(2)) || columnS2.equals(resultSet.getMetaData().getColumnName(2)) ? 1 : 0) != 0);
            Assert.assertTrue((columnS1.equals(resultSet.getMetaData().getColumnName(3)) || columnS2.equals(resultSet.getMetaData().getColumnName(3)) ? 1 : 0) != 0);
            for (int i = 0; i < 10000; ++i) {
                Assert.assertTrue((boolean)resultSet.next());
                Assert.assertEquals((long)1L, (long)Integer.parseInt(resultSet.getString(columnS1)));
                Assert.assertNull((Object)resultSet.getString(columnS2));
            }
            Assert.assertTrue((boolean)resultSet.next());
            Assert.assertEquals((long)10000L, (long)Integer.parseInt(resultSet.getString(columnS1)));
            Assert.assertNull((Object)resultSet.getString(columnS2));
            Assert.assertFalse((boolean)resultSet.next());
        }
        catch (SQLException throwable) {
            Assert.fail((String)throwable.getMessage());
        }
    }

    @Test
    public void queryWithoutValueFilter8() {
        String sqlStr = "select validate(s1, s2, 'k'='') from root.vehicle.d3";
        try (Statement statement = DriverManager.getConnection("jdbc:iotdb://127.0.0.1:6667/", "root", "root").createStatement();){
            statement.executeQuery(sqlStr);
            Assert.fail();
        }
        catch (SQLException throwable) {
            Assert.assertTrue((boolean)throwable.getMessage().contains("the data type of the input series (index: 0) is not valid. expected: [INT32, INT64]. actual: FLOAT."));
        }
    }

    @Test
    public void queryWithoutValueFilter9() {
        String sqlStr = "select validate(s1, s2, s1, 'k'=''), * from root.vehicle.d1";
        try (Statement statement = DriverManager.getConnection("jdbc:iotdb://127.0.0.1:6667/", "root", "root").createStatement();){
            statement.executeQuery(sqlStr);
            Assert.fail();
        }
        catch (SQLException throwable) {
            Assert.assertTrue((boolean)throwable.getMessage().contains("the number of the input series is not valid. expected: 2. actual: 3."));
        }
    }

    @Test
    public void queryWithoutValueFilter10() {
        String sqlStr = "select validate(s1, s2), * from root.vehicle.d1";
        try (Statement statement = DriverManager.getConnection("jdbc:iotdb://127.0.0.1:6667/", "root", "root").createStatement();){
            statement.executeQuery(sqlStr);
            Assert.fail();
        }
        catch (SQLException throwable) {
            Assert.assertTrue((boolean)throwable.getMessage().contains("attribute \"k\" is required but was not provided."));
        }
    }

    @Test
    public void queryWithValueFilter1() {
        String sqlStr = "select udf(d2.s2, d2.s1), udf(d2.s1, d2.s2), d2.s1, d2.s2, udf(d2.s1, d2.s2), udf(d2.s2, d2.s1), d2.s1, d2.s2 from root.vehicle" + String.format(" where d2.s1 >= %d and d2.s2 < %d", 2500, 7500);
        HashSet<Integer> s1s2 = new HashSet<Integer>(Arrays.asList(0, 1, 4, 5));
        HashSet<Integer> s1 = new HashSet<Integer>(Arrays.asList(2, 6));
        HashSet<Integer> s2 = new HashSet<Integer>(Arrays.asList(3, 7));
        try (Statement statement = DriverManager.getConnection("jdbc:iotdb://127.0.0.1:6667/", "root", "root").createStatement();){
            ResultSet resultSet = statement.executeQuery(sqlStr);
            int index = 2500;
            int columnCount = resultSet.getMetaData().getColumnCount();
            Assert.assertEquals((long)9L, (long)columnCount);
            while (resultSet.next()) {
                for (int i = 2; i <= columnCount; ++i) {
                    String actualString = resultSet.getString(i);
                    if (s1s2.contains(i - 2)) {
                        Assert.assertEquals((long)(index * 2), (long)((int)Double.parseDouble(actualString)));
                        continue;
                    }
                    if (s1.contains(i - 2)) {
                        Assert.assertEquals((long)index, (long)((int)Double.parseDouble(actualString)));
                        continue;
                    }
                    if (!s2.contains(i - 2)) continue;
                    Assert.assertEquals((long)index, (long)((int)Double.parseDouble(actualString)));
                }
                ++index;
            }
            Assert.assertEquals((long)5000L, (long)(index - 2500));
        }
        catch (SQLException throwable) {
            Assert.fail((String)throwable.getMessage());
        }
    }

    @Test
    public void queryWithValueFilter2() {
        String sqlStr = "select udf(*, *, \"addend\"=\"500000000\"), *, udf(*, *) from root.vehicle.d2" + String.format(" where s1 >= %d and s2 < %d", 2500, 7500);
        HashSet<Integer> s1AndS2WithAddend = new HashSet<Integer>(Arrays.asList(0, 1, 2, 3));
        HashSet<Integer> s1AndS2 = new HashSet<Integer>(Arrays.asList(6, 7, 8, 9));
        HashSet<Integer> s1OrS2 = new HashSet<Integer>(Arrays.asList(4, 5));
        try (Statement statement = DriverManager.getConnection("jdbc:iotdb://127.0.0.1:6667/", "root", "root").createStatement();){
            ResultSet resultSet = statement.executeQuery(sqlStr);
            int index = 2500;
            int columnCount = resultSet.getMetaData().getColumnCount();
            Assert.assertEquals((long)11L, (long)columnCount);
            while (resultSet.next()) {
                for (int i = 2; i <= columnCount; ++i) {
                    String actualString = resultSet.getString(i);
                    if (s1AndS2WithAddend.contains(i - 2)) {
                        Assert.assertEquals((long)(index * 2 + 500000000), (long)((int)Double.parseDouble(actualString)));
                        continue;
                    }
                    if (s1AndS2.contains(i - 2)) {
                        Assert.assertEquals((long)(index * 2), (long)((int)Double.parseDouble(actualString)));
                        continue;
                    }
                    if (!s1OrS2.contains(i - 2)) continue;
                    Assert.assertEquals((long)index, (long)((int)Double.parseDouble(actualString)));
                }
                ++index;
            }
            Assert.assertEquals((long)5000L, (long)(index - 2500));
        }
        catch (SQLException throwable) {
            Assert.fail((String)throwable.getMessage());
        }
    }

    @Test
    public void queryWithValueFilter3() {
        String sqlStr = "select udf(d1.s2, d1.s1), udf(d1.s1, d1.s2), d1.s1, d1.s2, udf(d1.s1, d1.s2), udf(d1.s2, d1.s1), d1.s1, d1.s2 from root.vehicle" + String.format(" where d3.s1 >= %d and d3.s2 < %d", 3000, 7000);
        HashSet<Integer> s1s2 = new HashSet<Integer>(Arrays.asList(0, 1, 4, 5));
        HashSet<Integer> s1 = new HashSet<Integer>(Arrays.asList(2, 6));
        HashSet<Integer> s2 = new HashSet<Integer>(Arrays.asList(3, 7));
        try (Statement statement = DriverManager.getConnection("jdbc:iotdb://127.0.0.1:6667/", "root", "root").createStatement();){
            ResultSet resultSet = statement.executeQuery(sqlStr);
            int index = 3000;
            int columnCount = resultSet.getMetaData().getColumnCount();
            Assert.assertEquals((long)9L, (long)columnCount);
            while (resultSet.next()) {
                for (int i = 2; i <= columnCount; ++i) {
                    String actualString = resultSet.getString(i);
                    if (s1s2.contains(i - 2)) {
                        if (index % 3 != 0) {
                            Assert.assertEquals((double)(index * 2), (double)Double.parseDouble(actualString), (double)0.0);
                            continue;
                        }
                        Assert.assertNull((Object)actualString);
                        continue;
                    }
                    if (s1.contains(i - 2)) {
                        if (index % 3 != 0 || index % 2 == 0) {
                            Assert.assertEquals((double)index, (double)Double.parseDouble(actualString), (double)0.0);
                            continue;
                        }
                        Assert.assertNull((Object)actualString);
                        continue;
                    }
                    if (!s2.contains(i - 2)) continue;
                    if (index % 3 != 0 || index % 2 != 0) {
                        Assert.assertEquals((double)index, (double)Double.parseDouble(actualString), (double)0.0);
                        continue;
                    }
                    Assert.assertNull((Object)actualString);
                }
                ++index;
            }
            Assert.assertEquals((long)4000L, (long)(index - 3000));
        }
        catch (SQLException throwable) {
            Assert.fail((String)throwable.getMessage());
        }
    }

    @Test
    public void queryWithValueFilter4() {
        String sqlStr = "select udf(s2, s1), udf(s1, s2), s1, s2, udf(s1, s2), udf(s2, s1), s1, s2 from root.vehicle.d2, root.vehicle.d3" + String.format(" where root.vehicle.d2.s1 >= %d and root.vehicle.d3.s2 < %d", 3000, 7000);
        HashSet<Integer> s1s2 = new HashSet<Integer>(Arrays.asList(0, 1, 2, 3, 4, 5, 6, 7, 12, 13, 14, 15, 16, 17, 18, 19));
        HashSet<Integer> s1 = new HashSet<Integer>(Arrays.asList(8, 9, 20, 21));
        HashSet<Integer> s2 = new HashSet<Integer>(Arrays.asList(10, 11, 22, 23));
        try (Statement statement = DriverManager.getConnection("jdbc:iotdb://127.0.0.1:6667/", "root", "root").createStatement();){
            ResultSet resultSet = statement.executeQuery(sqlStr);
            int index = 3000;
            int columnCount = resultSet.getMetaData().getColumnCount();
            Assert.assertEquals((long)25L, (long)columnCount);
            while (resultSet.next()) {
                for (int i = 2; i <= columnCount; ++i) {
                    String actualString = resultSet.getString(i);
                    if (s1s2.contains(i - 2)) {
                        Assert.assertEquals((double)(index * 2), (double)Double.parseDouble(actualString), (double)0.0);
                        continue;
                    }
                    if (!s1.contains(i - 2) && !s2.contains(i - 2)) continue;
                    Assert.assertEquals((double)index, (double)Double.parseDouble(actualString), (double)0.0);
                }
                ++index;
            }
            Assert.assertEquals((long)4000L, (long)(index - 3000));
        }
        catch (SQLException throwable) {
            Assert.fail((String)throwable.getMessage());
        }
    }

    @Test
    public void queryWithValueFilter5() {
        String sqlStr = "select *, udf(*, *), udf(*, *) from root.vehicle.d2, root.vehicle.d3, root.vehicle.d2" + String.format(" where root.vehicle.d2.s1 >= %d and root.vehicle.d3.s2 < %d", 3000, 7000);
        try (Statement statement = DriverManager.getConnection("jdbc:iotdb://127.0.0.1:6667/", "root", "root").createStatement();){
            ResultSet resultSet = statement.executeQuery(sqlStr);
            int index = 3000;
            int columnCount = resultSet.getMetaData().getColumnCount();
            Assert.assertEquals((long)79L, (long)columnCount);
            while (resultSet.next()) {
                for (int i = 2; i <= columnCount; ++i) {
                    String actualString = resultSet.getString(i);
                    Assert.assertEquals((double)(i - 2 < 6 ? (double)index : (double)(2 * index)), (double)Double.parseDouble(actualString), (double)0.0);
                }
                ++index;
            }
            Assert.assertEquals((long)4000L, (long)(index - 3000));
        }
        catch (SQLException throwable) {
            Assert.fail((String)throwable.getMessage());
        }
    }

    @Test
    public void queryWithValueFilter6() {
        String sqlStr = "select *, udf(*, *), udf(*, *) from root.vehicle.d2, root.vehicle.d3, root.vehicle.d2" + String.format(" where root.vehicle.d2.s1 >= %d and root.vehicle.d3.s2 < %d ", 3000, 7000) + String.format(" limit %d offset %d", 1000, 1000);
        try (Statement statement = DriverManager.getConnection("jdbc:iotdb://127.0.0.1:6667/", "root", "root").createStatement();){
            ResultSet resultSet = statement.executeQuery(sqlStr);
            int index = 4000;
            int columnCount = resultSet.getMetaData().getColumnCount();
            Assert.assertEquals((long)79L, (long)columnCount);
            while (resultSet.next()) {
                for (int i = 2; i <= columnCount; ++i) {
                    String actualString = resultSet.getString(i);
                    Assert.assertEquals((double)(i - 2 < 6 ? (double)index : (double)(2 * index)), (double)Double.parseDouble(actualString), (double)0.0);
                }
                ++index;
            }
            Assert.assertEquals((long)1000L, (long)(index - 4000));
        }
        catch (SQLException throwable) {
            Assert.fail((String)throwable.getMessage());
        }
    }

    @Test
    public void queryWithValueFilter7() {
        String sqlStr = "select *, udf(*, *), udf(*, *) from root.vehicle.d2, root.vehicle.d3, root.vehicle.d2" + String.format(" where root.vehicle.d2.s1 >= %d and root.vehicle.d3.s2 < %d ", 3000, 7000) + String.format(" slimit %d soffset %d", 10, 2);
        try (Statement statement = DriverManager.getConnection("jdbc:iotdb://127.0.0.1:6667/", "root", "root").createStatement();){
            ResultSet resultSet = statement.executeQuery(sqlStr);
            int index = 3000;
            int columnCount = resultSet.getMetaData().getColumnCount();
            Assert.assertEquals((long)11L, (long)columnCount);
            while (resultSet.next()) {
                for (int i = 2; i <= columnCount; ++i) {
                    String actualString = resultSet.getString(i);
                    Assert.assertEquals((double)(i - 2 + 2 < 6 ? (double)index : (double)(2 * index)), (double)Double.parseDouble(actualString), (double)0.0);
                }
                ++index;
            }
            Assert.assertEquals((long)4000L, (long)(index - 3000));
        }
        catch (SQLException throwable) {
            Assert.fail((String)throwable.getMessage());
        }
    }

    @Test
    public void queryWithValueFilter8() {
        String sqlStr = "select max(s1), max(s2) from root.vehicle.d4" + String.format(" where root.vehicle.d4.s1 >= %d and root.vehicle.d4.s2 < %d ", 3000, 7000);
        try (Statement statement = DriverManager.getConnection("jdbc:iotdb://127.0.0.1:6667/", "root", "root").createStatement();){
            ResultSet resultSet = statement.executeQuery(sqlStr);
            Assert.assertEquals((long)3L, (long)resultSet.getMetaData().getColumnCount());
            Assert.assertEquals((Object)"Time", (Object)resultSet.getMetaData().getColumnName(1));
            String columnS1 = "max(root.vehicle.d4.s1)";
            String columnS2 = "max(root.vehicle.d4.s2)";
            Assert.assertTrue((columnS1.equals(resultSet.getMetaData().getColumnName(2)) || columnS2.equals(resultSet.getMetaData().getColumnName(2)) ? 1 : 0) != 0);
            Assert.assertTrue((columnS1.equals(resultSet.getMetaData().getColumnName(3)) || columnS2.equals(resultSet.getMetaData().getColumnName(3)) ? 1 : 0) != 0);
            Assert.assertFalse((boolean)resultSet.next());
        }
        catch (SQLException throwable) {
            Assert.fail((String)throwable.getMessage());
        }
    }

    @Test
    public void queryWithValueFilter9() {
        String sqlStr = "select max(s1), max(s2) from root.vehicle.d4" + String.format(" where root.vehicle.d4.s1 >= %d and root.vehicle.d4.s1 < %d ", 3000, 7000);
        try (Statement statement = DriverManager.getConnection("jdbc:iotdb://127.0.0.1:6667/", "root", "root").createStatement();){
            ResultSet resultSet = statement.executeQuery(sqlStr);
            Assert.assertEquals((long)3L, (long)resultSet.getMetaData().getColumnCount());
            Assert.assertEquals((Object)"Time", (Object)resultSet.getMetaData().getColumnName(1));
            String columnS1 = "max(root.vehicle.d4.s1)";
            String columnS2 = "max(root.vehicle.d4.s2)";
            Assert.assertTrue((columnS1.equals(resultSet.getMetaData().getColumnName(2)) || columnS2.equals(resultSet.getMetaData().getColumnName(2)) ? 1 : 0) != 0);
            Assert.assertTrue((columnS1.equals(resultSet.getMetaData().getColumnName(3)) || columnS2.equals(resultSet.getMetaData().getColumnName(3)) ? 1 : 0) != 0);
            Assert.assertTrue((boolean)resultSet.next());
            Assert.assertEquals((long)6999L, (long)Integer.parseInt(resultSet.getString(columnS1)));
            Assert.assertNull((Object)resultSet.getString(columnS2));
            Assert.assertFalse((boolean)resultSet.next());
        }
        catch (SQLException throwable) {
            Assert.fail((String)throwable.getMessage());
        }
    }

    @Test
    public void queryWithValueFilter10() {
        String sqlStr = "select terminate(s1), terminate(s2) from root.vehicle.d4" + String.format(" where root.vehicle.d4.s1 >= %d and root.vehicle.d4.s1 < %d ", 3000, 7000);
        try (Statement statement = DriverManager.getConnection("jdbc:iotdb://127.0.0.1:6667/", "root", "root").createStatement();){
            ResultSet resultSet = statement.executeQuery(sqlStr);
            Assert.assertEquals((long)3L, (long)resultSet.getMetaData().getColumnCount());
            Assert.assertEquals((Object)"Time", (Object)resultSet.getMetaData().getColumnName(1));
            String columnS1 = "terminate(root.vehicle.d4.s1)";
            String columnS2 = "terminate(root.vehicle.d4.s2)";
            Assert.assertTrue((columnS1.equals(resultSet.getMetaData().getColumnName(2)) || columnS2.equals(resultSet.getMetaData().getColumnName(2)) ? 1 : 0) != 0);
            Assert.assertTrue((columnS1.equals(resultSet.getMetaData().getColumnName(3)) || columnS2.equals(resultSet.getMetaData().getColumnName(3)) ? 1 : 0) != 0);
            for (int i = 0; i < 1334; ++i) {
                Assert.assertTrue((boolean)resultSet.next());
                Assert.assertEquals((long)1L, (long)Integer.parseInt(resultSet.getString(columnS1)));
                Assert.assertNull((Object)resultSet.getString(columnS2));
            }
            Assert.assertTrue((boolean)resultSet.next());
            Assert.assertEquals((long)1334L, (long)Integer.parseInt(resultSet.getString(columnS1)));
            Assert.assertNull((Object)resultSet.getString(columnS2));
            Assert.assertFalse((boolean)resultSet.next());
        }
        catch (SQLException throwable) {
            Assert.fail((String)throwable.getMessage());
        }
    }

    @Test
    public void queryNonexistentSeries() {
        String sqlStr = "select max(s100), udf(*, s100), udf(*, s100), udf(s100, s100) from root.vehicle.d4";
        try (Statement statement = DriverManager.getConnection("jdbc:iotdb://127.0.0.1:6667/", "root", "root").createStatement();){
            ResultSet resultSet = statement.executeQuery(sqlStr);
            Assert.assertEquals((long)1L, (long)resultSet.getMetaData().getColumnCount());
            Assert.assertEquals((Object)"Time", (Object)resultSet.getMetaData().getColumnName(1));
        }
        catch (SQLException throwable) {
            Assert.fail((String)throwable.getMessage());
        }
    }
}

