/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.integration;

import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import org.apache.iotdb.db.conf.IoTDBDescriptor;
import org.apache.iotdb.db.exception.metadata.MetadataException;
import org.apache.iotdb.db.metadata.PartialPath;
import org.apache.iotdb.db.service.IoTDB;
import org.apache.iotdb.db.utils.EnvironmentUtils;
import org.apache.iotdb.tsfile.file.metadata.enums.CompressionType;
import org.apache.iotdb.tsfile.file.metadata.enums.TSDataType;
import org.apache.iotdb.tsfile.file.metadata.enums.TSEncoding;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Test;

public class IoTDBUDFWindowQueryIT {
    public static final String ACCESS_STRATEGY_KEY = "access";
    public static final String ACCESS_STRATEGY_ROW_BY_ROW = "row-by-row";
    public static final String ACCESS_STRATEGY_SLIDING_SIZE = "size";
    public static final String ACCESS_STRATEGY_SLIDING_TIME = "time";
    public static final String WINDOW_SIZE_KEY = "windowSize";
    public static final String TIME_INTERVAL_KEY = "timeInterval";
    public static final String SLIDING_STEP_KEY = "slidingStep";
    public static final String DISPLAY_WINDOW_BEGIN_KEY = "displayWindowBegin";
    public static final String DISPLAY_WINDOW_END_KEY = "displayWindowEnd";
    protected static final int ITERATION_TIMES = 100000;

    @BeforeClass
    public static void setUp() throws Exception {
        IoTDBDescriptor.getInstance().getConfig().setUdfCollectorMemoryBudgetInMB(1.0f);
        IoTDBDescriptor.getInstance().getConfig().setUdfTransformerMemoryBudgetInMB(1.0f);
        IoTDBDescriptor.getInstance().getConfig().setUdfReaderMemoryBudgetInMB(1.0f);
        EnvironmentUtils.envSetUp();
        Class.forName("org.apache.iotdb.jdbc.IoTDBDriver");
        IoTDBUDFWindowQueryIT.createTimeSeries();
        IoTDBUDFWindowQueryIT.generateData();
        IoTDBUDFWindowQueryIT.registerUDF();
    }

    private static void createTimeSeries() throws MetadataException {
        IoTDB.metaManager.setStorageGroup(new PartialPath("root.vehicle"));
        IoTDB.metaManager.createTimeseries(new PartialPath("root.vehicle.d1.s1"), TSDataType.INT32, TSEncoding.PLAIN, CompressionType.UNCOMPRESSED, null);
        IoTDB.metaManager.createTimeseries(new PartialPath("root.vehicle.d1.s2"), TSDataType.INT32, TSEncoding.PLAIN, CompressionType.UNCOMPRESSED, null);
    }

    private static void generateData() {
        try (Connection connection = DriverManager.getConnection("jdbc:iotdb://127.0.0.1:6667/", "root", "root");
             Statement statement = connection.createStatement();){
            for (int i = 0; i < 100000; ++i) {
                statement.execute(String.format("insert into root.vehicle.d1(timestamp,s1,s2) values(%d,%d,%d)", i, i, i));
            }
        }
        catch (SQLException throwable) {
            Assert.fail((String)throwable.getMessage());
        }
    }

    private static void registerUDF() {
        try (Connection connection = DriverManager.getConnection("jdbc:iotdb://127.0.0.1:6667/", "root", "root");
             Statement statement = connection.createStatement();){
            statement.execute("create function counter as \"org.apache.iotdb.db.query.udf.example.Counter\"");
            statement.execute("create function accumulator as \"org.apache.iotdb.db.query.udf.example.Accumulator\"");
            statement.execute("create function time_window_tester as \"org.apache.iotdb.db.query.udf.example.SlidingTimeWindowConstructionTester\"");
            statement.execute("create function size_window_0 as \"org.apache.iotdb.db.query.udf.example.SlidingSizeWindowConstructorTester0\"");
            statement.execute("create function size_window_1 as \"org.apache.iotdb.db.query.udf.example.SlidingSizeWindowConstructorTester1\"");
        }
        catch (SQLException throwable) {
            Assert.fail((String)throwable.getMessage());
        }
    }

    @AfterClass
    public static void tearDown() throws Exception {
        EnvironmentUtils.cleanEnv();
        IoTDBDescriptor.getInstance().getConfig().setUdfCollectorMemoryBudgetInMB(100.0f);
        IoTDBDescriptor.getInstance().getConfig().setUdfTransformerMemoryBudgetInMB(100.0f);
        IoTDBDescriptor.getInstance().getConfig().setUdfReaderMemoryBudgetInMB(100.0f);
    }

    @Test
    public void testRowByRow() {
        String sql = String.format("select counter(s1, \"%s\"=\"%s\") from root.vehicle.d1", ACCESS_STRATEGY_KEY, ACCESS_STRATEGY_ROW_BY_ROW);
        try (Statement statement = DriverManager.getConnection("jdbc:iotdb://127.0.0.1:6667/", "root", "root").createStatement();){
            ResultSet resultSet = statement.executeQuery(sql);
            int count = 0;
            Assert.assertEquals((long)2L, (long)resultSet.getMetaData().getColumnCount());
            while (resultSet.next()) {
                Assert.assertEquals((long)count++, (long)((int)Double.parseDouble(resultSet.getString(1))));
            }
            Assert.assertEquals((long)100000L, (long)count);
        }
        catch (SQLException throwable) {
            Assert.fail((String)throwable.getMessage());
        }
    }

    @Test
    public void testSlidingSizeWindow1() {
        this.testSlidingSizeWindow(10000);
    }

    @Test
    public void testSlidingSizeWindow2() {
        this.testSlidingSizeWindow(3300);
    }

    @Test
    public void testSlidingSizeWindow3() {
        this.testSlidingSizeWindow(33300);
    }

    @Test
    public void testSlidingSizeWindow4() {
        this.testSlidingSizeWindow(150000);
    }

    @Test
    public void testSlidingSizeWindow5() {
        this.testSlidingSizeWindow(100000);
    }

    @Test
    public void testSlidingSizeWindow6() {
        this.testSlidingSizeWindow(300000);
    }

    @Test
    public void testSlidingSizeWindow7() {
        this.testSlidingSizeWindow(0);
    }

    @Test
    public void testSlidingSizeWindow8() {
        this.testSlidingSizeWindow(-100000);
    }

    private void testSlidingSizeWindow(int windowSize) {
        block10: {
            String sql = String.format("select accumulator(s1, \"%s\"=\"%s\", \"%s\"=\"%s\") from root.vehicle.d1", ACCESS_STRATEGY_KEY, ACCESS_STRATEGY_SLIDING_SIZE, WINDOW_SIZE_KEY, windowSize);
            try (Statement statement = DriverManager.getConnection("jdbc:iotdb://127.0.0.1:6667/", "root", "root").createStatement();){
                ResultSet resultSet = statement.executeQuery(sql);
                Assert.assertEquals((long)2L, (long)resultSet.getMetaData().getColumnCount());
                int count = 0;
                while (resultSet.next()) {
                    int expectedWindowSize = count < 100000 / windowSize ? windowSize : 100000 - 100000 / windowSize * windowSize;
                    int expectedAccumulation = 0;
                    for (int i = count * windowSize; i < count * windowSize + expectedWindowSize; ++i) {
                        expectedAccumulation += i;
                    }
                    Assert.assertEquals((long)expectedAccumulation, (long)((int)Double.parseDouble(resultSet.getString(2))));
                    ++count;
                }
            }
            catch (SQLException throwable) {
                if (0 >= windowSize && throwable.getMessage().contains(String.valueOf(windowSize))) break block10;
                Assert.fail((String)throwable.getMessage());
            }
        }
    }

    @Test
    public void testSlidingTimeWindow1() {
        this.testSlidingTimeWindow(33000, 33000, 33000, 33000);
    }

    @Test
    public void testSlidingTimeWindow2() {
        this.testSlidingTimeWindow(3300, 6600, 50000, 100000);
    }

    @Test
    public void testSlidingTimeWindow3() {
        this.testSlidingTimeWindow(6600, 3300, 50000, 100000);
    }

    @Test
    public void testSlidingTimeWindow4() {
        this.testSlidingTimeWindow(3300, 3300, 50000, 100000);
    }

    @Test
    public void testSlidingTimeWindow5() {
        this.testSlidingTimeWindow(100000, 100000, 0, 100000);
    }

    @Test
    public void testSlidingTimeWindow6() {
        this.testSlidingTimeWindow(101000, 1000, 0, 50000);
    }

    @Test
    public void testSlidingTimeWindow7() {
        this.testSlidingTimeWindow(1000, 101000, 0, 50000);
    }

    @Test
    public void testSlidingTimeWindow8() {
        this.testSlidingTimeWindow(101000, 101000, 0, 50000);
    }

    @Test
    public void testSlidingTimeWindow9() {
        this.testSlidingTimeWindow(1000, 5000, 50000, 0);
    }

    @Test
    public void testSlidingTimeWindow10() {
        this.testSlidingTimeWindow(-1000, 5000, 0, 50000);
    }

    @Test
    public void testSlidingTimeWindow11() {
        this.testSlidingTimeWindow(1000, -5000, 0, 50000);
    }

    @Test
    public void testSlidingTimeWindow12() {
        this.testSlidingTimeWindow(1000, 0, 0, 50000);
    }

    @Test
    public void testSlidingTimeWindow13() {
        this.testSlidingTimeWindow(0, 5000, 0, 50000);
    }

    private void testSlidingTimeWindow(int timeInterval, int slidingStep, int displayWindowBegin, int displayWindowEnd) {
        block10: {
            String sql = String.format("select accumulator(s1, \"%s\"=\"%s\", \"%s\"=\"%s\", \"%s\"=\"%s\", \"%s\"=\"%s\", \"%s\"=\"%s\") from root.vehicle.d1", ACCESS_STRATEGY_KEY, ACCESS_STRATEGY_SLIDING_TIME, TIME_INTERVAL_KEY, timeInterval, SLIDING_STEP_KEY, slidingStep, DISPLAY_WINDOW_BEGIN_KEY, displayWindowBegin, DISPLAY_WINDOW_END_KEY, displayWindowEnd);
            try (Statement statement = DriverManager.getConnection("jdbc:iotdb://127.0.0.1:6667/", "root", "root").createStatement();){
                ResultSet resultSet = statement.executeQuery(sql);
                Assert.assertEquals((long)2L, (long)resultSet.getMetaData().getColumnCount());
                int count = 0;
                while (resultSet.next()) {
                    int begin = displayWindowBegin + count * slidingStep;
                    int expectedWindowSize = begin + timeInterval < displayWindowEnd ? timeInterval : displayWindowEnd - begin;
                    int expectedAccumulation = 0;
                    for (int i = displayWindowBegin + count * slidingStep; i < displayWindowBegin + count * slidingStep + expectedWindowSize; ++i) {
                        expectedAccumulation += i;
                    }
                    Assert.assertEquals((long)expectedAccumulation, (long)((int)Double.parseDouble(resultSet.getString(2))));
                    ++count;
                }
            }
            catch (SQLException throwable) {
                if (slidingStep <= 0 || timeInterval <= 0 || displayWindowEnd < displayWindowBegin) break block10;
                Assert.fail((String)throwable.getMessage());
            }
        }
    }

    @Test
    public void testSlidingTimeWindowWithTimeIntervalOnly1() {
        this.testSlidingTimeWindowWithTimeIntervalOnly(1);
    }

    @Test
    public void testSlidingTimeWindowWithTimeIntervalOnly2() {
        this.testSlidingTimeWindowWithTimeIntervalOnly(10000);
    }

    @Test
    public void testSlidingTimeWindowWithTimeIntervalOnly3() {
        this.testSlidingTimeWindowWithTimeIntervalOnly(3030);
    }

    @Test
    public void testSlidingTimeWindowWithTimeIntervalOnly4() {
        this.testSlidingTimeWindowWithTimeIntervalOnly(100000);
    }

    @Test
    public void testSlidingTimeWindowWithTimeIntervalOnly5() {
        this.testSlidingTimeWindowWithTimeIntervalOnly(200000);
    }

    @Test
    public void testSlidingTimeWindowWithTimeIntervalOnly6() {
        this.testSlidingTimeWindowWithTimeIntervalOnly(-100000);
    }

    public void testSlidingTimeWindowWithTimeIntervalOnly(int timeInterval) {
        block10: {
            String sql = String.format("select time_window_tester(s1, \"%s\"=\"%s\") from root.vehicle.d1", TIME_INTERVAL_KEY, timeInterval);
            int displayWindowBegin = 0;
            int displayWindowEnd = 100000;
            try (Statement statement = DriverManager.getConnection("jdbc:iotdb://127.0.0.1:6667/", "root", "root").createStatement();){
                ResultSet resultSet = statement.executeQuery(sql);
                Assert.assertEquals((long)2L, (long)resultSet.getMetaData().getColumnCount());
                int count = 0;
                while (resultSet.next()) {
                    int begin = displayWindowBegin + count * timeInterval;
                    int expectedWindowSize = begin + timeInterval < displayWindowEnd ? timeInterval : displayWindowEnd - begin;
                    int expectedAccumulation = 0;
                    for (int i = displayWindowBegin + count * timeInterval; i < displayWindowBegin + count * timeInterval + expectedWindowSize; ++i) {
                        expectedAccumulation += i;
                    }
                    Assert.assertEquals((long)expectedAccumulation, (long)((int)Double.parseDouble(resultSet.getString(2))));
                    ++count;
                }
            }
            catch (SQLException throwable) {
                if (timeInterval <= 0) break block10;
                Assert.fail((String)throwable.getMessage());
            }
        }
    }

    @Test
    public void testSlidingSizeWindowWithSlidingStep1() {
        this.testSlidingSizeWindowWithSlidingStep(1, 1, 0);
        this.testSlidingSizeWindowWithSlidingStep(1, 1, 1);
        this.testSlidingSizeWindowWithSlidingStep(1, 1, 10);
        this.testSlidingSizeWindowWithSlidingStep(1, 1, 43400);
        this.testSlidingSizeWindowWithSlidingStep(1, 1, 150000);
    }

    @Test
    public void testSlidingSizeWindowWithSlidingStep2() {
        this.testSlidingSizeWindowWithSlidingStep(100, 100, 0);
        this.testSlidingSizeWindowWithSlidingStep(100, 100, 100);
        this.testSlidingSizeWindowWithSlidingStep(100, 100, 10000);
        this.testSlidingSizeWindowWithSlidingStep(100, 100, 43400);
        this.testSlidingSizeWindowWithSlidingStep(100, 100, 150000);
    }

    @Test
    public void testSlidingSizeWindowWithSlidingStep3() {
        this.testSlidingSizeWindowWithSlidingStep(111, 123, 0);
        this.testSlidingSizeWindowWithSlidingStep(111, 123, 43400);
        this.testSlidingSizeWindowWithSlidingStep(111, 123, 150000);
    }

    @Test
    public void testSlidingSizeWindowWithSlidingStep4() {
        this.testSlidingSizeWindowWithSlidingStep(123, 111, 0);
        this.testSlidingSizeWindowWithSlidingStep(123, 111, 43400);
        this.testSlidingSizeWindowWithSlidingStep(123, 111, 150000);
    }

    @Test
    public void testSlidingSizeWindowWithSlidingStep5() {
        this.testSlidingSizeWindowWithSlidingStep(100, 10000, 0);
        this.testSlidingSizeWindowWithSlidingStep(100, 10000, 100);
        this.testSlidingSizeWindowWithSlidingStep(100, 10000, 10000);
        this.testSlidingSizeWindowWithSlidingStep(100, 10000, 43400);
        this.testSlidingSizeWindowWithSlidingStep(100, 10000, 150000);
    }

    @Test
    public void testSlidingSizeWindowWithSlidingStep6() {
        this.testSlidingSizeWindowWithSlidingStep(10000, 1000, 0);
        this.testSlidingSizeWindowWithSlidingStep(10000, 1000, 1000);
        this.testSlidingSizeWindowWithSlidingStep(10000, 1000, 10000);
        this.testSlidingSizeWindowWithSlidingStep(10000, 1000, 43400);
        this.testSlidingSizeWindowWithSlidingStep(10000, 1000, 150000);
    }

    @Test
    public void testSlidingSizeWindowWithSlidingStep7() {
        this.testSlidingSizeWindowWithSlidingStep(150000, 4333, 0);
        this.testSlidingSizeWindowWithSlidingStep(150000, 4333, 43400);
        this.testSlidingSizeWindowWithSlidingStep(150000, 4333, 150000);
    }

    @Test
    public void testSlidingSizeWindowWithSlidingStep8() {
        this.testSlidingSizeWindowWithSlidingStep(10000, 150000, 0);
        this.testSlidingSizeWindowWithSlidingStep(10000, 150000, 43400);
        this.testSlidingSizeWindowWithSlidingStep(10000, 150000, 150000);
    }

    @Test
    public void testSlidingSizeWindowWithSlidingStep9() {
        this.testSlidingSizeWindowWithSlidingStep(150000, 150000, 0);
        this.testSlidingSizeWindowWithSlidingStep(150000, 150000, 43400);
        this.testSlidingSizeWindowWithSlidingStep(150000, 150000, 150000);
    }

    public void testSlidingSizeWindowWithSlidingStep(int windowSize, int slidingStep, int consumptionPoint) {
        block11: {
            String sql = String.format("select size_window_0(s1, \"%s\"=\"%s\", \"%s\"=\"%s\"), size_window_1(s1, \"%s\"=\"%s\") from root.vehicle.d1", WINDOW_SIZE_KEY, windowSize, SLIDING_STEP_KEY, slidingStep, "consumptionPoint", consumptionPoint);
            try (Statement statement = DriverManager.getConnection("jdbc:iotdb://127.0.0.1:6667/", "root", "root").createStatement();){
                ResultSet resultSet = statement.executeQuery(sql);
                Assert.assertEquals((long)3L, (long)resultSet.getMetaData().getColumnCount());
                int count = 0;
                while (resultSet.next()) {
                    String actual;
                    if (100000 < windowSize) {
                        actual = resultSet.getString(2);
                        if (actual == null) continue;
                        Assert.assertEquals((long)(100000 - count * slidingStep), (long)Integer.parseInt(actual));
                        ++count;
                        continue;
                    }
                    if (count * slidingStep + windowSize < 100000) {
                        actual = resultSet.getString(2);
                        if (actual == null) continue;
                        Assert.assertEquals((long)windowSize, (long)Integer.parseInt(resultSet.getString(2)));
                        ++count;
                        continue;
                    }
                    actual = resultSet.getString(2);
                    if (actual == null) continue;
                    Assert.assertEquals((long)(100000 - count * slidingStep), (long)Integer.parseInt(resultSet.getString(2)));
                    ++count;
                }
                Assert.assertEquals((long)((int)Math.ceil(100000.0 / (double)slidingStep)), (long)count);
            }
            catch (SQLException throwable) {
                if (windowSize <= 0) break block11;
                Assert.fail((String)throwable.getMessage());
            }
        }
    }
}

