/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.integration;

import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import org.apache.iotdb.db.metadata.PartialPath;
import org.apache.iotdb.db.qp.constant.SQLConstant;
import org.apache.iotdb.db.query.udf.builtin.BuiltinFunction;
import org.apache.iotdb.db.query.udf.service.UDFRegistrationService;
import org.apache.iotdb.db.service.IoTDB;
import org.apache.iotdb.db.utils.EnvironmentUtils;
import org.apache.iotdb.tsfile.file.metadata.enums.CompressionType;
import org.apache.iotdb.tsfile.file.metadata.enums.TSDataType;
import org.apache.iotdb.tsfile.file.metadata.enums.TSEncoding;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class IoTDBUDFManagementIT {
    private static final int NATIVE_FUNCTIONS_COUNT = SQLConstant.getNativeFunctionNames().size();
    private static final int BUILTIN_FUNCTIONS_COUNT = BuiltinFunction.values().length;

    @Before
    public void setUp() throws Exception {
        EnvironmentUtils.envSetUp();
        IoTDB.metaManager.setStorageGroup(new PartialPath("root.vehicle"));
        IoTDB.metaManager.createTimeseries(new PartialPath("root.vehicle.d1.s1"), TSDataType.FLOAT, TSEncoding.PLAIN, CompressionType.UNCOMPRESSED, null);
        IoTDB.metaManager.createTimeseries(new PartialPath("root.vehicle.d1.s2"), TSDataType.FLOAT, TSEncoding.PLAIN, CompressionType.UNCOMPRESSED, null);
        Class.forName("org.apache.iotdb.jdbc.IoTDBDriver");
    }

    @After
    public void tearDown() throws Exception {
        EnvironmentUtils.cleanEnv();
    }

    @Test
    public void testCreateReflectShowDrop() {
        try (Connection connection = DriverManager.getConnection("jdbc:iotdb://127.0.0.1:6667/", "root", "root");
             Statement statement = connection.createStatement();){
            statement.execute("create function udf as \"org.apache.iotdb.db.query.udf.example.Adder\"");
            statement.execute("select udf(*, *) from root.vehicle");
            ResultSet resultSet = statement.executeQuery("show functions");
            Assert.assertEquals((long)3L, (long)resultSet.getMetaData().getColumnCount());
            int count = 0;
            while (resultSet.next()) {
                StringBuilder stringBuilder = new StringBuilder();
                for (int i = 1; i <= resultSet.getMetaData().getColumnCount(); ++i) {
                    stringBuilder.append(resultSet.getString(i)).append(",");
                }
                String result = stringBuilder.toString();
                if (result.contains("native")) continue;
                ++count;
            }
            Assert.assertEquals((long)(1 + BUILTIN_FUNCTIONS_COUNT), (long)count);
            resultSet = statement.executeQuery("show temporary functions");
            count = 0;
            while (resultSet.next()) {
                ++count;
            }
            Assert.assertEquals((long)0L, (long)count);
            Assert.assertEquals((long)3L, (long)resultSet.getMetaData().getColumnCount());
            statement.execute("drop function udf");
        }
        catch (SQLException throwable) {
            Assert.fail((String)throwable.getMessage());
        }
    }

    @Test
    public void testCreateAndDropSeveralTimes() {
        try (Connection connection = DriverManager.getConnection("jdbc:iotdb://127.0.0.1:6667/", "root", "root");
             Statement statement = connection.createStatement();){
            statement.execute("create function udf as \"org.apache.iotdb.db.query.udf.example.Adder\"");
            statement.execute("select udf(*, *) from root.vehicle");
            ResultSet resultSet = statement.executeQuery("show functions");
            int count = 0;
            while (resultSet.next()) {
                ++count;
            }
            Assert.assertEquals((long)(1 + NATIVE_FUNCTIONS_COUNT + BUILTIN_FUNCTIONS_COUNT), (long)count);
            Assert.assertEquals((long)3L, (long)resultSet.getMetaData().getColumnCount());
            resultSet = statement.executeQuery("show temporary functions");
            count = 0;
            while (resultSet.next()) {
                ++count;
            }
            Assert.assertEquals((long)0L, (long)count);
            Assert.assertEquals((long)3L, (long)resultSet.getMetaData().getColumnCount());
            statement.execute("drop function udf");
            statement.execute("create temporary function udf as \"org.apache.iotdb.db.query.udf.example.Adder\"");
            statement.execute("select udf(*, *) from root.vehicle");
            resultSet = statement.executeQuery("show functions");
            count = 0;
            while (resultSet.next()) {
                ++count;
            }
            Assert.assertEquals((long)(1 + NATIVE_FUNCTIONS_COUNT + BUILTIN_FUNCTIONS_COUNT), (long)count);
            Assert.assertEquals((long)3L, (long)resultSet.getMetaData().getColumnCount());
            resultSet = statement.executeQuery("show temporary functions");
            count = 0;
            while (resultSet.next()) {
                ++count;
            }
            Assert.assertEquals((long)1L, (long)count);
            Assert.assertEquals((long)3L, (long)resultSet.getMetaData().getColumnCount());
            statement.execute("drop function udf");
            statement.execute("create function udf as \"org.apache.iotdb.db.query.udf.example.Adder\"");
            statement.execute("select udf(*, *) from root.vehicle");
            resultSet = statement.executeQuery("show functions");
            count = 0;
            while (resultSet.next()) {
                ++count;
            }
            Assert.assertEquals((long)(1 + NATIVE_FUNCTIONS_COUNT + BUILTIN_FUNCTIONS_COUNT), (long)count);
            Assert.assertEquals((long)3L, (long)resultSet.getMetaData().getColumnCount());
            resultSet = statement.executeQuery("show temporary functions");
            count = 0;
            while (resultSet.next()) {
                ++count;
            }
            Assert.assertEquals((long)0L, (long)count);
            Assert.assertEquals((long)3L, (long)resultSet.getMetaData().getColumnCount());
            statement.execute("drop function udf");
        }
        catch (SQLException throwable) {
            Assert.fail((String)throwable.getMessage());
        }
    }

    @Test
    public void testReflectBeforeCreate() {
        try (Connection connection = DriverManager.getConnection("jdbc:iotdb://127.0.0.1:6667/", "root", "root");
             Statement statement = connection.createStatement();){
            statement.execute("select udf(*, *) from root.vehicle");
        }
        catch (SQLException throwable) {
            Assert.assertTrue((boolean)throwable.getMessage().contains("Failed to reflect UDF instance"));
        }
    }

    @Test
    public void testReflectAfterDrop() {
        try (Connection connection = DriverManager.getConnection("jdbc:iotdb://127.0.0.1:6667/", "root", "root");
             Statement statement = connection.createStatement();){
            statement.execute("create function udf as \"org.apache.iotdb.db.query.udf.example.Adder\"");
            statement.execute("drop function udf");
            statement.execute("select udf(*, *) from root.vehicle");
        }
        catch (SQLException throwable) {
            Assert.assertTrue((boolean)throwable.getMessage().contains("Failed to reflect UDF instance"));
        }
    }

    @Test
    public void testCreateFunctionWithBuiltinFunctionName1() {
        try (Connection connection = DriverManager.getConnection("jdbc:iotdb://127.0.0.1:6667/", "root", "root");
             Statement statement = connection.createStatement();){
            statement.execute("create function aVg as \"org.apache.iotdb.db.query.udf.example.Adder\"");
            Assert.fail();
        }
        catch (SQLException throwable) {
            Assert.assertTrue((boolean)throwable.getMessage().contains("expecting ID"));
        }
    }

    @Test
    public void testCreateFunctionWithBuiltinFunctionName2() {
        try (Connection connection = DriverManager.getConnection("jdbc:iotdb://127.0.0.1:6667/", "root", "root");
             Statement statement = connection.createStatement();){
            statement.execute("create function MAX_VALUE as \"org.apache.iotdb.db.query.udf.example.Adder\"");
            Assert.fail();
        }
        catch (SQLException throwable) {
            Assert.assertTrue((boolean)throwable.getMessage().contains("expecting ID"));
        }
    }

    @Test
    public void testCreateFunction1() throws SQLException {
        try (Connection connection = DriverManager.getConnection("jdbc:iotdb://127.0.0.1:6667/", "root", "root");
             Statement statement = connection.createStatement();){
            statement.execute("create function udf as \"org.apache.iotdb.db.query.udf.example.Adder\"");
            try {
                statement.execute("create function udf as \"org.apache.iotdb.db.query.udf.example.Adder\"");
                Assert.fail();
            }
            catch (SQLException throwable) {
                Assert.assertTrue((boolean)throwable.getMessage().contains("Failed to register"));
            }
        }
    }

    @Test
    public void testCreateFunction2() throws SQLException {
        try (Connection connection = DriverManager.getConnection("jdbc:iotdb://127.0.0.1:6667/", "root", "root");
             Statement statement = connection.createStatement();){
            statement.execute("create temporary function udf as \"org.apache.iotdb.db.query.udf.example.Adder\"");
            try {
                statement.execute("create temporary function udf as \"org.apache.iotdb.db.query.udf.example.Adder\"");
                Assert.fail();
            }
            catch (SQLException throwable) {
                Assert.assertTrue((boolean)throwable.getMessage().contains("Failed to register"));
            }
        }
    }

    @Test
    public void testCreateFunction3() throws SQLException {
        try (Connection connection = DriverManager.getConnection("jdbc:iotdb://127.0.0.1:6667/", "root", "root");
             Statement statement = connection.createStatement();){
            statement.execute("create temporary function udf as \"org.apache.iotdb.db.query.udf.example.Adder\"");
            try {
                statement.execute("create function udf as \"org.apache.iotdb.db.query.udf.example.Adder\"");
                Assert.fail();
            }
            catch (SQLException throwable) {
                Assert.assertTrue((boolean)throwable.getMessage().contains("with the same function name and the class name has already been registered"));
            }
        }
    }

    @Test
    public void testCreateFunction4() throws SQLException {
        try (Connection connection = DriverManager.getConnection("jdbc:iotdb://127.0.0.1:6667/", "root", "root");
             Statement statement = connection.createStatement();){
            statement.execute("create function udf as \"org.apache.iotdb.db.query.udf.example.Adder\"");
            try {
                statement.execute("create temporary function udf as \"org.apache.iotdb.db.query.udf.example.Adder\"");
                Assert.fail();
            }
            catch (SQLException throwable) {
                Assert.assertTrue((boolean)throwable.getMessage().contains("with the same function name and the class name has already been registered"));
            }
        }
    }

    @Test
    public void testDropFunction1() throws SQLException {
        try (Connection connection = DriverManager.getConnection("jdbc:iotdb://127.0.0.1:6667/", "root", "root");
             Statement statement = connection.createStatement();){
            statement.execute("create function udf as \"org.apache.iotdb.db.query.udf.example.Adder\"");
            statement.execute("drop function udf");
            try {
                statement.execute("drop function udf");
                Assert.fail();
            }
            catch (SQLException throwable) {
                Assert.assertTrue((boolean)throwable.getMessage().contains("does not exist"));
            }
        }
    }

    @Test
    public void testDropFunction2() {
        try (Connection connection = DriverManager.getConnection("jdbc:iotdb://127.0.0.1:6667/", "root", "root");
             Statement statement = connection.createStatement();){
            statement.execute("drop function udf");
            Assert.fail();
        }
        catch (SQLException throwable) {
            Assert.assertTrue((boolean)throwable.getMessage().contains("does not exist"));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testCreateBuiltinFunction() throws ClassNotFoundException {
        UDFRegistrationService.getInstance().registerBuiltinFunction("adder", "org.apache.iotdb.db.query.udf.example.Adder");
        try (Connection connection = DriverManager.getConnection("jdbc:iotdb://127.0.0.1:6667/", "root", "root");
             Statement statement = connection.createStatement();){
            statement.execute("create function adder as \"org.apache.iotdb.db.query.udf.example.Adder\"");
            Assert.fail();
        }
        catch (SQLException throwable) {
            Assert.assertTrue((boolean)throwable.getMessage().contains("the given function name is the same as a built-in UDF function name"));
        }
        finally {
            UDFRegistrationService.getInstance().deregisterBuiltinFunction("adder");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testDropBuiltinFunction() throws ClassNotFoundException {
        UDFRegistrationService.getInstance().registerBuiltinFunction("adder", "org.apache.iotdb.db.query.udf.example.Adder");
        try (Connection connection = DriverManager.getConnection("jdbc:iotdb://127.0.0.1:6667/", "root", "root");
             Statement statement = connection.createStatement();){
            statement.execute("drop function adder");
            Assert.fail();
        }
        catch (SQLException throwable) {
            Assert.assertTrue((boolean)throwable.getMessage().contains("Built-in function ADDER can not be deregistered"));
        }
        finally {
            UDFRegistrationService.getInstance().deregisterBuiltinFunction("adder");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testReflectBuiltinFunction() throws ClassNotFoundException {
        UDFRegistrationService.getInstance().registerBuiltinFunction("adder", "org.apache.iotdb.db.query.udf.example.Adder");
        try (Connection connection = DriverManager.getConnection("jdbc:iotdb://127.0.0.1:6667/", "root", "root");
             Statement statement = connection.createStatement();){
            statement.execute("select adder(*, *) from root.vehicle");
        }
        catch (SQLException throwable) {
            Assert.fail((String)throwable.getMessage());
        }
        finally {
            UDFRegistrationService.getInstance().deregisterBuiltinFunction("adder");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testShowBuiltinFunction() throws ClassNotFoundException {
        UDFRegistrationService.getInstance().registerBuiltinFunction("adder", "org.apache.iotdb.db.query.udf.example.Adder");
        try (Connection connection = DriverManager.getConnection("jdbc:iotdb://127.0.0.1:6667/", "root", "root");
             Statement statement = connection.createStatement();){
            statement.execute("create function udf as \"org.apache.iotdb.db.query.udf.example.Adder\"");
            ResultSet resultSet = statement.executeQuery("show functions");
            Assert.assertEquals((long)3L, (long)resultSet.getMetaData().getColumnCount());
            int count = 0;
            while (resultSet.next()) {
                StringBuilder stringBuilder = new StringBuilder();
                for (int i = 1; i <= resultSet.getMetaData().getColumnCount(); ++i) {
                    stringBuilder.append(resultSet.getString(i)).append(",");
                }
                String result = stringBuilder.toString();
                if (result.contains("native")) continue;
                if (result.contains("external UDTF")) {
                    Assert.assertEquals((Object)String.format("UDF,%s,org.apache.iotdb.db.query.udf.example.Adder,", "external UDTF"), (Object)result);
                    ++count;
                    continue;
                }
                if (!result.contains("built-in UDTF")) continue;
                ++count;
            }
            Assert.assertEquals((long)(2 + BUILTIN_FUNCTIONS_COUNT), (long)count);
            resultSet = statement.executeQuery("show temporary functions");
            count = 0;
            while (resultSet.next()) {
                ++count;
            }
            Assert.assertEquals((long)0L, (long)count);
            Assert.assertEquals((long)3L, (long)resultSet.getMetaData().getColumnCount());
            statement.execute("drop function udf");
        }
        catch (SQLException throwable) {
            Assert.fail((String)throwable.getMessage());
        }
        finally {
            UDFRegistrationService.getInstance().deregisterBuiltinFunction("adder");
        }
    }
}

