/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.integration;

import java.sql.DriverManager;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import org.apache.iotdb.db.conf.IoTDBDescriptor;
import org.apache.iotdb.db.utils.EnvironmentUtils;
import org.apache.iotdb.jdbc.IoTDBConnection;
import org.apache.iotdb.rpc.TSStatusCode;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class IoTDBTtlIT {
    @Before
    public void setUp() throws Exception {
        Class.forName("org.apache.iotdb.jdbc.IoTDBDriver");
        EnvironmentUtils.closeStatMonitor();
        EnvironmentUtils.envSetUp();
    }

    @After
    public void tearDown() throws Exception {
        EnvironmentUtils.cleanEnv();
    }

    @Test
    public void testTTL() throws SQLException {
        try (IoTDBConnection connection = (IoTDBConnection)DriverManager.getConnection("jdbc:iotdb://127.0.0.1:6667/", "root", "root");
             Statement statement = connection.createStatement();){
            int cnt;
            int i;
            try {
                statement.execute("SET TTL TO root.TTL_SG1 1000");
            }
            catch (SQLException e) {
                Assert.assertEquals((long)TSStatusCode.TIMESERIES_NOT_EXIST.getStatusCode(), (long)e.getErrorCode());
            }
            try {
                statement.execute("UNSET TTL TO root.TTL_SG1");
            }
            catch (SQLException e) {
                Assert.assertEquals((long)TSStatusCode.TIMESERIES_NOT_EXIST.getStatusCode(), (long)e.getErrorCode());
            }
            statement.execute("SET STORAGE GROUP TO root.TTL_SG1");
            statement.execute("CREATE TIMESERIES root.TTL_SG1.s1 WITH DATATYPE=INT64,ENCODING=PLAIN");
            try {
                statement.execute("SET TTL TO root.TTL_SG1.s1 1000");
            }
            catch (SQLException e) {
                Assert.assertEquals((long)TSStatusCode.METADATA_ERROR.getStatusCode(), (long)e.getErrorCode());
            }
            long now = System.currentTimeMillis();
            for (i = 0; i < 100; ++i) {
                statement.execute(String.format("INSERT INTO root.TTL_SG1(timestamp, s1) VALUES (%d, %d)", now - 100L + (long)i, i));
            }
            for (i = 0; i < 100; ++i) {
                statement.execute(String.format("INSERT INTO root.TTL_SG1(timestamp, s1) VALUES (%d, %d)", now - 100000L + (long)i, i));
            }
            try (ResultSet resultSet = statement.executeQuery("SELECT s1 FROM root.TTL_SG1");){
                cnt = 0;
                while (resultSet.next()) {
                    ++cnt;
                }
                Assert.assertEquals((long)200L, (long)cnt);
            }
            statement.execute("SET TTL TO root.TTL_SG1 10000");
            resultSet = statement.executeQuery("SELECT s1 FROM root.TTL_SG1");
            try {
                cnt = 0;
                while (resultSet.next()) {
                    ++cnt;
                }
                Assert.assertEquals((long)100L, (long)cnt);
            }
            finally {
                if (resultSet != null) {
                    resultSet.close();
                }
            }
            for (int i2 = 0; i2 < 100; ++i2) {
                boolean caught;
                block54: {
                    caught = false;
                    try {
                        statement.execute(String.format("INSERT INTO root.TTL_SG1(timestamp, s1) VALUES (%d, %d)", now - 500000L + (long)i2, i2));
                    }
                    catch (SQLException e) {
                        if (TSStatusCode.OUT_OF_TTL_ERROR.getStatusCode() != e.getErrorCode()) break block54;
                        caught = true;
                    }
                }
                Assert.assertTrue((boolean)caught);
            }
            resultSet = statement.executeQuery("SELECT s1 FROM root.TTL_SG1");
            try {
                cnt = 0;
                while (resultSet.next()) {
                    ++cnt;
                }
                Assert.assertEquals((long)100L, (long)cnt);
            }
            finally {
                if (resultSet != null) {
                    resultSet.close();
                }
            }
            statement.execute("UNSET TTL TO root.TTL_SG1");
            for (int i3 = 0; i3 < 100; ++i3) {
                statement.execute(String.format("INSERT INTO root.TTL_SG1(timestamp, s1) VALUES (%d, %d)", now - 30000L + (long)i3, i3));
            }
            resultSet = statement.executeQuery("SELECT s1 FROM root.TTL_SG1");
            try {
                cnt = 0;
                while (resultSet.next()) {
                    ++cnt;
                }
                Assert.assertTrue((cnt >= 200 ? 1 : 0) != 0);
            }
            finally {
                if (resultSet != null) {
                    resultSet.close();
                }
            }
        }
    }

    @Test
    public void testShowTTL() throws SQLException {
        try (IoTDBConnection connection = (IoTDBConnection)DriverManager.getConnection("jdbc:iotdb://127.0.0.1:6667/", "root", "root");
             Statement statement = connection.createStatement();){
            statement.execute("SET STORAGE GROUP TO root.group1");
            statement.execute("SET STORAGE GROUP TO root.group2");
            String result = this.doQuery(statement, "SHOW ALL TTL");
            Assert.assertTrue((result.equals("root.group1,null\nroot.group2,null\n") || result.equals("root.group2,null\nroot.group1,null\n") ? 1 : 0) != 0);
            result = this.doQuery(statement, "SHOW TTL ON root.group1");
            Assert.assertEquals((Object)"root.group1,null\n", (Object)result);
            statement.execute("SET TTL TO root.group1 10000");
            result = this.doQuery(statement, "SHOW ALL TTL");
            Assert.assertTrue((result.equals("root.group1,10000\nroot.group2,null\n") || result.equals("root.group2,null\nroot.group1,10000\n") ? 1 : 0) != 0);
            result = this.doQuery(statement, "SHOW TTL ON root.group1");
            Assert.assertEquals((Object)"root.group1,10000\n", (Object)result);
            statement.execute("UNSET TTL TO root.group1");
            result = this.doQuery(statement, "SHOW ALL TTL");
            Assert.assertTrue((result.equals("root.group1,null\nroot.group2,null\n") || result.equals("root.group2,null\nroot.group1,null\n") ? 1 : 0) != 0);
            result = this.doQuery(statement, "SHOW TTL ON root.group1");
            Assert.assertEquals((Object)"root.group1,null\n", (Object)result);
        }
    }

    private String doQuery(Statement statement, String query) throws SQLException {
        StringBuilder ret;
        try (ResultSet resultSet = statement.executeQuery(query);){
            ret = new StringBuilder();
            while (resultSet.next()) {
                ret.append(resultSet.getString(1));
                ret.append(",");
                ret.append(resultSet.getString(2));
                ret.append("\n");
            }
        }
        return ret.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testDefaultTTL() throws SQLException {
        IoTDBDescriptor.getInstance().getConfig().setDefaultTTL(10000L);
        try (IoTDBConnection connection = (IoTDBConnection)DriverManager.getConnection("jdbc:iotdb://127.0.0.1:6667/", "root", "root");
             Statement statement = connection.createStatement();){
            statement.execute("SET STORAGE GROUP TO root.group1");
            statement.execute("SET STORAGE GROUP TO root.group2");
            String result = this.doQuery(statement, "SHOW ALL TTL");
            Assert.assertTrue((result.equals("root.group1,10000\nroot.group2,10000\n") || result.equals("root.group2,10000\nroot.group1,10000\n") ? 1 : 0) != 0);
        }
        finally {
            IoTDBDescriptor.getInstance().getConfig().setDefaultTTL(Long.MAX_VALUE);
        }
    }

    @Test
    public void testTTLOnAnyPath() throws SQLException {
        try (IoTDBConnection connection = (IoTDBConnection)DriverManager.getConnection("jdbc:iotdb://127.0.0.1:6667/", "root", "root");
             Statement statement = connection.createStatement();){
            statement.execute("SET STORAGE GROUP TO root.group1");
            statement.execute("SET STORAGE GROUP TO root.group2.sgroup1");
            statement.execute("SET TTL TO root.group2 10000");
            String result = this.doQuery(statement, "SHOW ALL TTL");
            Assert.assertTrue((result.equals("root.group1,null\nroot.group2.sgroup1,10000\n") || result.equals("root.group2.sgroup1 10000\nroot.group1,null\n") ? 1 : 0) != 0);
        }
    }
}

