/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.integration;

import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.Statement;
import org.apache.iotdb.db.conf.IoTDBConfig;
import org.apache.iotdb.db.conf.IoTDBDescriptor;
import org.apache.iotdb.db.utils.EnvironmentUtils;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Test;

public class IoTDBTracingIT {
    @BeforeClass
    public static void setUp() {
        EnvironmentUtils.closeStatMonitor();
        EnvironmentUtils.envSetUp();
    }

    @AfterClass
    public static void tearDown() throws Exception {
        EnvironmentUtils.cleanEnv();
    }

    @Test
    public void tracingTest() throws ClassNotFoundException {
        Class.forName("org.apache.iotdb.jdbc.IoTDBDriver");
        try (Connection connection = DriverManager.getConnection("jdbc:iotdb://127.0.0.1:6667/", "root", "root");
             Statement statement = connection.createStatement();){
            IoTDBConfig config = IoTDBDescriptor.getInstance().getConfig();
            Assert.assertEquals((Object)false, (Object)config.isEnablePerformanceTracing());
            statement.execute("tracing on");
            Assert.assertEquals((Object)true, (Object)config.isEnablePerformanceTracing());
            statement.execute("tracing off");
            Assert.assertEquals((Object)false, (Object)config.isEnablePerformanceTracing());
        }
        catch (Exception e) {
            e.printStackTrace();
            Assert.fail((String)e.getMessage());
        }
    }
}

