/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.integration;

import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import org.apache.iotdb.db.utils.EnvironmentUtils;
import org.apache.iotdb.jdbc.IoTDBConnection;
import org.apache.thrift.TException;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class IoTDBTimeZoneIT {
    private static String[] insertSqls = new String[]{"SET STORAGE GROUP TO root.timezone", "CREATE TIMESERIES root.timezone.tz1 WITH DATATYPE = INT32, ENCODING = PLAIN"};
    private final String TIMESTAMP_STR = "Time";
    private final String tz1 = "root.timezone.tz1";
    private String[] retArray = new String[]{"1514775603000,4", "1514779200000,1", "1514779201000,2", "1514779202000,3", "1514779203000,8", "1514782804000,5", "1514782805000,7", "1514782806000,9", "1514782807000,10", "1514782808000,11", "1514782809000,12", "1514782810000,13", "1514789200000,6"};

    @Before
    public void setUp() throws Exception {
        EnvironmentUtils.closeStatMonitor();
        EnvironmentUtils.envSetUp();
        this.createTimeseries();
    }

    @After
    public void tearDown() throws Exception {
        EnvironmentUtils.cleanEnv();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void timezoneTest() throws ClassNotFoundException, SQLException, TException {
        Class.forName("org.apache.iotdb.jdbc.IoTDBDriver");
        try (IoTDBConnection connection = (IoTDBConnection)DriverManager.getConnection("jdbc:iotdb://127.0.0.1:6667/", "root", "root");
             Statement statement = connection.createStatement();){
            String insertSQLTemplate = "insert into root.timezone(timestamp,tz1) values(%s,%s)";
            connection.setTimeZone("+08:00");
            statement.execute(String.format(insertSQLTemplate, "1514779200000", "1"));
            statement.execute(String.format(insertSQLTemplate, "2018-1-1T12:00:01", "2"));
            statement.execute(String.format(insertSQLTemplate, "2018-1-1T12:00:02+08:00", "3"));
            statement.execute(String.format(insertSQLTemplate, "2018-1-1T12:00:03+09:00", "4"));
            statement.execute(String.format(insertSQLTemplate, "2018-1-1T12:00:04+07:00", "5"));
            connection.setTimeZone("+09:00");
            statement.execute(String.format(insertSQLTemplate, "1514789200000", "6"));
            statement.execute(String.format(insertSQLTemplate, "2018-1-1T14:00:05", "7"));
            statement.execute(String.format(insertSQLTemplate, "2018-1-1T12:00:03+08:00", "8"));
            statement.execute(String.format(insertSQLTemplate, "2018-1-1T12:00:06+07:00", "9"));
            connection.setTimeZone("Asia/Almaty");
            statement.execute(String.format(insertSQLTemplate, "1514782807000", "10"));
            statement.execute(String.format(insertSQLTemplate, "2018-1-1T11:00:08", "11"));
            statement.execute(String.format(insertSQLTemplate, "2018-1-1T13:00:09+08:00", "12"));
            statement.execute(String.format(insertSQLTemplate, "2018-1-1T12:00:10+07:00", "13"));
            boolean hasResultSet = statement.execute("select * from root");
            Assert.assertTrue((boolean)hasResultSet);
            int cnt = 0;
            try (ResultSet resultSet = statement.getResultSet();){
                while (resultSet.next()) {
                    String ans = resultSet.getString("Time") + "," + resultSet.getString("root.timezone.tz1");
                    Assert.assertEquals((Object)this.retArray[cnt], (Object)ans);
                    ++cnt;
                }
            }
            Assert.assertEquals((long)13L, (long)cnt);
        }
    }

    private void createTimeseries() throws ClassNotFoundException {
        Class.forName("org.apache.iotdb.jdbc.IoTDBDriver");
        try (Connection connection = DriverManager.getConnection("jdbc:iotdb://127.0.0.1:6667/", "root", "root");
             Statement statement = connection.createStatement();){
            for (String sql : insertSqls) {
                statement.execute(sql);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            Assert.fail((String)e.getMessage());
        }
    }
}

