/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.integration;

import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.ResultSet;
import java.sql.Statement;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import org.apache.iotdb.db.utils.EnvironmentUtils;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class IoTDBTagIT {
    @Before
    public void setUp() {
        EnvironmentUtils.closeStatMonitor();
        EnvironmentUtils.envSetUp();
    }

    @After
    public void tearDown() throws Exception {
        EnvironmentUtils.cleanEnv();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void createOneTimeseriesTest() throws ClassNotFoundException {
        List<String> ret = Collections.singletonList("root.turbine.d1.s1,temperature,root.turbine,FLOAT,RLE,SNAPPY,{\"tag1\":\"v1\",\"tag2\":\"v2\"},{\"attr2\":\"v2\",\"attr1\":\"v1\"}");
        String sql = "create timeseries root.turbine.d1.s1(temperature) with datatype=FLOAT, encoding=RLE, compression=SNAPPY tags(tag1=v1, tag2=v2) attributes(attr1=v1, attr2=v2)";
        Class.forName("org.apache.iotdb.jdbc.IoTDBDriver");
        try (Connection connection = DriverManager.getConnection("jdbc:iotdb://127.0.0.1:6667/", "root", "root");
             Statement statement = connection.createStatement();){
            statement.execute(sql);
            boolean hasResult = statement.execute("show timeseries");
            Assert.assertTrue((boolean)hasResult);
            int count = 0;
            try (ResultSet resultSet = statement.getResultSet();){
                while (resultSet.next()) {
                    String ans = resultSet.getString("timeseries") + "," + resultSet.getString("alias") + "," + resultSet.getString("storage group") + "," + resultSet.getString("dataType") + "," + resultSet.getString("encoding") + "," + resultSet.getString("compression") + "," + resultSet.getString("tags") + "," + resultSet.getString("attributes");
                    Assert.assertTrue((boolean)ret.contains(ans));
                    ++count;
                }
            }
            Assert.assertEquals((long)ret.size(), (long)count);
        }
        catch (Exception e) {
            e.printStackTrace();
            Assert.fail();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void createMultiTimeseriesTest() throws ClassNotFoundException {
        List<String> ret = Arrays.asList("root.turbine.d2.s1,temperature,root.turbine,FLOAT,RLE,SNAPPY,{\"tag1\":\"t1\",\"tag2\":\"t2\"},{\"attr2\":\"a2\",\"attr1\":\"a1\"}", "root.turbine.d2.s2,status,root.turbine,INT32,RLE,SNAPPY,{\"tag2\":\"t2\",\"tag3\":\"t3\"},{\"attr4\":\"a4\",\"attr3\":\"a3\"}");
        String sql1 = "create timeseries root.turbine.d2.s1(temperature) with datatype=FLOAT, encoding=RLE, compression=SNAPPY tags(tag1=t1, tag2=t2) attributes(attr1=a1, attr2=a2)";
        String sql2 = "create timeseries root.turbine.d2.s2(status) with datatype=INT32, encoding=RLE tags(tag2=t2, tag3=t3) attributes(attr3=a3, attr4=a4)";
        Class.forName("org.apache.iotdb.jdbc.IoTDBDriver");
        try (Connection connection = DriverManager.getConnection("jdbc:iotdb://127.0.0.1:6667/", "root", "root");
             Statement statement = connection.createStatement();){
            statement.execute(sql1);
            statement.execute(sql2);
            boolean hasResult = statement.execute("show timeseries");
            Assert.assertTrue((boolean)hasResult);
            int count = 0;
            try (ResultSet resultSet = statement.getResultSet();){
                while (resultSet.next()) {
                    String ans = resultSet.getString("timeseries") + "," + resultSet.getString("alias") + "," + resultSet.getString("storage group") + "," + resultSet.getString("dataType") + "," + resultSet.getString("encoding") + "," + resultSet.getString("compression") + "," + resultSet.getString("tags") + "," + resultSet.getString("attributes");
                    Assert.assertTrue((boolean)ret.contains(ans));
                    ++count;
                }
            }
            Assert.assertEquals((long)ret.size(), (long)count);
        }
        catch (Exception e) {
            e.printStackTrace();
            Assert.fail();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void showTimeseriesTest() throws ClassNotFoundException {
        List<String> ret = Arrays.asList("root.turbine.d2.s1,temperature,root.turbine,FLOAT,RLE,SNAPPY,{\"tag1\":\"t1\",\"tag2\":\"t2\"},{\"attr2\":\"a2\",\"attr1\":\"a1\"}", "root.turbine.d2.s2,status,root.turbine,INT32,RLE,SNAPPY,{\"tag2\":\"t2\",\"tag3\":\"t3\"},{\"attr4\":\"a4\",\"attr3\":\"a3\"}");
        String sql1 = "create timeseries root.turbine.d2.s1(temperature) with datatype=FLOAT, encoding=RLE, compression=SNAPPY tags(tag1=t1, tag2=t2) attributes(attr1=a1, attr2=a2)";
        String sql2 = "create timeseries root.turbine.d2.s2(status) with datatype=INT32, encoding=RLE tags(tag2=t2, tag3=t3) attributes(attr3=a3, attr4=a4)";
        Class.forName("org.apache.iotdb.jdbc.IoTDBDriver");
        try (Connection connection = DriverManager.getConnection("jdbc:iotdb://127.0.0.1:6667/", "root", "root");
             Statement statement = connection.createStatement();){
            statement.execute(sql1);
            statement.execute(sql2);
            boolean hasResult = statement.execute("show timeseries");
            Assert.assertTrue((boolean)hasResult);
            int count = 0;
            try (ResultSet resultSet = statement.getResultSet();){
                while (resultSet.next()) {
                    String ans = resultSet.getString("timeseries") + "," + resultSet.getString("alias") + "," + resultSet.getString("storage group") + "," + resultSet.getString("dataType") + "," + resultSet.getString("encoding") + "," + resultSet.getString("compression") + "," + resultSet.getString("tags") + "," + resultSet.getString("attributes");
                    Assert.assertTrue((boolean)ret.contains(ans));
                    ++count;
                }
            }
            Assert.assertEquals((long)ret.size(), (long)count);
        }
        catch (Exception e) {
            e.printStackTrace();
            Assert.fail();
        }
    }

    @Test
    public void createDuplicateAliasTimeseriesTest1() throws ClassNotFoundException {
        String sql1 = "create timeseries root.turbine.d3.s1(temperature) with datatype=FLOAT, encoding=RLE, compression=SNAPPY tags(tag1=t1, tag2=t2) attributes(attr1=a1, attr2=a2)";
        String sql2 = "create timeseries root.turbine.d3.s2(temperature) with datatype=INT32, encoding=RLE tags(tag2=t2, tag3=t3) attributes(attr3=a3, attr4=a4)";
        Class.forName("org.apache.iotdb.jdbc.IoTDBDriver");
        try (Connection connection = DriverManager.getConnection("jdbc:iotdb://127.0.0.1:6667/", "root", "root");
             Statement statement = connection.createStatement();){
            statement.execute(sql1);
            try {
                statement.execute(sql2);
                Assert.fail();
            }
            catch (Exception e) {
                Assert.assertTrue((boolean)e.getMessage().contains("Alias [temperature] for Path [root.turbine.d3.s2] already exist"));
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            Assert.fail();
        }
    }

    @Test
    public void createDuplicateAliasTimeseriesTest2() throws ClassNotFoundException {
        String sql1 = "create timeseries root.turbine.d4.s1(temperature) with datatype=FLOAT, encoding=RLE, compression=SNAPPY tags(tag1=t1, tag2=t2) attributes(attr1=a1, attr2=a2)";
        String sql2 = "create timeseries root.turbine.d4.temperature with datatype=INT32, encoding=RLE tags(tag2=t2, tag3=t3) attributes(attr3=a3, attr4=a4)";
        Class.forName("org.apache.iotdb.jdbc.IoTDBDriver");
        try (Connection connection = DriverManager.getConnection("jdbc:iotdb://127.0.0.1:6667/", "root", "root");
             Statement statement = connection.createStatement();){
            statement.execute(sql1);
            try {
                statement.execute(sql2);
                Assert.fail();
            }
            catch (Exception e) {
                Assert.assertTrue((boolean)e.getMessage().contains("Path [root.turbine.d4.temperature] already exist"));
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            Assert.fail();
        }
    }

    @Test
    public void createDuplicateAliasTimeseriesTest3() throws ClassNotFoundException {
        String sql1 = "create timeseries root.turbine.d5.s1(temperature) with datatype=FLOAT, encoding=RLE, compression=SNAPPY tags(tag1=t1, tag2=t2) attributes(attr1=a1, attr2=a2)";
        String sql2 = "create timeseries root.turbine.d5.s2(s1) with datatype=INT32, encoding=RLE tags(tag2=t2, tag3=t3) attributes(attr3=a3, attr4=a4)";
        Class.forName("org.apache.iotdb.jdbc.IoTDBDriver");
        try (Connection connection = DriverManager.getConnection("jdbc:iotdb://127.0.0.1:6667/", "root", "root");
             Statement statement = connection.createStatement();){
            statement.execute(sql1);
            try {
                statement.execute(sql2);
                Assert.fail();
            }
            catch (Exception e) {
                Assert.assertTrue((boolean)e.getMessage().contains("Alias [s1] for Path [root.turbine.d5.s2] already exist"));
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            Assert.fail();
        }
    }

    @Test
    public void queryWithAliasTest() throws ClassNotFoundException {
        List<String> ret = Collections.singletonList("root.turbine.d6.s1,temperature,root.turbine,FLOAT,RLE,SNAPPY,{\"tag1\":\"v1\",\"tag2\":\"v2\"},{\"attr2\":\"v2\",\"attr1\":\"v1\"}");
        String sql = "create timeseries root.turbine.d6.s1(temperature) with datatype=FLOAT, encoding=RLE, compression=SNAPPY tags(tag1=v1, tag2=v2) attributes(attr1=v1, attr2=v2)";
        Class.forName("org.apache.iotdb.jdbc.IoTDBDriver");
        try (Connection connection = DriverManager.getConnection("jdbc:iotdb://127.0.0.1:6667/", "root", "root");
             Statement statement = connection.createStatement();){
            statement.execute(sql);
            boolean hasResult = statement.execute("show timeseries root.turbine.d6.temperature");
            Assert.assertTrue((boolean)hasResult);
            int count = 0;
            try (ResultSet resultSet = statement.getResultSet();){
                while (resultSet.next()) {
                    String ans = resultSet.getString("timeseries") + "," + resultSet.getString("alias") + "," + resultSet.getString("storage group") + "," + resultSet.getString("dataType") + "," + resultSet.getString("encoding") + "," + resultSet.getString("compression") + "," + resultSet.getString("tags") + "," + resultSet.getString("attributes");
                    Assert.assertTrue((boolean)ret.contains(ans));
                    ++count;
                }
            }
            Assert.assertEquals((long)ret.size(), (long)count);
        }
        catch (Exception e) {
            e.printStackTrace();
            Assert.fail();
        }
    }

    @Test
    public void queryWithLimitTest() throws ClassNotFoundException {
        List<String> ret = Arrays.asList("root.turbine.d1.s2,temperature2,root.turbine,FLOAT,RLE,SNAPPY,{\"tag1\":\"v1\",\"tag2\":\"v2\"},{\"attr2\":\"v2\",\"attr1\":\"v1\"}", "root.turbine.d1.s3,temperature3,root.turbine,FLOAT,RLE,SNAPPY,{\"tag1\":\"v1\",\"tag2\":\"v2\"},{\"attr2\":\"v2\",\"attr1\":\"v1\"}");
        Class.forName("org.apache.iotdb.jdbc.IoTDBDriver");
        try (Connection connection = DriverManager.getConnection("jdbc:iotdb://127.0.0.1:6667/", "root", "root");
             Statement statement = connection.createStatement();){
            statement.execute("create timeseries root.turbine.d1.s1(temperature1) with datatype=FLOAT, encoding=RLE, compression=SNAPPY tags(tag1=v1, tag2=v2) attributes(attr1=v1, attr2=v2)");
            statement.execute("create timeseries root.turbine.d1.s2(temperature2) with datatype=FLOAT, encoding=RLE, compression=SNAPPY tags(tag1=v1, tag2=v2) attributes(attr1=v1, attr2=v2)");
            statement.execute("create timeseries root.turbine.d1.s3(temperature3) with datatype=FLOAT, encoding=RLE, compression=SNAPPY tags(tag1=v1, tag2=v2) attributes(attr1=v1, attr2=v2)");
            boolean hasResult = statement.execute("show timeseries root.turbine.d1 where tag1=v1 limit 2 offset 1");
            Assert.assertTrue((boolean)hasResult);
            int count = 0;
            try (ResultSet resultSet = statement.getResultSet();){
                while (resultSet.next()) {
                    String ans = resultSet.getString("timeseries") + "," + resultSet.getString("alias") + "," + resultSet.getString("storage group") + "," + resultSet.getString("dataType") + "," + resultSet.getString("encoding") + "," + resultSet.getString("compression") + "," + resultSet.getString("tags") + "," + resultSet.getString("attributes");
                    Assert.assertTrue((boolean)ret.contains(ans));
                    ++count;
                }
            }
            Assert.assertEquals((long)ret.size(), (long)count);
        }
        catch (Exception e) {
            e.printStackTrace();
            Assert.fail();
        }
    }

    @Test
    public void deleteTest() throws ClassNotFoundException {
        List<String> ret1 = Arrays.asList("root.turbine.d7.s1,temperature,root.turbine,FLOAT,RLE,SNAPPY,{\"tag1\":\"t1\",\"tag2\":\"t2\"},{\"attr2\":\"a2\",\"attr1\":\"a1\"}", "root.turbine.d7.s2,status,root.turbine,INT32,RLE,SNAPPY,{\"tag2\":\"t2\",\"tag3\":\"t3\"},{\"attr4\":\"a4\",\"attr3\":\"a3\"}");
        List<String> ret2 = Collections.singletonList("root.turbine.d7.s1,temperature,root.turbine,FLOAT,RLE,SNAPPY,{\"tag1\":\"t1\",\"tag2\":\"t2\"},{\"attr2\":\"a2\",\"attr1\":\"a1\"}");
        String sql1 = "create timeseries root.turbine.d7.s1(temperature) with datatype=FLOAT, encoding=RLE, compression=SNAPPY tags(tag1=t1, tag2=t2) attributes(attr1=a1, attr2=a2)";
        String sql2 = "create timeseries root.turbine.d7.s2(status) with datatype=INT32, encoding=RLE tags(tag2=t2, tag3=t3) attributes(attr3=a3, attr4=a4)";
        Class.forName("org.apache.iotdb.jdbc.IoTDBDriver");
        try (Connection connection = DriverManager.getConnection("jdbc:iotdb://127.0.0.1:6667/", "root", "root");
             Statement statement = connection.createStatement();){
            String ans;
            statement.execute(sql1);
            statement.execute(sql2);
            boolean hasResult = statement.execute("show timeseries");
            Assert.assertTrue((boolean)hasResult);
            int count = 0;
            try (ResultSet resultSet = statement.getResultSet();){
                while (resultSet.next()) {
                    ans = resultSet.getString("timeseries") + "," + resultSet.getString("alias") + "," + resultSet.getString("storage group") + "," + resultSet.getString("dataType") + "," + resultSet.getString("encoding") + "," + resultSet.getString("compression") + "," + resultSet.getString("tags") + "," + resultSet.getString("attributes");
                    Assert.assertTrue((boolean)ret1.contains(ans));
                    ++count;
                }
            }
            Assert.assertEquals((long)ret1.size(), (long)count);
            statement.execute("delete timeseries root.turbine.d7.s2");
            hasResult = statement.execute("show timeseries");
            Assert.assertTrue((boolean)hasResult);
            count = 0;
            resultSet = statement.getResultSet();
            try {
                while (resultSet.next()) {
                    ans = resultSet.getString("timeseries") + "," + resultSet.getString("alias") + "," + resultSet.getString("storage group") + "," + resultSet.getString("dataType") + "," + resultSet.getString("encoding") + "," + resultSet.getString("compression") + "," + resultSet.getString("tags") + "," + resultSet.getString("attributes");
                    Assert.assertTrue((boolean)ret2.contains(ans));
                    ++count;
                }
            }
            finally {
                if (resultSet != null) {
                    resultSet.close();
                }
            }
            Assert.assertEquals((long)ret2.size(), (long)count);
        }
        catch (Exception e) {
            e.printStackTrace();
            Assert.fail();
        }
    }

    @Test
    public void deleteWithAliasTest() throws ClassNotFoundException {
        List<String> ret1 = Arrays.asList("root.turbine.d7.s1,temperature,root.turbine,FLOAT,RLE,SNAPPY,{\"tag1\":\"t1\",\"tag2\":\"t2\"},{\"attr2\":\"a2\",\"attr1\":\"a1\"}", "root.turbine.d7.s2,status,root.turbine,INT32,RLE,SNAPPY,{\"tag2\":\"t2\",\"tag3\":\"t3\"},{\"attr4\":\"a4\",\"attr3\":\"a3\"}");
        List<String> ret2 = Collections.singletonList("root.turbine.d7.s1,temperature,root.turbine,FLOAT,RLE,SNAPPY,{\"tag1\":\"t1\",\"tag2\":\"t2\"},{\"attr2\":\"a2\",\"attr1\":\"a1\"}");
        String sql1 = "create timeseries root.turbine.d7.s1(temperature) with datatype=FLOAT, encoding=RLE, compression=SNAPPY tags(tag1=t1, tag2=t2) attributes(attr1=a1, attr2=a2)";
        String sql2 = "create timeseries root.turbine.d7.s2(status) with datatype=INT32, encoding=RLE tags(tag2=t2, tag3=t3) attributes(attr3=a3, attr4=a4)";
        Class.forName("org.apache.iotdb.jdbc.IoTDBDriver");
        try (Connection connection = DriverManager.getConnection("jdbc:iotdb://127.0.0.1:6667/", "root", "root");
             Statement statement = connection.createStatement();){
            String ans;
            statement.execute(sql1);
            statement.execute(sql2);
            boolean hasResult = statement.execute("show timeseries");
            Assert.assertTrue((boolean)hasResult);
            int count = 0;
            try (ResultSet resultSet = statement.getResultSet();){
                while (resultSet.next()) {
                    ans = resultSet.getString("timeseries") + "," + resultSet.getString("alias") + "," + resultSet.getString("storage group") + "," + resultSet.getString("dataType") + "," + resultSet.getString("encoding") + "," + resultSet.getString("compression") + "," + resultSet.getString("tags") + "," + resultSet.getString("attributes");
                    Assert.assertTrue((boolean)ret1.contains(ans));
                    ++count;
                }
            }
            Assert.assertEquals((long)ret1.size(), (long)count);
            statement.execute("delete timeseries root.turbine.d7.status");
            hasResult = statement.execute("show timeseries");
            Assert.assertTrue((boolean)hasResult);
            count = 0;
            resultSet = statement.getResultSet();
            try {
                while (resultSet.next()) {
                    ans = resultSet.getString("timeseries") + "," + resultSet.getString("alias") + "," + resultSet.getString("storage group") + "," + resultSet.getString("dataType") + "," + resultSet.getString("encoding") + "," + resultSet.getString("compression") + "," + resultSet.getString("tags") + "," + resultSet.getString("attributes");
                    Assert.assertTrue((boolean)ret2.contains(ans));
                    ++count;
                }
            }
            finally {
                if (resultSet != null) {
                    resultSet.close();
                }
            }
            Assert.assertEquals((long)ret2.size(), (long)count);
        }
        catch (Exception e) {
            e.printStackTrace();
            Assert.fail();
        }
    }

    @Test
    public void queryWithWhereTest1() throws ClassNotFoundException {
        List<String> ret1 = Arrays.asList("root.turbine.d0.s0,temperature,root.turbine,FLOAT,RLE,SNAPPY,{\"description\":\"turbine this is a test1\",\"unit\":\"f\"},{\"H_Alarm\":\"100\",\"M_Alarm\":\"50\"}", "root.turbine.d0.s1,power,root.turbine,FLOAT,RLE,SNAPPY,{\"description\":\"turbine this is a test2\",\"unit\":\"kw\"},{\"H_Alarm\":\"99.9\",\"M_Alarm\":\"44.4\"}", "root.turbine.d1.s0,status,root.turbine,INT32,RLE,SNAPPY,{\"description\":\"turbine this is a test3\"},{\"H_Alarm\":\"9\",\"M_Alarm\":\"5\"}", "root.turbine.d2.s0,temperature,root.turbine,FLOAT,RLE,SNAPPY,{\"description\":\"turbine d2 this is a test1\",\"unit\":\"f\"},{\"MinValue\":\"1\",\"MaxValue\":\"100\"}", "root.turbine.d2.s1,power,root.turbine,FLOAT,RLE,SNAPPY,{\"description\":\"turbine d2 this is a test2\",\"unit\":\"kw\"},{\"MinValue\":\"44.4\",\"MaxValue\":\"99.9\"}", "root.turbine.d2.s3,status,root.turbine,INT32,RLE,SNAPPY,{\"description\":\"turbine d2 this is a test3\"},{\"MinValue\":\"5\",\"MaxValue\":\"9\"}", "root.ln.d0.s0,temperature,root.ln,FLOAT,RLE,SNAPPY,{\"description\":\"ln this is a test1\",\"unit\":\"c\"},{\"H_Alarm\":\"1000\",\"M_Alarm\":\"500\"}", "root.ln.d0.s1,power,root.ln,FLOAT,RLE,SNAPPY,{\"description\":\"ln this is a test2\",\"unit\":\"w\"},{\"H_Alarm\":\"9.9\",\"M_Alarm\":\"4.4\"}", "root.ln.d1.s0,status,root.ln,INT32,RLE,SNAPPY,{\"description\":\"ln this is a test3\"},{\"H_Alarm\":\"90\",\"M_Alarm\":\"50\"}");
        HashSet<String> ret2 = new HashSet<String>();
        ret2.add("root.turbine.d2.s0,temperature,root.turbine,FLOAT,RLE,SNAPPY,{\"description\":\"turbine d2 this is a test1\",\"unit\":\"f\"},{\"MinValue\":\"1\",\"MaxValue\":\"100\"}");
        ret2.add("root.turbine.d0.s0,temperature,root.turbine,FLOAT,RLE,SNAPPY,{\"description\":\"turbine this is a test1\",\"unit\":\"f\"},{\"H_Alarm\":\"100\",\"M_Alarm\":\"50\"}");
        String[] sqls = new String[]{"create timeseries root.turbine.d0.s0(temperature) with datatype=FLOAT, encoding=RLE, compression=SNAPPY tags(unit=f, description='turbine this is a test1') attributes(H_Alarm=100, M_Alarm=50)", "create timeseries root.turbine.d0.s1(power) with datatype=FLOAT, encoding=RLE, compression=SNAPPY tags(unit=kw, description='turbine this is a test2') attributes(H_Alarm=99.9, M_Alarm=44.4)", "create timeseries root.turbine.d1.s0(status) with datatype=INT32, encoding=RLE tags(description='turbine this is a test3') attributes(H_Alarm=9, M_Alarm=5)", "create timeseries root.turbine.d2.s0(temperature) with datatype=FLOAT, encoding=RLE, compression=SNAPPY tags(unit=f, description='turbine d2 this is a test1') attributes(MaxValue=100, MinValue=1)", "create timeseries root.turbine.d2.s1(power) with datatype=FLOAT, encoding=RLE, compression=SNAPPY tags(unit=kw, description='turbine d2 this is a test2') attributes(MaxValue=99.9, MinValue=44.4)", "create timeseries root.turbine.d2.s3(status) with datatype=INT32, encoding=RLE tags(description='turbine d2 this is a test3') attributes(MaxValue=9, MinValue=5)", "create timeseries root.ln.d0.s0(temperature) with datatype=FLOAT, encoding=RLE, compression=SNAPPY tags(unit=c, description='ln this is a test1') attributes(H_Alarm=1000, M_Alarm=500)", "create timeseries root.ln.d0.s1(power) with datatype=FLOAT, encoding=RLE, compression=SNAPPY tags(unit=w, description='ln this is a test2') attributes(H_Alarm=9.9, M_Alarm=4.4)", "create timeseries root.ln.d1.s0(status) with datatype=INT32, encoding=RLE tags(description='ln this is a test3') attributes(H_Alarm=90, M_Alarm=50)"};
        Class.forName("org.apache.iotdb.jdbc.IoTDBDriver");
        try (Connection connection = DriverManager.getConnection("jdbc:iotdb://127.0.0.1:6667/", "root", "root");
             Statement statement = connection.createStatement();){
            for (String sql : sqls) {
                statement.execute(sql);
            }
            boolean hasResult = statement.execute("show timeseries");
            Assert.assertTrue((boolean)hasResult);
            int count = 0;
            try (ResultSet resultSet = statement.getResultSet();){
                while (resultSet.next()) {
                    String ans = resultSet.getString("timeseries") + "," + resultSet.getString("alias") + "," + resultSet.getString("storage group") + "," + resultSet.getString("dataType") + "," + resultSet.getString("encoding") + "," + resultSet.getString("compression") + "," + resultSet.getString("tags") + "," + resultSet.getString("attributes");
                    Assert.assertTrue((boolean)ret1.contains(ans));
                    ++count;
                }
                Assert.assertEquals((long)ret1.size(), (long)count);
            }
            hasResult = statement.execute("show timeseries where unit=f");
            Assert.assertTrue((boolean)hasResult);
            count = 0;
            HashSet<String> res = new HashSet<String>();
            try (ResultSet resultSet = statement.getResultSet();){
                while (resultSet.next()) {
                    String ans = resultSet.getString("timeseries") + "," + resultSet.getString("alias") + "," + resultSet.getString("storage group") + "," + resultSet.getString("dataType") + "," + resultSet.getString("encoding") + "," + resultSet.getString("compression") + "," + resultSet.getString("tags") + "," + resultSet.getString("attributes");
                    res.add(ans);
                    ++count;
                }
                Assert.assertEquals(ret2, res);
                Assert.assertEquals((long)ret2.size(), (long)count);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            Assert.fail();
        }
    }

    @Test
    public void queryWithWhereTest2() throws ClassNotFoundException {
        HashSet<String> ret = new HashSet<String>();
        ret.add("root.turbine.d2.s0,temperature,root.turbine,FLOAT,RLE,SNAPPY,{\"description\":\"turbine d2 this is a test1\",\"unit\":\"f\"},{\"MinValue\":\"1\",\"MaxValue\":\"100\"}");
        ret.add("root.turbine.d0.s0,temperature,root.turbine,FLOAT,RLE,SNAPPY,{\"description\":\"turbine this is a test1\",\"unit\":\"f\"},{\"H_Alarm\":\"100\",\"M_Alarm\":\"50\"}");
        String[] sqls = new String[]{"create timeseries root.turbine.d0.s0(temperature) with datatype=FLOAT, encoding=RLE, compression=SNAPPY tags(unit=f, description='turbine this is a test1') attributes(H_Alarm=100, M_Alarm=50)", "create timeseries root.turbine.d0.s1(power) with datatype=FLOAT, encoding=RLE, compression=SNAPPY tags(unit=kw, description='turbine this is a test2') attributes(H_Alarm=99.9, M_Alarm=44.4)", "create timeseries root.turbine.d1.s0(status) with datatype=INT32, encoding=RLE tags(description='turbine this is a test3') attributes(H_Alarm=9, M_Alarm=5)", "create timeseries root.turbine.d2.s0(temperature) with datatype=FLOAT, encoding=RLE, compression=SNAPPY tags(unit=f, description='turbine d2 this is a test1') attributes(MaxValue=100, MinValue=1)", "create timeseries root.turbine.d2.s1(power) with datatype=FLOAT, encoding=RLE, compression=SNAPPY tags(unit=kw, description='turbine d2 this is a test2') attributes(MaxValue=99.9, MinValue=44.4)", "create timeseries root.turbine.d2.s3(status) with datatype=INT32, encoding=RLE tags(description='turbine d2 this is a test3') attributes(MaxValue=9, MinValue=5)", "create timeseries root.ln.d0.s0(temperature) with datatype=FLOAT, encoding=RLE, compression=SNAPPY tags(unit=f, description='ln this is a test1') attributes(H_Alarm=1000, M_Alarm=500)", "create timeseries root.ln.d0.s1(power) with datatype=FLOAT, encoding=RLE, compression=SNAPPY tags(unit=w, description='ln this is a test2') attributes(H_Alarm=9.9, M_Alarm=4.4)", "create timeseries root.ln.d1.s0(status) with datatype=INT32, encoding=RLE tags(description='ln this is a test3') attributes(H_Alarm=90, M_Alarm=50)"};
        Class.forName("org.apache.iotdb.jdbc.IoTDBDriver");
        try (Connection connection = DriverManager.getConnection("jdbc:iotdb://127.0.0.1:6667/", "root", "root");
             Statement statement = connection.createStatement();){
            String ans;
            for (String sql : sqls) {
                statement.execute(sql);
            }
            boolean hasResult = statement.execute("show timeseries root.turbine.* where unit=f");
            Assert.assertTrue((boolean)hasResult);
            int count = 0;
            HashSet<String> res = new HashSet<String>();
            try (ResultSet resultSet = statement.getResultSet();){
                while (resultSet.next()) {
                    ans = resultSet.getString("timeseries") + "," + resultSet.getString("alias") + "," + resultSet.getString("storage group") + "," + resultSet.getString("dataType") + "," + resultSet.getString("encoding") + "," + resultSet.getString("compression") + "," + resultSet.getString("tags") + "," + resultSet.getString("attributes");
                    res.add(ans);
                    ++count;
                }
            }
            Assert.assertEquals(ret, res);
            Assert.assertEquals((long)ret.size(), (long)count);
            hasResult = statement.execute("show timeseries root.turbine where unit=f");
            Assert.assertTrue((boolean)hasResult);
            count = 0;
            res.clear();
            resultSet = statement.getResultSet();
            try {
                while (resultSet.next()) {
                    ans = resultSet.getString("timeseries") + "," + resultSet.getString("alias") + "," + resultSet.getString("storage group") + "," + resultSet.getString("dataType") + "," + resultSet.getString("encoding") + "," + resultSet.getString("compression") + "," + resultSet.getString("tags") + "," + resultSet.getString("attributes");
                    res.add(ans);
                    ++count;
                }
                Assert.assertEquals(ret, res);
                Assert.assertEquals((long)ret.size(), (long)count);
            }
            finally {
                if (resultSet != null) {
                    resultSet.close();
                }
            }
            statement.execute("show timeseries root.turbine where unit=c");
            count = 0;
            resultSet = statement.getResultSet();
            try {
                while (resultSet.next()) {
                    ++count;
                }
                Assert.assertEquals((long)0L, (long)count);
            }
            finally {
                if (resultSet != null) {
                    resultSet.close();
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            Assert.fail();
        }
    }

    @Test
    public void queryWithWhereAndDeleteTest() throws ClassNotFoundException {
        HashSet<String> ret = new HashSet<String>();
        ret.add("root.turbine.d0.s0,temperature,root.turbine,FLOAT,RLE,SNAPPY,{\"description\":\"turbine this is a test1\",\"unit\":\"f\"},{\"H_Alarm\":\"100\",\"M_Alarm\":\"50\"}");
        ret.add("root.ln.d0.s0,temperature,root.ln,FLOAT,RLE,SNAPPY,{\"description\":\"ln this is a test1\",\"unit\":\"f\"},{\"H_Alarm\":\"1000\",\"M_Alarm\":\"500\"}");
        String[] sqls = new String[]{"create timeseries root.turbine.d0.s0(temperature) with datatype=FLOAT, encoding=RLE, compression=SNAPPY tags(unit=f, description='turbine this is a test1') attributes(H_Alarm=100, M_Alarm=50)", "create timeseries root.turbine.d0.s1(power) with datatype=FLOAT, encoding=RLE, compression=SNAPPY tags(unit=kw, description='turbine this is a test2') attributes(H_Alarm=99.9, M_Alarm=44.4)", "create timeseries root.turbine.d1.s0(status) with datatype=INT32, encoding=RLE tags(description='turbine this is a test3') attributes(H_Alarm=9, M_Alarm=5)", "create timeseries root.turbine.d2.s0(temperature) with datatype=FLOAT, encoding=RLE, compression=SNAPPY tags(unit=f, description='turbine d2 this is a test1') attributes(MaxValue=100, MinValue=1)", "create timeseries root.turbine.d2.s1(power) with datatype=FLOAT, encoding=RLE, compression=SNAPPY tags(unit=kw, description='turbine d2 this is a test2') attributes(MaxValue=99.9, MinValue=44.4)", "create timeseries root.turbine.d2.s3(status) with datatype=INT32, encoding=RLE tags(description='turbine d2 this is a test3') attributes(MaxValue=9, MinValue=5)", "create timeseries root.ln.d0.s0(temperature) with datatype=FLOAT, encoding=RLE, compression=SNAPPY tags(unit=f, description='ln this is a test1') attributes(H_Alarm=1000, M_Alarm=500)", "create timeseries root.ln.d0.s1(power) with datatype=FLOAT, encoding=RLE, compression=SNAPPY tags(unit=w, description='ln this is a test2') attributes(H_Alarm=9.9, M_Alarm=4.4)", "create timeseries root.ln.d1.s0(status) with datatype=INT32, encoding=RLE tags(description='ln this is a test3') attributes(H_Alarm=90, M_Alarm=50)"};
        Class.forName("org.apache.iotdb.jdbc.IoTDBDriver");
        try (Connection connection = DriverManager.getConnection("jdbc:iotdb://127.0.0.1:6667/", "root", "root");
             Statement statement = connection.createStatement();){
            for (String sql : sqls) {
                statement.execute(sql);
            }
            statement.execute("delete timeseries root.turbine.d2.s0");
            boolean hasResult = statement.execute("show timeseries where unit=f");
            Assert.assertTrue((boolean)hasResult);
            int count = 0;
            HashSet<String> res = new HashSet<String>();
            try (ResultSet resultSet = statement.getResultSet();){
                while (resultSet.next()) {
                    String ans = resultSet.getString("timeseries") + "," + resultSet.getString("alias") + "," + resultSet.getString("storage group") + "," + resultSet.getString("dataType") + "," + resultSet.getString("encoding") + "," + resultSet.getString("compression") + "," + resultSet.getString("tags") + "," + resultSet.getString("attributes");
                    res.add(ans);
                    ++count;
                }
            }
            Assert.assertEquals(ret, res);
            Assert.assertEquals((long)ret.size(), (long)count);
        }
        catch (Exception e) {
            e.printStackTrace();
            Assert.fail();
        }
    }

    @Test
    public void queryWithWhereContainsTest() throws ClassNotFoundException {
        HashSet<String> ret = new HashSet<String>();
        ret.add("root.turbine.d2.s0,temperature,root.turbine,FLOAT,RLE,SNAPPY,{\"description\":\"turbine d2 this is a test1\",\"unit\":\"f\"},{\"MinValue\":\"1\",\"MaxValue\":\"100\"}");
        ret.add("root.turbine.d0.s0,temperature,root.turbine,FLOAT,RLE,SNAPPY,{\"description\":\"turbine this is a test1\",\"unit\":\"f\"},{\"H_Alarm\":\"100\",\"M_Alarm\":\"50\"}");
        ret.add("root.ln.d0.s0,temperature,root.ln,FLOAT,RLE,SNAPPY,{\"description\":\"ln this is a test1\",\"unit\":\"f\"},{\"H_Alarm\":\"1000\",\"M_Alarm\":\"500\"}");
        HashSet<String> ret2 = new HashSet<String>();
        ret2.add("root.ln.d0.s0,temperature,root.ln,FLOAT,RLE,SNAPPY,{\"description\":\"ln this is a test1\",\"unit\":\"f\"},{\"H_Alarm\":\"1000\",\"M_Alarm\":\"500\"}");
        String[] sqls = new String[]{"create timeseries root.turbine.d0.s0(temperature) with datatype=FLOAT, encoding=RLE, compression=SNAPPY tags(unit=f, description='turbine this is a test1') attributes(H_Alarm=100, M_Alarm=50)", "create timeseries root.turbine.d0.s1(power) with datatype=FLOAT, encoding=RLE, compression=SNAPPY tags(unit=kw, description='turbine this is a test2') attributes(H_Alarm=99.9, M_Alarm=44.4)", "create timeseries root.turbine.d1.s0(status) with datatype=INT32, encoding=RLE tags(description='turbine this is a test3') attributes(H_Alarm=9, M_Alarm=5)", "create timeseries root.turbine.d2.s0(temperature) with datatype=FLOAT, encoding=RLE, compression=SNAPPY tags(unit=f, description='turbine d2 this is a test1') attributes(MaxValue=100, MinValue=1)", "create timeseries root.turbine.d2.s1(power) with datatype=FLOAT, encoding=RLE, compression=SNAPPY tags(unit=kw, description='turbine d2 this is a test2') attributes(MaxValue=99.9, MinValue=44.4)", "create timeseries root.turbine.d2.s3(status) with datatype=INT32, encoding=RLE tags(description='turbine d2 this is a test3') attributes(MaxValue=9, MinValue=5)", "create timeseries root.ln.d0.s0(temperature) with datatype=FLOAT, encoding=RLE, compression=SNAPPY tags(unit=f, description='ln this is a test1') attributes(H_Alarm=1000, M_Alarm=500)", "create timeseries root.ln.d0.s1(power) with datatype=FLOAT, encoding=RLE, compression=SNAPPY tags(unit=w, description='ln this is a test2') attributes(H_Alarm=9.9, M_Alarm=4.4)", "create timeseries root.ln.d1.s0(status) with datatype=INT32, encoding=RLE tags(description='ln this is a test3') attributes(H_Alarm=90, M_Alarm=50)"};
        Class.forName("org.apache.iotdb.jdbc.IoTDBDriver");
        try (Connection connection = DriverManager.getConnection("jdbc:iotdb://127.0.0.1:6667/", "root", "root");
             Statement statement = connection.createStatement();){
            String ans;
            for (String sql : sqls) {
                statement.execute(sql);
            }
            boolean hasResult = statement.execute("show timeseries where description contains 'test1'");
            Assert.assertTrue((boolean)hasResult);
            int count = 0;
            HashSet<String> res = new HashSet<String>();
            try (ResultSet resultSet = statement.getResultSet();){
                while (resultSet.next()) {
                    ans = resultSet.getString("timeseries") + "," + resultSet.getString("alias") + "," + resultSet.getString("storage group") + "," + resultSet.getString("dataType") + "," + resultSet.getString("encoding") + "," + resultSet.getString("compression") + "," + resultSet.getString("tags") + "," + resultSet.getString("attributes");
                    System.out.println(ans);
                    res.add(ans);
                    ++count;
                }
            }
            Assert.assertEquals(ret, res);
            Assert.assertEquals((long)ret.size(), (long)count);
            hasResult = statement.execute("show timeseries root.ln where description contains 'test1'");
            Assert.assertTrue((boolean)hasResult);
            count = 0;
            res.clear();
            resultSet = statement.getResultSet();
            try {
                while (resultSet.next()) {
                    ans = resultSet.getString("timeseries") + "," + resultSet.getString("alias") + "," + resultSet.getString("storage group") + "," + resultSet.getString("dataType") + "," + resultSet.getString("encoding") + "," + resultSet.getString("compression") + "," + resultSet.getString("tags") + "," + resultSet.getString("attributes");
                    res.add(ans);
                    ++count;
                }
            }
            finally {
                if (resultSet != null) {
                    resultSet.close();
                }
            }
            Assert.assertEquals(ret2, res);
            Assert.assertEquals((long)ret2.size(), (long)count);
        }
        catch (Exception e) {
            e.printStackTrace();
            Assert.fail();
        }
    }

    @Test
    public void queryWithWhereOnNoneTagTest() throws ClassNotFoundException {
        String[] sqls = new String[]{"create timeseries root.turbine.d0.s0(temperature) with datatype=FLOAT, encoding=RLE, compression=SNAPPY tags(unit=f, description='turbine this is a test1') attributes(H_Alarm=100, M_Alarm=50)", "create timeseries root.turbine.d0.s1(power) with datatype=FLOAT, encoding=RLE, compression=SNAPPY tags(unit=kw, description='turbine this is a test2') attributes(H_Alarm=99.9, M_Alarm=44.4)", "create timeseries root.turbine.d1.s0(status) with datatype=INT32, encoding=RLE tags(description='turbine this is a test3') attributes(H_Alarm=9, M_Alarm=5)", "create timeseries root.turbine.d2.s0(temperature) with datatype=FLOAT, encoding=RLE, compression=SNAPPY tags(unit=f, description='turbine d2 this is a test1') attributes(MaxValue=100, MinValue=1)", "create timeseries root.turbine.d2.s1(power) with datatype=FLOAT, encoding=RLE, compression=SNAPPY tags(unit=kw, description='turbine d2 this is a test2') attributes(MaxValue=99.9, MinValue=44.4)", "create timeseries root.turbine.d2.s3(status) with datatype=INT32, encoding=RLE tags(description='turbine d2 this is a test3') attributes(MaxValue=9, MinValue=5)", "create timeseries root.ln.d0.s0(temperature) with datatype=FLOAT, encoding=RLE, compression=SNAPPY tags(unit=f, description='ln this is a test1') attributes(H_Alarm=1000, M_Alarm=500)", "create timeseries root.ln.d0.s1(power) with datatype=FLOAT, encoding=RLE, compression=SNAPPY tags(unit=w, description='ln this is a test2') attributes(H_Alarm=9.9, M_Alarm=4.4)", "create timeseries root.ln.d1.s0(status) with datatype=INT32, encoding=RLE tags(description='ln this is a test3') attributes(H_Alarm=90, M_Alarm=50)"};
        Class.forName("org.apache.iotdb.jdbc.IoTDBDriver");
        try (Connection connection = DriverManager.getConnection("jdbc:iotdb://127.0.0.1:6667/", "root", "root");
             Statement statement = connection.createStatement();){
            for (String sql : sqls) {
                statement.execute(sql);
            }
            try {
                statement.execute("show timeseries where H_Alarm=90");
                Assert.fail();
            }
            catch (Exception e) {
                Assert.assertTrue((boolean)e.getMessage().contains("The key H_Alarm is not a tag"));
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            Assert.fail();
        }
    }

    @Test
    public void sameNameTest() throws ClassNotFoundException {
        String sql = "create timeseries root.turbine.d1.s1(temperature) with datatype=FLOAT, encoding=RLE, compression=SNAPPY tags(tag1=v1, tag2=v2) attributes(tag1=v1, attr2=v2)";
        Class.forName("org.apache.iotdb.jdbc.IoTDBDriver");
        try (Connection connection = DriverManager.getConnection("jdbc:iotdb://127.0.0.1:6667/", "root", "root");
             Statement statement = connection.createStatement();){
            statement.execute(sql);
            Assert.fail();
        }
        catch (Exception e) {
            Assert.assertTrue((boolean)e.getMessage().contains("Tag and attribute shouldn't have the same property key"));
        }
    }

    @Test
    public void deleteStorageGroupTest() throws ClassNotFoundException {
        List<String> ret = Collections.singletonList("root.turbine.d1.s1,temperature,root.turbine,FLOAT,RLE,SNAPPY,{\"tag1\":\"v1\",\"tag2\":\"v2\"},{\"attr2\":\"v2\",\"attr1\":\"v1\"}");
        String sql = "create timeseries root.turbine.d1.s1(temperature) with datatype=FLOAT, encoding=RLE, compression=SNAPPY tags(tag1=v1, tag2=v2) attributes(attr1=v1, attr2=v2)";
        Class.forName("org.apache.iotdb.jdbc.IoTDBDriver");
        try (Connection connection = DriverManager.getConnection("jdbc:iotdb://127.0.0.1:6667/", "root", "root");
             Statement statement = connection.createStatement();){
            statement.execute(sql);
            boolean hasResult = statement.execute("show timeseries");
            Assert.assertTrue((boolean)hasResult);
            int count = 0;
            try (ResultSet resultSet = statement.getResultSet();){
                while (resultSet.next()) {
                    String ans = resultSet.getString("timeseries") + "," + resultSet.getString("alias") + "," + resultSet.getString("storage group") + "," + resultSet.getString("dataType") + "," + resultSet.getString("encoding") + "," + resultSet.getString("compression") + "," + resultSet.getString("tags") + "," + resultSet.getString("attributes");
                    Assert.assertTrue((boolean)ret.contains(ans));
                    ++count;
                }
            }
            Assert.assertEquals((long)ret.size(), (long)count);
            statement.execute("delete storage group root.turbine");
            try {
                statement.execute("show timeseries where tag1=v1");
                Assert.fail();
            }
            catch (Exception e) {
                Assert.assertTrue((boolean)e.getMessage().contains("The key tag1 is not a tag"));
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            Assert.fail();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void insertWithAliasTest() throws ClassNotFoundException {
        List<String> ret = Collections.singletonList("1,36.5,36.5");
        String[] sqls = new String[]{"create timeseries root.turbine.d1.s1(temperature) with datatype=FLOAT, encoding=RLE, compression=SNAPPY", "insert into root.turbine.d1(timestamp, temperature) values(1,36.5)"};
        Class.forName("org.apache.iotdb.jdbc.IoTDBDriver");
        try (Connection connection = DriverManager.getConnection("jdbc:iotdb://127.0.0.1:6667/", "root", "root");
             Statement statement = connection.createStatement();){
            for (String sql : sqls) {
                statement.execute(sql);
            }
            boolean hasResult = statement.execute("select s1, temperature from root.turbine.d1");
            Assert.assertTrue((boolean)hasResult);
            int count = 0;
            try (ResultSet resultSet = statement.getResultSet();){
                while (resultSet.next()) {
                    String ans = resultSet.getString("Time") + "," + resultSet.getString("root.turbine.d1.s1") + "," + resultSet.getString("root.turbine.d1.s1");
                    Assert.assertTrue((boolean)ret.contains(ans));
                    ++count;
                }
            }
            Assert.assertEquals((long)ret.size(), (long)count);
        }
        catch (Exception e) {
            e.printStackTrace();
            Assert.fail();
        }
    }
}

