/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.integration;

import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.ResultSet;
import java.sql.Statement;
import org.apache.iotdb.db.utils.EnvironmentUtils;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class IoTDBTagAlterIT {
    @Before
    public void setUp() {
        EnvironmentUtils.closeStatMonitor();
        EnvironmentUtils.envSetUp();
    }

    @After
    public void tearDown() throws Exception {
        EnvironmentUtils.cleanEnv();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void renameTest() throws ClassNotFoundException {
        String[] ret1 = new String[]{"root.turbine.d1.s1,temperature,root.turbine,FLOAT,RLE,SNAPPY,{\"tag1\":\"v1\",\"tag2\":\"v2\"},{\"attr2\":\"v2\",\"attr1\":\"v1\"}"};
        String[] ret2 = new String[]{"root.turbine.d1.s1,temperature,root.turbine,FLOAT,RLE,SNAPPY,{\"tag2\":\"v2\",\"tagNew1\":\"v1\"},{\"attr2\":\"v2\",\"attr1\":\"v1\"}"};
        String sql = "create timeseries root.turbine.d1.s1(temperature) with datatype=FLOAT, encoding=RLE, compression=SNAPPY tags(tag1=v1, tag2=v2) attributes(attr1=v1, attr2=v2)";
        Class.forName("org.apache.iotdb.jdbc.IoTDBDriver");
        try (Connection connection = DriverManager.getConnection("jdbc:iotdb://127.0.0.1:6667/", "root", "root");
             Statement statement = connection.createStatement();){
            String ans;
            statement.execute(sql);
            boolean hasResult = statement.execute("show timeseries");
            Assert.assertTrue((boolean)hasResult);
            int count = 0;
            try (ResultSet resultSet = statement.getResultSet();){
                while (resultSet.next()) {
                    ans = resultSet.getString("timeseries") + "," + resultSet.getString("alias") + "," + resultSet.getString("storage group") + "," + resultSet.getString("dataType") + "," + resultSet.getString("encoding") + "," + resultSet.getString("compression") + "," + resultSet.getString("tags") + "," + resultSet.getString("attributes");
                    Assert.assertEquals((Object)ret1[count], (Object)ans);
                    ++count;
                }
            }
            Assert.assertEquals((long)ret1.length, (long)count);
            try {
                statement.execute("ALTER timeseries root.turbine.d1.s1 RENAME tag3 TO tagNew3");
                Assert.fail();
            }
            catch (Exception e) {
                Assert.assertTrue((boolean)e.getMessage().contains("TimeSeries [root.turbine.d1.s1] does not have tag/attribute [tag3]."));
            }
            try {
                statement.execute("ALTER timeseries root.turbine.d1.s1 RENAME tag1 TO tag2");
                Assert.fail();
            }
            catch (Exception e) {
                Assert.assertTrue((boolean)e.getMessage().contains("TimeSeries [root.turbine.d1.s1] already has a tag/attribute named [tag2]."));
            }
            statement.execute("ALTER timeseries root.turbine.d1.s1 RENAME tag1 TO tagNew1");
            hasResult = statement.execute("show timeseries");
            Assert.assertTrue((boolean)hasResult);
            resultSet = statement.getResultSet();
            count = 0;
            try {
                while (resultSet.next()) {
                    ans = resultSet.getString("timeseries") + "," + resultSet.getString("alias") + "," + resultSet.getString("storage group") + "," + resultSet.getString("dataType") + "," + resultSet.getString("encoding") + "," + resultSet.getString("compression") + "," + resultSet.getString("tags") + "," + resultSet.getString("attributes");
                    Assert.assertEquals((Object)ret2[count], (Object)ans);
                    ++count;
                }
            }
            finally {
                resultSet.close();
            }
            Assert.assertEquals((long)ret2.length, (long)count);
        }
        catch (Exception e) {
            e.printStackTrace();
            Assert.fail();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void setTest() throws ClassNotFoundException {
        String[] ret = new String[]{"root.turbine.d1.s1,temperature,root.turbine,FLOAT,RLE,SNAPPY,{\"tag1\":\"v1\",\"tag2\":\"v2\"},{\"attr2\":\"v2\",\"attr1\":\"v1\"}"};
        String[] ret2 = new String[]{"root.turbine.d1.s1,temperature,root.turbine,FLOAT,RLE,SNAPPY,{\"tag1\":\"newV1\",\"tag2\":\"v2\"},{\"attr2\":\"newV2\",\"attr1\":\"v1\"}"};
        String sql = "create timeseries root.turbine.d1.s1(temperature) with datatype=FLOAT, encoding=RLE, compression=SNAPPY tags(tag1=v1, tag2=v2) attributes(attr1=v1, attr2=v2)";
        Class.forName("org.apache.iotdb.jdbc.IoTDBDriver");
        try (Connection connection = DriverManager.getConnection("jdbc:iotdb://127.0.0.1:6667/", "root", "root");
             Statement statement = connection.createStatement();){
            String ans;
            statement.execute(sql);
            boolean hasResult = statement.execute("show timeseries");
            Assert.assertTrue((boolean)hasResult);
            int count = 0;
            try (ResultSet resultSet = statement.getResultSet();){
                while (resultSet.next()) {
                    ans = resultSet.getString("timeseries") + "," + resultSet.getString("alias") + "," + resultSet.getString("storage group") + "," + resultSet.getString("dataType") + "," + resultSet.getString("encoding") + "," + resultSet.getString("compression") + "," + resultSet.getString("tags") + "," + resultSet.getString("attributes");
                    Assert.assertEquals((Object)ret[count], (Object)ans);
                    ++count;
                }
            }
            Assert.assertEquals((long)ret.length, (long)count);
            try {
                statement.execute("ALTER timeseries root.turbine.d1.s1 SET tag3=v3");
                Assert.fail();
            }
            catch (Exception e) {
                Assert.assertTrue((boolean)e.getMessage().contains("TimeSeries [root.turbine.d1.s1] does not have tag/attribute [tag3]."));
            }
            statement.execute("ALTER timeseries root.turbine.d1.s1 SET tag1=newV1, attr2=newV2");
            hasResult = statement.execute("show timeseries");
            Assert.assertTrue((boolean)hasResult);
            resultSet = statement.getResultSet();
            count = 0;
            try {
                while (resultSet.next()) {
                    ans = resultSet.getString("timeseries") + "," + resultSet.getString("alias") + "," + resultSet.getString("storage group") + "," + resultSet.getString("dataType") + "," + resultSet.getString("encoding") + "," + resultSet.getString("compression") + "," + resultSet.getString("tags") + "," + resultSet.getString("attributes");
                    Assert.assertEquals((Object)ret2[count], (Object)ans);
                    ++count;
                }
            }
            finally {
                resultSet.close();
            }
            Assert.assertEquals((long)ret2.length, (long)count);
        }
        catch (Exception e) {
            e.printStackTrace();
            Assert.fail();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void dropTest() throws ClassNotFoundException {
        String[] ret = new String[]{"root.turbine.d1.s1,temperature,root.turbine,FLOAT,RLE,SNAPPY,{\"tag1\":\"v1\",\"tag2\":\"v2\"},{\"attr2\":\"v2\",\"attr1\":\"v1\"}"};
        String[] ret2 = new String[]{"root.turbine.d1.s1,temperature,root.turbine,FLOAT,RLE,SNAPPY,{\"tag2\":\"v2\"},{\"attr2\":\"v2\"}"};
        String sql = "create timeseries root.turbine.d1.s1(temperature) with datatype=FLOAT, encoding=RLE, compression=SNAPPY tags(tag1=v1, tag2=v2) attributes(attr1=v1, attr2=v2)";
        Class.forName("org.apache.iotdb.jdbc.IoTDBDriver");
        try (Connection connection = DriverManager.getConnection("jdbc:iotdb://127.0.0.1:6667/", "root", "root");
             Statement statement = connection.createStatement();){
            String ans;
            statement.execute(sql);
            boolean hasResult = statement.execute("show timeseries");
            Assert.assertTrue((boolean)hasResult);
            int count = 0;
            try (ResultSet resultSet = statement.getResultSet();){
                while (resultSet.next()) {
                    ans = resultSet.getString("timeseries") + "," + resultSet.getString("alias") + "," + resultSet.getString("storage group") + "," + resultSet.getString("dataType") + "," + resultSet.getString("encoding") + "," + resultSet.getString("compression") + "," + resultSet.getString("tags") + "," + resultSet.getString("attributes");
                    Assert.assertEquals((Object)ret[count], (Object)ans);
                    ++count;
                }
            }
            Assert.assertEquals((long)ret.length, (long)count);
            statement.execute("ALTER timeseries root.turbine.d1.s1 DROP attr1,tag1");
            hasResult = statement.execute("show timeseries");
            Assert.assertTrue((boolean)hasResult);
            resultSet = statement.getResultSet();
            count = 0;
            try {
                while (resultSet.next()) {
                    ans = resultSet.getString("timeseries") + "," + resultSet.getString("alias") + "," + resultSet.getString("storage group") + "," + resultSet.getString("dataType") + "," + resultSet.getString("encoding") + "," + resultSet.getString("compression") + "," + resultSet.getString("tags") + "," + resultSet.getString("attributes");
                    Assert.assertEquals((Object)ret2[count], (Object)ans);
                    ++count;
                }
            }
            finally {
                resultSet.close();
            }
            Assert.assertEquals((long)ret2.length, (long)count);
            try {
                statement.execute("show timeseries where tag1=v1");
                Assert.fail();
            }
            catch (Exception e) {
                Assert.assertTrue((boolean)e.getMessage().contains("The key tag1 is not a tag"));
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            Assert.fail();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void addTagTest() throws ClassNotFoundException {
        String[] ret = new String[]{"root.turbine.d1.s1,temperature,root.turbine,FLOAT,RLE,SNAPPY,{\"tag1\":\"v1\",\"tag2\":\"v2\"},{\"attr2\":\"v2\",\"attr1\":\"v1\"}"};
        String[] ret2 = new String[]{"root.turbine.d1.s1,temperature,root.turbine,FLOAT,RLE,SNAPPY,{\"tag1\":\"v1\",\"tag4\":\"v4\",\"tag2\":\"v2\",\"tag3\":\"v3\"},{\"attr2\":\"v2\",\"attr1\":\"v1\"}"};
        String sql = "create timeseries root.turbine.d1.s1(temperature) with datatype=FLOAT, encoding=RLE, compression=SNAPPY tags(tag1=v1, tag2=v2) attributes(attr1=v1, attr2=v2)";
        Class.forName("org.apache.iotdb.jdbc.IoTDBDriver");
        try (Connection connection = DriverManager.getConnection("jdbc:iotdb://127.0.0.1:6667/", "root", "root");
             Statement statement = connection.createStatement();){
            String ans;
            statement.execute(sql);
            boolean hasResult = statement.execute("show timeseries");
            Assert.assertTrue((boolean)hasResult);
            int count = 0;
            try (ResultSet resultSet = statement.getResultSet();){
                while (resultSet.next()) {
                    ans = resultSet.getString("timeseries") + "," + resultSet.getString("alias") + "," + resultSet.getString("storage group") + "," + resultSet.getString("dataType") + "," + resultSet.getString("encoding") + "," + resultSet.getString("compression") + "," + resultSet.getString("tags") + "," + resultSet.getString("attributes");
                    Assert.assertEquals((Object)ret[count], (Object)ans);
                    ++count;
                }
            }
            Assert.assertEquals((long)ret.length, (long)count);
            statement.execute("ALTER timeseries root.turbine.d1.s1 ADD TAGS tag3=v3, tag4=v4");
            hasResult = statement.execute("show timeseries where tag3=v3");
            Assert.assertTrue((boolean)hasResult);
            resultSet = statement.getResultSet();
            count = 0;
            try {
                while (resultSet.next()) {
                    ans = resultSet.getString("timeseries") + "," + resultSet.getString("alias") + "," + resultSet.getString("storage group") + "," + resultSet.getString("dataType") + "," + resultSet.getString("encoding") + "," + resultSet.getString("compression") + "," + resultSet.getString("tags") + "," + resultSet.getString("attributes");
                    Assert.assertEquals((Object)ret2[count], (Object)ans);
                    ++count;
                }
            }
            finally {
                resultSet.close();
            }
            Assert.assertEquals((long)ret2.length, (long)count);
        }
        catch (Exception e) {
            e.printStackTrace();
            Assert.fail();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void addAttributeTest() throws ClassNotFoundException {
        String[] ret = new String[]{"root.turbine.d1.s1,temperature,root.turbine,FLOAT,RLE,SNAPPY,{\"tag1\":\"v1\",\"tag2\":\"v2\"},{\"attr2\":\"v2\",\"attr1\":\"v1\"}"};
        String[] ret2 = new String[]{"root.turbine.d1.s1,temperature,root.turbine,FLOAT,RLE,SNAPPY,{\"tag1\":\"v1\",\"tag2\":\"v2\"},{\"attr2\":\"v2\",\"attr1\":\"v1\",\"attr4\":\"v4\",\"attr3\":\"v3\"}"};
        String sql = "create timeseries root.turbine.d1.s1(temperature) with datatype=FLOAT, encoding=RLE, compression=SNAPPY tags(tag1=v1, tag2=v2) attributes(attr1=v1, attr2=v2)";
        Class.forName("org.apache.iotdb.jdbc.IoTDBDriver");
        try (Connection connection = DriverManager.getConnection("jdbc:iotdb://127.0.0.1:6667/", "root", "root");
             Statement statement = connection.createStatement();){
            String ans;
            statement.execute(sql);
            boolean hasResult = statement.execute("show timeseries");
            Assert.assertTrue((boolean)hasResult);
            int count = 0;
            try (ResultSet resultSet = statement.getResultSet();){
                while (resultSet.next()) {
                    ans = resultSet.getString("timeseries") + "," + resultSet.getString("alias") + "," + resultSet.getString("storage group") + "," + resultSet.getString("dataType") + "," + resultSet.getString("encoding") + "," + resultSet.getString("compression") + "," + resultSet.getString("tags") + "," + resultSet.getString("attributes");
                    Assert.assertEquals((Object)ret[count], (Object)ans);
                    ++count;
                }
            }
            Assert.assertEquals((long)ret.length, (long)count);
            statement.execute("ALTER timeseries root.turbine.d1.s1 ADD ATTRIBUTES attr3=v3, attr4=v4");
            hasResult = statement.execute("show timeseries");
            Assert.assertTrue((boolean)hasResult);
            resultSet = statement.getResultSet();
            count = 0;
            try {
                while (resultSet.next()) {
                    ans = resultSet.getString("timeseries") + "," + resultSet.getString("alias") + "," + resultSet.getString("storage group") + "," + resultSet.getString("dataType") + "," + resultSet.getString("encoding") + "," + resultSet.getString("compression") + "," + resultSet.getString("tags") + "," + resultSet.getString("attributes");
                    Assert.assertEquals((Object)ret2[count], (Object)ans);
                    ++count;
                }
            }
            finally {
                resultSet.close();
            }
            Assert.assertEquals((long)ret2.length, (long)count);
        }
        catch (Exception e) {
            e.printStackTrace();
            Assert.fail();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void upsertTest() throws ClassNotFoundException {
        String[] ret = new String[]{"root.turbine.d1.s1,temperature,root.turbine,FLOAT,RLE,SNAPPY,{\"tag1\":\"v1\",\"tag2\":\"v2\"},{\"attr2\":\"v2\",\"attr1\":\"v1\"}"};
        String[] ret2 = new String[]{"root.turbine.d1.s1,temperature,root.turbine,FLOAT,RLE,SNAPPY,{\"tag1\":\"v1\",\"tag2\":\"newV2\",\"tag3\":\"v3\"},{\"attr2\":\"v2\",\"attr1\":\"v1\"}"};
        String[] ret3 = new String[]{"root.turbine.d1.s1,temperature,root.turbine,FLOAT,RLE,SNAPPY,{\"tag1\":\"newV1\",\"tag2\":\"newV2\",\"tag3\":\"newV3\"},{\"attr2\":\"v2\",\"attr1\":\"newA1\",\"attr3\":\"v3\"}"};
        String sql = "create timeseries root.turbine.d1.s1(temperature) with datatype=FLOAT, encoding=RLE, compression=SNAPPY tags(tag1=v1, tag2=v2) attributes(attr1=v1, attr2=v2)";
        Class.forName("org.apache.iotdb.jdbc.IoTDBDriver");
        try (Connection connection = DriverManager.getConnection("jdbc:iotdb://127.0.0.1:6667/", "root", "root");
             Statement statement = connection.createStatement();){
            String ans;
            statement.execute(sql);
            boolean hasResult = statement.execute("show timeseries");
            Assert.assertTrue((boolean)hasResult);
            int count = 0;
            try (ResultSet resultSet = statement.getResultSet();){
                while (resultSet.next()) {
                    ans = resultSet.getString("timeseries") + "," + resultSet.getString("alias") + "," + resultSet.getString("storage group") + "," + resultSet.getString("dataType") + "," + resultSet.getString("encoding") + "," + resultSet.getString("compression") + "," + resultSet.getString("tags") + "," + resultSet.getString("attributes");
                    Assert.assertEquals((Object)ret[count], (Object)ans);
                    ++count;
                }
            }
            Assert.assertEquals((long)ret.length, (long)count);
            statement.execute("ALTER timeseries root.turbine.d1.s1 UPSERT TAGS(tag3=v3, tag2=newV2)");
            hasResult = statement.execute("show timeseries where tag3=v3");
            Assert.assertTrue((boolean)hasResult);
            resultSet = statement.getResultSet();
            count = 0;
            try {
                while (resultSet.next()) {
                    ans = resultSet.getString("timeseries") + "," + resultSet.getString("alias") + "," + resultSet.getString("storage group") + "," + resultSet.getString("dataType") + "," + resultSet.getString("encoding") + "," + resultSet.getString("compression") + "," + resultSet.getString("tags") + "," + resultSet.getString("attributes");
                    Assert.assertEquals((Object)ret2[count], (Object)ans);
                    ++count;
                }
            }
            finally {
                resultSet.close();
            }
            Assert.assertEquals((long)ret2.length, (long)count);
            statement.execute("ALTER timeseries root.turbine.d1.s1 UPSERT TAGS(tag1=newV1, tag3=newV3) ATTRIBUTES(attr1=newA1, attr3=v3)");
            hasResult = statement.execute("show timeseries where tag3=newV3");
            Assert.assertTrue((boolean)hasResult);
            resultSet = statement.getResultSet();
            count = 0;
            try {
                while (resultSet.next()) {
                    ans = resultSet.getString("timeseries") + "," + resultSet.getString("alias") + "," + resultSet.getString("storage group") + "," + resultSet.getString("dataType") + "," + resultSet.getString("encoding") + "," + resultSet.getString("compression") + "," + resultSet.getString("tags") + "," + resultSet.getString("attributes");
                    Assert.assertEquals((Object)ret3[count], (Object)ans);
                    ++count;
                }
                Assert.assertEquals((long)ret3.length, (long)count);
                statement.execute("show timeseries where tag3=v3");
                resultSet = statement.getResultSet();
                Assert.assertFalse((boolean)resultSet.next());
            }
            finally {
                resultSet.close();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            Assert.fail();
        }
    }
}

