/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.integration;

import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Random;
import org.apache.iotdb.db.conf.IoTDBDescriptor;
import org.apache.iotdb.db.exception.metadata.MetadataException;
import org.apache.iotdb.db.metadata.MManager;
import org.apache.iotdb.db.metadata.PartialPath;
import org.apache.iotdb.db.metadata.mnode.MeasurementMNode;
import org.apache.iotdb.db.utils.EnvironmentUtils;
import org.apache.iotdb.jdbc.IoTDBSQLException;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class IoTDBSimpleQueryIT {
    @Before
    public void setUp() {
        EnvironmentUtils.envSetUp();
    }

    @After
    public void tearDown() throws Exception {
        EnvironmentUtils.cleanEnv();
    }

    @Test
    public void testCreateTimeseries1() throws ClassNotFoundException, MetadataException {
        Class.forName("org.apache.iotdb.jdbc.IoTDBDriver");
        try (Connection connection = DriverManager.getConnection("jdbc:iotdb://127.0.0.1:6667/", "root", "root");
             Statement statement = connection.createStatement();){
            statement.setFetchSize(5);
            statement.execute("SET STORAGE GROUP TO root.sg1");
            statement.execute("CREATE TIMESERIES root.sg1.d0.s1 WITH DATATYPE=INT32,ENCODING=PLAIN");
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
        MeasurementMNode mNode = (MeasurementMNode)MManager.getInstance().getNodeByPath(new PartialPath("root.sg1.d0.s1"));
        Assert.assertNull((Object)mNode.getSchema().getProps());
    }

    @Test
    public void testCreateTimeseriesSDTProperties() throws ClassNotFoundException, MetadataException {
        Class.forName("org.apache.iotdb.jdbc.IoTDBDriver");
        try (Connection connection = DriverManager.getConnection("jdbc:iotdb://127.0.0.1:6667/", "root", "root");
             Statement statement = connection.createStatement();){
            statement.setFetchSize(5);
            statement.execute("SET STORAGE GROUP TO root.sg1");
            statement.execute("CREATE TIMESERIES root.sg1.d0.s1 WITH DATATYPE=INT32,ENCODING=PLAIN,LOSS=SDT,COMPDEV=2");
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
        MeasurementMNode mNode = (MeasurementMNode)MManager.getInstance().getNodeByPath(new PartialPath("root.sg1.d0.s1"));
        Assert.assertEquals((long)2L, (long)mNode.getSchema().getProps().size());
    }

    @Test
    public void testCreateTimeseriesWithSDTProperties2() throws ClassNotFoundException, MetadataException {
        Class.forName("org.apache.iotdb.jdbc.IoTDBDriver");
        try (Connection connection = DriverManager.getConnection("jdbc:iotdb://127.0.0.1:6667/", "root", "root");
             Statement statement = connection.createStatement();){
            statement.setFetchSize(5);
            statement.execute("SET STORAGE GROUP TO root.sg1");
            statement.execute("CREATE TIMESERIES root.sg1.d0.s1 WITH DATATYPE=INT32,ENCODING=PLAIN,LOSS=SDT,COMPDEV=2,COMPMINTIME=2,COMPMAXTIME=10");
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
        MeasurementMNode mNode = (MeasurementMNode)MManager.getInstance().getNodeByPath(new PartialPath("root.sg1.d0.s1"));
        Assert.assertEquals((long)4L, (long)mNode.getSchema().getProps().size());
    }

    @Test
    public void testFailedToCreateTimeseriesSDTProperties() throws ClassNotFoundException {
        Class.forName("org.apache.iotdb.jdbc.IoTDBDriver");
        try (Connection connection = DriverManager.getConnection("jdbc:iotdb://127.0.0.1:6667/", "root", "root");
             Statement statement = connection.createStatement();){
            statement.setFetchSize(5);
            statement.execute("SET STORAGE GROUP TO root.sg1");
            try {
                statement.execute("CREATE TIMESERIES root.sg1.d0.s1 WITH DATATYPE=INT32,ENCODING=PLAIN,LOSS=SDT,COMPDEV=-2");
            }
            catch (Exception e) {
                Assert.assertEquals((Object)"318: SDT compression deviation cannot be negative. Failed to create timeseries for path root.sg1.d0.s1", (Object)e.getMessage());
            }
            int count = 0;
            try (ResultSet resultSet = statement.executeQuery("show timeseries");){
                while (resultSet.next()) {
                    ++count;
                }
            }
            Assert.assertEquals((long)0L, (long)count);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    @Test
    public void testLastQueryNonCached() throws ClassNotFoundException {
        Class.forName("org.apache.iotdb.jdbc.IoTDBDriver");
        try (Connection connection = DriverManager.getConnection("jdbc:iotdb://127.0.0.1:6667/", "root", "root");
             Statement statement = connection.createStatement();){
            statement.execute("create timeseries root.turbine.d1.s1 with datatype=FLOAT, encoding=GORILLA, compression=SNAPPY");
            statement.execute("create timeseries root.turbine.d1.s2 with datatype=FLOAT, encoding=GORILLA, compression=SNAPPY");
            statement.execute("create timeseries root.turbine.d2.s1 with datatype=FLOAT, encoding=GORILLA, compression=SNAPPY");
            statement.execute("insert into root.turbine.d1(timestamp,s1,s2) values(1,1,2)");
            String[] results = new String[]{"root.turbine.d1.s1", "root.turbine.d1.s2"};
            int count = 0;
            try (ResultSet resultSet = statement.executeQuery("select last * from root");){
                while (resultSet.next()) {
                    String path = resultSet.getString("timeseries");
                    Assert.assertEquals((Object)results[count], (Object)path);
                    ++count;
                }
            }
            Assert.assertEquals((long)2L, (long)count);
            resultSet = statement.executeQuery("select last * from root");
            try {
                while (resultSet.next()) {
                    ++count;
                }
            }
            finally {
                if (resultSet != null) {
                    resultSet.close();
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    @Test
    public void testSDTEncodingSeq() throws ClassNotFoundException {
        Class.forName("org.apache.iotdb.jdbc.IoTDBDriver");
        try (Connection connection = DriverManager.getConnection("jdbc:iotdb://127.0.0.1:6667/", "root", "root");
             Statement statement = connection.createStatement();){
            statement.setFetchSize(5);
            statement.execute("SET STORAGE GROUP TO root.sg1");
            statement.execute("CREATE TIMESERIES root.sg1.d0.s0 WITH DATATYPE=DOUBLE,ENCODING=PLAIN,LOSS=SDT,COMPDEV=0.01");
            int degree = 0;
            for (int time = 0; time < 100; ++time) {
                double value = 10.0 * Math.sin((double)degree++ * Math.PI / 180.0);
                String sql = "insert into root.sg1.d0(timestamp,s0) values(" + time + "," + value + ")";
                statement.execute(sql);
            }
            ResultSet resultSet = statement.executeQuery("select s0 from root.sg1.d0");
            int count = 0;
            while (resultSet.next()) {
                ++count;
            }
            Assert.assertEquals((long)count, (long)100L);
            statement.execute("flush");
            resultSet = statement.executeQuery("select s0 from root.sg1.d0");
            count = 0;
            while (resultSet.next()) {
                ++count;
            }
            Assert.assertEquals((long)15L, (long)count);
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
    }

    @Test
    public void testSDTEncodingCompDev() throws ClassNotFoundException {
        Class.forName("org.apache.iotdb.jdbc.IoTDBDriver");
        try (Connection connection = DriverManager.getConnection("jdbc:iotdb://127.0.0.1:6667/", "root", "root");
             Statement statement = connection.createStatement();){
            statement.setFetchSize(5);
            statement.execute("SET STORAGE GROUP TO root.sg1");
            statement.execute("CREATE TIMESERIES root.sg1.d0.s0 WITH DATATYPE=INT32,ENCODING=PLAIN,LOSS=SDT,COMPDEV=2");
            for (int time = 1; time < 8; ++time) {
                String sql = "insert into root.sg1.d0(timestamp,s0) values(" + time + ",1)";
                statement.execute(sql);
            }
            statement.execute("flush");
            String sql = "insert into root.sg1.d0(timestamp,s0) values(15,10)";
            statement.execute(sql);
            sql = "insert into root.sg1.d0(timestamp,s0) values(16,20)";
            statement.execute(sql);
            sql = "insert into root.sg1.d0(timestamp,s0) values(17,1)";
            statement.execute(sql);
            sql = "insert into root.sg1.d0(timestamp,s0) values(18,30)";
            statement.execute(sql);
            statement.execute("flush");
            ResultSet resultSet = statement.executeQuery("select * from root");
            int count = 0;
            String[] timestamps = new String[]{"1", "7", "15", "16", "17", "18"};
            String[] values = new String[]{"1", "1", "10", "20", "1", "30"};
            while (resultSet.next()) {
                Assert.assertEquals((Object)timestamps[count], (Object)resultSet.getString("Time"));
                Assert.assertEquals((Object)values[count], (Object)resultSet.getString("root.sg1.d0.s0"));
                ++count;
            }
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
    }

    @Test
    public void testSDTEncodingSelectFill() throws ClassNotFoundException {
        Class.forName("org.apache.iotdb.jdbc.IoTDBDriver");
        try (Connection connection = DriverManager.getConnection("jdbc:iotdb://127.0.0.1:6667/", "root", "root");
             Statement statement = connection.createStatement();){
            String sql;
            int i;
            statement.setFetchSize(5);
            statement.execute("SET STORAGE GROUP TO root.sg1");
            double compDev = 2.0;
            statement.execute("CREATE TIMESERIES root.sg1.d0.s0 WITH DATATYPE=INT32,ENCODING=PLAIN,LOSS=SDT,COMPDEV=" + compDev);
            int[] originalValues = new int[1000];
            HashMap<String, Integer> map = new HashMap<String, Integer>();
            Random rand = new Random();
            for (i = 1; i < originalValues.length; ++i) {
                originalValues[i] = rand.nextInt(500);
                sql = "insert into root.sg1.d0(timestamp,s0) values(" + i + "," + originalValues[i] + ")";
                statement.execute(sql);
                map.put(i + "", originalValues[i]);
            }
            statement.execute("flush");
            for (i = 1; i < originalValues.length; ++i) {
                sql = "select * from root where time = " + i + " fill(int32 [linear, 20ms, 20ms])";
                ResultSet resultSet = statement.executeQuery(sql);
                while (resultSet.next()) {
                    String time = resultSet.getString("Time");
                    String value = resultSet.getString("root.sg1.d0.s0");
                    if (value == null) continue;
                    Assert.assertTrue(((double)Math.abs(Integer.parseInt(value) - (Integer)map.get(time)) <= 2.0 * compDev ? 1 : 0) != 0);
                }
            }
        }
        catch (SQLException e) {
            Assert.fail();
        }
    }

    @Test
    public void testSDTEncodingCompMin() throws ClassNotFoundException {
        Class.forName("org.apache.iotdb.jdbc.IoTDBDriver");
        try (Connection connection = DriverManager.getConnection("jdbc:iotdb://127.0.0.1:6667/", "root", "root");
             Statement statement = connection.createStatement();){
            statement.setFetchSize(5);
            statement.execute("SET STORAGE GROUP TO root.sg1");
            statement.execute("CREATE TIMESERIES root.sg1.d0.s0 WITH DATATYPE=INT32,ENCODING=PLAIN,LOSS=SDT,COMPDEV=2, COMPMINTIME=1");
            for (int time = 1; time < 8; ++time) {
                String sql = "insert into root.sg1.d0(timestamp,s0) values(" + time + ",1)";
                statement.execute(sql);
            }
            statement.execute("flush");
            String sql = "insert into root.sg1.d0(timestamp,s0) values(15,10)";
            statement.execute(sql);
            sql = "insert into root.sg1.d0(timestamp,s0) values(16,20)";
            statement.execute(sql);
            sql = "insert into root.sg1.d0(timestamp,s0) values(17,1)";
            statement.execute(sql);
            sql = "insert into root.sg1.d0(timestamp,s0) values(18,30)";
            statement.execute(sql);
            statement.execute("flush");
            ResultSet resultSet = statement.executeQuery("select * from root");
            int count = 0;
            String[] timestamps = new String[]{"1", "7", "15", "17", "18"};
            String[] values = new String[]{"1", "1", "10", "1", "30"};
            while (resultSet.next()) {
                Assert.assertEquals((Object)timestamps[count], (Object)resultSet.getString("Time"));
                Assert.assertEquals((Object)values[count], (Object)resultSet.getString("root.sg1.d0.s0"));
                ++count;
            }
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
    }

    @Test
    public void testSDTEncodingCompMax() throws ClassNotFoundException {
        Class.forName("org.apache.iotdb.jdbc.IoTDBDriver");
        try (Connection connection = DriverManager.getConnection("jdbc:iotdb://127.0.0.1:6667/", "root", "root");
             Statement statement = connection.createStatement();){
            statement.setFetchSize(5);
            statement.execute("SET STORAGE GROUP TO root.sg1");
            statement.execute("CREATE TIMESERIES root.sg1.d0.s0 WITH DATATYPE=INT32,ENCODING=PLAIN,LOSS=SDT,COMPDEV=2, COMPMAXTIME=20");
            for (int time = 1; time < 50; ++time) {
                String sql = "insert into root.sg1.d0(timestamp,s0) values(" + time + ",1)";
                statement.execute(sql);
            }
            statement.execute("flush");
            ResultSet resultSet = statement.executeQuery("select * from root");
            int count = 0;
            String[] timestamps = new String[]{"1", "21", "41", "49"};
            String[] values = new String[]{"1", "1", "1", "1"};
            while (resultSet.next()) {
                Assert.assertEquals((Object)timestamps[count], (Object)resultSet.getString("Time"));
                Assert.assertEquals((Object)values[count], (Object)resultSet.getString("root.sg1.d0.s0"));
                ++count;
            }
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
    }

    @Test
    public void testSDTEncodingUnseq() throws ClassNotFoundException {
        Class.forName("org.apache.iotdb.jdbc.IoTDBDriver");
        try (Connection connection = DriverManager.getConnection("jdbc:iotdb://127.0.0.1:6667/", "root", "root");
             Statement statement = connection.createStatement();){
            statement.setFetchSize(5);
            statement.execute("SET STORAGE GROUP TO root.sg1");
            statement.execute("CREATE TIMESERIES root.sg1.d0.s0 WITH DATATYPE=DOUBLE,ENCODING=PLAIN,LOSS=SDT,COMPDEV=0.01");
            int degree = 0;
            for (int time = 0; time < 100; ++time) {
                double value = 10.0 * Math.sin((double)degree++ * Math.PI / 180.0);
                String sql = "insert into root.sg1.d0(timestamp,s0) values(" + time + "," + value + ")";
                statement.execute(sql);
            }
            String sql = "insert into root.sg1.d0(timestamp,s0) values(2,19)";
            statement.execute(sql);
            ResultSet resultSet = statement.executeQuery("select s0 from root.sg1.d0");
            int count = 0;
            while (resultSet.next()) {
                ++count;
            }
            Assert.assertEquals((long)count, (long)100L);
            statement.execute("flush");
            resultSet = statement.executeQuery("select s0 from root.sg1.d0");
            count = 0;
            while (resultSet.next()) {
                ++count;
            }
            Assert.assertEquals((long)18L, (long)count);
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
    }

    @Test
    public void testSDTEncodingMergeSeq() throws ClassNotFoundException {
        Class.forName("org.apache.iotdb.jdbc.IoTDBDriver");
        try (Connection connection = DriverManager.getConnection("jdbc:iotdb://127.0.0.1:6667/", "root", "root");
             Statement statement = connection.createStatement();){
            statement.setFetchSize(5);
            statement.execute("SET STORAGE GROUP TO root.sg1");
            statement.execute("CREATE TIMESERIES root.sg1.d0.s0 WITH DATATYPE=DOUBLE,ENCODING=PLAIN,LOSS=SDT,COMPDEV=0.01");
            int degree = 0;
            for (int time = 0; time < 100; ++time) {
                double value = 10.0 * Math.sin((double)degree++ * Math.PI / 180.0);
                String sql = "insert into root.sg1.d0(timestamp,s0) values(" + time + "," + value + ")";
                statement.execute(sql);
            }
            ResultSet resultSet = statement.executeQuery("select s0 from root.sg1.d0");
            int count = 0;
            while (resultSet.next()) {
                ++count;
            }
            Assert.assertEquals((long)100L, (long)count);
            statement.execute("flush");
            resultSet = statement.executeQuery("select s0 from root.sg1.d0");
            count = 0;
            while (resultSet.next()) {
                ++count;
            }
            Assert.assertEquals((long)15L, (long)count);
            statement.execute("merge");
            resultSet = statement.executeQuery("select s0 from root.sg1.d0");
            count = 0;
            while (resultSet.next()) {
                ++count;
            }
            Assert.assertEquals((long)15L, (long)count);
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
    }

    @Test
    public void testSDTEncodingMergeUnseq() throws ClassNotFoundException {
        Class.forName("org.apache.iotdb.jdbc.IoTDBDriver");
        try (Connection connection = DriverManager.getConnection("jdbc:iotdb://127.0.0.1:6667/", "root", "root");
             Statement statement = connection.createStatement();){
            statement.setFetchSize(5);
            statement.execute("SET STORAGE GROUP TO root.sg1");
            statement.execute("CREATE TIMESERIES root.sg1.d0.s0 WITH DATATYPE=DOUBLE,ENCODING=PLAIN,LOSS=SDT,COMPDEV=0.01");
            int degree = 0;
            for (int time = 0; time < 100; ++time) {
                double value = 10.0 * Math.sin((double)degree++ * Math.PI / 180.0);
                String sql = "insert into root.sg1.d0(timestamp,s0) values(" + time + "," + value + ")";
                statement.execute(sql);
            }
            String sql = "insert into root.sg1.d0(timestamp,s0) values(2,19)";
            statement.execute(sql);
            ResultSet resultSet = statement.executeQuery("select s0 from root.sg1.d0");
            int count = 0;
            while (resultSet.next()) {
                ++count;
            }
            Assert.assertEquals((long)100L, (long)count);
            statement.execute("flush");
            resultSet = statement.executeQuery("select s0 from root.sg1.d0");
            count = 0;
            while (resultSet.next()) {
                ++count;
            }
            Assert.assertEquals((long)18L, (long)count);
            statement.execute("merge");
            resultSet = statement.executeQuery("select s0 from root.sg1.d0");
            count = 0;
            while (resultSet.next()) {
                ++count;
            }
            Assert.assertEquals((long)18L, (long)count);
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testEmptyDataSet() throws SQLException, ClassNotFoundException {
        Class.forName("org.apache.iotdb.jdbc.IoTDBDriver");
        try (Connection connection = DriverManager.getConnection("jdbc:iotdb://127.0.0.1:6667/", "root", "root");
             Statement statement = connection.createStatement();){
            Assert.assertEquals((long)1L, (long)resultSet.getMetaData().getColumnCount());
            try (ResultSet resultSet = statement.executeQuery("select * from root");){
                while (resultSet.next()) {
                    Assert.fail();
                }
                resultSet = statement.executeQuery("select count(*) from root where time >= 1 and time <= 100 group by ([0, 100), 20ms, 20ms)");
                Assert.assertEquals((long)1L, (long)resultSet.getMetaData().getColumnCount());
                while (resultSet.next()) {
                    Assert.fail();
                }
                resultSet = statement.executeQuery("select count(*) from root");
                Assert.assertEquals((long)0L, (long)resultSet.getMetaData().getColumnCount());
                while (resultSet.next()) {
                    Assert.fail();
                }
                resultSet = statement.executeQuery("select * from root align by device");
                Assert.assertEquals((long)2L, (long)resultSet.getMetaData().getColumnCount());
                while (resultSet.next()) {
                    Assert.fail();
                }
                resultSet = statement.executeQuery("select count(*) from root align by device");
                Assert.assertEquals((long)1L, (long)resultSet.getMetaData().getColumnCount());
                while (resultSet.next()) {
                    Assert.fail();
                }
                resultSet = statement.executeQuery("select count(*) from root where time >= 1 and time <= 100 group by ([0, 100), 20ms, 20ms) align by device");
                Assert.assertEquals((long)2L, (long)resultSet.getMetaData().getColumnCount());
                while (resultSet.next()) {
                    Assert.fail();
                }
            }
            resultSet.close();
        }
    }

    @Test
    public void testOrderByTimeDesc() throws Exception {
        Class.forName("org.apache.iotdb.jdbc.IoTDBDriver");
        try (Connection connection = DriverManager.getConnection("jdbc:iotdb://127.0.0.1:6667/", "root", "root");
             Statement statement = connection.createStatement();){
            statement.setFetchSize(5);
            statement.execute("SET STORAGE GROUP TO root.sg1");
            statement.execute("CREATE TIMESERIES root.sg1.d0.s0 WITH DATATYPE=INT32,ENCODING=PLAIN");
            statement.execute("CREATE TIMESERIES root.sg1.d0.s1 WITH DATATYPE=INT32,ENCODING=PLAIN");
            statement.execute("INSERT INTO root.sg1.d0(timestamp, s0) VALUES (1, 1)");
            statement.execute("INSERT INTO root.sg1.d0(timestamp, s0) VALUES (2, 2)");
            statement.execute("INSERT INTO root.sg1.d0(timestamp, s0) VALUES (3, 3)");
            statement.execute("INSERT INTO root.sg1.d0(timestamp, s0) VALUES (4, 4)");
            statement.execute("INSERT INTO root.sg1.d0(timestamp, s1) VALUES (3, 3)");
            statement.execute("INSERT INTO root.sg1.d0(timestamp, s1) VALUES (1, 1)");
            statement.execute("flush");
            String[] ret = new String[]{"4,4,null", "3,3,3", "2,2,null", "1,1,1"};
            int cur = 0;
            try (ResultSet resultSet = statement.executeQuery("select * from root order by time desc");){
                while (resultSet.next()) {
                    String ans = resultSet.getString("Time") + "," + resultSet.getString("root.sg1.d0.s0") + "," + resultSet.getString("root.sg1.d0.s1");
                    Assert.assertEquals((Object)ret[cur], (Object)ans);
                    ++cur;
                }
            }
        }
    }

    @Test
    public void testShowTimeseriesDataSet1() throws ClassNotFoundException {
        Class.forName("org.apache.iotdb.jdbc.IoTDBDriver");
        try (Connection connection = DriverManager.getConnection("jdbc:iotdb://127.0.0.1:6667/", "root", "root");
             Statement statement = connection.createStatement();){
            statement.setFetchSize(5);
            statement.execute("SET STORAGE GROUP TO root.sg1");
            statement.execute("CREATE TIMESERIES root.sg1.d0.s1 WITH DATATYPE=INT32,ENCODING=PLAIN");
            statement.execute("CREATE TIMESERIES root.sg1.d0.s2 WITH DATATYPE=INT32,ENCODING=PLAIN");
            statement.execute("CREATE TIMESERIES root.sg1.d0.s3 WITH DATATYPE=INT32,ENCODING=PLAIN");
            statement.execute("CREATE TIMESERIES root.sg1.d0.s4 WITH DATATYPE=INT32,ENCODING=PLAIN");
            statement.execute("CREATE TIMESERIES root.sg1.d0.s5 WITH DATATYPE=INT32,ENCODING=PLAIN");
            statement.execute("CREATE TIMESERIES root.sg1.d0.s6 WITH DATATYPE=INT32,ENCODING=PLAIN");
            statement.execute("CREATE TIMESERIES root.sg1.d0.s7 WITH DATATYPE=INT32,ENCODING=PLAIN");
            statement.execute("CREATE TIMESERIES root.sg1.d0.s8 WITH DATATYPE=INT32,ENCODING=PLAIN");
            statement.execute("CREATE TIMESERIES root.sg1.d0.s9 WITH DATATYPE=INT32,ENCODING=PLAIN");
            statement.execute("CREATE TIMESERIES root.sg1.d0.s10 WITH DATATYPE=INT32,ENCODING=PLAIN");
            statement.execute("flush");
            int count = 0;
            try (ResultSet resultSet = statement.executeQuery("show timeseries");){
                while (resultSet.next()) {
                    ++count;
                }
            }
            Assert.assertEquals((long)10L, (long)count);
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
    }

    @Test
    public void testShowTimeseriesDataSet2() throws ClassNotFoundException {
        Class.forName("org.apache.iotdb.jdbc.IoTDBDriver");
        try (Connection connection = DriverManager.getConnection("jdbc:iotdb://127.0.0.1:6667/", "root", "root");
             Statement statement = connection.createStatement();){
            statement.setFetchSize(10);
            statement.execute("SET STORAGE GROUP TO root.sg1");
            statement.execute("CREATE TIMESERIES root.sg1.d0.s1 WITH DATATYPE=INT32,ENCODING=PLAIN");
            statement.execute("CREATE TIMESERIES root.sg1.d0.s2 WITH DATATYPE=INT32,ENCODING=PLAIN");
            statement.execute("CREATE TIMESERIES root.sg1.d0.s3 WITH DATATYPE=INT32,ENCODING=PLAIN");
            statement.execute("CREATE TIMESERIES root.sg1.d0.s4 WITH DATATYPE=INT32,ENCODING=PLAIN");
            statement.execute("CREATE TIMESERIES root.sg1.d0.s5 WITH DATATYPE=INT32,ENCODING=PLAIN");
            statement.execute("CREATE TIMESERIES root.sg1.d0.s6 WITH DATATYPE=INT32,ENCODING=PLAIN");
            statement.execute("CREATE TIMESERIES root.sg1.d0.s7 WITH DATATYPE=INT32,ENCODING=PLAIN");
            statement.execute("CREATE TIMESERIES root.sg1.d0.s8 WITH DATATYPE=INT32,ENCODING=PLAIN");
            statement.execute("CREATE TIMESERIES root.sg1.d0.s9 WITH DATATYPE=INT32,ENCODING=PLAIN");
            statement.execute("CREATE TIMESERIES root.sg1.d0.s10 WITH DATATYPE=INT32,ENCODING=PLAIN");
            statement.execute("flush");
            int count = 0;
            try (ResultSet resultSet = statement.executeQuery("show timeseries");){
                while (resultSet.next()) {
                    ++count;
                }
            }
            Assert.assertEquals((long)10L, (long)count);
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
    }

    @Test
    public void testShowTimeseriesDataSet3() throws ClassNotFoundException {
        Class.forName("org.apache.iotdb.jdbc.IoTDBDriver");
        try (Connection connection = DriverManager.getConnection("jdbc:iotdb://127.0.0.1:6667/", "root", "root");
             Statement statement = connection.createStatement();){
            statement.setFetchSize(15);
            statement.execute("SET STORAGE GROUP TO root.sg1");
            statement.execute("CREATE TIMESERIES root.sg1.d0.s1 WITH DATATYPE=INT32,ENCODING=PLAIN");
            statement.execute("CREATE TIMESERIES root.sg1.d0.s2 WITH DATATYPE=INT32,ENCODING=PLAIN");
            statement.execute("CREATE TIMESERIES root.sg1.d0.s3 WITH DATATYPE=INT32,ENCODING=PLAIN");
            statement.execute("CREATE TIMESERIES root.sg1.d0.s4 WITH DATATYPE=INT32,ENCODING=PLAIN");
            statement.execute("CREATE TIMESERIES root.sg1.d0.s5 WITH DATATYPE=INT32,ENCODING=PLAIN");
            statement.execute("CREATE TIMESERIES root.sg1.d0.s6 WITH DATATYPE=INT32,ENCODING=PLAIN");
            statement.execute("CREATE TIMESERIES root.sg1.d0.s7 WITH DATATYPE=INT32,ENCODING=PLAIN");
            statement.execute("CREATE TIMESERIES root.sg1.d0.s8 WITH DATATYPE=INT32,ENCODING=PLAIN");
            statement.execute("CREATE TIMESERIES root.sg1.d0.s9 WITH DATATYPE=INT32,ENCODING=PLAIN");
            statement.execute("CREATE TIMESERIES root.sg1.d0.s10 WITH DATATYPE=INT32,ENCODING=PLAIN");
            statement.execute("flush");
            int count = 0;
            try (ResultSet resultSet = statement.executeQuery("show timeseries");){
                while (resultSet.next()) {
                    ++count;
                }
            }
            Assert.assertEquals((long)10L, (long)count);
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
    }

    @Test
    public void testShowTimeseriesDataSet4() throws ClassNotFoundException {
        Class.forName("org.apache.iotdb.jdbc.IoTDBDriver");
        try (Connection connection = DriverManager.getConnection("jdbc:iotdb://127.0.0.1:6667/", "root", "root");
             Statement statement = connection.createStatement();){
            statement.setFetchSize(5);
            statement.execute("SET STORAGE GROUP TO root.sg1");
            statement.execute("CREATE TIMESERIES root.sg1.d0.s1 WITH DATATYPE=INT32,ENCODING=PLAIN");
            statement.execute("CREATE TIMESERIES root.sg1.d0.s2 WITH DATATYPE=INT32,ENCODING=PLAIN");
            statement.execute("CREATE TIMESERIES root.sg1.d0.s3 WITH DATATYPE=INT32,ENCODING=PLAIN");
            statement.execute("CREATE TIMESERIES root.sg1.d0.s4 WITH DATATYPE=INT32,ENCODING=PLAIN");
            statement.execute("CREATE TIMESERIES root.sg1.d0.s5 WITH DATATYPE=INT32,ENCODING=PLAIN");
            statement.execute("CREATE TIMESERIES root.sg1.d0.s6 WITH DATATYPE=INT32,ENCODING=PLAIN");
            statement.execute("CREATE TIMESERIES root.sg1.d0.s7 WITH DATATYPE=INT32,ENCODING=PLAIN");
            statement.execute("CREATE TIMESERIES root.sg1.d0.s8 WITH DATATYPE=INT32,ENCODING=PLAIN");
            statement.execute("CREATE TIMESERIES root.sg1.d0.s9 WITH DATATYPE=INT32,ENCODING=PLAIN");
            statement.execute("CREATE TIMESERIES root.sg1.d0.s10 WITH DATATYPE=INT32,ENCODING=PLAIN");
            statement.execute("flush");
            int count = 0;
            try (ResultSet resultSet = statement.executeQuery("show timeseries limit 8");){
                while (resultSet.next()) {
                    ++count;
                }
            }
            Assert.assertEquals((long)8L, (long)count);
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
    }

    @Test
    public void testShowTimeseriesWithLimitOffset() throws SQLException, ClassNotFoundException {
        Class.forName("org.apache.iotdb.jdbc.IoTDBDriver");
        try (Connection connection = DriverManager.getConnection("jdbc:iotdb://127.0.0.1:6667/", "root", "root");
             Statement statement = connection.createStatement();){
            List<String> exps = Arrays.asList("root.sg1.d0.s1", "root.sg1.d0.s2", "root.sg1.d0.s3", "root.sg1.d0.s4");
            statement.execute("INSERT INTO root.sg1.d0(timestamp, s1) VALUES (5, 5)");
            statement.execute("INSERT INTO root.sg1.d0(timestamp, s2) VALUES (5, 5)");
            statement.execute("INSERT INTO root.sg1.d0(timestamp, s3) VALUES (5, 5)");
            statement.execute("INSERT INTO root.sg1.d0(timestamp, s4) VALUES (5, 5)");
            int count = 0;
            try (ResultSet resultSet = statement.executeQuery("show timeseries limit 2 offset 1");){
                while (resultSet.next()) {
                    Assert.assertTrue((boolean)exps.contains(resultSet.getString(1)));
                    ++count;
                }
            }
            Assert.assertEquals((long)2L, (long)count);
        }
    }

    @Test
    public void testShowDevicesWithLimitOffset() throws SQLException, ClassNotFoundException {
        Class.forName("org.apache.iotdb.jdbc.IoTDBDriver");
        try (Connection connection = DriverManager.getConnection("jdbc:iotdb://127.0.0.1:6667/", "root", "root");
             Statement statement = connection.createStatement();){
            List<String> exps = Arrays.asList("root.sg1.d1", "root.sg1.d2");
            statement.execute("INSERT INTO root.sg1.d0(timestamp, s1) VALUES (5, 5)");
            statement.execute("INSERT INTO root.sg1.d1(timestamp, s2) VALUES (5, 5)");
            statement.execute("INSERT INTO root.sg1.d2(timestamp, s3) VALUES (5, 5)");
            statement.execute("INSERT INTO root.sg1.d3(timestamp, s4) VALUES (5, 5)");
            int count = 0;
            try (ResultSet resultSet = statement.executeQuery("show devices limit 2 offset 1");){
                while (resultSet.next()) {
                    Assert.assertEquals((Object)exps.get(count), (Object)resultSet.getString(1));
                    ++count;
                }
            }
            Assert.assertEquals((long)2L, (long)count);
        }
    }

    @Test
    public void testShowDevicesWithLimit() throws SQLException, ClassNotFoundException {
        Class.forName("org.apache.iotdb.jdbc.IoTDBDriver");
        try (Connection connection = DriverManager.getConnection("jdbc:iotdb://127.0.0.1:6667/", "root", "root");
             Statement statement = connection.createStatement();){
            List<String> exps = Arrays.asList("root.sg1.d0", "root.sg1.d1");
            statement.execute("INSERT INTO root.sg1.d0(timestamp, s1) VALUES (5, 5)");
            statement.execute("INSERT INTO root.sg1.d1(timestamp, s2) VALUES (5, 5)");
            statement.execute("INSERT INTO root.sg1.d2(timestamp, s3) VALUES (5, 5)");
            statement.execute("INSERT INTO root.sg1.d3(timestamp, s4) VALUES (5, 5)");
            int count = 0;
            try (ResultSet resultSet = statement.executeQuery("show devices limit 2");){
                while (resultSet.next()) {
                    Assert.assertEquals((Object)exps.get(count), (Object)resultSet.getString(1));
                    ++count;
                }
            }
            Assert.assertEquals((long)2L, (long)count);
        }
    }

    @Test
    public void testFirstOverlappedPageFiltered() throws SQLException, ClassNotFoundException {
        Class.forName("org.apache.iotdb.jdbc.IoTDBDriver");
        try (Connection connection = DriverManager.getConnection("jdbc:iotdb://127.0.0.1:6667/", "root", "root");
             Statement statement = connection.createStatement();){
            statement.execute("SET STORAGE GROUP TO root.sg1");
            statement.execute("CREATE TIMESERIES root.sg1.d0.s0 WITH DATATYPE=INT32,ENCODING=PLAIN");
            statement.execute("INSERT INTO root.sg1.d0(timestamp, s0) VALUES (1, 1)");
            statement.execute("INSERT INTO root.sg1.d0(timestamp, s0) VALUES (10, 10)");
            statement.execute("flush");
            statement.execute("INSERT INTO root.sg1.d0(timestamp, s0) VALUES (13, 13)");
            statement.execute("INSERT INTO root.sg1.d0(timestamp, s0) VALUES (20, 20)");
            statement.execute("flush");
            statement.execute("INSERT INTO root.sg1.d0(timestamp, s0) VALUES (5, 5)");
            statement.execute("INSERT INTO root.sg1.d0(timestamp, s0) VALUES (15, 15)");
            statement.execute("flush");
            long count = 0L;
            try (ResultSet resultSet = statement.executeQuery("select s0 from root.sg1.d0 where s0 > 18");){
                while (resultSet.next()) {
                    ++count;
                }
            }
            Assert.assertEquals((long)1L, (long)count);
        }
    }

    @Test
    public void testPartialInsertion() throws SQLException, ClassNotFoundException {
        Class.forName("org.apache.iotdb.jdbc.IoTDBDriver");
        try (Connection connection = DriverManager.getConnection("jdbc:iotdb://127.0.0.1:6667/", "root", "root");
             Statement statement = connection.createStatement();){
            statement.execute("SET STORAGE GROUP TO root.sg1");
            statement.execute("CREATE TIMESERIES root.sg1.d0.s0 WITH DATATYPE=INT32,ENCODING=PLAIN");
            statement.execute("CREATE TIMESERIES root.sg1.d0.s1 WITH DATATYPE=INT32,ENCODING=PLAIN");
            try {
                statement.execute("INSERT INTO root.sg1.d0(timestamp, s0, s1) VALUES (1, 1, 2.2)");
                Assert.fail();
            }
            catch (IoTDBSQLException e) {
                Assert.assertTrue((boolean)e.getMessage().contains("s1"));
            }
            try (ResultSet resultSet = statement.executeQuery("select s0, s1 from root.sg1.d0");){
                while (resultSet.next()) {
                    Assert.assertEquals((long)1L, (long)resultSet.getInt("root.sg1.d0.s0"));
                    Assert.assertEquals(null, (Object)resultSet.getString("root.sg1.d0.s1"));
                }
            }
        }
    }

    @Test
    public void testPartialInsertionAllFailed() throws SQLException, ClassNotFoundException {
        Class.forName("org.apache.iotdb.jdbc.IoTDBDriver");
        boolean autoCreateSchemaEnabled = IoTDBDescriptor.getInstance().getConfig().isAutoCreateSchemaEnabled();
        boolean enablePartialInsert = IoTDBDescriptor.getInstance().getConfig().isEnablePartialInsert();
        try (Connection connection = DriverManager.getConnection("jdbc:iotdb://127.0.0.1:6667/", "root", "root");
             Statement statement = connection.createStatement();){
            IoTDBDescriptor.getInstance().getConfig().setAutoCreateSchemaEnabled(false);
            IoTDBDescriptor.getInstance().getConfig().setEnablePartialInsert(true);
            statement.execute("SET STORAGE GROUP TO root.sg1");
            try {
                statement.execute("INSERT INTO root.sg1(timestamp, s0) VALUES (1, 1)");
                Assert.fail();
            }
            catch (IoTDBSQLException e) {
                Assert.assertTrue((boolean)e.getMessage().contains("s0"));
            }
        }
        IoTDBDescriptor.getInstance().getConfig().setEnablePartialInsert(enablePartialInsert);
        IoTDBDescriptor.getInstance().getConfig().setAutoCreateSchemaEnabled(autoCreateSchemaEnabled);
    }

    @Test
    public void testOverlappedPagesMerge() throws SQLException, ClassNotFoundException {
        Class.forName("org.apache.iotdb.jdbc.IoTDBDriver");
        try (Connection connection = DriverManager.getConnection("jdbc:iotdb://127.0.0.1:6667/", "root", "root");
             Statement statement = connection.createStatement();){
            statement.execute("SET STORAGE GROUP TO root.sg1");
            statement.execute("CREATE TIMESERIES root.sg1.d0.s0 WITH DATATYPE=INT32,ENCODING=PLAIN");
            statement.execute("INSERT INTO root.sg1.d0(timestamp, s0) VALUES (1000, 0)");
            statement.execute("flush");
            statement.execute("INSERT INTO root.sg1.d0(timestamp, s0) VALUES (1, 1)");
            statement.execute("INSERT INTO root.sg1.d0(timestamp, s0) VALUES (10, 10)");
            statement.execute("flush");
            statement.execute("INSERT INTO root.sg1.d0(timestamp, s0) VALUES (5, 5)");
            statement.execute("INSERT INTO root.sg1.d0(timestamp, s0) VALUES (15, 15)");
            statement.execute("flush");
            statement.execute("INSERT INTO root.sg1.d0(timestamp, s0) VALUES (15, 150)");
            statement.execute("flush");
            long count = 0L;
            try (ResultSet resultSet = statement.executeQuery("select s0 from root.sg1.d0 where s0 < 100");){
                while (resultSet.next()) {
                    ++count;
                }
            }
            Assert.assertEquals((long)4L, (long)count);
        }
    }

    @Test
    public void testUnseqUnsealedDeleteQuery() throws SQLException, ClassNotFoundException {
        Class.forName("org.apache.iotdb.jdbc.IoTDBDriver");
        try (Connection connection = DriverManager.getConnection("jdbc:iotdb://127.0.0.1:6667/", "root", "root");
             Statement statement = connection.createStatement();){
            int i;
            statement.execute("SET STORAGE GROUP TO root.sg1");
            statement.execute("CREATE TIMESERIES root.sg1.d0.s0 WITH DATATYPE=INT32,ENCODING=PLAIN");
            statement.execute("INSERT INTO root.sg1.d0(timestamp, s0) VALUES (1000, 1)");
            statement.execute("flush");
            for (i = 1; i <= 10; ++i) {
                statement.execute(String.format("INSERT INTO root.sg1.d0(timestamp, s0) VALUES (%d, %d)", i, i));
            }
            statement.execute("flush");
            for (i = 11; i <= 20; ++i) {
                statement.execute(String.format("INSERT INTO root.sg1.d0(timestamp, s0) VALUES (%d, %d)", i, i));
            }
            statement.execute("delete from root.sg1.d0.s0 where time <= 15");
            long count = 0L;
            try (ResultSet resultSet = statement.executeQuery("select * from root");){
                while (resultSet.next()) {
                    ++count;
                }
            }
            System.out.println(count);
        }
    }

    @Test
    public void testTimeseriesMetadataCache() throws ClassNotFoundException {
        Class.forName("org.apache.iotdb.jdbc.IoTDBDriver");
        try (Connection connection = DriverManager.getConnection("jdbc:iotdb://127.0.0.1:6667/", "root", "root");
             Statement statement = connection.createStatement();){
            int i;
            statement.execute("SET STORAGE GROUP TO root.sg1");
            for (i = 0; i < 10000; ++i) {
                statement.execute("CREATE TIMESERIES root.sg1.d0.s" + i + " WITH DATATYPE=INT32,ENCODING=PLAIN");
            }
            for (i = 1; i < 10000; ++i) {
                statement.execute("INSERT INTO root.sg1.d0(timestamp, s" + i + ") VALUES (1000, 1)");
            }
            statement.execute("flush");
            statement.executeQuery("select s0 from root.sg1.d0");
        }
        catch (SQLException e) {
            Assert.fail();
        }
    }

    @Test
    public void testInvalidSchema() throws ClassNotFoundException {
        Class.forName("org.apache.iotdb.jdbc.IoTDBDriver");
        try (Connection connection = DriverManager.getConnection("jdbc:iotdb://127.0.0.1:6667/", "root", "root");
             Statement statement = connection.createStatement();){
            statement.execute("SET STORAGE GROUP TO root.sg1");
            try {
                statement.execute("CREATE TIMESERIES root.sg1.d1.s1 with datatype=BOOLEAN, encoding=TS_2DIFF");
            }
            catch (Exception e) {
                Assert.assertEquals((Object)"303: encoding TS_2DIFF does not support BOOLEAN", (Object)e.getMessage());
            }
            try {
                statement.execute("CREATE TIMESERIES root.sg1.d1.s3 with datatype=DOUBLE, encoding=REGULAR");
            }
            catch (Exception e) {
                Assert.assertEquals((Object)"303: encoding REGULAR does not support DOUBLE", (Object)e.getMessage());
            }
            try {
                statement.execute("CREATE TIMESERIES root.sg1.d1.s4 with datatype=TEXT, encoding=TS_2DIFF");
            }
            catch (Exception e) {
                Assert.assertEquals((Object)"303: encoding TS_2DIFF does not support TEXT", (Object)e.getMessage());
            }
        }
        catch (SQLException e) {
            Assert.fail();
        }
    }

    @Test
    public void testUseSameStatement() throws SQLException, ClassNotFoundException {
        Class.forName("org.apache.iotdb.jdbc.IoTDBDriver");
        try (Connection connection = DriverManager.getConnection("jdbc:iotdb://127.0.0.1:6667/", "root", "root");
             Statement statement = connection.createStatement();){
            statement.execute("SET STORAGE GROUP TO root.sg1");
            statement.execute("CREATE TIMESERIES root.sg1.d0.s0 WITH DATATYPE=INT64, ENCODING=RLE, COMPRESSOR=SNAPPY");
            statement.execute("CREATE TIMESERIES root.sg1.d0.s1 WITH DATATYPE=INT64, ENCODING=RLE, COMPRESSOR=SNAPPY");
            statement.execute("CREATE TIMESERIES root.sg1.d1.s0 WITH DATATYPE=INT64, ENCODING=RLE, COMPRESSOR=SNAPPY");
            statement.execute("CREATE TIMESERIES root.sg1.d1.s1 WITH DATATYPE=INT64, ENCODING=RLE, COMPRESSOR=SNAPPY");
            statement.execute("insert into root.sg1.d0(timestamp,s0,s1) values(1,1,1)");
            statement.execute("insert into root.sg1.d1(timestamp,s0,s1) values(1000,1000,1000)");
            statement.execute("insert into root.sg1.d0(timestamp,s0,s1) values(10,10,10)");
            ArrayList<ResultSet> resultSetList = new ArrayList<ResultSet>();
            ResultSet r1 = statement.executeQuery("select * from root.sg1.d0 where time <= 1");
            resultSetList.add(r1);
            ResultSet r2 = statement.executeQuery("select * from root.sg1.d1 where s0 == 1000");
            resultSetList.add(r2);
            ResultSet r3 = statement.executeQuery("select * from root.sg1.d0 where s1 == 10");
            resultSetList.add(r3);
            r1.next();
            Assert.assertEquals((long)r1.getLong(1), (long)1L);
            Assert.assertEquals((long)r1.getLong(2), (long)1L);
            Assert.assertEquals((long)r1.getLong(3), (long)1L);
            r2.next();
            Assert.assertEquals((long)r2.getLong(1), (long)1000L);
            Assert.assertEquals((long)r2.getLong(2), (long)1000L);
            Assert.assertEquals((long)r2.getLong(3), (long)1000L);
            r3.next();
            Assert.assertEquals((long)r3.getLong(1), (long)10L);
            Assert.assertEquals((long)r3.getLong(2), (long)10L);
            Assert.assertEquals((long)r3.getLong(3), (long)10L);
        }
    }

    @Test
    public void testInvalidMaxPointNumber() throws ClassNotFoundException {
        Class.forName("org.apache.iotdb.jdbc.IoTDBDriver");
        try (Connection connection = DriverManager.getConnection("jdbc:iotdb://127.0.0.1:6667/", "root", "root");
             Statement statement = connection.createStatement();){
            statement.execute("SET STORAGE GROUP TO root.sg1");
            statement.execute("CREATE TIMESERIES root.sg1.d1.s1 with datatype=FLOAT, encoding=TS_2DIFF, max_point_number=4");
            statement.execute("CREATE TIMESERIES root.sg1.d1.s2 with datatype=FLOAT, encoding=TS_2DIFF, max_point_number=2.5");
            statement.execute("CREATE TIMESERIES root.sg1.d1.s3 with datatype=FLOAT, encoding=RLE, max_point_number=q");
            statement.execute("CREATE TIMESERIES root.sg1.d1.s4 with datatype=FLOAT, encoding=RLE, max_point_number=-1");
            statement.execute("insert into root.sg1.d1(timestamp,s1,s2,s3,s4) values(1,1.1234,1.1234,1.1234,1.1234)");
            try (ResultSet r1 = statement.executeQuery("select s1 from root.sg1.d1");){
                r1.next();
                Assert.assertEquals((float)1.1234f, (float)r1.getFloat(2), (float)0.0f);
            }
            try (ResultSet r2 = statement.executeQuery("select s3 from root.sg1.d1");){
                r2.next();
                Assert.assertEquals((float)1.12f, (float)r2.getFloat(2), (float)0.0f);
            }
            try (ResultSet r3 = statement.executeQuery("select s3 from root.sg1.d1");){
                r3.next();
                Assert.assertEquals((float)1.12f, (float)r3.getFloat(2), (float)0.0f);
            }
            try (ResultSet r4 = statement.executeQuery("select s4 from root.sg1.d1");){
                r4.next();
                Assert.assertEquals((float)1.12f, (float)r4.getFloat(2), (float)0.0f);
            }
        }
        catch (SQLException e) {
            Assert.fail();
        }
    }

    @Test
    public void testStorageGroupWithHyphenInName() throws ClassNotFoundException, MetadataException {
        block37: {
            Statement statement;
            Connection connection;
            Class.forName("org.apache.iotdb.jdbc.IoTDBDriver");
            try {
                connection = DriverManager.getConnection("jdbc:iotdb://127.0.0.1:6667/", "root", "root");
                try {
                    statement = connection.createStatement();
                    try {
                        statement.setFetchSize(5);
                        statement.execute("SET STORAGE GROUP TO root.group-with-hyphen");
                    }
                    finally {
                        if (statement != null) {
                            statement.close();
                        }
                    }
                }
                finally {
                    if (connection != null) {
                        connection.close();
                    }
                }
            }
            catch (SQLException e) {
                Assert.fail();
            }
            try {
                connection = DriverManager.getConnection("jdbc:iotdb://127.0.0.1:6667/", "root", "root");
                try {
                    statement = connection.createStatement();
                    try {
                        boolean hasResultSet = statement.execute("SHOW STORAGE GROUP");
                        if (!hasResultSet) break block37;
                        try (ResultSet resultSet = statement.getResultSet();){
                            ResultSetMetaData resultSetMetaData = resultSet.getMetaData();
                            while (resultSet.next()) {
                                StringBuilder builder = new StringBuilder();
                                for (int i = 1; i <= resultSetMetaData.getColumnCount(); ++i) {
                                    builder.append(resultSet.getString(i));
                                }
                                Assert.assertEquals((Object)builder.toString(), (Object)"root.group-with-hyphen");
                            }
                        }
                    }
                    finally {
                        if (statement != null) {
                            statement.close();
                        }
                    }
                }
                finally {
                    if (connection != null) {
                        connection.close();
                    }
                }
            }
            catch (SQLException e) {
                Assert.fail();
            }
        }
    }

    @Test
    public void testDisableAlign() throws Exception {
        Class.forName("org.apache.iotdb.jdbc.IoTDBDriver");
        try (Connection connection = DriverManager.getConnection("jdbc:iotdb://127.0.0.1:6667/", "root", "root");
             Statement statement = connection.createStatement();){
            statement.execute("CREATE TIMESERIES root.sg1.d1.s1 WITH DATATYPE=INT32");
            statement.execute("CREATE TIMESERIES root.sg1.d1.s2 WITH DATATYPE=BOOLEAN");
            ResultSet resultSet = statement.executeQuery("select s1, s2 from root.sg1.d1 disable align");
            ResultSetMetaData metaData = resultSet.getMetaData();
            int[] types = new int[]{93, 4, -5, 16};
            int columnCount = metaData.getColumnCount();
            for (int i = 0; i < columnCount; ++i) {
                Assert.assertEquals((long)types[i], (long)metaData.getColumnType(i + 1));
            }
        }
    }

    @Test
    public void testEnableAlign() throws Exception {
        Class.forName("org.apache.iotdb.jdbc.IoTDBDriver");
        try (Connection connection = DriverManager.getConnection("jdbc:iotdb://127.0.0.1:6667/", "root", "root");
             Statement statement = connection.createStatement();){
            statement.execute("CREATE TIMESERIES root.sg1.d1.s1 WITH DATATYPE=INT32");
            statement.execute("CREATE TIMESERIES root.sg1.d1.s2 WITH DATATYPE=BOOLEAN");
            ResultSet resultSet = statement.executeQuery("select s1, s2 from root.sg1.d1");
            ResultSetMetaData metaData = resultSet.getMetaData();
            int[] types = new int[]{93, 4, 16};
            int columnCount = metaData.getColumnCount();
            for (int i = 0; i < columnCount; ++i) {
                Assert.assertEquals((long)types[i], (long)metaData.getColumnType(i + 1));
            }
        }
    }
}

