/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.integration;

import java.io.IOException;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.apache.iotdb.db.conf.IoTDBDescriptor;
import org.apache.iotdb.db.constant.TestConstant;
import org.apache.iotdb.db.engine.compaction.CompactionStrategy;
import org.apache.iotdb.db.exception.StorageEngineException;
import org.apache.iotdb.db.exception.metadata.IllegalPathException;
import org.apache.iotdb.db.exception.query.QueryProcessException;
import org.apache.iotdb.db.metadata.PartialPath;
import org.apache.iotdb.db.qp.physical.crud.RawDataQueryPlan;
import org.apache.iotdb.db.query.context.QueryContext;
import org.apache.iotdb.db.query.control.QueryResourceManager;
import org.apache.iotdb.db.query.executor.QueryRouter;
import org.apache.iotdb.db.utils.EnvironmentUtils;
import org.apache.iotdb.tsfile.common.conf.TSFileConfig;
import org.apache.iotdb.tsfile.common.conf.TSFileDescriptor;
import org.apache.iotdb.tsfile.file.metadata.enums.TSDataType;
import org.apache.iotdb.tsfile.read.common.Path;
import org.apache.iotdb.tsfile.read.expression.IExpression;
import org.apache.iotdb.tsfile.read.expression.impl.SingleSeriesExpression;
import org.apache.iotdb.tsfile.read.filter.TimeFilter;
import org.apache.iotdb.tsfile.read.filter.ValueFilter;
import org.apache.iotdb.tsfile.read.filter.basic.Filter;
import org.apache.iotdb.tsfile.read.query.dataset.QueryDataSet;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Test;

public class IoTDBSeriesReaderIT {
    private static TSFileConfig tsFileConfig = TSFileDescriptor.getInstance().getConfig();
    private static int pageSizeInByte;
    private static int groupSizeInByte;
    private static long prevPartitionInterval;
    private static int prevChunkMergePointThreshold;
    private static Connection connection;

    @BeforeClass
    public static void setUp() throws Exception {
        EnvironmentUtils.closeStatMonitor();
        pageSizeInByte = tsFileConfig.getPageSizeInByte();
        groupSizeInByte = tsFileConfig.getGroupSizeInByte();
        tsFileConfig.setMaxNumberOfPointsInPage(1000);
        tsFileConfig.setPageSizeInByte(0x9600000);
        tsFileConfig.setGroupSizeInByte(0x9600000);
        prevChunkMergePointThreshold = IoTDBDescriptor.getInstance().getConfig().getMergeChunkPointNumberThreshold();
        IoTDBDescriptor.getInstance().getConfig().setCompactionStrategy(CompactionStrategy.NO_COMPACTION);
        IoTDBDescriptor.getInstance().getConfig().setMergeChunkPointNumberThreshold(Integer.MAX_VALUE);
        IoTDBDescriptor.getInstance().getConfig().setMemtableSizeThreshold(16384L);
        prevPartitionInterval = IoTDBDescriptor.getInstance().getConfig().getPartitionInterval();
        IoTDBDescriptor.getInstance().getConfig().setPartitionInterval(2L);
        EnvironmentUtils.envSetUp();
        IoTDBSeriesReaderIT.insertData();
        connection = DriverManager.getConnection("jdbc:iotdb://127.0.0.1:6667/", "root", "root");
    }

    @AfterClass
    public static void tearDown() throws Exception {
        connection.close();
        tsFileConfig.setMaxNumberOfPointsInPage(0x9600000);
        tsFileConfig.setPageSizeInByte(pageSizeInByte);
        tsFileConfig.setGroupSizeInByte(groupSizeInByte);
        EnvironmentUtils.cleanEnv();
        IoTDBDescriptor.getInstance().getConfig().setCompactionStrategy(CompactionStrategy.LEVEL_COMPACTION);
        IoTDBDescriptor.getInstance().getConfig().setMemtableSizeThreshold((long)groupSizeInByte);
        IoTDBDescriptor.getInstance().getConfig().setPartitionInterval(prevPartitionInterval);
        IoTDBDescriptor.getInstance().getConfig().setMergeChunkPointNumberThreshold(prevChunkMergePointThreshold);
    }

    private static void insertData() throws ClassNotFoundException {
        Class.forName("org.apache.iotdb.jdbc.IoTDBDriver");
        try (Connection connection = DriverManager.getConnection("jdbc:iotdb://127.0.0.1:6667/", "root", "root");
             Statement statement = connection.createStatement();){
            int time;
            for (String sql : TestConstant.create_sql) {
                statement.execute(sql);
            }
            for (time = 3000; time < 13600; ++time) {
                String sql = String.format("insert into root.vehicle.d0(timestamp,s0) values(%s,%s)", time, time % 100);
                statement.execute(sql);
                sql = String.format("insert into root.vehicle.d0(timestamp,s1) values(%s,%s)", time, time % 17);
                statement.execute(sql);
                sql = String.format("insert into root.vehicle.d0(timestamp,s2) values(%s,%s)", time, time % 22);
                statement.execute(sql);
                sql = String.format("insert into root.vehicle.d0(timestamp,s3) values(%s,'%s')", time, TestConstant.stringValue[time % 5]);
                statement.execute(sql);
                sql = String.format("insert into root.vehicle.d0(timestamp,s4) values(%s, %s)", time, TestConstant.booleanValue[time % 2]);
                statement.execute(sql);
                sql = String.format("insert into root.vehicle.d0(timestamp,s5) values(%s, %s)", time, time);
                statement.execute(sql);
            }
            for (time = 13700; time < 24000; ++time) {
                String sql = String.format("insert into root.vehicle.d0(timestamp,s0) values(%s,%s)", time, time % 70);
                statement.execute(sql);
                sql = String.format("insert into root.vehicle.d0(timestamp,s1) values(%s,%s)", time, time % 40);
                statement.execute(sql);
                sql = String.format("insert into root.vehicle.d0(timestamp,s2) values(%s,%s)", time, time % 123);
                statement.execute(sql);
            }
            statement.execute("merge");
            for (time = 100000; time < 101000; ++time) {
                String sql = String.format("insert into root.vehicle.d0(timestamp,s0) values(%s,%s)", time, time % 20);
                statement.execute(sql);
                sql = String.format("insert into root.vehicle.d0(timestamp,s1) values(%s,%s)", time, time % 30);
                statement.execute(sql);
                sql = String.format("insert into root.vehicle.d0(timestamp,s2) values(%s,%s)", time, time % 77);
                statement.execute(sql);
            }
            for (time = 200000; time < 201000; ++time) {
                String sql = String.format("insert into root.vehicle.d0(timestamp,s0) values(%s,%s)", time, -time % 20);
                statement.execute(sql);
                sql = String.format("insert into root.vehicle.d0(timestamp,s1) values(%s,%s)", time, -time % 30);
                statement.execute(sql);
                sql = String.format("insert into root.vehicle.d0(timestamp,s2) values(%s,%s)", time, -time % 77);
                statement.execute(sql);
            }
            statement.execute("flush");
            for (time = 2000; time < 2500; ++time) {
                String sql = String.format("insert into root.vehicle.d0(timestamp,s0) values(%s,%s)", time, time);
                statement.execute(sql);
                sql = String.format("insert into root.vehicle.d0(timestamp,s1) values(%s,%s)", time, time + 1);
                statement.execute(sql);
                sql = String.format("insert into root.vehicle.d0(timestamp,s2) values(%s,%s)", time, time + 2);
                statement.execute(sql);
                sql = String.format("insert into root.vehicle.d0(timestamp,s3) values(%s,'%s')", time, TestConstant.stringValue[time % 5]);
                statement.execute(sql);
            }
            for (time = 100000; time < 100500; ++time) {
                String sql = String.format("insert into root.vehicle.d0(timestamp,s0) values(%s,%s)", time, 666);
                statement.execute(sql);
                sql = String.format("insert into root.vehicle.d0(timestamp,s1) values(%s,%s)", time, 777);
                statement.execute(sql);
                sql = String.format("insert into root.vehicle.d0(timestamp,s2) values(%s,%s)", time, 888);
                statement.execute(sql);
            }
            statement.execute("flush");
            for (time = 200900; time < 201000; ++time) {
                String sql = String.format("insert into root.vehicle.d0(timestamp,s0) values(%s,%s)", time, 6666);
                statement.execute(sql);
                sql = String.format("insert into root.vehicle.d0(timestamp,s1) values(%s,%s)", time, 7777);
                statement.execute(sql);
                sql = String.format("insert into root.vehicle.d0(timestamp,s2) values(%s,%s)", time, 8888);
                statement.execute(sql);
                sql = String.format("insert into root.vehicle.d0(timestamp,s3) values(%s,'%s')", time, "goodman");
                statement.execute(sql);
                sql = String.format("insert into root.vehicle.d0(timestamp,s4) values(%s, %s)", time, TestConstant.booleanValue[time % 2]);
                statement.execute(sql);
                sql = String.format("insert into root.vehicle.d0(timestamp,s5) values(%s, %s)", time, 9999);
                statement.execute(sql);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            Assert.fail((String)e.getMessage());
        }
    }

    @Test
    public void selectAllTest() throws IOException, StorageEngineException, QueryProcessException, IllegalPathException {
        QueryRouter queryRouter = new QueryRouter();
        ArrayList<PartialPath> pathList = new ArrayList<PartialPath>();
        ArrayList<TSDataType> dataTypes = new ArrayList<TSDataType>();
        pathList.add(new PartialPath("root.vehicle.d0.s0"));
        dataTypes.add(TSDataType.INT32);
        pathList.add(new PartialPath("root.vehicle.d0.s1"));
        dataTypes.add(TSDataType.INT64);
        pathList.add(new PartialPath("root.vehicle.d0.s2"));
        dataTypes.add(TSDataType.FLOAT);
        pathList.add(new PartialPath("root.vehicle.d0.s3"));
        dataTypes.add(TSDataType.TEXT);
        pathList.add(new PartialPath("root.vehicle.d0.s4"));
        dataTypes.add(TSDataType.BOOLEAN);
        pathList.add(new PartialPath("root.vehicle.d0.s5"));
        dataTypes.add(TSDataType.DOUBLE);
        pathList.add(new PartialPath("root.vehicle.d1.s0"));
        dataTypes.add(TSDataType.INT32);
        pathList.add(new PartialPath("root.vehicle.d1.s1"));
        dataTypes.add(TSDataType.INT64);
        EnvironmentUtils.TEST_QUERY_JOB_ID = QueryResourceManager.getInstance().assignQueryId(true, 1024, pathList.size());
        EnvironmentUtils.TEST_QUERY_CONTEXT = new QueryContext(EnvironmentUtils.TEST_QUERY_JOB_ID);
        RawDataQueryPlan queryPlan = new RawDataQueryPlan();
        queryPlan.setDeduplicatedDataTypes(dataTypes);
        queryPlan.setDeduplicatedPaths(pathList);
        QueryDataSet queryDataSet = queryRouter.rawDataQuery(queryPlan, EnvironmentUtils.TEST_QUERY_CONTEXT);
        int cnt = 0;
        while (queryDataSet.hasNext()) {
            queryDataSet.next();
            ++cnt;
        }
        Assert.assertEquals((long)23400L, (long)cnt);
        QueryResourceManager.getInstance().endQuery(EnvironmentUtils.TEST_QUERY_JOB_ID);
    }

    @Test
    public void selectOneSeriesWithValueFilterTest() throws IOException, StorageEngineException, QueryProcessException, IllegalPathException {
        QueryRouter queryRouter = new QueryRouter();
        ArrayList<PartialPath> pathList = new ArrayList<PartialPath>();
        ArrayList<TSDataType> dataTypes = new ArrayList<TSDataType>();
        PartialPath p = new PartialPath("root.vehicle.d0.s0");
        pathList.add(p);
        dataTypes.add(TSDataType.INT32);
        SingleSeriesExpression singleSeriesExpression = new SingleSeriesExpression((Path)p, (Filter)ValueFilter.gtEq((Comparable)Integer.valueOf(20)));
        EnvironmentUtils.TEST_QUERY_JOB_ID = QueryResourceManager.getInstance().assignQueryId(true, 1024, pathList.size());
        EnvironmentUtils.TEST_QUERY_CONTEXT = new QueryContext(EnvironmentUtils.TEST_QUERY_JOB_ID);
        RawDataQueryPlan queryPlan = new RawDataQueryPlan();
        queryPlan.setDeduplicatedDataTypes(dataTypes);
        queryPlan.setDeduplicatedPaths(pathList);
        queryPlan.setExpression((IExpression)singleSeriesExpression);
        QueryDataSet queryDataSet = queryRouter.rawDataQuery(queryPlan, EnvironmentUtils.TEST_QUERY_CONTEXT);
        int cnt = 0;
        while (queryDataSet.hasNext()) {
            queryDataSet.next();
            ++cnt;
        }
        Assert.assertEquals((long)16940L, (long)cnt);
        QueryResourceManager.getInstance().endQuery(EnvironmentUtils.TEST_QUERY_JOB_ID);
    }

    @Test
    public void seriesTimeDigestReadTest() throws IOException, StorageEngineException, QueryProcessException, IllegalPathException {
        QueryRouter queryRouter = new QueryRouter();
        PartialPath path = new PartialPath("root.vehicle.d0.s0");
        List<TSDataType> dataTypes = Collections.singletonList(TSDataType.INT32);
        SingleSeriesExpression expression = new SingleSeriesExpression((Path)path, (Filter)TimeFilter.gt((long)22987L));
        EnvironmentUtils.TEST_QUERY_JOB_ID = QueryResourceManager.getInstance().assignQueryId(true, 1024, 1);
        EnvironmentUtils.TEST_QUERY_CONTEXT = new QueryContext(EnvironmentUtils.TEST_QUERY_JOB_ID);
        RawDataQueryPlan queryPlan = new RawDataQueryPlan();
        queryPlan.setDeduplicatedDataTypes(dataTypes);
        queryPlan.setDeduplicatedPaths(Collections.singletonList(path));
        queryPlan.setExpression((IExpression)expression);
        QueryDataSet queryDataSet = queryRouter.rawDataQuery(queryPlan, EnvironmentUtils.TEST_QUERY_CONTEXT);
        int cnt = 0;
        while (queryDataSet.hasNext()) {
            queryDataSet.next();
            ++cnt;
        }
        Assert.assertEquals((long)3012L, (long)cnt);
        QueryResourceManager.getInstance().endQuery(EnvironmentUtils.TEST_QUERY_JOB_ID);
    }

    @Test
    public void crossSeriesReadUpdateTest() throws IOException, StorageEngineException, QueryProcessException, IllegalPathException {
        QueryRouter queryRouter = new QueryRouter();
        PartialPath path1 = new PartialPath("root.vehicle.d0.s0");
        PartialPath path2 = new PartialPath("root.vehicle.d0.s1");
        RawDataQueryPlan queryPlan = new RawDataQueryPlan();
        ArrayList<PartialPath> pathList = new ArrayList<PartialPath>();
        pathList.add(path1);
        pathList.add(path2);
        queryPlan.setDeduplicatedPaths(pathList);
        ArrayList<TSDataType> dataTypes = new ArrayList<TSDataType>();
        dataTypes.add(TSDataType.INT32);
        dataTypes.add(TSDataType.INT64);
        queryPlan.setDeduplicatedDataTypes(dataTypes);
        EnvironmentUtils.TEST_QUERY_JOB_ID = QueryResourceManager.getInstance().assignQueryId(true, 1024, pathList.size());
        EnvironmentUtils.TEST_QUERY_CONTEXT = new QueryContext(EnvironmentUtils.TEST_QUERY_JOB_ID);
        SingleSeriesExpression singleSeriesExpression = new SingleSeriesExpression((Path)path1, (Filter)ValueFilter.lt((Comparable)Integer.valueOf(111)));
        queryPlan.setExpression((IExpression)singleSeriesExpression);
        QueryDataSet queryDataSet = queryRouter.rawDataQuery(queryPlan, EnvironmentUtils.TEST_QUERY_CONTEXT);
        int cnt = 0;
        while (queryDataSet.hasNext()) {
            queryDataSet.next();
            ++cnt;
        }
        Assert.assertEquals((long)22300L, (long)cnt);
        QueryResourceManager.getInstance().endQuery(EnvironmentUtils.TEST_QUERY_JOB_ID);
    }

    @Test
    public void queryEmptySeriesTest() throws SQLException {
        Statement statement = connection.createStatement();
        statement.execute("CREATE TIMESERIES root.vehicle.d_empty.s1 WITH DATATYPE=INT64, ENCODING=RLE");
        try (ResultSet resultSet = statement.executeQuery("select * from root.vehicle.d_empty");){
            Assert.assertFalse((boolean)resultSet.next());
        }
    }

    @Test
    public void queryWithLongRangeUnSeqTest() throws SQLException {
        try (Connection connection = DriverManager.getConnection("jdbc:iotdb://127.0.0.1:6667/", "root", "root");
             Statement statement = connection.createStatement();){
            int i;
            String INSERT_TEMPLATE = "insert into root.sg.d1(time, s1) values(%d, %d)";
            String FLUSH_CMD = "flush";
            for (i = 1; i <= 10; ++i) {
                statement.execute(String.format("insert into root.sg.d1(time, s1) values(%d, %d)", i, i));
            }
            statement.execute("flush");
            for (i = 12; i <= 20; ++i) {
                statement.execute(String.format("insert into root.sg.d1(time, s1) values(%d, %d)", i, i));
            }
            statement.execute("flush");
            for (i = 21; i <= 110; ++i) {
                statement.execute(String.format("insert into root.sg.d1(time, s1) values(%d, %d)", i, i));
                if (i % 10 != 0) continue;
                statement.execute("flush");
            }
            for (i = 11; i <= 101; i += 10) {
                statement.execute(String.format("insert into root.sg.d1(time, s1) values(%d, %d)", i, i));
            }
            statement.execute("flush");
            ResultSet resultSet = statement.executeQuery("select s1 from root.sg.d1 where time > 10");
            int cnt = 0;
            while (resultSet.next()) {
                ++cnt;
            }
            Assert.assertEquals((long)100L, (long)cnt);
        }
    }
}

