/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.integration;

import java.io.IOException;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.Statement;
import java.util.ArrayList;
import org.apache.iotdb.db.conf.IoTDBDescriptor;
import org.apache.iotdb.db.constant.TestConstant;
import org.apache.iotdb.db.exception.StorageEngineException;
import org.apache.iotdb.db.exception.metadata.IllegalPathException;
import org.apache.iotdb.db.exception.query.QueryProcessException;
import org.apache.iotdb.db.metadata.PartialPath;
import org.apache.iotdb.db.qp.physical.crud.RawDataQueryPlan;
import org.apache.iotdb.db.query.context.QueryContext;
import org.apache.iotdb.db.query.control.QueryResourceManager;
import org.apache.iotdb.db.query.executor.QueryRouter;
import org.apache.iotdb.db.utils.EnvironmentUtils;
import org.apache.iotdb.tsfile.common.conf.TSFileConfig;
import org.apache.iotdb.tsfile.common.conf.TSFileDescriptor;
import org.apache.iotdb.tsfile.file.metadata.enums.TSDataType;
import org.apache.iotdb.tsfile.read.common.Field;
import org.apache.iotdb.tsfile.read.common.Path;
import org.apache.iotdb.tsfile.read.common.RowRecord;
import org.apache.iotdb.tsfile.read.expression.IExpression;
import org.apache.iotdb.tsfile.read.expression.impl.GlobalTimeExpression;
import org.apache.iotdb.tsfile.read.expression.impl.SingleSeriesExpression;
import org.apache.iotdb.tsfile.read.filter.TimeFilter;
import org.apache.iotdb.tsfile.read.filter.ValueFilter;
import org.apache.iotdb.tsfile.read.filter.basic.Filter;
import org.apache.iotdb.tsfile.read.query.dataset.QueryDataSet;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Test;

public class IoTDBSequenceDataQueryIT {
    private static TSFileConfig tsFileConfig = TSFileDescriptor.getInstance().getConfig();
    private static int maxNumberOfPointsInPage;
    private static int pageSizeInByte;
    private static int groupSizeInByte;
    private static int count;

    @BeforeClass
    public static void setUp() throws Exception {
        EnvironmentUtils.closeStatMonitor();
        maxNumberOfPointsInPage = tsFileConfig.getMaxNumberOfPointsInPage();
        pageSizeInByte = tsFileConfig.getPageSizeInByte();
        groupSizeInByte = tsFileConfig.getGroupSizeInByte();
        tsFileConfig.setMaxNumberOfPointsInPage(100);
        tsFileConfig.setPageSizeInByte(0x9600000);
        tsFileConfig.setGroupSizeInByte(0x6400000);
        IoTDBDescriptor.getInstance().getConfig().setMemtableSizeThreshold(0x6400000L);
        EnvironmentUtils.envSetUp();
        IoTDBSequenceDataQueryIT.insertData();
    }

    @AfterClass
    public static void tearDown() throws Exception {
        tsFileConfig.setMaxNumberOfPointsInPage(maxNumberOfPointsInPage);
        tsFileConfig.setPageSizeInByte(pageSizeInByte);
        tsFileConfig.setGroupSizeInByte(groupSizeInByte);
        IoTDBDescriptor.getInstance().getConfig().setMemtableSizeThreshold((long)groupSizeInByte);
        EnvironmentUtils.cleanEnv();
    }

    private static void insertData() throws ClassNotFoundException {
        Class.forName("org.apache.iotdb.jdbc.IoTDBDriver");
        try (Connection connection = DriverManager.getConnection("jdbc:iotdb://127.0.0.1:6667/", "root", "root");
             Statement statement = connection.createStatement();){
            long time;
            for (String sql : TestConstant.create_sql) {
                statement.execute(sql);
            }
            for (time = 300L; time < 1000L; ++time) {
                String sql = String.format("insert into root.vehicle.d0(timestamp,s0) values(%s,%s)", time, time % 17L);
                statement.execute(sql);
                sql = String.format("insert into root.vehicle.d0(timestamp,s1) values(%s,%s)", time, time % 29L);
                statement.execute(sql);
                sql = String.format("insert into root.vehicle.d0(timestamp,s2) values(%s,%s)", time, time % 31L);
                statement.execute(sql);
                sql = String.format("insert into root.vehicle.d0(timestamp,s3) values(%s,'%s')", time, TestConstant.stringValue[(int)time % 5]);
                statement.execute(sql);
                if (time % 17L < 14L) continue;
                ++count;
            }
            statement.execute("flush");
            for (time = 1200L; time < 1500L; ++time) {
                if (time % 2L == 0L) {
                    String sql = String.format("insert into root.vehicle.d0(timestamp,s0) values(%s,%s)", time, time % 17L);
                    statement.execute(sql);
                    sql = String.format("insert into root.vehicle.d0(timestamp,s1) values(%s,%s)", time, time % 29L);
                    statement.execute(sql);
                    if (time % 17L >= 14L) {
                        ++count;
                    }
                }
                String sql = String.format("insert into root.vehicle.d0(timestamp,s2) values(%s,%s)", time, time % 31L);
                statement.execute(sql);
                sql = String.format("insert into root.vehicle.d0(timestamp,s3) values(%s,'%s')", time, TestConstant.stringValue[(int)time % 5]);
                statement.execute(sql);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            Assert.fail((String)e.getMessage());
        }
    }

    @Test
    public void readWithoutFilterTest() throws IOException, StorageEngineException, QueryProcessException, IllegalPathException {
        QueryRouter queryRouter = new QueryRouter();
        ArrayList<PartialPath> pathList = new ArrayList<PartialPath>();
        ArrayList<TSDataType> dataTypes = new ArrayList<TSDataType>();
        pathList.add(new PartialPath("root.vehicle.d0.s0"));
        dataTypes.add(TSDataType.INT32);
        pathList.add(new PartialPath("root.vehicle.d0.s1"));
        dataTypes.add(TSDataType.INT64);
        pathList.add(new PartialPath("root.vehicle.d0.s2"));
        dataTypes.add(TSDataType.FLOAT);
        pathList.add(new PartialPath("root.vehicle.d0.s3"));
        dataTypes.add(TSDataType.TEXT);
        pathList.add(new PartialPath("root.vehicle.d0.s4"));
        dataTypes.add(TSDataType.BOOLEAN);
        pathList.add(new PartialPath("root.vehicle.d1.s0"));
        dataTypes.add(TSDataType.INT32);
        pathList.add(new PartialPath("root.vehicle.d1.s1"));
        dataTypes.add(TSDataType.INT64);
        EnvironmentUtils.TEST_QUERY_JOB_ID = QueryResourceManager.getInstance().assignQueryId(true, 1024, pathList.size());
        EnvironmentUtils.TEST_QUERY_CONTEXT = new QueryContext(EnvironmentUtils.TEST_QUERY_JOB_ID);
        RawDataQueryPlan queryPlan = new RawDataQueryPlan();
        queryPlan.setDeduplicatedDataTypes(dataTypes);
        queryPlan.setDeduplicatedPaths(pathList);
        QueryDataSet queryDataSet = queryRouter.rawDataQuery(queryPlan, EnvironmentUtils.TEST_QUERY_CONTEXT);
        int cnt = 0;
        while (queryDataSet.hasNext()) {
            queryDataSet.next();
            ++cnt;
        }
        Assert.assertEquals((long)1000L, (long)cnt);
        QueryResourceManager.getInstance().endQuery(EnvironmentUtils.TEST_QUERY_JOB_ID);
    }

    @Test
    public void readWithTimeFilterTest() throws IOException, StorageEngineException, QueryProcessException, IllegalPathException {
        QueryRouter queryRouter = new QueryRouter();
        ArrayList<PartialPath> pathList = new ArrayList<PartialPath>();
        ArrayList<TSDataType> dataTypes = new ArrayList<TSDataType>();
        pathList.add(new PartialPath("root.vehicle.d0.s0"));
        dataTypes.add(TSDataType.INT32);
        pathList.add(new PartialPath("root.vehicle.d1.s0"));
        dataTypes.add(TSDataType.INT32);
        pathList.add(new PartialPath("root.vehicle.d1.s1"));
        dataTypes.add(TSDataType.INT64);
        GlobalTimeExpression globalTimeExpression = new GlobalTimeExpression((Filter)TimeFilter.gtEq((long)800L));
        EnvironmentUtils.TEST_QUERY_JOB_ID = QueryResourceManager.getInstance().assignQueryId(true, 1024, pathList.size());
        EnvironmentUtils.TEST_QUERY_CONTEXT = new QueryContext(EnvironmentUtils.TEST_QUERY_JOB_ID);
        RawDataQueryPlan queryPlan = new RawDataQueryPlan();
        queryPlan.setDeduplicatedDataTypes(dataTypes);
        queryPlan.setDeduplicatedPaths(pathList);
        queryPlan.setExpression((IExpression)globalTimeExpression);
        QueryDataSet queryDataSet = queryRouter.rawDataQuery(queryPlan, EnvironmentUtils.TEST_QUERY_CONTEXT);
        int cnt = 0;
        while (queryDataSet.hasNext()) {
            RowRecord rowRecord = queryDataSet.next();
            String value = ((Field)rowRecord.getFields().get(0)).getStringValue();
            long time = rowRecord.getTimestamp();
            Assert.assertEquals((Object)("" + time % 17L), (Object)value);
            ++cnt;
        }
        Assert.assertEquals((long)350L, (long)cnt);
        QueryResourceManager.getInstance().endQuery(EnvironmentUtils.TEST_QUERY_JOB_ID);
    }

    @Test
    public void readWithValueFilterTest() throws IOException, StorageEngineException, QueryProcessException, IllegalPathException {
        QueryRouter queryRouter = new QueryRouter();
        ArrayList<PartialPath> pathList = new ArrayList<PartialPath>();
        ArrayList<TSDataType> dataTypes = new ArrayList<TSDataType>();
        pathList.add(new PartialPath("root.vehicle.d0.s0"));
        dataTypes.add(TSDataType.INT32);
        pathList.add(new PartialPath("root.vehicle.d0.s1"));
        dataTypes.add(TSDataType.INT64);
        pathList.add(new PartialPath("root.vehicle.d0.s2"));
        dataTypes.add(TSDataType.FLOAT);
        pathList.add(new PartialPath("root.vehicle.d0.s3"));
        dataTypes.add(TSDataType.TEXT);
        pathList.add(new PartialPath("root.vehicle.d0.s4"));
        dataTypes.add(TSDataType.BOOLEAN);
        pathList.add(new PartialPath("root.vehicle.d1.s0"));
        dataTypes.add(TSDataType.INT32);
        pathList.add(new PartialPath("root.vehicle.d1.s1"));
        dataTypes.add(TSDataType.INT64);
        PartialPath queryPath = new PartialPath("root.vehicle.d0.s0");
        SingleSeriesExpression singleSeriesExpression = new SingleSeriesExpression((Path)queryPath, (Filter)ValueFilter.gtEq((Comparable)Integer.valueOf(14)));
        EnvironmentUtils.TEST_QUERY_JOB_ID = QueryResourceManager.getInstance().assignQueryId(true, 1024, pathList.size());
        EnvironmentUtils.TEST_QUERY_CONTEXT = new QueryContext(EnvironmentUtils.TEST_QUERY_JOB_ID);
        RawDataQueryPlan queryPlan = new RawDataQueryPlan();
        queryPlan.setDeduplicatedDataTypes(dataTypes);
        queryPlan.setDeduplicatedPaths(pathList);
        queryPlan.setExpression((IExpression)singleSeriesExpression);
        QueryDataSet queryDataSet = queryRouter.rawDataQuery(queryPlan, EnvironmentUtils.TEST_QUERY_CONTEXT);
        int cnt = 0;
        while (queryDataSet.hasNext()) {
            queryDataSet.next();
            ++cnt;
        }
        Assert.assertEquals((long)count, (long)cnt);
        QueryResourceManager.getInstance().endQuery(EnvironmentUtils.TEST_QUERY_JOB_ID);
    }

    static {
        count = 0;
    }
}

