/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.integration;

import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import org.apache.iotdb.db.utils.EnvironmentUtils;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class IoTDBSensorUpdateIT {
    @Before
    public void setUp() throws Exception {
        EnvironmentUtils.closeStatMonitor();
        EnvironmentUtils.envSetUp();
        Class.forName("org.apache.iotdb.jdbc.IoTDBDriver");
    }

    @After
    public void tearDown() throws Exception {
        EnvironmentUtils.cleanEnv();
    }

    @Test
    public void testMerge() throws SQLException, InterruptedException {
        try (Connection connection = DriverManager.getConnection("jdbc:iotdb://127.0.0.1:6667/", "root", "root");
             Statement statement = connection.createStatement();){
            int cnt;
            statement.execute("set storage group to root.demo");
            statement.execute("create timeseries root.demo.d1.s1 with datatype=INT64,encoding=RLE");
            statement.execute("create timeseries root.demo.d1.s2 with datatype=INT64,encoding=RLE");
            statement.execute("create timeseries root.demo.d1.s3 with datatype=INT64,encoding=RLE");
            statement.execute("insert into root.demo.d1(time,s1,s2) values(1,1,2)");
            statement.execute("flush");
            statement.execute("insert into root.demo.d1(time,s3) values(1,1)");
            statement.execute("flush");
            try (ResultSet set = statement.executeQuery("SELECT * FROM root");){
                cnt = 0;
                while (set.next()) {
                    ++cnt;
                    Assert.assertEquals((long)1L, (long)set.getLong("root.demo.d1.s3"));
                }
                Assert.assertEquals((long)1L, (long)cnt);
            }
            statement.execute("merge");
            Thread.sleep(1000L);
            set = statement.executeQuery("SELECT * FROM root");
            try {
                cnt = 0;
                while (set.next()) {
                    ++cnt;
                    Assert.assertEquals((long)1L, (long)set.getLong("root.demo.d1.s3"));
                }
                Assert.assertEquals((long)1L, (long)cnt);
            }
            finally {
                if (set != null) {
                    set.close();
                }
            }
        }
    }
}

