/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.integration;

import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import org.apache.iotdb.db.utils.EnvironmentUtils;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Test;

public class IoTDBResultSetIT {
    private static List<String> sqls = new ArrayList<String>();
    private static Connection connection;

    @BeforeClass
    public static void setUp() throws Exception {
        EnvironmentUtils.closeStatMonitor();
        IoTDBResultSetIT.initCreateSQLStatement();
        EnvironmentUtils.envSetUp();
        IoTDBResultSetIT.insertData();
    }

    @AfterClass
    public static void tearDown() throws Exception {
        IoTDBResultSetIT.close();
        EnvironmentUtils.cleanEnv();
    }

    private static void close() {
        if (Objects.nonNull(connection)) {
            try {
                connection.close();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    private static void initCreateSQLStatement() {
        sqls.add("SET STORAGE GROUP TO root.t1");
        sqls.add("CREATE TIMESERIES root.t1.wf01.wt01.status WITH DATATYPE=BOOLEAN, ENCODING=PLAIN");
        sqls.add("CREATE TIMESERIES root.t1.wf01.wt01.temperature WITH DATATYPE=FLOAT, ENCODING=RLE");
        sqls.add("CREATE TIMESERIES root.t1.wf01.wt01.type WITH DATATYPE=INT32, ENCODING=RLE");
        sqls.add("CREATE TIMESERIES root.t1.wf01.wt01.grade WITH DATATYPE=INT64, ENCODING=RLE");
    }

    private static void insertData() throws ClassNotFoundException, SQLException {
        Class.forName("org.apache.iotdb.jdbc.IoTDBDriver");
        connection = DriverManager.getConnection("jdbc:iotdb://127.0.0.1:6667/", "root", "root");
        Statement statement = connection.createStatement();
        for (String sql : sqls) {
            statement.execute(sql);
        }
        statement.close();
    }

    @Test
    public void testIntAndLongConversion() throws SQLException {
        Statement st0 = connection.createStatement();
        st0.execute("insert into root.t1.wf01.wt01(timestamp, status, type, grade) values (1000, true, 1, 1000)");
        st0.execute("insert into root.t1.wf01.wt01(timestamp, status, type, grade) values (2000, false, 2, 2000)");
        st0.close();
        Statement st1 = connection.createStatement();
        ResultSet rs1 = st1.executeQuery("select count(status) from root.t1.wf01.wt01");
        rs1.next();
        int countStatus = rs1.getInt(1);
        Assert.assertTrue(((long)countStatus == 2L ? 1 : 0) != 0);
        ResultSet rs2 = st1.executeQuery("select type from root.t1.wf01.wt01 where time = 1000 limit 1");
        rs2.next();
        long type = rs2.getLong(2);
        Assert.assertTrue((type == 1L ? 1 : 0) != 0);
        ResultSet rs3 = st1.executeQuery("select grade from root.t1.wf01.wt01 where time = 1000 limit 1");
        rs3.next();
        int grade = rs3.getInt(2);
        Assert.assertTrue((grade == 1000 ? 1 : 0) != 0);
        st1.close();
    }
}

