/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.integration;

import java.io.IOException;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import org.apache.iotdb.db.engine.StorageEngine;
import org.apache.iotdb.db.engine.compaction.CompactionMergeTaskPoolManager;
import org.apache.iotdb.db.exception.StorageEngineException;
import org.apache.iotdb.db.utils.EnvironmentUtils;
import org.junit.Assert;
import org.junit.Test;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class IoTDBRestartIT {
    private final Logger logger = LoggerFactory.getLogger(IoTDBRestartIT.class);

    @Test
    public void testRestart() throws SQLException, ClassNotFoundException, IOException, StorageEngineException {
        Statement statement;
        EnvironmentUtils.envSetUp();
        Class.forName("org.apache.iotdb.jdbc.IoTDBDriver");
        try (Connection connection = DriverManager.getConnection("jdbc:iotdb://127.0.0.1:6667/", "root", "root");){
            statement = connection.createStatement();
            try {
                statement.execute("insert into root.turbine.d1(timestamp,s1) values(1,1.0)");
                statement.execute("flush");
            }
            finally {
                if (statement != null) {
                    statement.close();
                }
            }
        }
        try {
            EnvironmentUtils.restartDaemon();
        }
        catch (Exception e) {
            Assert.fail();
        }
        connection = DriverManager.getConnection("jdbc:iotdb://127.0.0.1:6667/", "root", "root");
        try {
            statement = connection.createStatement();
            try {
                statement.execute("insert into root.turbine.d1(timestamp,s1) values(2,1.0)");
            }
            finally {
                if (statement != null) {
                    statement.close();
                }
            }
        }
        finally {
            if (connection != null) {
                connection.close();
            }
        }
        try {
            EnvironmentUtils.restartDaemon();
        }
        catch (Exception e) {
            Assert.fail();
        }
        connection = DriverManager.getConnection("jdbc:iotdb://127.0.0.1:6667/", "root", "root");
        try {
            statement = connection.createStatement();
            try {
                statement.execute("insert into root.turbine.d1(timestamp,s1) values(3,1.0)");
                boolean hasResultSet = statement.execute("SELECT s1 FROM root.turbine.d1");
                Assert.assertTrue((boolean)hasResultSet);
                String[] exp = new String[]{"1,1.0", "2,1.0", "3,1.0"};
                int cnt = 0;
                try (ResultSet resultSet = statement.getResultSet();){
                    while (resultSet.next()) {
                        String result = resultSet.getString("Time") + "," + resultSet.getString(2);
                        Assert.assertEquals((Object)exp[cnt], (Object)result);
                        ++cnt;
                    }
                }
            }
            finally {
                if (statement != null) {
                    statement.close();
                }
            }
        }
        finally {
            if (connection != null) {
                connection.close();
            }
        }
        EnvironmentUtils.cleanEnv();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testRestartDelete() throws SQLException, ClassNotFoundException, IOException, StorageEngineException {
        EnvironmentUtils.envSetUp();
        Class.forName("org.apache.iotdb.jdbc.IoTDBDriver");
        try (Connection connection = DriverManager.getConnection("jdbc:iotdb://127.0.0.1:6667/", "root", "root");
             Statement statement = connection.createStatement();){
            statement.execute("insert into root.turbine.d1(timestamp,s1) values(1,1)");
            statement.execute("insert into root.turbine.d1(timestamp,s1) values(2,2)");
            statement.execute("insert into root.turbine.d1(timestamp,s1) values(3,3)");
        }
        long time = 0L;
        try {
            EnvironmentUtils.restartDaemon();
            StorageEngine.getInstance().recover();
            while (!StorageEngine.getInstance().isAllSgReady()) {
                Thread.sleep(500L);
                if ((time += 500L) <= 10000L) continue;
                this.logger.warn("wait too long in restart, wait for: " + time / 1000L + "s");
            }
        }
        catch (Exception e) {
            Assert.fail();
        }
        try (Connection connection = DriverManager.getConnection("jdbc:iotdb://127.0.0.1:6667/", "root", "root");
             Statement statement = connection.createStatement();){
            statement.execute("delete from root.turbine.d1.s1 where time<=1");
            boolean hasResultSet = statement.execute("SELECT s1 FROM root.turbine.d1");
            Assert.assertTrue((boolean)hasResultSet);
            String[] exp = new String[]{"2,2.0", "3,3.0"};
            int cnt = 0;
            try (ResultSet resultSet = statement.getResultSet();){
                String result;
                while (resultSet.next()) {
                    result = resultSet.getString("Time") + "," + resultSet.getString(2);
                    Assert.assertEquals((Object)exp[cnt], (Object)result);
                    ++cnt;
                }
                statement.execute("flush");
                statement.execute("delete from root.turbine.d1.s1 where time<=2");
                hasResultSet = statement.execute("SELECT s1 FROM root.turbine.d1");
                Assert.assertTrue((boolean)hasResultSet);
                exp = new String[]{"3,3.0"};
                resultSet = statement.getResultSet();
                cnt = 0;
                while (resultSet.next()) {
                    result = resultSet.getString("Time") + "," + resultSet.getString(2);
                    Assert.assertEquals((Object)exp[cnt], (Object)result);
                    ++cnt;
                }
            }
        }
        EnvironmentUtils.cleanEnv();
    }

    @Test
    public void testRestartQueryLargerThanEndTime() throws SQLException, ClassNotFoundException, IOException, StorageEngineException {
        Statement statement;
        EnvironmentUtils.envSetUp();
        Class.forName("org.apache.iotdb.jdbc.IoTDBDriver");
        try (Connection connection = DriverManager.getConnection("jdbc:iotdb://127.0.0.1:6667/", "root", "root");){
            statement = connection.createStatement();
            try {
                statement.execute("insert into root.turbine.d1(timestamp,s1) values(1,1)");
                statement.execute("insert into root.turbine.d1(timestamp,s1) values(2,2)");
            }
            finally {
                if (statement != null) {
                    statement.close();
                }
            }
        }
        try {
            EnvironmentUtils.restartDaemon();
        }
        catch (Exception e) {
            Assert.fail();
        }
        connection = DriverManager.getConnection("jdbc:iotdb://127.0.0.1:6667/", "root", "root");
        try {
            statement = connection.createStatement();
            try {
                statement.execute("insert into root.turbine.d1(timestamp,s1) values(3,1)");
                statement.execute("insert into root.turbine.d1(timestamp,s1) values(4,2)");
            }
            finally {
                if (statement != null) {
                    statement.close();
                }
            }
        }
        finally {
            if (connection != null) {
                connection.close();
            }
        }
        try {
            EnvironmentUtils.restartDaemon();
        }
        catch (Exception e) {
            Assert.fail();
        }
        connection = DriverManager.getConnection("jdbc:iotdb://127.0.0.1:6667/", "root", "root");
        try {
            statement = connection.createStatement();
            try {
                boolean hasResultSet = statement.execute("SELECT s1 FROM root.turbine.d1 where time > 3");
                Assert.assertTrue((boolean)hasResultSet);
                String[] exp = new String[]{"4,2.0"};
                int cnt = 0;
                try (ResultSet resultSet = statement.getResultSet();){
                    while (resultSet.next()) {
                        String result = resultSet.getString("Time") + "," + resultSet.getString(2);
                        Assert.assertEquals((Object)exp[cnt], (Object)result);
                        ++cnt;
                    }
                }
                Assert.assertEquals((long)1L, (long)cnt);
            }
            finally {
                if (statement != null) {
                    statement.close();
                }
            }
        }
        finally {
            if (connection != null) {
                connection.close();
            }
        }
        EnvironmentUtils.cleanEnv();
    }

    @Test
    public void testRestartEndTime() throws SQLException, ClassNotFoundException, IOException, StorageEngineException {
        Statement statement;
        EnvironmentUtils.envSetUp();
        Class.forName("org.apache.iotdb.jdbc.IoTDBDriver");
        try (Connection connection = DriverManager.getConnection("jdbc:iotdb://127.0.0.1:6667/", "root", "root");){
            statement = connection.createStatement();
            try {
                statement.execute("insert into root.turbine.d1(timestamp,s1) values(1,1)");
                statement.execute("insert into root.turbine.d1(timestamp,s1) values(2,2)");
            }
            finally {
                if (statement != null) {
                    statement.close();
                }
            }
        }
        try {
            EnvironmentUtils.restartDaemon();
        }
        catch (Exception e) {
            Assert.fail();
        }
        connection = DriverManager.getConnection("jdbc:iotdb://127.0.0.1:6667/", "root", "root");
        try {
            statement = connection.createStatement();
            try {
                statement.execute("insert into root.turbine.d1(timestamp,s2) values(1,1)");
                statement.execute("insert into root.turbine.d1(timestamp,s2) values(2,2)");
            }
            finally {
                if (statement != null) {
                    statement.close();
                }
            }
        }
        finally {
            if (connection != null) {
                connection.close();
            }
        }
        try {
            EnvironmentUtils.restartDaemon();
        }
        catch (Exception e) {
            Assert.fail();
        }
        connection = DriverManager.getConnection("jdbc:iotdb://127.0.0.1:6667/", "root", "root");
        try {
            statement = connection.createStatement();
            try {
                boolean hasResultSet = statement.execute("SELECT s2 FROM root.turbine.d1");
                Assert.assertTrue((boolean)hasResultSet);
                String[] exp = new String[]{"1,1.0", "2,2.0"};
                int cnt = 0;
                try (ResultSet resultSet = statement.getResultSet();){
                    while (resultSet.next()) {
                        String result = resultSet.getString("Time") + "," + resultSet.getString(2);
                        Assert.assertEquals((Object)exp[cnt], (Object)result);
                        ++cnt;
                    }
                }
                Assert.assertEquals((long)2L, (long)cnt);
            }
            finally {
                if (statement != null) {
                    statement.close();
                }
            }
        }
        finally {
            if (connection != null) {
                connection.close();
            }
        }
        EnvironmentUtils.cleanEnv();
    }

    @Test
    public void testRecoverWALMismatchDataType() throws Exception {
        Statement statement;
        EnvironmentUtils.envSetUp();
        Class.forName("org.apache.iotdb.jdbc.IoTDBDriver");
        try (Connection connection = DriverManager.getConnection("jdbc:iotdb://127.0.0.1:6667/", "root", "root");){
            statement = connection.createStatement();
            try {
                statement.execute("insert into root.turbine1.d1(timestamp,s1,s2) values(1,1.1,2.2)");
                statement.execute("delete timeseries root.turbine1.d1.s1");
                statement.execute("create timeseries root.turbine1.d1.s1 with datatype=INT32, encoding=RLE, compression=SNAPPY");
            }
            finally {
                if (statement != null) {
                    statement.close();
                }
            }
        }
        EnvironmentUtils.restartDaemon();
        connection = DriverManager.getConnection("jdbc:iotdb://127.0.0.1:6667/", "root", "root");
        try {
            statement = connection.createStatement();
            try {
                boolean hasResultSet = statement.execute("select * from root");
                Assert.assertTrue((boolean)hasResultSet);
                ResultSet resultSet = statement.getResultSet();
                int cnt = 0;
                while (resultSet.next()) {
                    ++cnt;
                }
                Assert.assertEquals((long)1L, (long)cnt);
            }
            finally {
                if (statement != null) {
                    statement.close();
                }
            }
        }
        finally {
            if (connection != null) {
                connection.close();
            }
        }
        EnvironmentUtils.cleanEnv();
    }

    @Test
    public void testRecoverWALDeleteSchema() throws Exception {
        Statement statement;
        EnvironmentUtils.envSetUp();
        Class.forName("org.apache.iotdb.jdbc.IoTDBDriver");
        try (Connection connection = DriverManager.getConnection("jdbc:iotdb://127.0.0.1:6667/", "root", "root");){
            statement = connection.createStatement();
            try {
                statement.execute("insert into root.turbine1.d1(timestamp,s1,s2) values(1,1.1,2.2)");
                statement.execute("delete timeseries root.turbine1.d1.s1");
            }
            finally {
                if (statement != null) {
                    statement.close();
                }
            }
        }
        EnvironmentUtils.restartDaemon();
        connection = DriverManager.getConnection("jdbc:iotdb://127.0.0.1:6667/", "root", "root");
        try {
            statement = connection.createStatement();
            try {
                boolean hasResultSet = statement.execute("select * from root");
                Assert.assertTrue((boolean)hasResultSet);
                ResultSet resultSet = statement.getResultSet();
                int cnt = 0;
                while (resultSet.next()) {
                    ++cnt;
                }
                Assert.assertEquals((long)1L, (long)cnt);
            }
            finally {
                if (statement != null) {
                    statement.close();
                }
            }
        }
        finally {
            if (connection != null) {
                connection.close();
            }
        }
        EnvironmentUtils.cleanEnv();
    }

    @Test
    public void testRestartCompaction() throws SQLException, ClassNotFoundException, IOException, StorageEngineException {
        Statement statement;
        EnvironmentUtils.envSetUp();
        Class.forName("org.apache.iotdb.jdbc.IoTDBDriver");
        try (Connection connection = DriverManager.getConnection("jdbc:iotdb://127.0.0.1:6667/", "root", "root");){
            statement = connection.createStatement();
            try {
                statement.execute("insert into root.turbine.d1(timestamp,s1) values(2,1.0)");
                statement.execute("flush");
                statement.execute("insert into root.turbine.d1(timestamp,s1) values(3,1.0)");
                statement.execute("flush");
                statement.execute("insert into root.turbine.d1(timestamp,s1) values(4,1.0)");
                statement.execute("flush");
                statement.execute("insert into root.turbine.d1(timestamp,s1) values(5,1.0)");
                statement.execute("flush");
                statement.execute("insert into root.turbine.d1(timestamp,s1) values(6,1.0)");
                statement.execute("flush");
                statement.execute("insert into root.turbine.d1(timestamp,s1) values(1,1.0)");
                statement.execute("flush");
                statement.execute("insert into root.turbine.d1(timestamp,s1) values(7,1.0)");
                statement.execute("flush");
            }
            finally {
                if (statement != null) {
                    statement.close();
                }
            }
        }
        try {
            CompactionMergeTaskPoolManager.getInstance().waitAllCompactionFinish();
            Thread.sleep(10000L);
            EnvironmentUtils.restartDaemon();
        }
        catch (Exception e) {
            Assert.fail();
        }
        connection = DriverManager.getConnection("jdbc:iotdb://127.0.0.1:6667/", "root", "root");
        try {
            statement = connection.createStatement();
            try {
                boolean hasResultSet = statement.execute("SELECT s1 FROM root.turbine.d1");
                Assert.assertTrue((boolean)hasResultSet);
                String[] exp = new String[]{"1,1.0", "2,1.0", "3,1.0", "4,1.0", "5,1.0", "6,1.0", "7,1.0"};
                int cnt = 0;
                try (ResultSet resultSet = statement.getResultSet();){
                    while (resultSet.next()) {
                        String result = resultSet.getString("Time") + "," + resultSet.getString(2);
                        Assert.assertEquals((Object)exp[cnt], (Object)result);
                        ++cnt;
                    }
                }
            }
            finally {
                if (statement != null) {
                    statement.close();
                }
            }
        }
        finally {
            if (connection != null) {
                connection.close();
            }
        }
        EnvironmentUtils.cleanEnv();
    }
}

