/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.integration;

import ch.qos.logback.classic.Level;
import ch.qos.logback.classic.Logger;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.ResultSet;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Arrays;
import org.apache.iotdb.db.engine.StorageEngine;
import org.apache.iotdb.db.exception.metadata.IllegalPathException;
import org.apache.iotdb.db.metadata.PartialPath;
import org.apache.iotdb.db.utils.EnvironmentUtils;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.slf4j.LoggerFactory;

public class IoTDBRemovePartitionIT {
    private static int partitionInterval = 100;

    @Before
    public void setUp() throws Exception {
        Logger rootLogger = (Logger)LoggerFactory.getLogger((String)"ROOT");
        rootLogger.setLevel(Level.toLevel((String)"trace"));
        EnvironmentUtils.closeStatMonitor();
        EnvironmentUtils.envSetUp();
        StorageEngine.setEnablePartition((boolean)true);
        StorageEngine.setTimePartitionInterval((long)partitionInterval);
        IoTDBRemovePartitionIT.insertData();
    }

    @After
    public void tearDown() throws Exception {
        StorageEngine.setEnablePartition((boolean)false);
        StorageEngine.setTimePartitionInterval((long)-1L);
        EnvironmentUtils.cleanEnv();
        Logger rootLogger = (Logger)LoggerFactory.getLogger((String)"ROOT");
        rootLogger.setLevel(Level.toLevel((String)"warn"));
    }

    @Test
    public void testRemoveNoPartition() throws IllegalPathException {
        StorageEngine.getInstance().removePartitions(new PartialPath("root.test1"), (storageGroupName, timePartitionId) -> false);
        try (Connection connection = DriverManager.getConnection("jdbc:iotdb://127.0.0.1:6667/", "root", "root");
             Statement statement = connection.createStatement();
             ResultSet resultSet = statement.executeQuery("SELECT * FROM root.test1");){
            int count = 0;
            while (resultSet.next()) {
                Assert.assertEquals((long)(count / 2 * 100 + count % 2 * 50), (long)resultSet.getLong(1));
                Assert.assertEquals((long)(count / 2 * 100 + count % 2 * 50), (long)resultSet.getLong(2));
                ++count;
            }
            Assert.assertEquals((long)20L, (long)count);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    @Test
    public void testRemovePartialPartition() throws IllegalPathException {
        StorageEngine.getInstance().removePartitions(new PartialPath("root.test1"), (storageGroupName, timePartitionId) -> timePartitionId >= 5L);
        StorageEngine.getInstance().removePartitions(new PartialPath("root.test2"), (storageGroupName, timePartitionId) -> timePartitionId < 5L);
        try (Connection connection = DriverManager.getConnection("jdbc:iotdb://127.0.0.1:6667/", "root", "root");
             Statement statement = connection.createStatement();){
            int count;
            try (ResultSet resultSet = statement.executeQuery("SELECT * FROM root.test1");){
                count = 0;
                while (resultSet.next()) {
                    Assert.assertEquals((long)(count / 2 * 100 + count % 2 * 50), (long)resultSet.getLong(1));
                    Assert.assertEquals((long)(count / 2 * 100 + count % 2 * 50), (long)resultSet.getLong(2));
                    ++count;
                }
                Assert.assertEquals((long)10L, (long)count);
            }
            resultSet = statement.executeQuery("SELECT * FROM root.test2");
            try {
                count = 0;
                while (resultSet.next()) {
                    Assert.assertEquals((long)(count / 2 * 100 + count % 2 * 50 + 500), (long)resultSet.getLong(1));
                    Assert.assertEquals((long)(count / 2 * 100 + count % 2 * 50 + 500), (long)resultSet.getLong(2));
                    ++count;
                }
                Assert.assertEquals((long)10L, (long)count);
            }
            finally {
                if (resultSet != null) {
                    resultSet.close();
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    @Test
    public void testRemoveAllPartition() throws IllegalPathException {
        StorageEngine.getInstance().removePartitions(new PartialPath("root.test1"), (storageGroupName, timePartitionId) -> true);
        try (Connection connection = DriverManager.getConnection("jdbc:iotdb://127.0.0.1:6667/", "root", "root");
             Statement statement = connection.createStatement();
             ResultSet resultSet = statement.executeQuery("SELECT * FROM root.test1");){
            Assert.assertFalse((boolean)resultSet.next());
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    @Test
    public void testSQLRemovePartition() {
        try (Connection connection = DriverManager.getConnection("jdbc:iotdb://127.0.0.1:6667/", "root", "root");
             Statement statement = connection.createStatement();){
            statement.execute("DELETE PARTITION root.test2 0,1,2,3,4");
            try (ResultSet resultSet = statement.executeQuery("SELECT * FROM root.test2");){
                int count = 0;
                while (resultSet.next()) {
                    Assert.assertEquals((long)(count / 2 * 100 + count % 2 * 50 + 500), (long)resultSet.getLong(1));
                    Assert.assertEquals((long)(count / 2 * 100 + count % 2 * 50 + 500), (long)resultSet.getLong(2));
                    ++count;
                }
                Assert.assertEquals((long)10L, (long)count);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    @Test
    public void testRemoveOnePartitionAndInsertData() {
        try (Connection connection = DriverManager.getConnection("jdbc:iotdb://127.0.0.1:6667/", "root", "root");
             Statement statement = connection.createStatement();){
            statement.execute("set storage group to root.test");
            statement.execute("insert into root.test.wf02.wt02(timestamp,status) values(1,true)");
            statement.execute("select * from root.test.wf02.wt02");
            statement.execute("DELETE PARTITION root.test 0");
            statement.execute("select * from root.test.wf02.wt02");
            statement.execute("insert into root.test.wf02.wt02(timestamp,status) values(1,true)");
            try (ResultSet resultSet = statement.executeQuery("select * from root.test.wf02.wt02");){
                Assert.assertEquals((Object)true, (Object)resultSet.next());
            }
            statement.execute("flush");
            resultSet = statement.executeQuery("select * from root.test.wf02.wt02");
            try {
                Assert.assertEquals((Object)true, (Object)resultSet.next());
            }
            finally {
                if (resultSet != null) {
                    resultSet.close();
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    @Test
    public void testRemovePartitionAndInsertUnSeqDataAndMerge() {
        try (Connection connection = DriverManager.getConnection("jdbc:iotdb://127.0.0.1:6667/", "root", "root");
             Statement statement = connection.createStatement();){
            statement.execute("set storage group to root.test");
            statement.execute("insert into root.test.wf02.wt02(timestamp,status) values(2,true)");
            statement.execute("select * from root.test.wf02.wt02");
            statement.execute("DELETE PARTITION root.test 0");
            statement.execute("select * from root.test.wf02.wt02");
            statement.execute("insert into root.test.wf02.wt02(timestamp,status) values(1,true)");
            try (ResultSet resultSet = statement.executeQuery("select * from root.test.wf02.wt02");){
                Assert.assertEquals((Object)true, (Object)resultSet.next());
            }
            statement.execute("insert into root.test.wf02.wt02(timestamp,status) values(3,true)");
            statement.execute("merge");
            int count = 0;
            try (ResultSet resultSet = statement.executeQuery("select * from root.test.wf02.wt02");){
                while (resultSet.next()) {
                    ++count;
                }
                Assert.assertEquals((long)2L, (long)count);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    @Test
    public void testRemovePartitionAndInsertUnSeqDataAndUnSeqDataMerge() {
        try (Connection connection = DriverManager.getConnection("jdbc:iotdb://127.0.0.1:6667/", "root", "root");
             Statement statement = connection.createStatement();){
            statement.execute("set storage group to root.test");
            statement.execute("insert into root.test.wf02.wt02(timestamp,status) values(2,true)");
            statement.execute("select * from root.test.wf02.wt02");
            statement.execute("DELETE PARTITION root.test 0");
            statement.execute("select * from root.test.wf02.wt02");
            statement.execute("insert into root.test.wf02.wt02(timestamp,status) values(1,true)");
            try (ResultSet resultSet = statement.executeQuery("select * from root.test.wf02.wt02");){
                Assert.assertEquals((Object)true, (Object)resultSet.next());
            }
            statement.execute("insert into root.test.wf02.wt02(timestamp,status) values(2,true)");
            statement.execute("merge");
            int count = 0;
            try (ResultSet resultSet = statement.executeQuery("select * from root.test.wf02.wt02");){
                while (resultSet.next()) {
                    ++count;
                }
                Assert.assertEquals((long)2L, (long)count);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    @Test
    public void testFlushAndRemoveOnePartitionAndInsertData() {
        try (Connection connection = DriverManager.getConnection("jdbc:iotdb://127.0.0.1:6667/", "root", "root");
             Statement statement = connection.createStatement();){
            statement.execute("set storage group to root.test");
            statement.execute("insert into root.test.wf02.wt02(timestamp,status) values(1,true)");
            statement.execute("flush");
            statement.execute("DELETE PARTITION root.test 0");
            statement.execute("select * from root.test.wf02.wt02");
            statement.execute("insert into root.test.wf02.wt02(timestamp,status) values(1,true)");
            try (ResultSet resultSet = statement.executeQuery("select * from root.test.wf02.wt02");){
                Assert.assertEquals((Object)true, (Object)resultSet.next());
            }
            statement.execute("flush");
            boolean count = false;
            try (ResultSet resultSet = statement.executeQuery("select * from root.test.wf02.wt02");){
                Assert.assertEquals((Object)true, (Object)resultSet.next());
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private static void insertData() throws ClassNotFoundException {
        ArrayList<String> sqls = new ArrayList<String>(Arrays.asList("SET STORAGE GROUP TO root.test1", "SET STORAGE GROUP TO root.test2", "CREATE TIMESERIES root.test1.s0 WITH DATATYPE=INT64,ENCODING=PLAIN", "CREATE TIMESERIES root.test2.s0 WITH DATATYPE=INT64,ENCODING=PLAIN"));
        for (int i = 0; i < 10; ++i) {
            int j;
            for (j = 1; j <= 2; ++j) {
                sqls.add(String.format("INSERT INTO root.test%d(timestamp, s0) VALUES (%d, %d)", j, i * partitionInterval + 50, i * partitionInterval + 50));
            }
            if (i < 9) {
                sqls.add("FLUSH");
            }
            for (j = 1; j <= 2; ++j) {
                sqls.add(String.format("INSERT INTO root.test%d(timestamp, s0) VALUES (%d, %d)", j, i * partitionInterval, i * partitionInterval));
            }
            sqls.add("MERGE");
            if (i >= 9) continue;
            sqls.add("FLUSH");
        }
        Class.forName("org.apache.iotdb.jdbc.IoTDBDriver");
        try (Connection connection = DriverManager.getConnection("jdbc:iotdb://127.0.0.1:6667/", "root", "root");
             Statement statement = connection.createStatement();){
            for (String sql : sqls) {
                statement.execute(sql);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

