/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.integration;

import java.io.IOException;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Locale;
import org.apache.iotdb.db.constant.TestConstant;
import org.apache.iotdb.db.exception.StartupException;
import org.apache.iotdb.db.utils.EnvironmentUtils;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class IoTDBRecoverUnclosedIT {
    private static final String TIMESTAMP_STR = "Time";
    private static final String TEMPERATURE_STR = "root.ln.wf01.wt01.temperature";
    private static String[] creationSqls = new String[]{"SET STORAGE GROUP TO root.vehicle.d0", "SET STORAGE GROUP TO root.vehicle.d1", "CREATE TIMESERIES root.vehicle.d0.s0 WITH DATATYPE=INT32, ENCODING=RLE", "CREATE TIMESERIES root.vehicle.d0.s1 WITH DATATYPE=INT64, ENCODING=RLE", "CREATE TIMESERIES root.vehicle.d0.s2 WITH DATATYPE=FLOAT, ENCODING=RLE", "CREATE TIMESERIES root.vehicle.d0.s3 WITH DATATYPE=TEXT, ENCODING=PLAIN", "CREATE TIMESERIES root.vehicle.d0.s4 WITH DATATYPE=BOOLEAN, ENCODING=PLAIN"};
    private static String[] dataSet2 = new String[]{"SET STORAGE GROUP TO root.ln.wf01.wt01", "CREATE TIMESERIES root.ln.wf01.wt01.status WITH DATATYPE=BOOLEAN, ENCODING=PLAIN", "CREATE TIMESERIES root.ln.wf01.wt01.temperature WITH DATATYPE=FLOAT, ENCODING=PLAIN", "CREATE TIMESERIES root.ln.wf01.wt01.hardware WITH DATATYPE=INT32, ENCODING=PLAIN", "INSERT INTO root.ln.wf01.wt01(timestamp,temperature,status, hardware) values(1, 1.1, false, 11)", "INSERT INTO root.ln.wf01.wt01(timestamp,temperature,status, hardware) values(2, 2.2, true, 22)", "INSERT INTO root.ln.wf01.wt01(timestamp,temperature,status, hardware) values(3, 3.3, false, 33 )", "INSERT INTO root.ln.wf01.wt01(timestamp,temperature,status, hardware) values(4, 4.4, false, 44)", "INSERT INTO root.ln.wf01.wt01(timestamp,temperature,status, hardware) values(5, 5.5, false, 55)"};
    private final String d0s0 = "root.vehicle.d0.s0";
    private final String d0s1 = "root.vehicle.d0.s1";
    private final String d0s2 = "root.vehicle.d0.s2";
    private final String d0s3 = "root.vehicle.d0.s3";
    private String insertTemplate = "INSERT INTO root.vehicle.d0(timestamp,s0,s1,s2,s3,s4) VALUES(%d,%d,%d,%f,%s,%s)";

    @Before
    public void setUp() throws Exception {
        EnvironmentUtils.closeStatMonitor();
        EnvironmentUtils.envSetUp();
        Class.forName("org.apache.iotdb.jdbc.IoTDBDriver");
        this.prepareData();
    }

    @After
    public void tearDown() throws Exception {
        EnvironmentUtils.cleanEnv();
    }

    @Test
    public void test() throws SQLException, IOException, StartupException {
        String ans;
        int cnt;
        ResultSet resultSet;
        boolean hasResultSet;
        Statement statement;
        Connection connection;
        String[] retArray = new String[]{"0,2", "0,4", "0,3"};
        try {
            connection = DriverManager.getConnection("jdbc:iotdb://127.0.0.1:6667/", "root", "root");
            try {
                statement = connection.createStatement();
                try {
                    hasResultSet = statement.execute("select count(temperature) from root.ln.wf01.wt01 where time > 3");
                    Assert.assertTrue((boolean)hasResultSet);
                    resultSet = statement.getResultSet();
                    try {
                        cnt = 0;
                        while (resultSet.next()) {
                            ans = resultSet.getString(TIMESTAMP_STR) + "," + resultSet.getString(TestConstant.count(TEMPERATURE_STR));
                            Assert.assertEquals((Object)retArray[cnt], (Object)ans);
                            ++cnt;
                        }
                        Assert.assertEquals((long)1L, (long)cnt);
                    }
                    finally {
                        if (resultSet != null) {
                            resultSet.close();
                        }
                    }
                    hasResultSet = statement.execute("select min_time(temperature) from root.ln.wf01.wt01 where time > 3");
                    Assert.assertTrue((boolean)hasResultSet);
                    resultSet = statement.getResultSet();
                    try {
                        while (resultSet.next()) {
                            ans = resultSet.getString(TIMESTAMP_STR) + "," + resultSet.getString(TestConstant.min_time(TEMPERATURE_STR));
                            Assert.assertEquals((Object)retArray[cnt], (Object)ans);
                            ++cnt;
                        }
                        Assert.assertEquals((long)2L, (long)cnt);
                    }
                    finally {
                        if (resultSet != null) {
                            resultSet.close();
                        }
                    }
                    hasResultSet = statement.execute("select min_time(temperature) from root.ln.wf01.wt01 where temperature > 3");
                    Assert.assertTrue((boolean)hasResultSet);
                    resultSet = statement.getResultSet();
                    try {
                        while (resultSet.next()) {
                            ans = resultSet.getString(TIMESTAMP_STR) + "," + resultSet.getString(TestConstant.min_time(TEMPERATURE_STR));
                            Assert.assertEquals((Object)retArray[cnt], (Object)ans);
                            ++cnt;
                        }
                        Assert.assertEquals((long)3L, (long)cnt);
                    }
                    finally {
                        if (resultSet != null) {
                            resultSet.close();
                        }
                    }
                }
                finally {
                    if (statement != null) {
                        statement.close();
                    }
                }
            }
            finally {
                if (connection != null) {
                    connection.close();
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            Assert.fail((String)e.getMessage());
        }
        try {
            EnvironmentUtils.restartDaemon();
        }
        catch (Exception e) {
            Assert.fail();
        }
        this.insertMoreData();
        try {
            EnvironmentUtils.restartDaemon();
        }
        catch (Exception e) {
            Assert.fail();
        }
        retArray = new String[]{"0,8499,500.0", "0,2499,500.0"};
        try {
            connection = DriverManager.getConnection("jdbc:iotdb://127.0.0.1:6667/", "root", "root");
            try {
                statement = connection.createStatement();
                try {
                    hasResultSet = statement.execute("select max_value(s0),min_value(s2) from root.vehicle.d0 where time >= 100 and time < 9000");
                    Assert.assertTrue((boolean)hasResultSet);
                    resultSet = statement.getResultSet();
                    try {
                        cnt = 0;
                        while (resultSet.next()) {
                            ans = resultSet.getString(TIMESTAMP_STR) + "," + resultSet.getString(TestConstant.max_value("root.vehicle.d0.s0")) + "," + resultSet.getString(TestConstant.min_value("root.vehicle.d0.s2"));
                            Assert.assertEquals((Object)retArray[cnt], (Object)ans);
                            ++cnt;
                        }
                        Assert.assertEquals((long)1L, (long)cnt);
                    }
                    finally {
                        if (resultSet != null) {
                            resultSet.close();
                        }
                    }
                    hasResultSet = statement.execute("select max_value(s0),min_value(s2) from root.vehicle.d0 where time < 2500");
                    Assert.assertTrue((boolean)hasResultSet);
                    resultSet = statement.getResultSet();
                    try {
                        while (resultSet.next()) {
                            ans = resultSet.getString(TIMESTAMP_STR) + "," + resultSet.getString(TestConstant.max_value("root.vehicle.d0.s0")) + "," + resultSet.getString(TestConstant.min_value("root.vehicle.d0.s2"));
                            Assert.assertEquals((Object)retArray[cnt], (Object)ans);
                            ++cnt;
                        }
                        Assert.assertEquals((long)2L, (long)cnt);
                    }
                    finally {
                        if (resultSet != null) {
                            resultSet.close();
                        }
                    }
                }
                finally {
                    if (statement != null) {
                        statement.close();
                    }
                }
            }
            finally {
                if (connection != null) {
                    connection.close();
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            Assert.fail((String)e.getMessage());
        }
    }

    private void prepareData() {
        try (Connection connection = DriverManager.getConnection("jdbc:iotdb://127.0.0.1:6667/", "root", "root");
             Statement statement = connection.createStatement();){
            for (String sql : creationSqls) {
                statement.execute(sql);
            }
            for (String sql : dataSet2) {
                statement.execute(sql);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void insertMoreData() {
        try (Connection connection = DriverManager.getConnection("jdbc:iotdb://127.0.0.1:6667/", "root", "root");
             Statement statement = connection.createStatement();){
            int i;
            for (i = 5000; i < 7000; ++i) {
                statement.execute(String.format(Locale.ENGLISH, this.insertTemplate, i, i, i, (double)i, "'" + i + "'", "true"));
            }
            for (i = 7500; i < 8500; ++i) {
                statement.execute(String.format(Locale.ENGLISH, this.insertTemplate, i, i, i, (double)i, "'" + i + "'", "false"));
            }
            for (i = 500; i < 1500; ++i) {
                statement.execute(String.format(Locale.ENGLISH, this.insertTemplate, i, i, i, (double)i, "'" + i + "'", "true"));
            }
            for (i = 3000; i < 6500; ++i) {
                statement.execute(String.format(Locale.ENGLISH, this.insertTemplate, i, i, i, (double)i, "'" + i + "'", "false"));
            }
            for (i = 9000; i < 10000; ++i) {
                statement.execute(String.format(Locale.ENGLISH, this.insertTemplate, i, i, i, (double)i, "'" + i + "'", "true"));
            }
            for (i = 2000; i < 2500; ++i) {
                statement.execute(String.format(Locale.ENGLISH, this.insertTemplate, i, i, i, (double)i, "'" + i + "'", "false"));
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

