/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.integration;

import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import org.apache.iotdb.db.utils.EnvironmentUtils;
import org.apache.iotdb.jdbc.IoTDBSQLException;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class IoTDBQuotedPathIT {
    @Before
    public void setUp() throws Exception {
        EnvironmentUtils.closeStatMonitor();
        EnvironmentUtils.envSetUp();
        Class.forName("org.apache.iotdb.jdbc.IoTDBDriver");
    }

    @After
    public void tearDown() throws Exception {
        EnvironmentUtils.cleanEnv();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void test() {
        try (Connection connection = DriverManager.getConnection("jdbc:iotdb://127.0.0.1:6667/", "root", "root");
             Statement statement = connection.createStatement();){
            String[] exp = new String[]{"1509465600000,true", "1509465600001,true", "1509465600002,false", "1509465600003,false"};
            statement.execute("SET STORAGE GROUP TO root.ln");
            statement.execute("CREATE TIMESERIES root.ln.\"wf.01\".wt01.\"status.2.3\" WITH DATATYPE=BOOLEAN, ENCODING=PLAIN");
            statement.execute("INSERT INTO root.ln.\"wf.01\".wt01(timestamp,\"status.2.3\") values(1509465600000,true)");
            statement.execute("INSERT INTO root.ln.\"wf.01\".wt01(timestamp,\"status.2.3\") values(1509465600001,true)");
            statement.execute("INSERT INTO root.ln.\"wf.01\".wt01(timestamp,\"status.2.3\") values(1509465600002,false)");
            statement.execute("INSERT INTO root.ln.\"wf.01\".wt01(timestamp,\"status.2.3\") values(1509465600003,false)");
            statement.execute("CREATE TIMESERIES root.ln.\"wf.01\".wt02.\"abd\" WITH DATATYPE=BOOLEAN, ENCODING=PLAIN");
            statement.execute("CREATE TIMESERIES root.ln.\"wf.01\".wt02.\"asf.asd.sdf\" WITH DATATYPE=BOOLEAN, ENCODING=PLAIN");
            statement.execute("CREATE TIMESERIES root.ln.\"wf.01\".wt02.\"asd12\" WITH DATATYPE=BOOLEAN, ENCODING=PLAIN");
            boolean hasResultSet = statement.execute("SELECT * FROM root.ln.\"wf.01\".wt01");
            Assert.assertTrue((boolean)hasResultSet);
            try (ResultSet resultSet = statement.getResultSet();){
                String result;
                int cnt = 0;
                while (resultSet.next()) {
                    result = resultSet.getString("Time") + "," + resultSet.getString(2);
                    Assert.assertEquals((Object)exp[cnt++], (Object)result);
                }
                hasResultSet = statement.execute("SELECT * FROM root.ln.\"wf.01\".wt01 WHERE \"status.2.3\" = false");
                Assert.assertTrue((boolean)hasResultSet);
                exp = new String[]{"1509465600002,false", "1509465600003,false"};
                cnt = 0;
                resultSet = statement.getResultSet();
                while (resultSet.next()) {
                    result = resultSet.getString("Time") + "," + resultSet.getString(2);
                    Assert.assertEquals((Object)exp[cnt++], (Object)result);
                }
                hasResultSet = statement.execute("select \"status.2.3\", 'status.2.3' from root.ln.\"wf.01\".wt01 align by device");
                Assert.assertTrue((boolean)hasResultSet);
                exp = new String[]{"1509465600000,root.ln.\"wf.01\".wt01,true,'status.2.3',", "1509465600001,root.ln.\"wf.01\".wt01,true,'status.2.3',", "1509465600002,root.ln.\"wf.01\".wt01,false,'status.2.3',", "1509465600003,root.ln.\"wf.01\".wt01,false,'status.2.3',"};
                cnt = 0;
                resultSet = statement.getResultSet();
                while (resultSet.next()) {
                    StringBuilder builder = new StringBuilder();
                    for (int i = 1; i <= resultSet.getMetaData().getColumnCount(); ++i) {
                        builder.append(resultSet.getString(i)).append(",");
                    }
                    Assert.assertEquals((Object)exp[cnt++], (Object)builder.toString());
                }
                statement.execute("DELETE FROM root.ln.\"wf.01\".wt01.\"status.2.3\" WHERE time < 1509465600001");
                statement.execute("DELETE TIMESERIES root.ln.\"wf.01\".wt01.\"status.2.3\"");
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            Assert.fail();
        }
    }

    @Test
    public void testIllegalStorageGroup() throws SQLException {
        try (Connection connection = DriverManager.getConnection("jdbc:iotdb://127.0.0.1:6667/", "root", "root");
             Statement statement = connection.createStatement();){
            statement.execute("SET STORAGE GROUP TO root.\"ln\"");
        }
        catch (IoTDBSQLException e) {
            Assert.assertEquals((Object)"315: The storage group name can only be characters, numbers and underscores. root.\"ln\" is not a legal path", (Object)e.getMessage());
        }
    }
}

