/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.integration;

import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.Statement;
import org.apache.iotdb.db.utils.EnvironmentUtils;
import org.apache.iotdb.jdbc.IoTDBSQLException;
import org.apache.iotdb.jdbc.IoTDBStatement;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Test;

public class IoTDBQueryTimeoutIT {
    @BeforeClass
    public static void setUp() throws Exception {
        EnvironmentUtils.closeStatMonitor();
        EnvironmentUtils.envSetUp();
        Class.forName("org.apache.iotdb.jdbc.IoTDBDriver");
        IoTDBQueryTimeoutIT.prepareData();
    }

    @AfterClass
    public static void tearDown() throws Exception {
        EnvironmentUtils.cleanEnv();
    }

    @Test
    public void queryProcessListTest() {
        String headerResult = "Time, queryId, statement, ";
        try (Connection connection = DriverManager.getConnection("jdbc:iotdb://127.0.0.1:6667/", "root", "root");
             Statement statement = connection.createStatement();){
            boolean hasResultSet = statement.execute("show query processlist");
            Assert.assertTrue((boolean)hasResultSet);
            ResultSet resultSet = statement.getResultSet();
            ResultSetMetaData metaData = resultSet.getMetaData();
            Assert.assertEquals((long)3L, (long)metaData.getColumnCount());
            StringBuilder headerBuilder = new StringBuilder();
            for (int i = 1; i <= metaData.getColumnCount(); ++i) {
                headerBuilder.append(metaData.getColumnName(i)).append(", ");
            }
            Assert.assertEquals((Object)headerResult, (Object)headerBuilder.toString());
            int cnt = 0;
            while (resultSet.next()) {
                ++cnt;
            }
            Assert.assertEquals((long)0L, (long)cnt);
        }
        catch (Exception e) {
            e.printStackTrace();
            Assert.fail((String)e.getMessage());
        }
    }

    @Test
    public void queryWithTimeoutTest() {
        try (Connection connection = DriverManager.getConnection("jdbc:iotdb://127.0.0.1:6667/", "root", "root");
             Statement statement = connection.createStatement();){
            statement.setFetchSize(40000);
            try {
                ((IoTDBStatement)statement).executeQuery("select count(*) from root group by ([1, 80000), 2ms)", 1L);
            }
            catch (IoTDBSQLException e) {
                Assert.assertTrue((boolean)e.getMessage().contains("Current query is time out"));
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            Assert.fail((String)e.getMessage());
        }
    }

    @Test
    public void queryAfterTimeoutQueryTest() {
        try (Connection connection = DriverManager.getConnection("jdbc:iotdb://127.0.0.1:6667/", "root", "root");
             Statement statement = connection.createStatement();){
            statement.setFetchSize(40000);
            try {
                ((IoTDBStatement)statement).executeQuery("select count(*) from root group by ([1, 80000), 2ms)", 1L);
            }
            catch (IoTDBSQLException e) {
                Assert.assertTrue((boolean)e.getMessage().contains("Current query is time out"));
            }
            Boolean hasResultSet = statement.execute("select max_time(s1) from root.sg1.d1");
            Assert.assertTrue((boolean)hasResultSet);
            ResultSet resultSet = statement.getResultSet();
            while (resultSet.next()) {
                Assert.assertEquals((long)80000L, (long)resultSet.getLong("max_time(root.sg1.d1.s1)"));
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            Assert.fail((String)e.getMessage());
        }
    }

    private static void prepareData() {
        try (Connection connection = DriverManager.getConnection("jdbc:iotdb://127.0.0.1:6667/", "root", "root");
             Statement statement = connection.createStatement();){
            for (int i = 0; i <= 80000; ++i) {
                statement.execute(String.format("insert into root.sg1.d1(time,s1) values(%d,%d)", i, i));
                statement.execute(String.format("insert into root.sg2.d2(time,s2) values(%d,%d)", i, i));
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

