/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.integration;

import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Statement;
import org.apache.iotdb.db.conf.IoTDBDescriptor;
import org.apache.iotdb.db.utils.EnvironmentUtils;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class IoTDBQueryMemoryControlIT {
    private int defaultMaxQueryDeduplicatedPathNum;
    private static final String[] sqls = new String[]{"set storage group to root.ln", "create timeseries root.ln.wf01.wt01 with datatype=BOOLEAN,encoding=PLAIN", "create timeseries root.ln.wf01.wt02 with datatype=BOOLEAN,encoding=PLAIN", "create timeseries root.ln.wf01.wt03 with datatype=BOOLEAN,encoding=PLAIN", "create timeseries root.ln.wf01.wt04 with datatype=BOOLEAN,encoding=PLAIN", "create timeseries root.ln.wf01.wt05 with datatype=BOOLEAN,encoding=PLAIN", "create timeseries root.ln.wf02.wt01 with datatype=FLOAT,encoding=RLE", "create timeseries root.ln.wf02.wt02 with datatype=FLOAT,encoding=RLE", "create timeseries root.ln.wf02.wt03 with datatype=FLOAT,encoding=RLE", "create timeseries root.ln.wf02.wt04 with datatype=FLOAT,encoding=RLE", "create timeseries root.ln.wf02.wt05 with datatype=FLOAT,encoding=RLE", "create timeseries root.ln.wf03.wt01 with datatype=TEXT,encoding=PLAIN", "create timeseries root.ln.wf03.wt02 with datatype=TEXT,encoding=PLAIN", "create timeseries root.ln.wf03.wt03 with datatype=TEXT,encoding=PLAIN", "create timeseries root.ln.wf03.wt04 with datatype=TEXT,encoding=PLAIN", "create timeseries root.ln.wf03.wt05 with datatype=TEXT,encoding=PLAIN"};

    @Before
    public void setUp() throws Exception {
        this.defaultMaxQueryDeduplicatedPathNum = IoTDBDescriptor.getInstance().getConfig().getMaxQueryDeduplicatedPathNum();
        IoTDBDescriptor.getInstance().getConfig().setMaxQueryDeduplicatedPathNum(10);
        EnvironmentUtils.envSetUp();
        Class.forName("org.apache.iotdb.jdbc.IoTDBDriver");
        IoTDBQueryMemoryControlIT.createTimeSeries();
    }

    private static void createTimeSeries() {
        try (Statement statement = DriverManager.getConnection("jdbc:iotdb://127.0.0.1:6667/", "root", "root").createStatement();){
            for (String sql : sqls) {
                statement.execute(sql);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            Assert.fail((String)e.getMessage());
        }
    }

    @After
    public void tearDown() throws Exception {
        EnvironmentUtils.cleanEnv();
        IoTDBDescriptor.getInstance().getConfig().setMaxQueryDeduplicatedPathNum(this.defaultMaxQueryDeduplicatedPathNum);
    }

    @Test
    public void selectWildcard() {
        try (Connection connection = DriverManager.getConnection("jdbc:iotdb://127.0.0.1:6667/", "root", "root");
             Statement statement = connection.createStatement();){
            try {
                statement.execute("select * from root");
            }
            catch (SQLException e) {
                Assert.assertTrue((boolean)e.getMessage().contains("Too many paths in one query!"));
            }
            try {
                statement.execute("select count(*) from root");
            }
            catch (SQLException e) {
                Assert.assertTrue((boolean)e.getMessage().contains("Too many paths in one query!"));
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            Assert.fail((String)e.getMessage());
        }
    }

    @Test
    public void selectWildcardSlimit10() {
        try (Connection connection = DriverManager.getConnection("jdbc:iotdb://127.0.0.1:6667/", "root", "root");
             Statement statement = connection.createStatement();){
            statement.execute("select * from root slimit 10");
            statement.execute("select count(*) from root slimit 10");
        }
        catch (SQLException e) {
            e.printStackTrace();
            Assert.fail((String)e.getMessage());
        }
    }

    @Test
    public void selectWildcardSlimit11() {
        try (Connection connection = DriverManager.getConnection("jdbc:iotdb://127.0.0.1:6667/", "root", "root");
             Statement statement = connection.createStatement();){
            try {
                statement.execute("select * from root slimit 11");
            }
            catch (SQLException e) {
                Assert.assertTrue((boolean)e.getMessage().contains("Too many paths in one query!"));
            }
            try {
                statement.execute("select count(*) from root slimit 11");
            }
            catch (SQLException e) {
                Assert.assertTrue((boolean)e.getMessage().contains("Too many paths in one query!"));
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            Assert.fail((String)e.getMessage());
        }
    }

    @Test
    public void selectWildcardWildcardWildcardSlimit5Soffset7() {
        try (Connection connection = DriverManager.getConnection("jdbc:iotdb://127.0.0.1:6667/", "root", "root");
             Statement statement = connection.createStatement();){
            int i;
            statement.execute("select wf01.*, wf02.*, wf03.* from root.ln slimit 5 soffset 7");
            ResultSetMetaData resultSetMetaData = statement.getResultSet().getMetaData();
            Assert.assertEquals((long)6L, (long)resultSetMetaData.getColumnCount());
            for (i = 2; i < 5; ++i) {
                Assert.assertTrue((boolean)resultSetMetaData.getColumnName(i).contains("root.ln.wf02.wt0"));
            }
            for (i = 5; i < 7; ++i) {
                Assert.assertTrue((boolean)resultSetMetaData.getColumnName(i).contains("root.ln.wf03.wt0"));
            }
            statement.execute("select count(wf01.*), avg(wf02.*), sum(wf03.*) from root.ln slimit 5 soffset 7");
            resultSetMetaData = statement.getResultSet().getMetaData();
            Assert.assertEquals((long)5L, (long)resultSetMetaData.getColumnCount());
            for (i = 1; i < 4; ++i) {
                Assert.assertTrue((boolean)resultSetMetaData.getColumnName(i).contains("root.ln.wf02.wt0"));
            }
            for (i = 4; i < 6; ++i) {
                Assert.assertTrue((boolean)resultSetMetaData.getColumnName(i).contains("root.ln.wf03.wt0"));
            }
        }
        catch (SQLException e) {
            e.printStackTrace();
            Assert.fail((String)e.getMessage());
        }
    }

    @Test
    public void selectWildcardWildcardWildcardSlimit5Soffset5() {
        try (Connection connection = DriverManager.getConnection("jdbc:iotdb://127.0.0.1:6667/", "root", "root");
             Statement statement = connection.createStatement();){
            int i;
            statement.execute("select wf01.*, wf02.*, wf03.* from root.ln slimit 5 soffset 5");
            ResultSetMetaData resultSetMetaData = statement.getResultSet().getMetaData();
            Assert.assertEquals((long)6L, (long)resultSetMetaData.getColumnCount());
            for (i = 2; i < 7; ++i) {
                Assert.assertTrue((boolean)resultSetMetaData.getColumnName(i).contains("root.ln.wf02.wt0"));
            }
            statement.execute("select count(wf01.*), sum(wf02.*), avg(wf03.*) from root.ln slimit 5 soffset 5");
            resultSetMetaData = statement.getResultSet().getMetaData();
            Assert.assertEquals((long)5L, (long)resultSetMetaData.getColumnCount());
            for (i = 1; i < 6; ++i) {
                Assert.assertTrue((boolean)resultSetMetaData.getColumnName(i).contains("root.ln.wf02.wt0"));
            }
        }
        catch (SQLException e) {
            e.printStackTrace();
            Assert.fail((String)e.getMessage());
        }
    }

    @Test
    public void selectWildcardWildcardWildcardSlimit15Soffset5() {
        try (Connection connection = DriverManager.getConnection("jdbc:iotdb://127.0.0.1:6667/", "root", "root");
             Statement statement = connection.createStatement();){
            int i;
            statement.execute("select wf01.*, wf03.*, wf02.* from root.ln slimit 15 soffset 5");
            ResultSetMetaData resultSetMetaData = statement.getResultSet().getMetaData();
            Assert.assertEquals((long)11L, (long)resultSetMetaData.getColumnCount());
            for (i = 2; i < 7; ++i) {
                Assert.assertTrue((boolean)resultSetMetaData.getColumnName(i).contains("root.ln.wf03.wt0"));
            }
            for (i = 7; i < 12; ++i) {
                Assert.assertTrue((boolean)resultSetMetaData.getColumnName(i).contains("root.ln.wf02.wt0"));
            }
            statement.execute("select sum(wf01.*), avg(wf03.*), count(wf02.*) from root.ln slimit 15 soffset 5");
            resultSetMetaData = statement.getResultSet().getMetaData();
            Assert.assertEquals((long)10L, (long)resultSetMetaData.getColumnCount());
            for (i = 1; i < 6; ++i) {
                Assert.assertTrue((boolean)resultSetMetaData.getColumnName(i).contains("root.ln.wf03.wt0"));
            }
            for (i = 6; i < 11; ++i) {
                Assert.assertTrue((boolean)resultSetMetaData.getColumnName(i).contains("root.ln.wf02.wt0"));
            }
        }
        catch (SQLException e) {
            e.printStackTrace();
            Assert.fail((String)e.getMessage());
        }
    }

    @Test
    public void selectWildcardWildcardWildcardSlimit15Soffset4() {
        try (Connection connection = DriverManager.getConnection("jdbc:iotdb://127.0.0.1:6667/", "root", "root");
             Statement statement = connection.createStatement();){
            try {
                statement.execute("select wf01.*, wf02.*, wf03.* from root.ln slimit 15 soffset 4");
            }
            catch (SQLException e) {
                Assert.assertTrue((boolean)e.getMessage().contains("Too many paths in one query!"));
            }
            try {
                statement.execute("select count(wf01.*), avg(wf02.*), sum(wf03.*) from root.ln slimit 15 soffset 4");
            }
            catch (SQLException e) {
                Assert.assertTrue((boolean)e.getMessage().contains("Too many paths in one query!"));
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            Assert.fail((String)e.getMessage());
        }
    }

    @Test
    public void selectWildcardWildcardWildcardSlimit3Soffset4() {
        try (Connection connection = DriverManager.getConnection("jdbc:iotdb://127.0.0.1:6667/", "root", "root");
             Statement statement = connection.createStatement();){
            int i;
            statement.execute("select wf01.*, wf02.*, wf03.* from root.ln slimit 3 soffset 4");
            ResultSetMetaData resultSetMetaData = statement.getResultSet().getMetaData();
            Assert.assertEquals((long)4L, (long)resultSetMetaData.getColumnCount());
            for (i = 2; i < 3; ++i) {
                Assert.assertTrue((boolean)resultSetMetaData.getColumnName(i).contains("root.ln.wf01.wt0"));
            }
            for (i = 3; i < 5; ++i) {
                Assert.assertTrue((boolean)resultSetMetaData.getColumnName(i).contains("root.ln.wf02.wt0"));
            }
            statement.execute("select sum(wf01.*), count(wf02.*), avg(wf03.*) from root.ln slimit 3 soffset 4");
            resultSetMetaData = statement.getResultSet().getMetaData();
            Assert.assertEquals((long)3L, (long)resultSetMetaData.getColumnCount());
            for (i = 1; i < 2; ++i) {
                Assert.assertTrue((boolean)resultSetMetaData.getColumnName(i).contains("root.ln.wf01.wt0"));
            }
            for (i = 2; i < 4; ++i) {
                Assert.assertTrue((boolean)resultSetMetaData.getColumnName(i).contains("root.ln.wf02.wt0"));
            }
        }
        catch (SQLException e) {
            e.printStackTrace();
            Assert.fail((String)e.getMessage());
        }
    }
}

