/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.integration;

import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.apache.iotdb.db.utils.EnvironmentUtils;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Test;

public class IoTDBQueryDemoIT {
    private static String[] sqls = new String[]{"set storage group to root.ln", "create timeseries root.ln.wf01.wt01.status with datatype=BOOLEAN,encoding=PLAIN", "insert into root.ln.wf01.wt01(timestamp,status) values(1509465600000,true)", "insert into root.ln.wf01.wt01(timestamp,status) values(1509465660000,true)", "insert into root.ln.wf01.wt01(timestamp,status) values(1509465720000,false)", "insert into root.ln.wf01.wt01(timestamp,status) values(1509465780000,false)", "insert into root.ln.wf01.wt01(timestamp,status) values(1509465840000,false)", "insert into root.ln.wf01.wt01(timestamp,status) values(1509465900000,false)", "insert into root.ln.wf01.wt01(timestamp,status) values(1509465960000,false)", "insert into root.ln.wf01.wt01(timestamp,status) values(1509466020000,false)", "insert into root.ln.wf01.wt01(timestamp,status) values(1509466080000,false)", "insert into root.ln.wf01.wt01(timestamp,status) values(1509466140000,false)", "create timeseries root.ln.wf01.wt01.temperature with datatype=FLOAT,encoding=RLE", "insert into root.ln.wf01.wt01(timestamp,temperature) values(1509465600000,25.957603)", "insert into root.ln.wf01.wt01(timestamp,temperature) values(1509465660000,24.359503)", "insert into root.ln.wf01.wt01(timestamp,temperature) values(1509465720000,20.092794)", "insert into root.ln.wf01.wt01(timestamp,temperature) values(1509465780000,20.182663)", "insert into root.ln.wf01.wt01(timestamp,temperature) values(1509465840000,21.125198)", "insert into root.ln.wf01.wt01(timestamp,temperature) values(1509465900000,22.720892)", "insert into root.ln.wf01.wt01(timestamp,temperature) values(1509465960000,20.71);", "insert into root.ln.wf01.wt01(timestamp,temperature) values(1509466020000,21.451046);", "insert into root.ln.wf01.wt01(timestamp,temperature) values(1509466080000,22.57987);", "insert into root.ln.wf01.wt01(timestamp,temperature) values(1509466140000,20.98177);", "create timeseries root.ln.wf02.wt02.hardware with datatype=TEXT,encoding=PLAIN", "insert into root.ln.wf02.wt02(timestamp,hardware) values(1509465600000,\"v2\")", "insert into root.ln.wf02.wt02(timestamp,hardware) values(1509465660000,\"v2\")", "insert into root.ln.wf02.wt02(timestamp,hardware) values(1509465720000,\"v1\")", "insert into root.ln.wf02.wt02(timestamp,hardware) values(1509465780000,\"v1\")", "insert into root.ln.wf02.wt02(timestamp,hardware) values(1509465840000,\"v1\")", "insert into root.ln.wf02.wt02(timestamp,hardware) values(1509465900000,\"v1\")", "insert into root.ln.wf02.wt02(timestamp,hardware) values(1509465960000,\"v1\")", "insert into root.ln.wf02.wt02(timestamp,hardware) values(1509466020000,\"v1\")", "insert into root.ln.wf02.wt02(timestamp,hardware) values(1509466080000,\"v1\")", "insert into root.ln.wf02.wt02(timestamp,hardware) values(1509466140000,\"v1\")", "create timeseries root.ln.wf02.wt02.status with datatype=BOOLEAN,encoding=PLAIN", "insert into root.ln.wf02.wt02(timestamp,status) values(1509465600000,true)", "insert into root.ln.wf02.wt02(timestamp,status) values(1509465660000,true)", "insert into root.ln.wf02.wt02(timestamp,status) values(1509465720000,false)", "insert into root.ln.wf02.wt02(timestamp,status) values(1509465780000,false)", "insert into root.ln.wf02.wt02(timestamp,status) values(1509465840000,false)", "insert into root.ln.wf02.wt02(timestamp,status) values(1509465900000,false)", "insert into root.ln.wf02.wt02(timestamp,status) values(1509465960000,false)", "insert into root.ln.wf02.wt02(timestamp,status) values(1509466020000,false)", "insert into root.ln.wf02.wt02(timestamp,status) values(1509466080000,false)", "insert into root.ln.wf02.wt02(timestamp,status) values(1509466140000,false)", "set storage group to root.sgcc", "create timeseries root.sgcc.wf03.wt01.status with datatype=BOOLEAN,encoding=PLAIN", "insert into root.sgcc.wf03.wt01(timestamp,status) values(1509465600000,true)", "insert into root.sgcc.wf03.wt01(timestamp,status) values(1509465660000,true)", "insert into root.sgcc.wf03.wt01(timestamp,status) values(1509465720000,false)", "insert into root.sgcc.wf03.wt01(timestamp,status) values(1509465780000,false)", "insert into root.sgcc.wf03.wt01(timestamp,status) values(1509465840000,false)", "insert into root.sgcc.wf03.wt01(timestamp,status) values(1509465900000,false)", "insert into root.sgcc.wf03.wt01(timestamp,status) values(1509465960000,false)", "insert into root.sgcc.wf03.wt01(timestamp,status) values(1509466020000,false)", "insert into root.sgcc.wf03.wt01(timestamp,status) values(1509466080000,false)", "insert into root.sgcc.wf03.wt01(timestamp,status) values(1509466140000,false)", "create timeseries root.sgcc.wf03.wt01.temperature with datatype=FLOAT,encoding=RLE", "insert into root.sgcc.wf03.wt01(timestamp,temperature) values(1509465600000,25.957603)", "insert into root.sgcc.wf03.wt01(timestamp,temperature) values(1509465660000,24.359503)", "insert into root.sgcc.wf03.wt01(timestamp,temperature) values(1509465720000,20.092794)", "insert into root.sgcc.wf03.wt01(timestamp,temperature) values(1509465780000,20.182663)", "insert into root.sgcc.wf03.wt01(timestamp,temperature) values(1509465840000,21.125198)", "insert into root.sgcc.wf03.wt01(timestamp,temperature) values(1509465900000,22.720892)", "insert into root.sgcc.wf03.wt01(timestamp,temperature) values(1509465960000,20.71)", "insert into root.sgcc.wf03.wt01(timestamp,temperature) values(1509466020000,21.451046)", "insert into root.sgcc.wf03.wt01(timestamp,temperature) values(1509466080000,22.57987)", "insert into root.sgcc.wf03.wt01(timestamp,temperature) values(1509466140000,20.98177)"};

    @BeforeClass
    public static void setUp() throws Exception {
        EnvironmentUtils.closeStatMonitor();
        EnvironmentUtils.envSetUp();
        IoTDBQueryDemoIT.importData();
    }

    @AfterClass
    public static void tearDown() throws Exception {
        EnvironmentUtils.cleanEnv();
    }

    private static void importData() throws ClassNotFoundException {
        Class.forName("org.apache.iotdb.jdbc.IoTDBDriver");
        try (Connection connection = DriverManager.getConnection("jdbc:iotdb://127.0.0.1:6667/", "root", "root");
             Statement statement = connection.createStatement();){
            for (String sql : sqls) {
                statement.execute(sql);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            Assert.fail((String)e.getMessage());
        }
    }

    @Test
    public void selectTest() throws ClassNotFoundException {
        String[] retArray = new String[]{"1509465600000,true,25.96,v2,true,true,25.96,", "1509465660000,true,24.36,v2,true,true,24.36,", "1509465720000,false,20.09,v1,false,false,20.09,", "1509465780000,false,20.18,v1,false,false,20.18,", "1509465840000,false,21.13,v1,false,false,21.13,", "1509465900000,false,22.72,v1,false,false,22.72,", "1509465960000,false,20.71,v1,false,false,20.71,", "1509466020000,false,21.45,v1,false,false,21.45,", "1509466080000,false,22.58,v1,false,false,22.58,", "1509466140000,false,20.98,v1,false,false,20.98,"};
        Class.forName("org.apache.iotdb.jdbc.IoTDBDriver");
        try (Connection connection = DriverManager.getConnection("jdbc:iotdb://127.0.0.1:6667/", "root", "root");
             Statement statement = connection.createStatement();){
            boolean hasResultSet = statement.execute("select * from root where time>10");
            Assert.assertTrue((boolean)hasResultSet);
            try (ResultSet resultSet = statement.getResultSet();){
                ResultSetMetaData resultSetMetaData = resultSet.getMetaData();
                List<Integer> actualIndexToExpectedIndexList = this.checkHeader(resultSetMetaData, "Time,root.ln.wf01.wt01.status,root.ln.wf01.wt01.temperature,root.ln.wf02.wt02.hardware,root.ln.wf02.wt02.status,root.sgcc.wf03.wt01.status,root.sgcc.wf03.wt01.temperature,", new int[]{93, 16, 6, 12, 16, 16, 6});
                int cnt = 0;
                while (resultSet.next()) {
                    String[] expectedStrings = retArray[cnt].split(",");
                    StringBuilder expectedBuilder = new StringBuilder();
                    StringBuilder actualBuilder = new StringBuilder();
                    for (int i = 1; i <= resultSetMetaData.getColumnCount(); ++i) {
                        actualBuilder.append(resultSet.getString(i)).append(",");
                        expectedBuilder.append(expectedStrings[actualIndexToExpectedIndexList.get(i - 1)]).append(",");
                    }
                    Assert.assertEquals((Object)expectedBuilder.toString(), (Object)actualBuilder.toString());
                    ++cnt;
                }
                Assert.assertEquals((long)10L, (long)cnt);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            Assert.fail((String)e.getMessage());
        }
    }

    @Test
    public void LimitTest() throws ClassNotFoundException {
        String[] retArray = new String[]{"1509465780000,false,20.18,v1,false,false,20.18,", "1509465840000,false,21.13,v1,false,false,21.13,", "1509465900000,false,22.72,v1,false,false,22.72,", "1509465960000,false,20.71,v1,false,false,20.71,", "1509466020000,false,21.45,v1,false,false,21.45,"};
        Class.forName("org.apache.iotdb.jdbc.IoTDBDriver");
        try (Connection connection = DriverManager.getConnection("jdbc:iotdb://127.0.0.1:6667/", "root", "root");
             Statement statement = connection.createStatement();){
            int i;
            StringBuilder actualBuilder;
            StringBuilder expectedBuilder;
            String[] expectedStrings;
            int cnt;
            List<Integer> actualIndexToExpectedIndexList;
            ResultSetMetaData resultSetMetaData;
            statement.setFetchSize(4);
            Assert.assertEquals((long)4L, (long)statement.getFetchSize());
            boolean hasResultSet = statement.execute("select * from root where time>10 limit 5 offset 3");
            Assert.assertTrue((boolean)hasResultSet);
            try (ResultSet resultSet = statement.getResultSet();){
                resultSetMetaData = resultSet.getMetaData();
                actualIndexToExpectedIndexList = this.checkHeader(resultSetMetaData, "Time,root.ln.wf01.wt01.status,root.ln.wf01.wt01.temperature,root.ln.wf02.wt02.hardware,root.ln.wf02.wt02.status,root.sgcc.wf03.wt01.status,root.sgcc.wf03.wt01.temperature,", new int[]{93, 16, 6, 12, 16, 16, 6});
                cnt = 0;
                while (resultSet.next()) {
                    expectedStrings = retArray[cnt].split(",");
                    expectedBuilder = new StringBuilder();
                    actualBuilder = new StringBuilder();
                    for (i = 1; i <= resultSetMetaData.getColumnCount(); ++i) {
                        actualBuilder.append(resultSet.getString(i)).append(",");
                        expectedBuilder.append(expectedStrings[actualIndexToExpectedIndexList.get(i - 1)]).append(",");
                    }
                    Assert.assertEquals((Object)expectedBuilder.toString(), (Object)actualBuilder.toString());
                    ++cnt;
                }
                Assert.assertEquals((long)5L, (long)cnt);
            }
            statement.setFetchSize(10000);
            Assert.assertEquals((long)10000L, (long)statement.getFetchSize());
            hasResultSet = statement.execute("select * from root where time>10 limit 5 offset 3");
            Assert.assertTrue((boolean)hasResultSet);
            resultSet = statement.getResultSet();
            try {
                resultSetMetaData = resultSet.getMetaData();
                actualIndexToExpectedIndexList = this.checkHeader(resultSetMetaData, "Time,root.ln.wf01.wt01.status,root.ln.wf01.wt01.temperature,root.ln.wf02.wt02.hardware,root.ln.wf02.wt02.status,root.sgcc.wf03.wt01.status,root.sgcc.wf03.wt01.temperature,", new int[]{93, 16, 6, 12, 16, 16, 6});
                cnt = 0;
                while (resultSet.next()) {
                    expectedStrings = retArray[cnt].split(",");
                    expectedBuilder = new StringBuilder();
                    actualBuilder = new StringBuilder();
                    for (i = 1; i <= resultSetMetaData.getColumnCount(); ++i) {
                        actualBuilder.append(resultSet.getString(i)).append(",");
                        expectedBuilder.append(expectedStrings[actualIndexToExpectedIndexList.get(i - 1)]).append(",");
                    }
                    Assert.assertEquals((Object)expectedBuilder.toString(), (Object)actualBuilder.toString());
                    ++cnt;
                }
                Assert.assertEquals((long)5L, (long)cnt);
            }
            finally {
                if (resultSet != null) {
                    resultSet.close();
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            Assert.fail((String)e.getMessage());
        }
    }

    @Test
    public void InTest() throws ClassNotFoundException {
        String[] retArray = new String[]{"1509465780000,false,20.18,v1,false,false,20.18,", "1509465840000,false,21.13,v1,false,false,21.13,", "1509465900000,false,22.72,v1,false,false,22.72,", "1509465960000,false,20.71,v1,false,false,20.71,", "1509466020000,false,21.45,v1,false,false,21.45,"};
        Class.forName("org.apache.iotdb.jdbc.IoTDBDriver");
        try (Connection connection = DriverManager.getConnection("jdbc:iotdb://127.0.0.1:6667/", "root", "root");
             Statement statement = connection.createStatement();){
            int i;
            StringBuilder actualBuilder;
            StringBuilder expectedBuilder;
            String[] expectedStrings;
            int cnt;
            List<Integer> actualIndexToExpectedIndexList;
            ResultSetMetaData resultSetMetaData;
            statement.setFetchSize(4);
            Assert.assertEquals((long)4L, (long)statement.getFetchSize());
            boolean hasResultSet = statement.execute("select * from root where time in (1509465780000, 1509465840000, 1509465900000, 1509465960000, 1509466020000)");
            Assert.assertTrue((boolean)hasResultSet);
            try (ResultSet resultSet = statement.getResultSet();){
                resultSetMetaData = resultSet.getMetaData();
                actualIndexToExpectedIndexList = this.checkHeader(resultSetMetaData, "Time,root.ln.wf01.wt01.status,root.ln.wf01.wt01.temperature,root.ln.wf02.wt02.hardware,root.ln.wf02.wt02.status,root.sgcc.wf03.wt01.status,root.sgcc.wf03.wt01.temperature,", new int[]{93, 16, 6, 12, 16, 16, 6});
                cnt = 0;
                while (resultSet.next()) {
                    expectedStrings = retArray[cnt].split(",");
                    expectedBuilder = new StringBuilder();
                    actualBuilder = new StringBuilder();
                    for (i = 1; i <= resultSetMetaData.getColumnCount(); ++i) {
                        actualBuilder.append(resultSet.getString(i)).append(",");
                        expectedBuilder.append(expectedStrings[actualIndexToExpectedIndexList.get(i - 1)]).append(",");
                    }
                    Assert.assertEquals((Object)expectedBuilder.toString(), (Object)actualBuilder.toString());
                    ++cnt;
                }
                Assert.assertEquals((long)5L, (long)cnt);
            }
            retArray = new String[]{"1509465600000,true,25.96,v2,true,true,25.96,", "1509465660000,true,24.36,v2,true,true,24.36,", "1509465720000,false,20.09,v1,false,false,20.09,", "1509466080000,false,22.58,v1,false,false,22.58,", "1509466140000,false,20.98,v1,false,false,20.98,"};
            hasResultSet = statement.execute("select * from root where time not in (1509465780000, 1509465840000, 1509465900000, 1509465960000, 1509466020000)");
            Assert.assertTrue((boolean)hasResultSet);
            resultSet = statement.getResultSet();
            try {
                resultSetMetaData = resultSet.getMetaData();
                actualIndexToExpectedIndexList = this.checkHeader(resultSetMetaData, "Time,root.ln.wf01.wt01.status,root.ln.wf01.wt01.temperature,root.ln.wf02.wt02.hardware,root.ln.wf02.wt02.status,root.sgcc.wf03.wt01.status,root.sgcc.wf03.wt01.temperature,", new int[]{93, 16, 6, 12, 16, 16, 6});
                cnt = 0;
                while (resultSet.next()) {
                    expectedStrings = retArray[cnt].split(",");
                    expectedBuilder = new StringBuilder();
                    actualBuilder = new StringBuilder();
                    for (i = 1; i <= resultSetMetaData.getColumnCount(); ++i) {
                        actualBuilder.append(resultSet.getString(i)).append(",");
                        expectedBuilder.append(expectedStrings[actualIndexToExpectedIndexList.get(i - 1)]).append(",");
                    }
                    Assert.assertEquals((Object)expectedBuilder.toString(), (Object)actualBuilder.toString());
                    ++cnt;
                }
                Assert.assertEquals((long)5L, (long)cnt);
            }
            finally {
                if (resultSet != null) {
                    resultSet.close();
                }
            }
            retArray = new String[]{"1509465780000,false,20.18,v1,false,false,20.18,", "1509465960000,false,20.71,v1,false,false,20.71,", "1509466080000,false,22.58,v1,false,false,22.58,"};
            hasResultSet = statement.execute("select * from root where ln.wf01.wt01.temperature in (20.18, 20.71, 22.58)");
            Assert.assertTrue((boolean)hasResultSet);
            resultSet = statement.getResultSet();
            try {
                resultSetMetaData = resultSet.getMetaData();
                actualIndexToExpectedIndexList = this.checkHeader(resultSetMetaData, "Time,root.ln.wf01.wt01.status,root.ln.wf01.wt01.temperature,root.ln.wf02.wt02.hardware,root.ln.wf02.wt02.status,root.sgcc.wf03.wt01.status,root.sgcc.wf03.wt01.temperature,", new int[]{93, 16, 6, 12, 16, 16, 6});
                cnt = 0;
                while (resultSet.next()) {
                    expectedStrings = retArray[cnt].split(",");
                    expectedBuilder = new StringBuilder();
                    actualBuilder = new StringBuilder();
                    for (i = 1; i <= resultSetMetaData.getColumnCount(); ++i) {
                        actualBuilder.append(resultSet.getString(i)).append(",");
                        expectedBuilder.append(expectedStrings[actualIndexToExpectedIndexList.get(i - 1)]).append(",");
                    }
                    Assert.assertEquals((Object)expectedBuilder.toString(), (Object)actualBuilder.toString());
                    ++cnt;
                }
                Assert.assertEquals((long)3L, (long)cnt);
            }
            finally {
                if (resultSet != null) {
                    resultSet.close();
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            Assert.fail((String)e.getMessage());
        }
    }

    private List<Integer> checkHeader(ResultSetMetaData resultSetMetaData, String expectedHeaderStrings, int[] expectedTypes) throws SQLException {
        String[] expectedHeaders = expectedHeaderStrings.split(",");
        HashMap<String, Integer> expectedHeaderToTypeIndexMap = new HashMap<String, Integer>();
        for (int i = 0; i < expectedHeaders.length; ++i) {
            expectedHeaderToTypeIndexMap.put(expectedHeaders[i], i);
        }
        ArrayList<Integer> actualIndexToExpectedIndexList = new ArrayList<Integer>();
        for (int i = 1; i <= resultSetMetaData.getColumnCount(); ++i) {
            Integer typeIndex = (Integer)expectedHeaderToTypeIndexMap.get(resultSetMetaData.getColumnName(i));
            Assert.assertNotNull((Object)typeIndex);
            Assert.assertEquals((long)expectedTypes[typeIndex], (long)resultSetMetaData.getColumnType(i));
            actualIndexToExpectedIndexList.add(typeIndex);
        }
        return actualIndexToExpectedIndexList;
    }
}

