/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.integration;

import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.ResultSet;
import java.sql.Statement;
import org.apache.iotdb.db.conf.IoTDBDescriptor;
import org.apache.iotdb.db.engine.compaction.CompactionStrategy;
import org.apache.iotdb.db.utils.EnvironmentUtils;
import org.apache.iotdb.tsfile.common.conf.TSFileDescriptor;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Test;

public class IoTDBOverlappedPageIT {
    private static int beforeMaxNumberOfPointsInPage;
    private static boolean enableUnseqCompaction;
    private static String[] dataSet1;

    @BeforeClass
    public static void setUp() throws Exception {
        Class.forName("org.apache.iotdb.jdbc.IoTDBDriver");
        EnvironmentUtils.closeStatMonitor();
        IoTDBDescriptor.getInstance().getConfig().setCompactionStrategy(CompactionStrategy.NO_COMPACTION);
        enableUnseqCompaction = IoTDBDescriptor.getInstance().getConfig().isEnableUnseqCompaction();
        IoTDBDescriptor.getInstance().getConfig().setEnableUnseqCompaction(false);
        beforeMaxNumberOfPointsInPage = TSFileDescriptor.getInstance().getConfig().getMaxNumberOfPointsInPage();
        TSFileDescriptor.getInstance().getConfig().setMaxNumberOfPointsInPage(10);
        EnvironmentUtils.envSetUp();
    }

    @AfterClass
    public static void tearDown() throws Exception {
        EnvironmentUtils.cleanEnv();
        IoTDBDescriptor.getInstance().getConfig().setCompactionStrategy(CompactionStrategy.LEVEL_COMPACTION);
        IoTDBDescriptor.getInstance().getConfig().setEnableUnseqCompaction(enableUnseqCompaction);
        IoTDBDescriptor.getInstance().getConfig().setMemtableSizeThreshold((long)beforeMaxNumberOfPointsInPage);
    }

    @Test
    public void selectOverlappedPageTest() {
        String[] res = new String[]{"11,111", "12,112", "13,113", "14,114", "15,115", "16,116", "17,117", "18,118", "19,119", "20,120"};
        try (Connection connection = DriverManager.getConnection("jdbc:iotdb://127.0.0.1:6667/", "root", "root");
             Statement statement = connection.createStatement();){
            IoTDBOverlappedPageIT.insertData();
            String sql = "select s0 from root.vehicle.d0 where time >= 1 and time <= 110 AND root.vehicle.d0.s0 > 110";
            try (ResultSet resultSet = statement.executeQuery(sql);){
                int cnt = 0;
                while (resultSet.next()) {
                    String ans = resultSet.getString("Time") + "," + resultSet.getString("root.vehicle.d0.s0");
                    Assert.assertEquals((Object)res[cnt], (Object)ans);
                    ++cnt;
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            Assert.fail((String)e.getMessage());
        }
    }

    @Test
    public void selectOverlappedPageTest2() {
        String[] res = new String[]{"0,10"};
        try (Connection connection = DriverManager.getConnection("jdbc:iotdb://127.0.0.1:6667/", "root", "root");
             Statement statement = connection.createStatement();){
            for (String insertSql : dataSet1) {
                statement.execute(insertSql);
            }
            boolean hasResultSet = statement.execute("select count(s1) from root.sg1.d1");
            Assert.assertTrue((boolean)hasResultSet);
            int cnt = 0;
            try (ResultSet resultSet = statement.getResultSet();){
                while (resultSet.next()) {
                    String ans = resultSet.getString("Time") + "," + resultSet.getString("count(root.sg1.d1.s1)");
                    Assert.assertEquals((Object)res[cnt], (Object)ans);
                    ++cnt;
                }
                Assert.assertEquals((long)res.length, (long)cnt);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            Assert.fail((String)e.getMessage());
        }
    }

    private static void insertData() {
        try (Connection connection = DriverManager.getConnection("jdbc:iotdb://127.0.0.1:6667/", "root", "root");
             Statement statement = connection.createStatement();){
            String sql;
            long time;
            statement.execute("CREATE TIMESERIES root.vehicle.d0.s0 WITH DATATYPE=INT32, ENCODING=RLE");
            for (time = 1L; time <= 10L; ++time) {
                sql = String.format("insert into root.vehicle.d0(timestamp,s0) values(%s,%s)", time, time);
                statement.execute(sql);
            }
            statement.execute("flush");
            for (time = 11L; time <= 20L; ++time) {
                sql = String.format("insert into root.vehicle.d0(timestamp,s0) values(%s,%s)", time, time + 100L);
                statement.execute(sql);
            }
            for (time = 100L; time <= 120L; ++time) {
                sql = String.format("insert into root.vehicle.d0(timestamp,s0) values(%s,%s)", time, time);
                statement.execute(sql);
            }
            statement.execute("flush");
            for (time = 1L; time <= 10L; ++time) {
                sql = String.format("insert into root.vehicle.d0(timestamp,s0) values(%s,%s)", time, time + 100L);
                statement.execute(sql);
            }
            for (time = 11L; time <= 20L; ++time) {
                sql = String.format("insert into root.vehicle.d0(timestamp,s0) values(%s,%s)", time, time + 100L);
                statement.execute(sql);
            }
            statement.execute("flush");
        }
        catch (Exception e) {
            e.printStackTrace();
            Assert.fail((String)e.getMessage());
        }
    }

    static {
        dataSet1 = new String[]{"SET STORAGE GROUP TO root.sg1", "CREATE TIMESERIES root.sg1.d1.s1 WITH DATATYPE=INT32, ENCODING=PLAIN", "INSERT INTO root.sg1.d1(time,s1) values(1, 1)", "INSERT INTO root.sg1.d1(time,s1) values(10, 10)", "flush", "INSERT INTO root.sg1.d1(time,s1) values(20, 20)", "INSERT INTO root.sg1.d1(time,s1) values(30, 30)", "flush", "INSERT INTO root.sg1.d1(time,s1) values(110, 110)", "flush", "INSERT INTO root.sg1.d1(time,s1) values(5, 5)", "INSERT INTO root.sg1.d1(time,s1) values(50, 50)", "INSERT INTO root.sg1.d1(time,s1) values(100, 100)", "flush", "INSERT INTO root.sg1.d1(time,s1) values(15, 15)", "INSERT INTO root.sg1.d1(time,s1) values(25, 25)", "flush"};
    }
}

