/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.integration;

import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.List;
import java.util.SortedSet;
import java.util.concurrent.TimeUnit;
import org.apache.iotdb.db.conf.IoTDBDescriptor;
import org.apache.iotdb.db.engine.StorageEngine;
import org.apache.iotdb.db.engine.compaction.CompactionStrategy;
import org.apache.iotdb.db.engine.compaction.level.LevelCompactionTsFileManagement;
import org.apache.iotdb.db.engine.storagegroup.StorageGroupProcessor;
import org.apache.iotdb.db.exception.StorageEngineException;
import org.apache.iotdb.db.metadata.PartialPath;
import org.apache.iotdb.db.utils.EnvironmentUtils;
import org.apache.iotdb.tsfile.common.conf.TSFileDescriptor;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class IoTDBNewTsFileCompactionIT {
    private int prevSeqLevelFileNum;
    private int prevSeqLevelNum;
    private int prevMergePagePointNumber;
    private int preMaxNumberOfPointsInPage;
    private CompactionStrategy preCompactionStrategy;
    private PartialPath storageGroupPath;
    private static final long MAX_WAIT_TIME_FOR_MERGE = Long.MAX_VALUE;
    private static final float FLOAT_DELTA = 1.0E-5f;

    @Before
    public void setUp() throws Exception {
        EnvironmentUtils.closeStatMonitor();
        this.prevSeqLevelFileNum = IoTDBDescriptor.getInstance().getConfig().getSeqFileNumInEachLevel();
        this.prevSeqLevelNum = IoTDBDescriptor.getInstance().getConfig().getSeqLevelNum();
        this.prevMergePagePointNumber = IoTDBDescriptor.getInstance().getConfig().getMergePagePointNumberThreshold();
        this.preMaxNumberOfPointsInPage = TSFileDescriptor.getInstance().getConfig().getMaxNumberOfPointsInPage();
        this.preCompactionStrategy = IoTDBDescriptor.getInstance().getConfig().getCompactionStrategy();
        this.storageGroupPath = new PartialPath("root.sg1");
        IoTDBDescriptor.getInstance().getConfig().setSeqFileNumInEachLevel(2);
        IoTDBDescriptor.getInstance().getConfig().setSeqLevelNum(2);
        IoTDBDescriptor.getInstance().getConfig().setMergePagePointNumberThreshold(1);
        TSFileDescriptor.getInstance().getConfig().setMaxNumberOfPointsInPage(1);
        IoTDBDescriptor.getInstance().getConfig().setCompactionStrategy(CompactionStrategy.LEVEL_COMPACTION);
        EnvironmentUtils.envSetUp();
        Class.forName("org.apache.iotdb.jdbc.IoTDBDriver");
        try (Connection connection = DriverManager.getConnection("jdbc:iotdb://127.0.0.1:6667/", "root", "root");
             Statement statement = connection.createStatement();){
            statement.execute("SET STORAGE GROUP TO root.sg1");
        }
    }

    @After
    public void tearDown() throws Exception {
        EnvironmentUtils.cleanEnv();
        IoTDBDescriptor.getInstance().getConfig().setSeqFileNumInEachLevel(this.prevSeqLevelFileNum);
        IoTDBDescriptor.getInstance().getConfig().setSeqLevelNum(this.prevSeqLevelNum);
        IoTDBDescriptor.getInstance().getConfig().setMergePagePointNumberThreshold(this.prevMergePagePointNumber);
        TSFileDescriptor.getInstance().getConfig().setMaxNumberOfPointsInPage(this.preMaxNumberOfPointsInPage);
        IoTDBDescriptor.getInstance().getConfig().setCompactionStrategy(this.preCompactionStrategy);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void test1() throws SQLException {
        String[][] retArray = new String[][]{{"1", "1"}, {"2", "2"}};
        int preAvgSeriesPointNumberThreshold = IoTDBDescriptor.getInstance().getConfig().getAvgSeriesPointNumberThreshold();
        try (Connection connection = DriverManager.getConnection("jdbc:iotdb://127.0.0.1:6667/", "root", "root");
             Statement statement = connection.createStatement();){
            int cnt;
            IoTDBDescriptor.getInstance().getConfig().setAvgSeriesPointNumberThreshold(10000);
            statement.execute("INSERT INTO root.sg1.d1(time,s1) values(1, 1)");
            statement.execute("FLUSH");
            statement.execute("INSERT INTO root.sg1.d1(time,s1) values(2, 2)");
            statement.execute("FLUSH");
            Assert.assertTrue((boolean)this.waitForMergeFinish());
            try (ResultSet resultSet = statement.executeQuery("SELECT s1 FROM root.sg1.d1");){
                cnt = 0;
                while (resultSet.next()) {
                    long time = resultSet.getLong("Time");
                    float s1 = resultSet.getFloat("root.sg1.d1.s1");
                    Assert.assertEquals((long)Long.parseLong(retArray[cnt][0]), (long)time);
                    Assert.assertEquals((float)Float.parseFloat(retArray[cnt][1]), (float)s1, (float)1.0E-5f);
                    ++cnt;
                }
            }
            Assert.assertEquals((long)retArray.length, (long)cnt);
        }
        catch (InterruptedException | StorageEngineException e) {
            e.printStackTrace();
            Assert.fail();
        }
        finally {
            IoTDBDescriptor.getInstance().getConfig().setAvgSeriesPointNumberThreshold(preAvgSeriesPointNumberThreshold);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void test2() throws SQLException {
        String[][] retArray = new String[][]{{"1", "1"}, {"2", "2"}, {"3", "3"}};
        int preAvgSeriesPointNumberThreshold = IoTDBDescriptor.getInstance().getConfig().getAvgSeriesPointNumberThreshold();
        try (Connection connection = DriverManager.getConnection("jdbc:iotdb://127.0.0.1:6667/", "root", "root");
             Statement statement = connection.createStatement();){
            int cnt;
            IoTDBDescriptor.getInstance().getConfig().setAvgSeriesPointNumberThreshold(1);
            statement.execute("INSERT INTO root.sg1.d1(time,s1) values(1, 1)");
            statement.execute("INSERT INTO root.sg1.d1(time,s1) values(2, 2)");
            statement.execute("FLUSH");
            statement.execute("INSERT INTO root.sg1.d1(time,s1) values(3, 3)");
            statement.execute("FLUSH");
            Assert.assertTrue((boolean)this.waitForMergeFinish());
            try (ResultSet resultSet = statement.executeQuery("SELECT s1 FROM root.sg1.d1");){
                cnt = 0;
                while (resultSet.next()) {
                    long time = resultSet.getLong("Time");
                    float s1 = resultSet.getFloat("root.sg1.d1.s1");
                    Assert.assertEquals((long)Long.parseLong(retArray[cnt][0]), (long)time);
                    Assert.assertEquals((float)Float.parseFloat(retArray[cnt][1]), (float)s1, (float)1.0E-5f);
                    ++cnt;
                }
            }
            Assert.assertEquals((long)retArray.length, (long)cnt);
        }
        catch (InterruptedException | StorageEngineException e) {
            e.printStackTrace();
            Assert.fail();
        }
        finally {
            IoTDBDescriptor.getInstance().getConfig().setAvgSeriesPointNumberThreshold(preAvgSeriesPointNumberThreshold);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void test3() throws SQLException {
        String[][] retArray = new String[][]{{"1", "1"}, {"2", "2"}, {"3", "3"}};
        int preAvgSeriesPointNumberThreshold = IoTDBDescriptor.getInstance().getConfig().getAvgSeriesPointNumberThreshold();
        try (Connection connection = DriverManager.getConnection("jdbc:iotdb://127.0.0.1:6667/", "root", "root");
             Statement statement = connection.createStatement();){
            int cnt;
            IoTDBDescriptor.getInstance().getConfig().setAvgSeriesPointNumberThreshold(10000);
            statement.execute("INSERT INTO root.sg1.d1(time,s1) values(1, 1)");
            statement.execute("INSERT INTO root.sg1.d1(time,s1) values(2, 2)");
            statement.execute("FLUSH");
            statement.execute("INSERT INTO root.sg1.d1(time,s1) values(3, 3)");
            statement.execute("FLUSH");
            Assert.assertTrue((boolean)this.waitForMergeFinish());
            try (ResultSet resultSet = statement.executeQuery("SELECT s1 FROM root.sg1.d1");){
                cnt = 0;
                while (resultSet.next()) {
                    long time = resultSet.getLong("Time");
                    float s1 = resultSet.getFloat("root.sg1.d1.s1");
                    Assert.assertEquals((long)Long.parseLong(retArray[cnt][0]), (long)time);
                    Assert.assertEquals((float)Float.parseFloat(retArray[cnt][1]), (float)s1, (float)1.0E-5f);
                    ++cnt;
                }
            }
            Assert.assertEquals((long)retArray.length, (long)cnt);
        }
        catch (InterruptedException | StorageEngineException e) {
            e.printStackTrace();
            Assert.fail();
        }
        finally {
            IoTDBDescriptor.getInstance().getConfig().setAvgSeriesPointNumberThreshold(preAvgSeriesPointNumberThreshold);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void test4() throws SQLException {
        String[][] retArray = new String[][]{{"1", "1"}, {"2", "2"}, {"3", "3"}, {"4", "4"}, {"5", "5"}};
        int preAvgSeriesPointNumberThreshold = IoTDBDescriptor.getInstance().getConfig().getAvgSeriesPointNumberThreshold();
        try (Connection connection = DriverManager.getConnection("jdbc:iotdb://127.0.0.1:6667/", "root", "root");
             Statement statement = connection.createStatement();){
            int cnt;
            IoTDBDescriptor.getInstance().getConfig().setAvgSeriesPointNumberThreshold(2);
            statement.execute("INSERT INTO root.sg1.d1(time,s1) values(1, 1)");
            statement.execute("INSERT INTO root.sg1.d1(time,s1) values(2, 2)");
            statement.execute("INSERT INTO root.sg1.d1(time,s1) values(3, 3)");
            statement.execute("INSERT INTO root.sg1.d1(time,s1) values(4, 4)");
            statement.execute("FLUSH");
            statement.execute("INSERT INTO root.sg1.d1(time,s1) values(5, 5)");
            statement.execute("FLUSH");
            Assert.assertTrue((boolean)this.waitForMergeFinish());
            try (ResultSet resultSet = statement.executeQuery("SELECT s1 FROM root.sg1.d1");){
                cnt = 0;
                while (resultSet.next()) {
                    long time = resultSet.getLong("Time");
                    float s1 = resultSet.getFloat("root.sg1.d1.s1");
                    Assert.assertEquals((long)Long.parseLong(retArray[cnt][0]), (long)time);
                    Assert.assertEquals((float)Float.parseFloat(retArray[cnt][1]), (float)s1, (float)1.0E-5f);
                    ++cnt;
                }
            }
            Assert.assertEquals((long)retArray.length, (long)cnt);
        }
        catch (InterruptedException | StorageEngineException e) {
            e.printStackTrace();
            Assert.fail();
        }
        finally {
            IoTDBDescriptor.getInstance().getConfig().setAvgSeriesPointNumberThreshold(preAvgSeriesPointNumberThreshold);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void test5() throws SQLException {
        String[][] retArray = new String[][]{{"1", "1"}, {"2", "2"}, {"3", "3"}};
        int preAvgSeriesPointNumberThreshold = IoTDBDescriptor.getInstance().getConfig().getAvgSeriesPointNumberThreshold();
        try (Connection connection = DriverManager.getConnection("jdbc:iotdb://127.0.0.1:6667/", "root", "root");
             Statement statement = connection.createStatement();){
            int cnt;
            IoTDBDescriptor.getInstance().getConfig().setAvgSeriesPointNumberThreshold(10000);
            statement.execute("INSERT INTO root.sg1.d1(time,s1) values(1, 1)");
            statement.execute("FLUSH");
            statement.execute("INSERT INTO root.sg1.d1(time,s1) values(2, 2)");
            statement.execute("INSERT INTO root.sg1.d1(time,s1) values(3, 3)");
            statement.execute("FLUSH");
            Assert.assertTrue((boolean)this.waitForMergeFinish());
            try (ResultSet resultSet = statement.executeQuery("SELECT s1 FROM root.sg1.d1");){
                cnt = 0;
                while (resultSet.next()) {
                    long time = resultSet.getLong("Time");
                    float s1 = resultSet.getFloat("root.sg1.d1.s1");
                    Assert.assertEquals((long)Long.parseLong(retArray[cnt][0]), (long)time);
                    Assert.assertEquals((float)Float.parseFloat(retArray[cnt][1]), (float)s1, (float)1.0E-5f);
                    ++cnt;
                }
            }
            Assert.assertEquals((long)retArray.length, (long)cnt);
        }
        catch (InterruptedException | StorageEngineException e) {
            e.printStackTrace();
            Assert.fail();
        }
        finally {
            IoTDBDescriptor.getInstance().getConfig().setAvgSeriesPointNumberThreshold(preAvgSeriesPointNumberThreshold);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void test6() throws SQLException {
        String[][] retArray = new String[][]{{"1", "1"}, {"2", "2"}, {"3", "3"}, {"4", "4"}};
        int preAvgSeriesPointNumberThreshold = IoTDBDescriptor.getInstance().getConfig().getAvgSeriesPointNumberThreshold();
        try (Connection connection = DriverManager.getConnection("jdbc:iotdb://127.0.0.1:6667/", "root", "root");
             Statement statement = connection.createStatement();){
            int cnt;
            IoTDBDescriptor.getInstance().getConfig().setAvgSeriesPointNumberThreshold(1);
            statement.execute("INSERT INTO root.sg1.d1(time,s1) values(1, 1)");
            statement.execute("INSERT INTO root.sg1.d1(time,s1) values(2, 2)");
            statement.execute("FLUSH");
            IoTDBDescriptor.getInstance().getConfig().setAvgSeriesPointNumberThreshold(2);
            statement.execute("INSERT INTO root.sg1.d1(time,s1) values(3, 3)");
            statement.execute("INSERT INTO root.sg1.d1(time,s1) values(4, 4)");
            statement.execute("FLUSH");
            Assert.assertTrue((boolean)this.waitForMergeFinish());
            try (ResultSet resultSet = statement.executeQuery("SELECT s1 FROM root.sg1.d1");){
                cnt = 0;
                while (resultSet.next()) {
                    long time = resultSet.getLong("Time");
                    float s1 = resultSet.getFloat("root.sg1.d1.s1");
                    Assert.assertEquals((long)Long.parseLong(retArray[cnt][0]), (long)time);
                    Assert.assertEquals((float)Float.parseFloat(retArray[cnt][1]), (float)s1, (float)1.0E-5f);
                    ++cnt;
                }
            }
            Assert.assertEquals((long)retArray.length, (long)cnt);
        }
        catch (InterruptedException | StorageEngineException e) {
            e.printStackTrace();
            Assert.fail();
        }
        finally {
            IoTDBDescriptor.getInstance().getConfig().setAvgSeriesPointNumberThreshold(preAvgSeriesPointNumberThreshold);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void test7() throws SQLException {
        String[][] retArray = new String[][]{{"1", "1"}, {"2", "2"}, {"3", "3"}, {"4", "4"}};
        int preAvgSeriesPointNumberThreshold = IoTDBDescriptor.getInstance().getConfig().getAvgSeriesPointNumberThreshold();
        try (Connection connection = DriverManager.getConnection("jdbc:iotdb://127.0.0.1:6667/", "root", "root");
             Statement statement = connection.createStatement();){
            int cnt;
            IoTDBDescriptor.getInstance().getConfig().setAvgSeriesPointNumberThreshold(10000);
            statement.execute("INSERT INTO root.sg1.d1(time,s1) values(1, 1)");
            statement.execute("INSERT INTO root.sg1.d1(time,s1) values(2, 2)");
            statement.execute("FLUSH");
            statement.execute("INSERT INTO root.sg1.d1(time,s1) values(3, 3)");
            statement.execute("INSERT INTO root.sg1.d1(time,s1) values(4, 4)");
            statement.execute("FLUSH");
            Assert.assertTrue((boolean)this.waitForMergeFinish());
            try (ResultSet resultSet = statement.executeQuery("SELECT s1 FROM root.sg1.d1");){
                cnt = 0;
                while (resultSet.next()) {
                    long time = resultSet.getLong("Time");
                    float s1 = resultSet.getFloat("root.sg1.d1.s1");
                    Assert.assertEquals((long)Long.parseLong(retArray[cnt][0]), (long)time);
                    Assert.assertEquals((float)Float.parseFloat(retArray[cnt][1]), (float)s1, (float)1.0E-5f);
                    ++cnt;
                }
            }
            Assert.assertEquals((long)retArray.length, (long)cnt);
        }
        catch (InterruptedException | StorageEngineException e) {
            e.printStackTrace();
            Assert.fail();
        }
        finally {
            IoTDBDescriptor.getInstance().getConfig().setAvgSeriesPointNumberThreshold(preAvgSeriesPointNumberThreshold);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void test8() throws SQLException {
        String[][] retArray = new String[][]{{"1", "1"}, {"2", "2"}, {"3", "3"}, {"4", "4"}, {"5", "5"}, {"6", "6"}};
        int preAvgSeriesPointNumberThreshold = IoTDBDescriptor.getInstance().getConfig().getAvgSeriesPointNumberThreshold();
        try (Connection connection = DriverManager.getConnection("jdbc:iotdb://127.0.0.1:6667/", "root", "root");
             Statement statement = connection.createStatement();){
            int cnt;
            IoTDBDescriptor.getInstance().getConfig().setAvgSeriesPointNumberThreshold(2);
            statement.execute("INSERT INTO root.sg1.d1(time,s1) values(1, 1)");
            statement.execute("INSERT INTO root.sg1.d1(time,s1) values(2, 2)");
            statement.execute("INSERT INTO root.sg1.d1(time,s1) values(3, 3)");
            statement.execute("INSERT INTO root.sg1.d1(time,s1) values(4, 4)");
            statement.execute("FLUSH");
            statement.execute("INSERT INTO root.sg1.d1(time,s1) values(5, 5)");
            statement.execute("INSERT INTO root.sg1.d1(time,s1) values(6, 6)");
            statement.execute("FLUSH");
            Assert.assertTrue((boolean)this.waitForMergeFinish());
            try (ResultSet resultSet = statement.executeQuery("SELECT s1 FROM root.sg1.d1");){
                cnt = 0;
                while (resultSet.next()) {
                    long time = resultSet.getLong("Time");
                    float s1 = resultSet.getFloat("root.sg1.d1.s1");
                    Assert.assertEquals((long)Long.parseLong(retArray[cnt][0]), (long)time);
                    Assert.assertEquals((float)Float.parseFloat(retArray[cnt][1]), (float)s1, (float)1.0E-5f);
                    ++cnt;
                }
            }
            Assert.assertEquals((long)retArray.length, (long)cnt);
        }
        catch (InterruptedException | StorageEngineException e) {
            e.printStackTrace();
            Assert.fail();
        }
        finally {
            IoTDBDescriptor.getInstance().getConfig().setAvgSeriesPointNumberThreshold(preAvgSeriesPointNumberThreshold);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void test9() throws SQLException {
        String[][] retArray = new String[][]{{"1", "1"}, {"2", "2"}, {"3", "3"}};
        int preAvgSeriesPointNumberThreshold = IoTDBDescriptor.getInstance().getConfig().getAvgSeriesPointNumberThreshold();
        try (Connection connection = DriverManager.getConnection("jdbc:iotdb://127.0.0.1:6667/", "root", "root");
             Statement statement = connection.createStatement();){
            int cnt;
            IoTDBDescriptor.getInstance().getConfig().setAvgSeriesPointNumberThreshold(10000);
            statement.execute("INSERT INTO root.sg1.d1(time,s1) values(1, 1)");
            statement.execute("FLUSH");
            IoTDBDescriptor.getInstance().getConfig().setAvgSeriesPointNumberThreshold(1);
            statement.execute("INSERT INTO root.sg1.d1(time,s1) values(2, 2)");
            statement.execute("INSERT INTO root.sg1.d1(time,s1) values(3, 3)");
            statement.execute("FLUSH");
            Assert.assertTrue((boolean)this.waitForMergeFinish());
            try (ResultSet resultSet = statement.executeQuery("SELECT s1 FROM root.sg1.d1");){
                cnt = 0;
                while (resultSet.next()) {
                    long time = resultSet.getLong("Time");
                    float s1 = resultSet.getFloat("root.sg1.d1.s1");
                    Assert.assertEquals((long)Long.parseLong(retArray[cnt][0]), (long)time);
                    Assert.assertEquals((float)Float.parseFloat(retArray[cnt][1]), (float)s1, (float)1.0E-5f);
                    ++cnt;
                }
            }
            Assert.assertEquals((long)retArray.length, (long)cnt);
        }
        catch (InterruptedException | StorageEngineException e) {
            e.printStackTrace();
            Assert.fail();
        }
        finally {
            IoTDBDescriptor.getInstance().getConfig().setAvgSeriesPointNumberThreshold(preAvgSeriesPointNumberThreshold);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void test10() throws SQLException {
        String[][] retArray = new String[][]{{"1", "1"}, {"2", "2"}, {"3", "3"}, {"4", "4"}};
        int preAvgSeriesPointNumberThreshold = IoTDBDescriptor.getInstance().getConfig().getAvgSeriesPointNumberThreshold();
        try (Connection connection = DriverManager.getConnection("jdbc:iotdb://127.0.0.1:6667/", "root", "root");
             Statement statement = connection.createStatement();){
            int cnt;
            IoTDBDescriptor.getInstance().getConfig().setAvgSeriesPointNumberThreshold(1);
            statement.execute("INSERT INTO root.sg1.d1(time,s1) values(1, 1)");
            statement.execute("INSERT INTO root.sg1.d1(time,s1) values(2, 2)");
            statement.execute("FLUSH");
            statement.execute("INSERT INTO root.sg1.d1(time,s1) values(3, 3)");
            statement.execute("INSERT INTO root.sg1.d1(time,s1) values(4, 4)");
            statement.execute("FLUSH");
            Assert.assertTrue((boolean)this.waitForMergeFinish());
            try (ResultSet resultSet = statement.executeQuery("SELECT s1 FROM root.sg1.d1");){
                cnt = 0;
                while (resultSet.next()) {
                    long time = resultSet.getLong("Time");
                    float s1 = resultSet.getFloat("root.sg1.d1.s1");
                    Assert.assertEquals((long)Long.parseLong(retArray[cnt][0]), (long)time);
                    Assert.assertEquals((float)Float.parseFloat(retArray[cnt][1]), (float)s1, (float)1.0E-5f);
                    ++cnt;
                }
            }
            Assert.assertEquals((long)retArray.length, (long)cnt);
            resultSet = statement.executeQuery("SELECT count(s1) FROM root.sg1.d1 where time < 4");
            try {
                Assert.assertTrue((boolean)resultSet.next());
                Assert.assertEquals((long)3L, (long)resultSet.getLong("count(root.sg1.d1.s1)"));
            }
            finally {
                if (resultSet != null) {
                    resultSet.close();
                }
            }
        }
        catch (InterruptedException | StorageEngineException e) {
            e.printStackTrace();
            Assert.fail();
        }
        finally {
            IoTDBDescriptor.getInstance().getConfig().setAvgSeriesPointNumberThreshold(preAvgSeriesPointNumberThreshold);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void test11() throws SQLException {
        String[][] retArray = new String[][]{{"1", "1"}, {"2", "2"}, {"3", "3"}, {"4", "4"}};
        int preAvgSeriesPointNumberThreshold = IoTDBDescriptor.getInstance().getConfig().getAvgSeriesPointNumberThreshold();
        try (Connection connection = DriverManager.getConnection("jdbc:iotdb://127.0.0.1:6667/", "root", "root");
             Statement statement = connection.createStatement();){
            int cnt;
            IoTDBDescriptor.getInstance().getConfig().setAvgSeriesPointNumberThreshold(10000);
            statement.execute("INSERT INTO root.sg1.d1(time,s1) values(1, 1)");
            statement.execute("INSERT INTO root.sg1.d1(time,s1) values(2, 2)");
            statement.execute("FLUSH");
            IoTDBDescriptor.getInstance().getConfig().setAvgSeriesPointNumberThreshold(1);
            statement.execute("INSERT INTO root.sg1.d1(time,s1) values(3, 3)");
            statement.execute("INSERT INTO root.sg1.d1(time,s1) values(4, 4)");
            statement.execute("FLUSH");
            Assert.assertTrue((boolean)this.waitForMergeFinish());
            try (ResultSet resultSet = statement.executeQuery("SELECT s1 FROM root.sg1.d1");){
                cnt = 0;
                while (resultSet.next()) {
                    long time = resultSet.getLong("Time");
                    float s1 = resultSet.getFloat("root.sg1.d1.s1");
                    Assert.assertEquals((long)Long.parseLong(retArray[cnt][0]), (long)time);
                    Assert.assertEquals((float)Float.parseFloat(retArray[cnt][1]), (float)s1, (float)1.0E-5f);
                    ++cnt;
                }
            }
            Assert.assertEquals((long)retArray.length, (long)cnt);
        }
        catch (InterruptedException | StorageEngineException e) {
            e.printStackTrace();
            Assert.fail();
        }
        finally {
            IoTDBDescriptor.getInstance().getConfig().setAvgSeriesPointNumberThreshold(preAvgSeriesPointNumberThreshold);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void test12() throws SQLException {
        String[][] retArray = new String[][]{{"1", "1"}, {"2", "2"}, {"3", "3"}, {"4", "4"}, {"5", "5"}, {"6", "6"}};
        int preAvgSeriesPointNumberThreshold = IoTDBDescriptor.getInstance().getConfig().getAvgSeriesPointNumberThreshold();
        try (Connection connection = DriverManager.getConnection("jdbc:iotdb://127.0.0.1:6667/", "root", "root");
             Statement statement = connection.createStatement();){
            int cnt;
            IoTDBDescriptor.getInstance().getConfig().setAvgSeriesPointNumberThreshold(2);
            statement.execute("INSERT INTO root.sg1.d1(time,s1) values(1, 1)");
            statement.execute("INSERT INTO root.sg1.d1(time,s1) values(2, 2)");
            statement.execute("INSERT INTO root.sg1.d1(time,s1) values(3, 3)");
            statement.execute("INSERT INTO root.sg1.d1(time,s1) values(4, 4)");
            statement.execute("FLUSH");
            IoTDBDescriptor.getInstance().getConfig().setAvgSeriesPointNumberThreshold(1);
            statement.execute("INSERT INTO root.sg1.d1(time,s1) values(5, 5)");
            statement.execute("INSERT INTO root.sg1.d1(time,s1) values(6, 6)");
            statement.execute("FLUSH");
            Assert.assertTrue((boolean)this.waitForMergeFinish());
            try (ResultSet resultSet = statement.executeQuery("SELECT s1 FROM root.sg1.d1");){
                cnt = 0;
                while (resultSet.next()) {
                    long time = resultSet.getLong("Time");
                    float s1 = resultSet.getFloat("root.sg1.d1.s1");
                    Assert.assertEquals((long)Long.parseLong(retArray[cnt][0]), (long)time);
                    Assert.assertEquals((float)Float.parseFloat(retArray[cnt][1]), (float)s1, (float)1.0E-5f);
                    ++cnt;
                }
            }
            Assert.assertEquals((long)retArray.length, (long)cnt);
        }
        catch (InterruptedException | StorageEngineException e) {
            e.printStackTrace();
            Assert.fail();
        }
        finally {
            IoTDBDescriptor.getInstance().getConfig().setAvgSeriesPointNumberThreshold(preAvgSeriesPointNumberThreshold);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void test13() throws SQLException {
        String[][] retArray = new String[][]{{"1", "1"}, {"2", "2"}, {"3", "3"}, {"4", "4"}, {"5", "5"}};
        int preAvgSeriesPointNumberThreshold = IoTDBDescriptor.getInstance().getConfig().getAvgSeriesPointNumberThreshold();
        try (Connection connection = DriverManager.getConnection("jdbc:iotdb://127.0.0.1:6667/", "root", "root");
             Statement statement = connection.createStatement();){
            int cnt;
            IoTDBDescriptor.getInstance().getConfig().setAvgSeriesPointNumberThreshold(10000);
            statement.execute("INSERT INTO root.sg1.d1(time,s1) values(1, 1)");
            statement.execute("FLUSH");
            IoTDBDescriptor.getInstance().getConfig().setAvgSeriesPointNumberThreshold(2);
            statement.execute("INSERT INTO root.sg1.d1(time,s1) values(2, 2)");
            statement.execute("INSERT INTO root.sg1.d1(time,s1) values(3, 3)");
            statement.execute("INSERT INTO root.sg1.d1(time,s1) values(4, 4)");
            statement.execute("INSERT INTO root.sg1.d1(time,s1) values(5, 5)");
            statement.execute("FLUSH");
            Assert.assertTrue((boolean)this.waitForMergeFinish());
            try (ResultSet resultSet = statement.executeQuery("SELECT s1 FROM root.sg1.d1");){
                cnt = 0;
                while (resultSet.next()) {
                    long time = resultSet.getLong("Time");
                    float s1 = resultSet.getFloat("root.sg1.d1.s1");
                    Assert.assertEquals((long)Long.parseLong(retArray[cnt][0]), (long)time);
                    Assert.assertEquals((float)Float.parseFloat(retArray[cnt][1]), (float)s1, (float)1.0E-5f);
                    ++cnt;
                }
            }
            Assert.assertEquals((long)retArray.length, (long)cnt);
        }
        catch (InterruptedException | StorageEngineException e) {
            e.printStackTrace();
            Assert.fail();
        }
        finally {
            IoTDBDescriptor.getInstance().getConfig().setAvgSeriesPointNumberThreshold(preAvgSeriesPointNumberThreshold);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void test14() throws SQLException {
        String[][] retArray = new String[][]{{"1", "1"}, {"2", "2"}, {"3", "3"}, {"4", "4"}, {"5", "5"}, {"6", "6"}};
        int preAvgSeriesPointNumberThreshold = IoTDBDescriptor.getInstance().getConfig().getAvgSeriesPointNumberThreshold();
        try (Connection connection = DriverManager.getConnection("jdbc:iotdb://127.0.0.1:6667/", "root", "root");
             Statement statement = connection.createStatement();){
            int cnt;
            IoTDBDescriptor.getInstance().getConfig().setAvgSeriesPointNumberThreshold(1);
            statement.execute("INSERT INTO root.sg1.d1(time,s1) values(1, 1)");
            statement.execute("INSERT INTO root.sg1.d1(time,s1) values(2, 2)");
            statement.execute("FLUSH");
            IoTDBDescriptor.getInstance().getConfig().setAvgSeriesPointNumberThreshold(2);
            statement.execute("INSERT INTO root.sg1.d1(time,s1) values(3, 3)");
            statement.execute("INSERT INTO root.sg1.d1(time,s1) values(4, 4)");
            statement.execute("INSERT INTO root.sg1.d1(time,s1) values(5, 5)");
            statement.execute("INSERT INTO root.sg1.d1(time,s1) values(6, 6)");
            statement.execute("FLUSH");
            Assert.assertTrue((boolean)this.waitForMergeFinish());
            try (ResultSet resultSet = statement.executeQuery("SELECT s1 FROM root.sg1.d1");){
                cnt = 0;
                while (resultSet.next()) {
                    long time = resultSet.getLong("Time");
                    float s1 = resultSet.getFloat("root.sg1.d1.s1");
                    Assert.assertEquals((long)Long.parseLong(retArray[cnt][0]), (long)time);
                    Assert.assertEquals((float)Float.parseFloat(retArray[cnt][1]), (float)s1, (float)1.0E-5f);
                    ++cnt;
                }
            }
            Assert.assertEquals((long)retArray.length, (long)cnt);
        }
        catch (InterruptedException | StorageEngineException e) {
            e.printStackTrace();
            Assert.fail();
        }
        finally {
            IoTDBDescriptor.getInstance().getConfig().setAvgSeriesPointNumberThreshold(preAvgSeriesPointNumberThreshold);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void test15() throws SQLException {
        String[][] retArray = new String[][]{{"1", "1"}, {"2", "2"}, {"3", "3"}, {"4", "4"}, {"5", "5"}, {"6", "6"}};
        int preAvgSeriesPointNumberThreshold = IoTDBDescriptor.getInstance().getConfig().getAvgSeriesPointNumberThreshold();
        try (Connection connection = DriverManager.getConnection("jdbc:iotdb://127.0.0.1:6667/", "root", "root");
             Statement statement = connection.createStatement();){
            int cnt;
            IoTDBDescriptor.getInstance().getConfig().setAvgSeriesPointNumberThreshold(10000);
            statement.execute("INSERT INTO root.sg1.d1(time,s1) values(1, 1)");
            statement.execute("INSERT INTO root.sg1.d1(time,s1) values(2, 2)");
            statement.execute("FLUSH");
            IoTDBDescriptor.getInstance().getConfig().setAvgSeriesPointNumberThreshold(2);
            statement.execute("INSERT INTO root.sg1.d1(time,s1) values(3, 3)");
            statement.execute("INSERT INTO root.sg1.d1(time,s1) values(4, 4)");
            statement.execute("INSERT INTO root.sg1.d1(time,s1) values(5, 5)");
            statement.execute("INSERT INTO root.sg1.d1(time,s1) values(6, 6)");
            statement.execute("FLUSH");
            Assert.assertTrue((boolean)this.waitForMergeFinish());
            try (ResultSet resultSet = statement.executeQuery("SELECT s1 FROM root.sg1.d1");){
                cnt = 0;
                while (resultSet.next()) {
                    long time = resultSet.getLong("Time");
                    float s1 = resultSet.getFloat("root.sg1.d1.s1");
                    Assert.assertEquals((long)Long.parseLong(retArray[cnt][0]), (long)time);
                    Assert.assertEquals((float)Float.parseFloat(retArray[cnt][1]), (float)s1, (float)1.0E-5f);
                    ++cnt;
                }
            }
            Assert.assertEquals((long)retArray.length, (long)cnt);
        }
        catch (InterruptedException | StorageEngineException e) {
            e.printStackTrace();
            Assert.fail();
        }
        finally {
            IoTDBDescriptor.getInstance().getConfig().setAvgSeriesPointNumberThreshold(preAvgSeriesPointNumberThreshold);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void test16() throws SQLException {
        String[][] retArray = new String[][]{{"1", "1"}, {"2", "2"}, {"3", "3"}, {"4", "4"}, {"5", "5"}, {"6", "6"}, {"7", "7"}, {"8", "8"}};
        int preAvgSeriesPointNumberThreshold = IoTDBDescriptor.getInstance().getConfig().getAvgSeriesPointNumberThreshold();
        try (Connection connection = DriverManager.getConnection("jdbc:iotdb://127.0.0.1:6667/", "root", "root");
             Statement statement = connection.createStatement();){
            int cnt;
            IoTDBDescriptor.getInstance().getConfig().setAvgSeriesPointNumberThreshold(2);
            statement.execute("INSERT INTO root.sg1.d1(time,s1) values(1, 1)");
            statement.execute("INSERT INTO root.sg1.d1(time,s1) values(2, 2)");
            statement.execute("INSERT INTO root.sg1.d1(time,s1) values(3, 3)");
            statement.execute("INSERT INTO root.sg1.d1(time,s1) values(4, 4)");
            statement.execute("FLUSH");
            statement.execute("INSERT INTO root.sg1.d1(time,s1) values(5, 5)");
            statement.execute("INSERT INTO root.sg1.d1(time,s1) values(6, 6)");
            statement.execute("INSERT INTO root.sg1.d1(time,s1) values(7, 7)");
            statement.execute("INSERT INTO root.sg1.d1(time,s1) values(8, 8)");
            statement.execute("FLUSH");
            Assert.assertTrue((boolean)this.waitForMergeFinish());
            try (ResultSet resultSet = statement.executeQuery("SELECT s1 FROM root.sg1.d1");){
                cnt = 0;
                while (resultSet.next()) {
                    long time = resultSet.getLong("Time");
                    float s1 = resultSet.getFloat("root.sg1.d1.s1");
                    Assert.assertEquals((long)Long.parseLong(retArray[cnt][0]), (long)time);
                    Assert.assertEquals((float)Float.parseFloat(retArray[cnt][1]), (float)s1, (float)1.0E-5f);
                    ++cnt;
                }
            }
            Assert.assertEquals((long)retArray.length, (long)cnt);
        }
        catch (InterruptedException | StorageEngineException e) {
            e.printStackTrace();
            Assert.fail();
        }
        finally {
            IoTDBDescriptor.getInstance().getConfig().setAvgSeriesPointNumberThreshold(preAvgSeriesPointNumberThreshold);
        }
    }

    private boolean waitForMergeFinish() throws StorageEngineException, InterruptedException {
        StorageGroupProcessor storageGroupProcessor = StorageEngine.getInstance().getProcessor(this.storageGroupPath);
        LevelCompactionTsFileManagement tsFileManagement = (LevelCompactionTsFileManagement)storageGroupProcessor.getTsFileManagement();
        long startTime = System.nanoTime();
        while (((List)tsFileManagement.getSequenceTsFileResources().get(0L)).size() < 2 || ((SortedSet)((List)tsFileManagement.getSequenceTsFileResources().get(0L)).get(1)).size() != 1) {
            TimeUnit.MILLISECONDS.sleep(100L);
            if (System.nanoTime() - startTime < Long.MAX_VALUE) continue;
        }
        return ((SortedSet)((List)tsFileManagement.getSequenceTsFileResources().get(0L)).get(1)).size() == 1;
    }
}

