/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.integration;

import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.ResultSet;
import java.sql.Statement;
import org.apache.iotdb.db.conf.IoTDBDescriptor;
import org.apache.iotdb.db.constant.TestConstant;
import org.apache.iotdb.db.engine.compaction.CompactionStrategy;
import org.apache.iotdb.db.utils.EnvironmentUtils;
import org.apache.iotdb.tsfile.common.conf.TSFileConfig;
import org.apache.iotdb.tsfile.common.conf.TSFileDescriptor;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Test;

public class IoTDBMultiStatementsIT {
    private static TSFileConfig tsFileConfig = TSFileDescriptor.getInstance().getConfig();
    private static int maxNumberOfPointsInPage;
    private static int pageSizeInByte;
    private static int groupSizeInByte;

    @BeforeClass
    public static void setUp() throws Exception {
        EnvironmentUtils.closeStatMonitor();
        IoTDBDescriptor.getInstance().getConfig().setCompactionStrategy(CompactionStrategy.NO_COMPACTION);
        maxNumberOfPointsInPage = tsFileConfig.getMaxNumberOfPointsInPage();
        pageSizeInByte = tsFileConfig.getPageSizeInByte();
        groupSizeInByte = tsFileConfig.getGroupSizeInByte();
        tsFileConfig.setMaxNumberOfPointsInPage(1000);
        tsFileConfig.setPageSizeInByte(153600);
        tsFileConfig.setGroupSizeInByte(1024000);
        IoTDBDescriptor.getInstance().getConfig().setMemtableSizeThreshold(1024000L);
        EnvironmentUtils.envSetUp();
        IoTDBMultiStatementsIT.insertData();
    }

    @AfterClass
    public static void tearDown() throws Exception {
        tsFileConfig.setMaxNumberOfPointsInPage(maxNumberOfPointsInPage);
        tsFileConfig.setPageSizeInByte(pageSizeInByte);
        tsFileConfig.setGroupSizeInByte(groupSizeInByte);
        IoTDBDescriptor.getInstance().getConfig().setMemtableSizeThreshold((long)groupSizeInByte);
        IoTDBDescriptor.getInstance().getConfig().setCompactionStrategy(CompactionStrategy.LEVEL_COMPACTION);
        EnvironmentUtils.cleanEnv();
    }

    private static void insertData() throws ClassNotFoundException {
        Class.forName("org.apache.iotdb.jdbc.IoTDBDriver");
        try (Connection connection = DriverManager.getConnection("jdbc:iotdb://127.0.0.1:6667/", "root", "root");
             Statement statement = connection.createStatement();){
            for (String sql : TestConstant.create_sql) {
                statement.execute(sql);
            }
            statement.execute("SET STORAGE GROUP TO root.fans");
            statement.execute("CREATE TIMESERIES root.fans.d0.s0 WITH DATATYPE=INT32, ENCODING=RLE");
            statement.execute("CREATE TIMESERIES root.fans.d0.s1 WITH DATATYPE=INT64, ENCODING=RLE");
            for (int time = 1; time < 10; ++time) {
                String sql = String.format("insert into root.fans.d0(timestamp,s0) values(%s,%s)", time, time % 10);
                statement.execute(sql);
                sql = String.format("insert into root.fans.d0(timestamp,s1) values(%s,%s)", time, time % 5);
                statement.execute(sql);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            Assert.fail((String)e.getMessage());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void selectAllTest() throws ClassNotFoundException {
        String[] retArray = new String[]{"1,1,1", "2,2,2", "3,3,3", "4,4,4", "5,5,0", "6,6,1", "7,7,2", "8,8,3", "9,9,4"};
        String selectSql = "select * from root";
        Class.forName("org.apache.iotdb.jdbc.IoTDBDriver");
        try (Connection connection = DriverManager.getConnection("jdbc:iotdb://127.0.0.1:6667/", "root", "root");
             Statement statement1 = connection.createStatement();
             Statement statement2 = connection.createStatement();){
            statement1.setFetchSize(10);
            boolean hasResultSet1 = statement1.execute(selectSql);
            Assert.assertTrue((boolean)hasResultSet1);
            try (ResultSet resultSet1 = statement1.getResultSet();){
                StringBuilder builder;
                int cnt1;
                for (cnt1 = 0; resultSet1.next() && cnt1 < 5; ++cnt1) {
                    StringBuilder builder2 = new StringBuilder();
                    builder2.append(resultSet1.getString("Time")).append(",").append(resultSet1.getString("root.fans.d0.s0")).append(",").append(resultSet1.getString("root.fans.d0.s1"));
                    Assert.assertEquals((Object)retArray[cnt1], (Object)builder2.toString());
                }
                statement2.setFetchSize(10);
                boolean hasResultSet2 = statement2.execute(selectSql);
                Assert.assertTrue((boolean)hasResultSet2);
                int cnt2 = 0;
                try (ResultSet resultSet2 = statement2.getResultSet();){
                    while (resultSet2.next()) {
                        builder = new StringBuilder();
                        builder.append(resultSet2.getString("Time")).append(",").append(resultSet2.getString("root.fans.d0.s0")).append(",").append(resultSet2.getString("root.fans.d0.s1"));
                        Assert.assertEquals((Object)retArray[cnt2], (Object)builder.toString());
                        ++cnt2;
                    }
                }
                Assert.assertEquals((long)9L, (long)cnt2);
                do {
                    builder = new StringBuilder();
                    builder.append(resultSet1.getString("Time")).append(",").append(resultSet1.getString("root.fans.d0.s0")).append(",").append(resultSet1.getString("root.fans.d0.s1"));
                    Assert.assertEquals((Object)retArray[cnt1], (Object)builder.toString());
                    ++cnt1;
                } while (resultSet1.next());
                Assert.assertEquals((long)9L, (long)cnt1);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            Assert.fail((String)e.getMessage());
        }
    }
}

