/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.integration;

import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.ResultSet;
import java.sql.Statement;
import org.apache.iotdb.db.conf.IoTDBDescriptor;
import org.apache.iotdb.db.constant.TestConstant;
import org.apache.iotdb.db.engine.compaction.CompactionStrategy;
import org.apache.iotdb.db.utils.EnvironmentUtils;
import org.apache.iotdb.tsfile.common.conf.TSFileDescriptor;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Test;

public class IoTDBMultiOverlappedPageIT {
    private static int beforeMaxNumberOfPointsInPage;
    private static long beforeMemtableSizeThreshold;

    @BeforeClass
    public static void setUp() throws Exception {
        EnvironmentUtils.closeStatMonitor();
        IoTDBDescriptor.getInstance().getConfig().setCompactionStrategy(CompactionStrategy.NO_COMPACTION);
        beforeMemtableSizeThreshold = IoTDBDescriptor.getInstance().getConfig().getMemtableSizeThreshold();
        IoTDBDescriptor.getInstance().getConfig().setMemtableSizeThreshold(16384L);
        beforeMaxNumberOfPointsInPage = TSFileDescriptor.getInstance().getConfig().getMaxNumberOfPointsInPage();
        TSFileDescriptor.getInstance().getConfig().setMaxNumberOfPointsInPage(10);
        EnvironmentUtils.envSetUp();
        Class.forName("org.apache.iotdb.jdbc.IoTDBDriver");
        IoTDBMultiOverlappedPageIT.insertData();
    }

    @AfterClass
    public static void tearDown() throws Exception {
        TSFileDescriptor.getInstance().getConfig().setMaxNumberOfPointsInPage(beforeMaxNumberOfPointsInPage);
        EnvironmentUtils.cleanEnv();
        IoTDBDescriptor.getInstance().getConfig().setMemtableSizeThreshold(beforeMemtableSizeThreshold);
        IoTDBDescriptor.getInstance().getConfig().setCompactionStrategy(CompactionStrategy.LEVEL_COMPACTION);
    }

    @Test
    public void selectOverlappedPageTest() {
        String[] res = new String[]{"11,111", "12,112", "13,113", "14,114", "15,215", "16,216", "17,217", "18,218", "19,219", "20,220", "21,221", "22,222", "23,223", "24,224"};
        try (Connection connection = DriverManager.getConnection("jdbc:iotdb://127.0.0.1:6667/", "root", "root");
             Statement statement = connection.createStatement();){
            String sql = "select s0 from root.vehicle.d0 where time >= 1 and time <= 50 AND root.vehicle.d0.s0 >= 111";
            int cnt = 0;
            try (ResultSet resultSet = statement.executeQuery(sql);){
                while (resultSet.next()) {
                    String ans = resultSet.getString("Time") + "," + resultSet.getString("root.vehicle.d0.s0");
                    Assert.assertEquals((Object)res[cnt], (Object)ans);
                    ++cnt;
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            Assert.fail((String)e.getMessage());
        }
    }

    @Test
    public void selectOverlappedPageTest2() {
        try (Connection connection = DriverManager.getConnection("jdbc:iotdb://127.0.0.1:6667/", "root", "root");
             Statement statement = connection.createStatement();){
            String sql = "select first_value(s0) from root.vehicle.d0 where time > 18";
            try (ResultSet resultSet = statement.executeQuery(sql);){
                while (resultSet.next()) {
                    String ans = resultSet.getString(TestConstant.first_value("root.vehicle.d0.s0"));
                    Assert.assertEquals((Object)"219", (Object)ans);
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            Assert.fail((String)e.getMessage());
        }
    }

    private static void insertData() {
        try (Connection connection = DriverManager.getConnection("jdbc:iotdb://127.0.0.1:6667/", "root", "root");
             Statement statement = connection.createStatement();){
            String sql;
            long time;
            statement.execute("CREATE TIMESERIES root.vehicle.d0.s0 WITH DATATYPE=INT32, ENCODING=RLE");
            for (time = 1L; time <= 10L; ++time) {
                sql = String.format("insert into root.vehicle.d0(timestamp,s0) values(%s,%s)", time, time);
                statement.execute(sql);
            }
            for (time = 11L; time <= 20L; ++time) {
                sql = String.format("insert into root.vehicle.d0(timestamp,s0) values(%s,%s)", time, 100L + time);
                statement.execute(sql);
            }
            for (time = 21L; time <= 30L; ++time) {
                sql = String.format("insert into root.vehicle.d0(timestamp,s0) values(%s,%s)", time, time);
                statement.execute(sql);
            }
            statement.execute("flush");
            for (time = 101L; time <= 110L; ++time) {
                sql = String.format("insert into root.vehicle.d0(timestamp,s0) values(%s,%s)", time, time);
                statement.execute(sql);
            }
            statement.execute("flush");
            for (time = 1L; time <= 10L; ++time) {
                sql = String.format("insert into root.vehicle.d0(timestamp,s0) values(%s,%s)", time, time + 100L);
                statement.execute(sql);
            }
            for (time = 15L; time <= 24L; ++time) {
                sql = String.format("insert into root.vehicle.d0(timestamp,s0) values(%s,%s)", time, time + 200L);
                statement.execute(sql);
            }
            statement.execute("flush");
        }
        catch (Exception e) {
            e.printStackTrace();
            Assert.fail((String)e.getMessage());
        }
    }
}

